/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital.query;

import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayExtractOrderCheckGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayExtractOrderCheckGatewayServiceImpl
extends AbstractEPayCheckGatewayService {
    @Override
    public QueryOrderReq getQueryReq(String tradeId) throws Exception {
        EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
        QueryOrderReq request = this.initQueryReq(enterpriseOrder.getPartnerAccount(), enterpriseOrder.getTradeId(), enterpriseOrder.getPartnerConfigCode());
        request.setThirdLogNo(enterpriseOrder.getTradeId());
        request.setTranDate(new DateTime((Object)enterpriseOrder.getOrderTime()).toString("yyyyMMdd"));
        request.setFuncFlag(AbstractEPayCheckGatewayService.FuncFlag.EXTRACT.getFlag());
        request.setCustAcctId(enterpriseOrder.getPtUserId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        request.setTranDate(sdf.format(enterpriseOrder.getOrderTime()));
        return request;
    }

    @Override
    public void rechargeResponse(String tradeId, QueryOrderResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)tradeId, (Date)new Date());
        partnerOrder.setAcceptTime(new Date());
        if ("000000".equals(resp.getRspCode()) || "ERR020".equals(resp.getRspCode())) {
            if (AbstractEPayCheckGatewayService.TranStatus.SUCC.getStatus().equals(resp.getTranStatus()) && "7".equals(resp.getTranFlag())) {
                EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
                this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u6210\u529f");
                BigDecimal partnerAmt = new BigDecimal(resp.getTranAmount());
                partnerAmt = partnerAmt.subtract(null == enterpriseOrder.getFee() ? new BigDecimal("0.00") : enterpriseOrder.getFee());
                partnerOrder.setAmount(partnerAmt);
                this.payEnterOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            } else {
                this.logger.error("\u6e20\u9053\u8fd4\u56de\u63d0\u73b0\u8ba2\u5355\u5931\u8d25");
                this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
            }
        } else {
            this.logger.error("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u9519\u8bef\u7801\u4e3a\uff1a" + resp.getRspCode());
        }
    }

    public void validate(String tradeId, QueryOrderResp queryOrderResp) throws Exception {
    }
}

