/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital.query;

import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayPayOrderCheckGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayPayOrderCheckGatewayServiceImpl
extends AbstractEPayCheckGatewayService {
    @Override
    public QueryOrderReq getQueryReq(String tradeId) throws Exception {
        EnterpriseOrderEo order = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
        QueryOrderReq request = this.initQueryReq(order.getPartnerAccount(), order.getParentTradeId() == null ? order.getTradeId() : order.getParentTradeId(), order.getPartnerConfigCode());
        request.setThirdLogNo(order.getTradeId());
        request.setFuncFlag(AbstractEPayCheckGatewayService.FuncFlag.TRADE.getFlag());
        request.setCustAcctId(order.getPtUserId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        request.setTranDate(sdf.format(order.getOrderTime()));
        return request;
    }

    @Override
    public void rechargeResponse(String tradeId, QueryOrderResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)tradeId, (Date)new Date());
        partnerOrder.setAcceptTime(new Date());
        if ("000000".equals(resp.getRspCode()) || "ERR020".equals(resp.getRspCode())) {
            if (AbstractEPayCheckGatewayService.TranStatus.SUCC.getStatus().equals(resp.getTranStatus()) && "6".equals(resp.getTranFlag())) {
                this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u6210\u529f");
                EnterpriseOrderEo order = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
                BigDecimal partnerAmt = new BigDecimal(resp.getTranAmount());
                partnerAmt = partnerAmt.subtract(null == order.getFee() ? new BigDecimal("0.00") : order.getFee());
                partnerOrder.setAmount(partnerAmt);
                this.payEnterOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            } else {
                this.logger.error("\u6e20\u9053\u8fd4\u56de\u652f\u4ed8\u8ba2\u5355\u5931\u8d25");
                partnerOrder.setErrorCode(resp.getRspCode());
                partnerOrder.setErrorMsg(resp.getRspMsg());
                this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
            }
        } else {
            this.logger.error("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u9519\u8bef\u7801\u4e3a\uff1a" + resp.getRspCode());
        }
    }

    public void validate(String tradeId, QueryOrderResp queryOrderResp) throws Exception {
    }
}

