/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital.query;

import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayRecordOrderCheckGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayRecordOrderCheckGatewayServiceImpl
extends AbstractEPayCheckGatewayService {
    @Override
    public QueryOrderReq getQueryReq(String tradeId) throws Exception {
        EnterpriseOrderEo order = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
        QueryOrderReq request = this.initQueryReq(order.getPartnerAccount(), order.getTradeId(), order.getPartnerConfigCode());
        request.setFuncFlag(AbstractEPayCheckGatewayService.FuncFlag.TRADE.getFlag());
        request.setTranDate(new DateTime((Object)order.getOrderTime()).toString("yyyyMMdd"));
        return request;
    }

    @Override
    public void rechargeResponse(String tradeId, QueryOrderResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)tradeId, (Date)new Date());
        partnerOrder.setAcceptTime(new Date());
        if ("000000".equals(resp.getRspCode()) && AbstractEPayCheckGatewayService.TranStatus.SUCC.getStatus().equals(resp.getTranStatus())) {
            this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u6210\u529f");
            partnerOrder.setAmount(new BigDecimal(resp.getTranAmount()));
            this.payEnterOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else if ("000000".equals(resp.getRspCode()) || "ERR020".equals(resp.getRspCode())) {
            this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u5931\u8d25, \u672c\u5730\u4e0d\u5b58\u5728\u767b\u8bb0\u6302\u8d26\u8ba2\u5355");
            this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
        } else {
            this.logger.error("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u9519\u8bef\u7801\u4e3a\uff1a" + resp.getRspCode());
        }
    }

    public void validate(String s, QueryOrderResp queryOrderResp) throws Exception {
    }
}

