/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital.query;

import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayRefundOrderCheckGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayRefundOrderCheckGatewayServiceImpl
extends AbstractEPayCheckGatewayService {
    @Override
    public QueryOrderReq getQueryReq(String refundId) throws Exception {
        RefundOrderEo order = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)refundId);
        EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)order.getTradeId());
        QueryOrderReq request = this.initQueryReq(order.getPartnerAccount(), enterpriseOrder.getTradeId(), order.getPartnerConfigCode());
        request.setFuncFlag(AbstractEPayCheckGatewayService.FuncFlag.RECHARGE.getFlag());
        request.setTranDate(new DateTime((Object)order.getRefundTime()).toString("yyyyMMdd"));
        return request;
    }

    @Override
    public void rechargeResponse(String refundId, QueryOrderResp resp) throws Exception {
        RefundOrderEo order = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)refundId);
        EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)order.getTradeId());
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundId, (Date)new Date());
        if ("000000".equals(resp.getRspCode()) || "ERR020".equals(resp.getRspCode())) {
            if (EnterOrderType.ALLOT.getType().equals(enterpriseOrder.getTranType())) {
                partnerOrder.setAcceptTime(new Date());
                if (AbstractEPayCheckGatewayService.TranStatus.FAIL.getStatus().equals(resp.getTranStatus())) {
                    partnerOrder.setAmount(new BigDecimal(resp.getTranAmount()));
                    this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
                } else {
                    partnerOrder.setErrorCode(resp.getRspCode());
                    partnerOrder.setErrorMsg(resp.getRspMsg());
                    this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
                }
            } else {
                this.logger.warn("\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u6e05\u5206\u8ba2\u5355\uff0c\u56e0\u6b64\u4e0d\u9700\u8981\u66f4\u65b0\u72b6\u6001");
            }
        } else {
            this.logger.error("\u6e20\u9053\u67e5\u8be2\u5931\u8d25, \u5173\u95ed\u672c\u5730\u8ba2\u5355");
            partnerOrder.setErrorCode(resp.getRspCode());
            partnerOrder.setErrorMsg(resp.getRspMsg());
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
    }

    public void validate(String tradeId, QueryOrderResp queryOrderResp) throws Exception {
    }
}

