/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.finnace;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.constants.SafetyConstants;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.finance.FinanceRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.finance.FinanceResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PtFinanceOrder;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PtOriginOrder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayOrderDownloadGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayOrderDownloadGatewayServiceImpl
extends AbstractEPayGatewayService<PartnerConfigEo, FinanceResponse> {
    public BaseGatewayResult rechargeResult(PartnerConfigEo payPartnerConfig, FinanceResponse financeResponse) throws Exception {
        GatewayResult result = new GatewayResult();
        if ("000000".equals(financeResponse.getRspCode())) {
            result.setDoneSucc(true);
            if (!CollectionUtils.isEmpty((Collection)financeResponse.getFileInfo())) {
                ArrayList list = new ArrayList();
                for (Map map : financeResponse.getFileInfo()) {
                    ArrayList tempList = new ArrayList();
                    tempList.add(map.get("fileName"));
                    tempList.add(map.get("randomPwd"));
                    list.add(tempList);
                }
                if (list.size() > 0) {
                    HashMap<String, String> data = new HashMap<String, String>(1);
                    data.put("fileInfo", JSON.toJSONString(list));
                    result.setData(data);
                }
            } else if (StringUtils.isBlank((CharSequence)financeResponse.getTotalCount())) {
                if (StringUtils.isBlank((CharSequence)SafetyConstants.EPAYCFG.getLocalFilePath())) {
                    result.setErrorMsg("localFilePath\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5c06\u6570\u636e\u52a0\u8f7d\u8fdb\u5165\u6570\u636e\u5e93");
                    return result;
                }
                if (StringUtils.isBlank((CharSequence)financeResponse.getFileName())) {
                    result.setErrorMsg("\u4e0b\u8f7d\u6587\u4ef6\u540d\u672a\u7a7a");
                    return result;
                }
                if (!financeResponse.getFileName().endsWith("txt")) {
                    return result;
                }
                this.insertToDB(payPartnerConfig, SafetyConstants.EPAYCFG.getLocalFilePath(), financeResponse.getFileName(), result);
            }
        } else {
            result.setDoneSucc(false);
            result.setErrorCode(financeResponse.getRspCode());
            result.setErrorMsg(financeResponse.getRspMsg());
        }
        return result;
    }

    public FinanceResponse _execute(PartnerConfigEo payPartnerConfig) throws Exception {
        FinanceRequest request = new FinanceRequest();
        Calendar date = Calendar.getInstance();
        if (NumberUtils.isNumber((String)payPartnerConfig.getMemo())) {
            date.add(5, -Integer.valueOf(payPartnerConfig.getMemo()).intValue());
        } else {
            date.add(5, -1);
        }
        request.setSupAcctId(payPartnerConfig.getPtAccount());
        request.setQydm(payPartnerConfig.getPtMerId());
        request.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        String fileName = null;
        if (payPartnerConfig.getMemo() != null && payPartnerConfig.getMemo().startsWith("[")) {
            Element root = DocumentHelper.createElement((String)"Result");
            Document document = DocumentHelper.createDocument((Element)root);
            Element tradeSn = DocumentHelper.createElement((String)"TradeSn");
            tradeSn.addText(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
            root.add(tradeSn);
            JSONArray jsonArray = JSON.parseArray((String)payPartnerConfig.getMemo());
            Element fileNameEle = DocumentHelper.createElement((String)"FileName");
            fileName = String.valueOf(jsonArray.get(0)).replaceAll("\\.enc", "");
            fileNameEle.addText(fileName);
            root.add(fileNameEle);
            Element randomPwd = DocumentHelper.createElement((String)"RandomPwd");
            randomPwd.addText(String.valueOf(jsonArray.get(1)));
            root.add(randomPwd);
            StringWriter requestXML = new StringWriter();
            OutputFormat xmlFormat = new OutputFormat();
            xmlFormat.setEncoding("UTF-8");
            XMLWriter xmlWriter = new XMLWriter((Writer)requestXML, xmlFormat);
            try {
                xmlWriter.write(document);
                xmlWriter.close();
            }
            catch (IOException e) {
                this.logger.error("\u751f\u6210xml\u5931\u8d25" + e.getMessage(), (Throwable)e);
                throw e;
            }
            request.setXml(requestXML.toString().replaceAll("\r|\n", ""));
            request.setBib2c(true);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            request.setTranFunc("6103");
            request.setTranDate(sdf.format(date.getTime()));
            request.setFileType(payPartnerConfig.getMemo());
        }
        FinanceResponse financeResponse = this.ePayCapitalPartnerService.downloadOrder(request);
        if (StringUtils.isNotBlank(fileName)) {
            financeResponse.setFileName(fileName);
        }
        return financeResponse;
    }

    public void validate(PartnerConfigEo payPartnerConfig, FinanceResponse financeResponse) throws Exception {
    }

    private void insertToDB(PartnerConfigEo payPartnerConfig, String filePath, String fileName, GatewayResult result) throws Exception {
        File file = new File(filePath + File.separator + fileName);
        if (!file.exists()) {
            result.setErrorMsg("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728(" + file.getAbsolutePath() + ")");
            return;
        }
        int waitTime = 0;
        int maxTime = 1800;
        while (!file.canRead()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (++waitTime <= maxTime) continue;
            result.setErrorMsg("\u6587\u4ef6" + fileName + maxTime / 60 + "\u5206\u4ecd\u672a\u4e0b\u8f7d\u597d");
            return;
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader in = null;
        ArrayList<String> lineList = new ArrayList<String>();
        try {
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            in = new BufferedReader(isr);
            String line = null;
            while ((line = in.readLine()) != null) {
                lineList.add(line);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        ArrayList<PtOriginOrder> ptOriginOrders = new ArrayList<PtOriginOrder>();
        ArrayList<PtFinanceOrder> ptFinanceOrders = new ArrayList<PtFinanceOrder>();
        for (String line : lineList) {
            this.parseAndSave(payPartnerConfig, line, fileName, ptOriginOrders, ptFinanceOrders);
        }
        this.savePtOriginOrders(payPartnerConfig, ptOriginOrders);
        this.savePtFinanceOrders(payPartnerConfig, ptFinanceOrders);
    }

    private void parseAndSave(PartnerConfigEo payPartnerConfig, String line, String fileName, List<PtOriginOrder> ptOriginOrders, List<PtFinanceOrder> ptFinanceOrders) throws ParseException {
        if (StringUtils.isBlank((CharSequence)line)) {
            return;
        }
        PtOriginOrder originOrder = PtOriginOrder.newInstance();
        originOrder.setCreateTime(new Date());
        originOrder.setOriginOrder(line);
        originOrder.setPartnerId(payPartnerConfig.getPartnerCode());
        originOrder.setPtAppId(payPartnerConfig.getPtAccount());
        originOrder.setPtMerId(payPartnerConfig.getPtMerId());
        ptOriginOrders.add(originOrder);
        PtFinanceOrder ptFinanceOrder = PtFinanceOrder.newInstance();
        ptFinanceOrder.setCreateTime(new Date());
        ptFinanceOrder.setOrderStatus("S");
        ptFinanceOrder.setPtMerId(payPartnerConfig.getPtMerId());
        ptFinanceOrder.setPartnerId(payPartnerConfig.getPartnerCode());
        ptFinanceOrder.setPtAccountId(payPartnerConfig.getPtAccount());
        this.parse(line, fileName, ptFinanceOrder);
        originOrder.setPtOrderId(ptFinanceOrder.getPtOrderId());
        if (ptFinanceOrder.getPayTypeId() != null && ptFinanceOrder.getPayTypeId().length() > 8) {
            ptFinanceOrder.setPayTypeId(ptFinanceOrder.getPayTypeId().substring(0, 8));
        }
        ptFinanceOrders.add(ptFinanceOrder);
    }

    private void savePtOriginOrders(PartnerConfigEo config, List<PtOriginOrder> ptOriginOrders) {
        for (PtOriginOrder ptOriginOrder : ptOriginOrders) {
            PtOriginOrder example = PtOriginOrder.newInstance();
            if (StringUtils.isBlank((CharSequence)ptOriginOrder.getPtOrderId()) && StringUtils.isBlank((CharSequence)ptOriginOrder.getPtRefundId())) break;
            example.setPartnerId(config.getPartnerCode());
            example.setPtOrderId(ptOriginOrder.getPtOrderId());
            example.setPtRefundId(ptOriginOrder.getPtRefundId());
            this.ptOriginOrderDas.delete((BaseEo)example);
        }
        this.ptOriginOrderDas.getMapper().insertBatch(ptOriginOrders);
    }

    private void savePtFinanceOrders(PartnerConfigEo config, List<PtFinanceOrder> ptFinanceOrders) {
        for (PtFinanceOrder ptFinanceOrder : ptFinanceOrders) {
            PtFinanceOrder example = PtFinanceOrder.newInstance();
            if (StringUtils.isBlank((CharSequence)ptFinanceOrder.getPtOrderId()) && StringUtils.isBlank((CharSequence)ptFinanceOrder.getRefundId())) break;
            example.setPtOrderId(ptFinanceOrder.getPtOrderId());
            example.setPtRefundId(ptFinanceOrder.getPtRefundId());
            example.setPartnerId(config.getPartnerCode());
            this.ptFinanceOrderDas.delete((BaseEo)example);
        }
        this.ptFinanceOrderDas.getMapper().insertBatch(ptFinanceOrders);
    }

    private void parse(String line, String fileName, PtFinanceOrder ptFinanceOrder) throws ParseException {
        List<String> dataList = Arrays.asList(line.split("&"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (fileName.startsWith("CZ")) {
            ptFinanceOrder.setUserId(dataList.get(1));
            ptFinanceOrder.setOrderAmt(new BigDecimal(dataList.get(4)));
            ptFinanceOrder.setFeeAmt(new BigDecimal(dataList.get(5)));
            ptFinanceOrder.setOrderTime(sdf.parse(dataList.get(6) + dataList.get(7)));
            ptFinanceOrder.setPtOrderId(dataList.get(9));
            ptFinanceOrder.setPayTypeId(dataList.get(11));
            ptFinanceOrder.setOrderId(dataList.get(12));
        } else if (fileName.startsWith("TX")) {
            ptFinanceOrder.setUserId(dataList.get(1));
            ptFinanceOrder.setOrderAmt(new BigDecimal(dataList.get(4)));
            ptFinanceOrder.setFeeAmt(new BigDecimal(dataList.get(5)));
            ptFinanceOrder.setOrderTime(sdf.parse(dataList.get(6) + dataList.get(7)));
            ptFinanceOrder.setPtOrderId(dataList.get(9));
            ptFinanceOrder.setPayTypeId(dataList.get(11));
            ptFinanceOrder.setOrderId(dataList.get(12));
        } else if (fileName.startsWith("JY")) {
            ptFinanceOrder.setPayTypeId(dataList.get(1));
            ptFinanceOrder.setUserId(dataList.get(2));
            ptFinanceOrder.setSellerNum(dataList.get(5));
            ptFinanceOrder.setSellerName(dataList.get(7));
            ptFinanceOrder.setOrderAmt(new BigDecimal(dataList.get(8)));
            ptFinanceOrder.setFeeAmt(new BigDecimal(dataList.get(9)));
            ptFinanceOrder.setOrderTime(sdf.parse(dataList.get(10) + dataList.get(11)));
            ptFinanceOrder.setPtOrderId(dataList.get(13));
            ptFinanceOrder.setOrderId(dataList.get(15));
        } else {
            ptFinanceOrder.setUserId(dataList.get(1));
            ptFinanceOrder.setPayTypeId("\u4f59\u989d");
            ptFinanceOrder.setOrderAmt(new BigDecimal(dataList.get(3)));
        }
    }
}

