/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl;

import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.DefaultGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.NotifyAssitantVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletQueryGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.EWalletGatewayService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="eWalletGatewayService")
public class EWalletGatewayServiceImpl
extends DefaultGatewayService
implements EWalletGatewayService {
    private static Logger logger = LoggerFactory.getLogger(EWalletGatewayServiceImpl.class);
    @Resource
    private AbstractEWalletGatewayService eWalletGatewayOrderCreateGatewayService;
    @Resource
    private AbstractEWalletGatewayService eWalletPayOrderNotifyGatewayService;
    @Resource
    private AbstractEWalletGatewayService eWalletRefundOrderNotifyGatewayService;
    @Resource
    private AbstractEWalletQueryGatewayService eWalletPayOrderQueryGatewayService;
    @Resource
    private AbstractEWalletQueryGatewayService eWalletRefundOrderQueryGatewayService;
    @Resource
    private AbstractEWalletGatewayService eWalletCreateRefundOrderGatewayService;
    @Resource
    private AbstractEWalletGatewayService eWalletOrderDownloadGatewayService;

    public BaseGatewayResult createPayTrade(PayOrderEo order) {
        return this.eWalletGatewayOrderCreateGatewayService.execute(order);
    }

    public BaseGatewayResult createRefundTrade(RefundOrderEo order) {
        return this.eWalletCreateRefundOrderGatewayService.execute(order);
    }

    public CheckResult checkOrder(String tradeId) {
        if (TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.PAY)) {
            logger.info("\u5f00\u59cb\u5904\u7406\u58f9\u94b1\u5305\u652f\u4ed8\u8ba2\u5355\u6838\u5bf9");
            return (CheckResult)this.eWalletPayOrderQueryGatewayService.execute(tradeId);
        }
        logger.info("\u5f00\u59cb\u5904\u7406\u58f9\u94b1\u5305\u9000\u6b3e\u8ba2\u5355\u6838\u5bf9");
        return (CheckResult)this.eWalletRefundOrderQueryGatewayService.execute(tradeId);
    }

    public BaseGatewayResult handleNotify(Map<String, String> notify, String ntfyTradeId) throws Exception {
        if (TradeIdType.verifyIdType((String)ntfyTradeId, (TradeIdType)TradeIdType.PAY)) {
            return this.eWalletPayOrderNotifyGatewayService.execute(new NotifyAssitantVo(ntfyTradeId, notify));
        }
        if (TradeIdType.verifyIdType((String)ntfyTradeId, (TradeIdType)TradeIdType.REFUND)) {
            return this.eWalletRefundOrderNotifyGatewayService.execute(new NotifyAssitantVo(ntfyTradeId, notify));
        }
        throw new Exception("\u65e0\u6cd5\u5904\u7406\u6e20\u9053\u901a\u77e5");
    }

    public BaseGatewayResult downloadTradeOrder(PartnerConfigEo partnerConfig) {
        return this.eWalletOrderDownloadGatewayService.execute(partnerConfig);
    }

    public BaseGatewayResult createEnterpriseTransferOrder(EnterpriseOrderEo order) {
        return null;
    }
}

