/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.finnace;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.finance.BillRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.finance.BillResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PtFinanceOrder;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PtOriginOrder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="eWalletOrderDownloadGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletOrderDownloadGatewayServiceImpl
extends AbstractEWalletGatewayService<PartnerConfigEo, BillResponse> {
    private Logger logger = LoggerFactory.getLogger(EWalletOrderDownloadGatewayServiceImpl.class);

    public BaseGatewayResult rechargeResult(PartnerConfigEo payPartnerConfig, BillResponse billResponse) throws Exception {
        if (billResponse != null && StringUtils.isBlank((CharSequence)billResponse.getErrorCode()) && StringUtils.isBlank((CharSequence)billResponse.getErrorMsg()) && !CollectionUtils.isEmpty((Collection)billResponse.getiOrderListDetail())) {
            this.saveOrders(payPartnerConfig, billResponse.getiOrderListDetail());
        }
        return new GatewayResult(null);
    }

    private void saveOrders(PartnerConfigEo config, List<Map<String, String>> iOrderListDetail) throws Exception {
        ArrayList<PtOriginOrder> ptOriginOrders = new ArrayList<PtOriginOrder>();
        ArrayList<PtFinanceOrder> ptFinanceOrders = new ArrayList<PtFinanceOrder>();
        for (Map<String, String> orderMap : iOrderListDetail) {
            PtOriginOrder originOrder = PtOriginOrder.newInstance();
            originOrder.setCreateTime(new Date());
            originOrder.setOriginOrder(JSON.toJSONString(orderMap));
            originOrder.setPartnerId(config.getPartnerCode());
            originOrder.setPtAppId(config.getPtAccount());
            originOrder.setPtMerId(config.getPtMerId());
            originOrder.setPtOrderId(orderMap.get("orderId"));
            ptOriginOrders.add(originOrder);
            PtFinanceOrder financeOrder = PtFinanceOrder.newInstance();
            financeOrder.setPayTypeId("200,201");
            financeOrder.setCreateTime(new Date());
            financeOrder.setOrderStatus("01".equals(orderMap.get("status")) ? "S" : "A");
            financeOrder.setOrderTime(new DateTime((Object)orderMap.get("date")).toDate());
            financeOrder.setFeeAmt(new BigDecimal(orderMap.get("charge")));
            financeOrder.setPtMerId(config.getPtMerId());
            financeOrder.setPartnerId(config.getPartnerCode());
            financeOrder.setPtAccountId(config.getPtAccount());
            financeOrder.setPtOrderId(orderMap.get("orderId"));
            financeOrder.setCurrencyType(orderMap.get("currency"));
            financeOrder.setOrderAmt(new BigDecimal(orderMap.get("amount")));
            financeOrder.setPayTypeId(orderMap.get("settleflg"));
            financeOrder.setFeeRate(orderMap.get("chargeflg"));
            ptFinanceOrders.add(financeOrder);
        }
        this.savePtOriginOrders(config, ptOriginOrders);
        this.savePtFinanceOrders(config, ptFinanceOrders);
    }

    private void savePtOriginOrders(PartnerConfigEo config, List<PtOriginOrder> ptOriginOrders) {
        for (PtOriginOrder ptOriginOrder : ptOriginOrders) {
            PtOriginOrder example = PtOriginOrder.newInstance();
            example.setPartnerId(config.getPartnerCode());
            example.setPtOrderId(ptOriginOrder.getPtOrderId());
            this.ptOriginOrderDas.delete((BaseEo)example);
        }
        this.ptOriginOrderDas.getMapper().insertBatch(ptOriginOrders);
    }

    private void savePtFinanceOrders(PartnerConfigEo config, List<PtFinanceOrder> ptFinanceOrders) {
        for (PtFinanceOrder ptFinanceOrder : ptFinanceOrders) {
            PtFinanceOrder example = PtFinanceOrder.newInstance();
            example.setPtOrderId(ptFinanceOrder.getPtOrderId());
            example.setPartnerId(config.getPartnerCode());
            this.ptFinanceOrderDas.delete((BaseEo)example);
        }
        this.ptFinanceOrderDas.getMapper().insertBatch(ptFinanceOrders);
    }

    public BillResponse _execute(PartnerConfigEo payPartnerConfig) throws Exception {
        if (StringUtils.isBlank((CharSequence)payPartnerConfig.getLcPrivKey())) {
            return null;
        }
        BillRequest request = new BillRequest();
        request.setMasterId(payPartnerConfig.getPtMerId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar date = Calendar.getInstance();
        if (NumberUtils.isNumber((String)payPartnerConfig.getMemo())) {
            date.add(5, -Integer.valueOf(payPartnerConfig.getMemo()).intValue());
        } else {
            date.add(5, -1);
        }
        request.setDate(sdf.format(date.getTime()));
        request.setEncryptKey(payPartnerConfig.getLcPrivKey());
        request.setDecryptKey(payPartnerConfig.getPtPubKey());
        return this.eWalletPartnerService.downloadOrder(request);
    }

    public void validate(PartnerConfigEo payPartnerConfig, BillResponse billResponse) throws Exception {
    }
}

