/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.notify;

import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.NotifyAssitantVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.NotifyMsg;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="eWalletPayOrderNotifyGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletPayOrderNotifyGatewayServiceImpl
extends AbstractEWalletGatewayService<NotifyAssitantVo, NotifyMsg> {
    public BaseGatewayResult rechargeResult(NotifyAssitantVo notifyAssitantVo, NotifyMsg notifyMsg) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)notifyMsg.getAccNo()) && StringUtils.isNotBlank((CharSequence)notifyMsg.getOpenId())) {
            this.logger.warn("\u5feb\u6377\u652f\u4ed8\u529f\u80fd\u672a\u53ef\u7528\uff01\uff01\u6682\u4e0d\u5904\u7406\u8be5\u901a\u77e5");
        } else {
            this.handleOrderNotify(notifyAssitantVo.getTradeId(), notifyMsg);
        }
        return this.parseResponse((BaseGatewayResult)new GatewayResult(notifyAssitantVo.getTradeId()), (BaseRespDomain)notifyMsg);
    }

    private void handleOrderNotify(String tradeId, NotifyMsg notifyMsg) throws Exception {
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)tradeId);
        if ("01".equals(notifyMsg.getStatus())) {
            partnerOrder.setAmount(new BigDecimal(notifyMsg.getAmount()));
            DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
            DateTime dateTime = DateTime.parse((String)notifyMsg.getDate(), (DateTimeFormatter)format);
            partnerOrder.setFinishTime(dateTime.toDate());
            this.payOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else {
            partnerOrder.setErrorCode(notifyMsg.getErrorCode());
            partnerOrder.setErrorMsg(notifyMsg.getErrorMsg());
            this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
    }

    public void validate(NotifyAssitantVo notifyAssitantVo, NotifyMsg notifyMsg) throws Exception {
    }

    public NotifyMsg _execute(NotifyAssitantVo notifyAssitantVo) throws Exception {
        if (StringUtils.isBlank((CharSequence)notifyAssitantVo.getTradeId())) {
            this.logger.error("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c \u6e20\u9053\u8ba2\u5355\u4e3a\uff1a{}", (Object)notifyAssitantVo.getTradeId());
            throw new Exception("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)notifyAssitantVo.getTradeId());
        if (null == payOrder) {
            this.logger.error("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c \u6e20\u9053\u8ba2\u5355\u4e3a\uff1a{}", (Object)notifyAssitantVo.getTradeId());
            throw new Exception("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        PartnerConfigEo cfg = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        return (NotifyMsg)this.eWalletPartnerService.parseNotify(notifyAssitantVo.getNotify(), cfg);
    }
}

