/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.notify;

import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.NotifyAssitantVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.NotifyMsg;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="eWalletRefundOrderNotifyGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletRefundOrderNotifyGatewayServiceImpl
extends AbstractEWalletGatewayService<NotifyAssitantVo, NotifyMsg> {
    public BaseGatewayResult rechargeResult(NotifyAssitantVo notifyAssitantVo, NotifyMsg notifyMsg) throws Exception {
        if ("01".equals(notifyMsg.getStatus())) {
            RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)notifyAssitantVo.getTradeId());
            partnerOrder.setAmount(new BigDecimal(notifyMsg.getAmount()));
            DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
            DateTime dateTime = DateTime.parse((String)notifyMsg.getDate(), (DateTimeFormatter)format);
            partnerOrder.setFinishTime(dateTime.toDate());
            this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else {
            this.logger.warn("\u6e20\u9053\u901a\u77e5\uff0c\u6e05\u5355\u72b6\u6001\u4e0d\u662f\u6210\u529f\uff0c\u4e0d\u5904\u7406\u8ba2\u5355");
        }
        return this.parseResponse((BaseGatewayResult)new GatewayResult(notifyAssitantVo.getTradeId()), (BaseRespDomain)notifyMsg);
    }

    public NotifyMsg _execute(NotifyAssitantVo notifyAssitantVo) throws Exception {
        if (StringUtils.isBlank((CharSequence)notifyAssitantVo.getTradeId())) {
            this.logger.error("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c \u6e20\u9053\u8ba2\u5355\u4e3arefundId\uff1a{}", (Object)notifyAssitantVo.getTradeId());
            throw new Exception("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        RefundOrderEo payOrder = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)notifyAssitantVo.getTradeId());
        if (null == payOrder) {
            this.logger.error("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c \u6e20\u9053\u8ba2\u5355\u4e3arefundId\uff1a{}", (Object)notifyAssitantVo.getTradeId());
            throw new Exception("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        PartnerConfigEo cfg = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        return (NotifyMsg)this.eWalletPartnerService.parseNotify(notifyAssitantVo.getNotify(), cfg);
    }

    public void validate(NotifyAssitantVo notifyAssitantVo, NotifyMsg notifyMsg) throws Exception {
        RefundOrderEo payOrder = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)notifyAssitantVo.getTradeId());
        if (!payOrder.getRemark1().equals(notifyMsg.getOrderId())) {
            this.logger.error("\u6e20\u9053\u8ba2\u5355\u4e0d\u5b58\u5728\u3002\u672c\u5730\u8ba2\u5355refundId={}\uff0cremark1={}\uff0c \u6e20\u9053\u8ba2\u5355orderId={}", new Object[]{notifyAssitantVo.getTradeId(), payOrder.getRemark1(), notifyMsg.getOrderId()});
            throw new PartnerException("\u6e20\u9053\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
    }
}

