/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.query;

import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletQueryGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.OrderQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.OrderQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="eWalletPayOrderQueryGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletPayOrderQueryGatewayServiceImpl
extends AbstractEWalletQueryGatewayService<OrderQueryResp> {
    public BaseGatewayResult rechargeResult(String tradeId, OrderQueryResp resp) throws Exception {
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)tradeId);
        PayOrderAttachInfoEo attachInfoEo = PayOrderAttachInfoEo.newInstance();
        attachInfoEo.setTradeId(tradeId);
        CheckResult result = new CheckResult(1, tradeId);
        if ("01".equals(resp.getStatus())) {
            partnerOrder.setAmount(new BigDecimal(resp.getAmount()));
            attachInfoEo.setRemark1(resp.getSettleflg());
            this.payOrderProcessorService.handleSuccOrder((Object)partnerOrder, (Object)attachInfoEo);
        } else if (!"00".equals(resp.getStatus())) {
            if (StringUtils.isBlank((CharSequence)resp.getErrorCode())) {
                resp.setErrorCode("2222");
                resp.setErrorMsg("\u672a\u77e5\u9519\u8bef");
            }
            partnerOrder.setErrorMsg(resp.getErrorMsg());
            partnerOrder.setErrorCode(resp.getErrorCode());
            this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        return result;
    }

    public OrderQueryResp _execute(String tradeId) throws Exception {
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
        PartnerConfigEo partnerConfig = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        OrderQueryReq req = new OrderQueryReq(partnerConfig.getPtMerId(), payOrder.getPartnerOrderId(), partnerConfig.getLcPrivKey(), partnerConfig.getPtPubKey());
        return (OrderQueryResp)this.eWalletPartnerService.queryOrder((Object)req);
    }

    public void validate(String tradeId, OrderQueryResp resp) throws Exception {
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
        if (!payOrder.getPartnerOrderId().equals(resp.getOrderId())) {
            this.logger.error("\u672c\u5730\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c \u672c\u5730\u8ba2\u5355\uff1atradeId={}, partnerOrderId={}, \u6e20\u9053\u8ba2\u5355\uff1aorderId={}", new Object[]{tradeId, payOrder.getPartnerOrderId(), resp.getOrderId()});
            throw new PartnerException("\u6e20\u9053\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
    }
}

