/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.bean.AttachInfo;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.AqSmsCodeReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.GwPlaceReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.GwPlaceResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.NotifyAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="eWalletGatewayOrderCreateGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletGatewayOrderCreateGatewayServiceImpl
extends AbstractEWalletGatewayService<PayOrderEo, GwPlaceResp> {
    @Resource
    private PartnerConfigManager partnerConfigManager;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrder, GwPlaceResp resp) throws Exception {
        GatewayResult result = new GatewayResult(true, payOrder.getTradeId());
        if ("01".equals(resp.getStatus()) || "00".equals(resp.getStatus())) {
            this.payOrderProcessorService.handleAcceptOrder((Object)payOrder);
        } else {
            if (StringUtils.isBlank((CharSequence)resp.getErrorCode())) {
                resp.setErrorCode("2222");
                resp.setErrorMsg("\u672a\u77e5\u9519\u8bef");
            }
            result.setErrorMsg(resp.getErrorMsg());
            result.setErrorCode(resp.getErrorCode());
            result.setDoneSucc(false);
            this.payOrderProcessorService.handleFailOrder((Object)payOrder);
        }
        return result;
    }

    public GwPlaceResp _execute(PayOrderEo payOrder) throws Exception {
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        PayOrderAttachInfoEo attachInfoEo = (PayOrderAttachInfoEo)this.payOrderAttachInfoDas.selectByLogicKey((Object)payOrder.getTradeId());
        this.recordOrderNo(payOrder, config.getPtMerId());
        AttachInfo attachInfo = this.getAttachInfo(payOrder);
        if (StringUtils.isNotBlank((CharSequence)payOrder.getRemark())) {
            AqSmsCodeReq request = new AqSmsCodeReq();
            request.setMasterId(config.getPtMerId());
            request.setOrderId(attachInfoEo.getRemark1());
            request.setAmount(payOrder.getAmount().toString());
            request.setObjectName(payOrder.getBody());
            request.setPaydate(new DateTime((Object)payOrder.getOrderTime()).toString("yyyyMMddHHmmss"));
            String millis = payOrder.getExpireTime() == null ? String.valueOf(0x6DDD00) : String.valueOf(payOrder.getExpireTime() * 60 * 1000);
            request.setValidtime(millis);
            request.setCustomerId(payOrder.getUserId());
            request.setNOTIFYURL(NotifyAssistant.getNotifyUrlWithTradeId((String)payOrder.getTradeId(), (String)"ewallet"));
            request.setVerifyCode(payOrder.getRemark());
            request.setOpenId(attachInfo.getBindId());
            request.setIssInsCode(attachInfo.getIssInsCode());
            request.setPayCardType(attachInfo.getPayCardType());
            request.setRemark(this.createRemark(payOrder.getPtUserId(), this.partnerConfigManager.getEPayPartnerconfig().getPtMerId()));
            request.setDecryptKey(config.getPtPubKey());
            request.setEncryptKey(config.getLcPrivKey());
            return this.eWalletPartnerService.verifyCode(request);
        }
        GwPlaceReq req = new GwPlaceReq();
        req.setMasterId(config.getPtMerId());
        req.setOrderId(attachInfoEo.getRemark1());
        req.setAmount(payOrder.getAmount().toString());
        req.setObjectName(payOrder.getBody());
        req.setPaydate(new DateTime((Object)payOrder.getOrderTime()).toString("yyyyMMddHHmmss"));
        req.setCustomerId(payOrder.getUserId());
        req.setOpenId(attachInfo.getBindId());
        String millis = payOrder.getExpireTime() == null ? String.valueOf(0x6DDD00) : String.valueOf(payOrder.getExpireTime() * 60 * 1000);
        req.setValidtime(millis);
        req.setDecryptKey(config.getPtPubKey());
        req.setEncryptKey(config.getLcPrivKey());
        this.logger.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)req.toString());
        return this.eWalletPartnerService.placeGwOrder(req);
    }

    public void validate(PayOrderEo payOrder, GwPlaceResp placeResp) throws Exception {
    }

    private String createRemark(String ptUserId, String ptMerId) {
        ArrayList root = new ArrayList();
        HashMap<String, Object> remarkMap = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        remarkMap.put("oderlist", list);
        HashMap<String, String> ptUserMap = new HashMap<String, String>();
        ptUserMap.put("SubAccNo", ptUserId);
        ptUserMap.put("PayModel", "1");
        ptUserMap.put("TranFee", "0");
        remarkMap.put("SFJOrdertype", "0");
        remarkMap.put("remarktype", "SDS0100000");
        remarkMap.put("plantCode", ptMerId);
        list.add(ptUserMap);
        root.add(remarkMap);
        return JSON.toJSONString(root);
    }
}

