/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.ewallet.AbstractEWalletGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.RefundReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.RefundResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.NotifyAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="eWalletCreateRefundOrderGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EWalletRefundOrderCreateGatewayServiceImpl
extends AbstractEWalletGatewayService<RefundOrderEo, RefundResp> {
    @Resource
    private PartnerConfigManager partnerConfigManager;

    public BaseGatewayResult rechargeResult(RefundOrderEo payOrder, RefundResp resp) throws Exception {
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)payOrder.getRefundId());
        if ("01".equals(resp.getStatus())) {
            this.payRefundOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
            this.mqMessageService.sendDelaySingleMessageAsync("YX_PAY_ORDER_CHECK", (Object)payOrder.getRefundId(), DEFAULT_QUERY_DELAY_TIME);
        } else {
            if (StringUtils.isBlank((CharSequence)resp.getErrorCode())) {
                resp.setErrorCode("2222");
                resp.setErrorMsg("\u672a\u77e5\u9519\u8bef");
            }
            partnerOrder.setErrorMsg(resp.getErrorMsg());
            partnerOrder.setErrorCode(resp.getErrorCode());
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        return this.parseResponse((BaseGatewayResult)new GatewayResult(partnerOrder.getRefundId()), (BaseRespDomain)resp);
    }

    public RefundResp _execute(RefundOrderEo refundOrder) throws Exception {
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)refundOrder.getPartnerConfigCode());
        String notifyUrl = NotifyAssistant.getNotifyUrlWithTradeId((String)refundOrder.getRefundId(), (String)"ewallet");
        RefundReq req = new RefundReq();
        req.setMasterId(config.getPtMerId());
        req.setRefundNo(refundOrder.getPartnerOrderId());
        req.setOrderId(refundOrder.getRemark5());
        req.setRefundAmt(refundOrder.getAmount().toString());
        req.setObjectName("\u8ba2\u5355\u9000\u6b3e");
        req.setRemark(this.createRemark(refundOrder.getPtUserId(), this.partnerConfigManager.getEPayPartnerconfig().getPtMerId()));
        req.setNOTIFYURL(notifyUrl);
        req.setEncryptKey(config.getLcPrivKey());
        req.setDecryptKey(config.getPtPubKey());
        return (RefundResp)this.eWalletPartnerService.refundOrder((Object)req);
    }

    private String createRemark(String ptUserId, String ptMerId) {
        ArrayList list = new ArrayList();
        LinkedHashMap<String, Object> temp = new LinkedHashMap<String, Object>();
        temp.put("SFJOrdertype", "0");
        ArrayList orderList = new ArrayList();
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("SubAccNo", ptUserId);
        order.put("refundModel", "1");
        order.put("RefundTranFee", "0");
        orderList.add(order);
        temp.put("oderlist", orderList);
        temp.put("remarktype", "SDT0100000");
        temp.put("plantCode", ptMerId);
        list.add(temp);
        return JSON.toJSONString(list);
    }

    public void validate(RefundOrderEo payRefundOrder, RefundResp refundResp) throws Exception {
    }
}

