/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.impl;

import com.dtyunxi.yundt.cube.center.payment.core.util.Coder;
import com.dtyunxi.yundt.cube.center.payment.service.constants.SafetyConstants;
import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.partner.domain.BasePartnerDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.AbstractEWalletPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.EWalletPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.RequestVo;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.bank.BindCardQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.bank.BindCardQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.finance.BillRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.finance.BillResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.OrderQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.OrderQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.RefundQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.query.RefundQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.AqSmsCodeReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.GwPlaceReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.GwPlaceResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.NotifyMsg;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.RefundReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.trade.RefundResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.net.URLDecoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="eWalletPartnerService")
public class EWalletPartnerServiceImpl
extends AbstractEWalletPartnerService
implements EWalletPartnerService {
    private static Logger logger = LoggerFactory.getLogger(EWalletPartnerServiceImpl.class);

    public RefundResp refundOrder(RefundReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getRefund());
        RefundResp resp = new RefundResp();
        return (RefundResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)resp);
    }

    public OrderQueryResp queryOrder(OrderQueryReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getQuery());
        OrderQueryResp resp = new OrderQueryResp();
        return (OrderQueryResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)resp);
    }

    public NotifyMsg parseNotify(Map<String, String> notifyMap, PartnerConfigEo info) throws Exception {
        RequestVo requestVo = new RequestVo();
        requestVo = (RequestVo)requestVo.map2Bean(notifyMap);
        requestVo.setOrig(new String(Coder.decryptBASE64((String)URLDecoder.decode(requestVo.getOrig(), "GBK")), "GBK"));
        requestVo.setSign(new String(Coder.decryptBASE64((String)URLDecoder.decode(requestVo.getSign(), "GBK"))));
        logger.info("\u6536\u5230\u58f9\u94b1\u5305\u6e20\u9053\u901a\u77e5:{}", (Object)requestVo.toString());
        NotifyMsg notifyMsg = new NotifyMsg();
        notifyMsg.setDecryptKey(info.getPtPubKey());
        if (!notifyMsg.verifySign(requestVo.getOrig(), requestVo.getSign())) {
            logger.error("\u7b7e\u540d\u9519\u8bef");
            throw new PartnerException("\u7b7e\u540d\u9519\u8bef");
        }
        logger.info("\u7b7e\u540d\u901a\u8fc7\uff01 true");
        notifyMsg = (NotifyMsg)notifyMsg.requestVo2Bean(requestVo);
        return notifyMsg;
    }

    public GwPlaceResp placeGwOrder(GwPlaceReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getGetMessageCode());
        return (GwPlaceResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)new GwPlaceResp());
    }

    public GwPlaceResp verifyCode(AqSmsCodeReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getGwPlace());
        return (GwPlaceResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)new GwPlaceResp());
    }

    public RefundQueryResp queryRefundOrder(RefundQueryReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getRefundQuery());
        RefundQueryResp resp = new RefundQueryResp();
        return (RefundQueryResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)resp);
    }

    public BindCardQueryResp queryBindCard(BindCardQueryReq request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getQueryBindCard());
        return (BindCardQueryResp)this.execute((BasePartnerDomain)request, (BasePartnerDomain)new BindCardQueryResp());
    }

    public BillResponse downloadOrder(BillRequest request) throws Exception {
        request.setRequestUrl(SafetyConstants.EWALLETCFG.getFinance());
        return (BillResponse)this.execute((BasePartnerDomain)request, (BasePartnerDomain)new BillResponse());
    }

    public GwPlaceResp placeOrder(GwPlaceReq placeRequest) throws Exception {
        return null;
    }
}

