/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.util;

import com.dtyunxi.yundt.cube.center.payment.service.constants.SafetyConstants;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class EWalletHttpUtil {
    public static boolean hostnameVerifier = false;

    private static int getVendorType() {
        Properties tSysProperties = System.getProperties();
        String tJvmVendor = tSysProperties.getProperty("java.vm.vendor");
        if (tJvmVendor.equals("IBM Corporation")) {
            return 1;
        }
        return 0;
    }

    public static SSLSocketFactory getSSLSocket(String jksPath, String pas) throws Exception {
        int iProviderType = EWalletHttpUtil.getVendorType();
        SSLSocketFactory ssf = null;
        try {
            TrustManagerFactory tmf;
            KeyManagerFactory kmf;
            SSLContext sslContext = null;
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            if (iProviderType == 1) {
                sslContext = SSLContext.getInstance("TLS", "IBMJSSE2");
                kmf = KeyManagerFactory.getInstance("IbmX509");
                tmf = TrustManagerFactory.getInstance("IbmX509");
            } else {
                sslContext = SSLContext.getInstance("TLS", "SunJSSE");
                kmf = KeyManagerFactory.getInstance("SunX509");
                tmf = TrustManagerFactory.getInstance("SunX509");
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(EWalletHttpUtil.class.getResourceAsStream(jksPath), pas.toCharArray());
            kmf.init(ks, pas.toCharArray());
            KeyStore tks = KeyStore.getInstance("JKS");
            tks.load(EWalletHttpUtil.class.getResourceAsStream(jksPath), pas.toCharArray());
            tmf.init(tks);
            sslContext.init(kmf.getKeyManagers(), tm, new SecureRandom());
            ssf = sslContext.getSocketFactory();
            return ssf;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static byte[] sendData(byte[] aOutputData, String serverUrl) throws Exception {
        int readlen;
        SSLSocketFactory ssf = EWalletHttpUtil.getSSLSocket(SafetyConstants.EWALLETCFG.getCertPath(), SafetyConstants.EWALLETCFG.getCertPass());
        HttpsURLConnection.setDefaultSSLSocketFactory(ssf);
        URL url = new URL(serverUrl);
        boolean ishttps = false;
        if (serverUrl.startsWith("https://")) {
            ishttps = true;
        }
        HttpURLConnection http = null;
        http = (HttpURLConnection)url.openConnection();
        if (!hostnameVerifier && ishttps) {
            ((HttpsURLConnection)http).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        if (ishttps) {
            ((HttpsURLConnection)http).setSSLSocketFactory(ssf);
        }
        http.setConnectTimeout(10000);
        http.setReadTimeout(60000);
        http.setDoOutput(true);
        http.setDoInput(true);
        http.setAllowUserInteraction(false);
        http.setUseCaches(false);
        http.setRequestMethod("POST");
        http.setRequestProperty("content-type", "application/x-www-form-urlencoded; charset=utf-8");
        http.setRequestProperty("Content-Length", String.valueOf(aOutputData.length));
        http.setRequestProperty("Connection", "close");
        http.setRequestProperty("User-Agent", "sdb client");
        http.setRequestProperty("Accept", "text/xml");
        OutputStream out = http.getOutputStream();
        out.write(aOutputData);
        out.flush();
        ByteArrayOutputStream byteout = new ByteArrayOutputStream(4096);
        InputStream in = http.getInputStream();
        int code = http.getResponseCode();
        if (code != 200) {
            throw new Exception("validation.yikou.network.webservice");
        }
        byte[] buf = new byte[4096];
        while ((readlen = in.read(buf, 0, 4096)) >= 0) {
            if (readlen <= 0) continue;
            byteout.write(buf, 0, readlen);
        }
        out.close();
        in.close();
        return byteout.toByteArray();
    }
}

