/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.util;

import com.dtyunxi.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;

public class ExportRsaKey {
    private File keystoreFile;
    private String keyStoreType;
    private char[] password;

    public static KeyPair getPublicKey(KeyStore keystore, String alias) throws Exception {
        PublicKey key = keystore.getCertificate(alias).getPublicKey();
        if (key instanceof PublicKey) {
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, null);
        }
        return null;
    }

    public static KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) throws Exception {
        Key key = keystore.getKey(alias, password);
        if (key instanceof PrivateKey) {
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        return null;
    }

    public void exportPrivateKey(String fileName, String alias) throws Exception {
        KeyStore keystore = KeyStore.getInstance(this.keyStoreType);
        keystore.load(new FileInputStream(this.keystoreFile), this.password);
        KeyPair keyPair = ExportRsaKey.getPrivateKey(keystore, alias, this.password);
        if (null != keyPair) {
            System.out.println("\u5f00\u59cb\u5bfc\u51fa\u79c1\u94a5\uff1a");
            this.dumpKey(keyPair.getPrivate(), fileName);
        } else {
            System.out.println("keyPair \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\u79c1\u94a5");
        }
    }

    public void exportPublicKey(String fileName, String alias) throws Exception {
        KeyStore keystore = KeyStore.getInstance(this.keyStoreType);
        keystore.load(new FileInputStream(this.keystoreFile), this.password);
        KeyPair keyPair = ExportRsaKey.getPublicKey(keystore, alias);
        if (null != keyPair) {
            System.out.println("\u5f00\u59cb\u5bfc\u51fa\u516c\u94a5\uff1a");
            this.dumpKey(keyPair.getPublic(), fileName);
        } else {
            System.out.println("keyPair \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\u516c\u94a5");
        }
    }

    private void dumpKey(Key key, String fileName) throws Exception {
        String encoded = Base64.encodeString((String)new String(key.getEncoded()));
        System.out.println("\u5bfc\u51fakey\u4e3a\uff1a\n" + encoded);
        FileWriter fw = new FileWriter(fileName);
        fw.write(encoded);
        fw.close();
    }

    public static void main(String[] args) throws Exception {
        String pub_alias = "sdb";
        String priv_alias = "mykey";
        String pub_file = "ewallet_rsa_public.txt";
        String priv_file = "ewallet_rsa_private.txt";
        ExportRsaKey export = new ExportRsaKey();
        export.keystoreFile = new File("C:\\Users\\huang.kuiyi\\Desktop\\\u5e73\u5b89\u94f6\u884c\\\u5e73\u5b89\u652f\u4ed8-\u5bcc\u529b\u5bc6\u94a5\u7b49\\merchant-\u7528\u4e8e\u8de8\u884c\u5feb\u6377-\u5bc6\u7801\uff1achangeit.jks");
        export.keyStoreType = "JKS";
        export.password = "changeit".toCharArray();
        export.exportPrivateKey(priv_file, priv_alias);
        export.exportPublicKey(pub_file, pub_alias);
    }
}

