/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.RCustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RCustomerSalesmanServiceImpl
implements IRCustomerSalesmanService {
    @Autowired
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncBatchAdd(List<RCustomerSalesmanEo> customerSalesmanEos) {
        if (CollectionUtil.isEmpty(customerSalesmanEos)) {
            return;
        }
        Map<Long, List<RCustomerSalesmanEo>> collect = customerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getSalesmanId));
        ArrayList disCustomerSalesmanEos = Lists.newArrayList();
        for (Long salesmanId : collect.keySet()) {
            ArrayList customerIds = Lists.newArrayList();
            ArrayList orgIds = Lists.newArrayList();
            for (RCustomerSalesmanEo rCustomerSalesmanEo : collect.get(salesmanId)) {
                customerIds.add(rCustomerSalesmanEo.getCustomerId());
                orgIds.add(rCustomerSalesmanEo.getOrgId());
            }
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(salesmanId);
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)customerIds));
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)orgIds));
            eo.setSqlFilters((List)sqlFilters);
            List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            Map<String, RCustomerSalesmanEo> oldRelationMap = eos.stream().collect(Collectors.toMap(e -> e.getSalesmanId() + "#" + e.getCustomerId() + "#" + e.getOrgId(), e -> e, (e1, e2) -> e1));
            List collect1 = collect.get(salesmanId).stream().filter(e -> !oldRelationMap.containsKey(e.getSalesmanId() + "#" + e.getCustomerId() + "#" + e.getOrgId())).collect(Collectors.toList());
            disCustomerSalesmanEos.addAll(collect1);
        }
        if (CollectionUtil.isNotEmpty((Collection)disCustomerSalesmanEos)) {
            this.rCustomerSalesmanDas.insertBatch((List)disCustomerSalesmanEos);
        }
    }

    @Override
    public List<RCustomerSalesmanRespDto> queryByUserId(Long userId) {
        if (userId == null) {
            return Lists.newArrayList();
        }
        RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
        eo.setSalesmanId(userId);
        List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eos, RCustomerSalesmanRespDto.class);
        return list;
    }

    @Override
    public List<RCustomerSalesmanRespDto> queryList(RCustomerSalesmanReqDto rCustomerSalesmanReqDto) {
        if (rCustomerSalesmanReqDto.getCustomerId() == null && rCustomerSalesmanReqDto.getSalesmanId() == null) {
            return Lists.newArrayList();
        }
        RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)rCustomerSalesmanReqDto, (String[])new String[0]);
        List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)eos, RCustomerSalesmanRespDto.class);
        return respDtos;
    }

    @Override
    public PageInfo<RCustomerSalesmanRespDto> queryPage(RCustomerSalesmanReqDto rCustomerSalesmanReqDto) {
        RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)rCustomerSalesmanReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.rCustomerSalesmanDas.selectPage((BaseEo)eo, rCustomerSalesmanReqDto.getPageNum(), rCustomerSalesmanReqDto.getPageSize());
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eoPageInfo.getList(), RCustomerSalesmanRespDto.class);
        respDtoPageInfo.setList((List)list);
        return respDtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(RCustomerSalesmanReqDto salesmanReqDto) {
        Long customerId = salesmanReqDto.getCustomerId();
        Long orgId = salesmanReqDto.getOrgId();
        if (customerId == null || orgId == null || CollectionUtils.isEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            return;
        }
        RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
        eo.setCustomerId(customerId);
        eo.setOrgId(orgId);
        this.rCustomerSalesmanDas.delete((BaseEo)eo);
        Map<Long, Long> salesmanMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerSalesmanDas.filter(true).in((Object)"user_id", (Collection)salesmanReqDto.getSalesmanIds())).eq((Object)"org_info_id", (Object)orgId)).list().stream().collect(Collectors.toMap(StdCustomerSalesmanEo::getUserId, BaseEo::getId, (o, o1) -> o));
        if (CollectionUtil.isNotEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            ArrayList list = Lists.newArrayList();
            for (Long salesmanId : salesmanReqDto.getSalesmanIds()) {
                RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(salesmanId);
                rCustomerSalesmanEo.setCustomerId(customerId);
                rCustomerSalesmanEo.setOrgId(orgId);
                rCustomerSalesmanEo.setRealSalesmanId(salesmanMap.get(salesmanId));
                list.add(rCustomerSalesmanEo);
            }
            this.rCustomerSalesmanDas.insertBatch((List)list);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(RCustomerSalesmanReqDto salesmanReqDto) {
        Long customerId = salesmanReqDto.getCustomerId();
        Long orgId = salesmanReqDto.getOrgId();
        if (customerId == null || orgId == null) {
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            ArrayList list = Lists.newArrayList();
            for (Long salesmanId : salesmanReqDto.getSalesmanIds()) {
                RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(salesmanId);
                rCustomerSalesmanEo.setCustomerId(customerId);
                rCustomerSalesmanEo.setOrgId(orgId);
                list.add(rCustomerSalesmanEo);
            }
            this.rCustomerSalesmanDas.insertBatch((List)list);
        }
    }

    @Override
    public List<RCustomerSalesmanRespDto> queryByUserIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"salesman_id", userIds));
        eo.setSqlFilters(sqlFilters);
        List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eos, RCustomerSalesmanRespDto.class);
        return list;
    }
}

