/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerLevelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerLevelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerLevelService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerLevelEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="customerLevelService")
public class CustomerLevelServiceImpl
implements ICustomerLevelService {
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private ICustomerExtService customerExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CustomerLevelReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        reqDto.setId(null);
        this.validCustomerLevelName(reqDto);
        CustomerLevelEo customerLevelEo = CustomerLevelEo.newInstance();
        this.initCustomerLevelEo(reqDto, customerLevelEo);
        customerLevelEo.setOrgInfoId(this.customerExtService.getCurrentUserOrgId());
        this.customerLevelDas.insert((BaseEo)customerLevelEo);
        return customerLevelEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(CustomerLevelReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg());
        CustomerLevelEo queryEo = (CustomerLevelEo)this.customerLevelDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_LEVEL_NON_EXIST.getMsg());
        reqDto.setType(queryEo.getType());
        this.validCustomerLevelName(reqDto);
        queryEo.setName(reqDto.getName());
        this.customerLevelDas.updateSelective((BaseEo)queryEo);
    }

    @Override
    public void delete(Long id) {
        CustomerEo queryEo = new CustomerEo();
        queryEo.setLevelId(id);
        MybatisPlusUtils.checkUnique(this.customerDas, queryEo, CustomerExceptionCode.CUSTOMER_LEVEL_EXISTS_CUSTOMER.getCode(), CustomerExceptionCode.CUSTOMER_LEVEL_EXISTS_CUSTOMER.getMsg());
        this.customerLevelDas.logicDeleteById(id);
    }

    @Override
    public CustomerLevelRespDto queryById(Long id) {
        CustomerLevelEo customerLevelEo = (CustomerLevelEo)this.customerLevelDas.selectByPrimaryKey(id);
        Assert.notNull((Object)customerLevelEo, (String)CustomerExceptionCode.CUSTOMER_LEVEL_NON_EXIST.getMsg());
        CustomerLevelRespDto customerLevelRespDto = new CustomerLevelRespDto();
        DtoHelper.eo2Dto((BaseEo)customerLevelEo, (BaseVo)customerLevelRespDto);
        return customerLevelRespDto;
    }

    @Override
    public PageInfo<CustomerLevelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerLevelEo customerLevelEo = CustomerLevelEo.newInstance();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            CustomerLevelReqDto customerLevelReqDto = (CustomerLevelReqDto)JSONObject.parseObject((String)filter, CustomerLevelReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerLevelReqDto, (BaseEo)customerLevelEo);
        }
        Assert.notNull((Object)customerLevelEo.getType(), (String)CustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        customerLevelEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        customerLevelEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        LambdaQueryWrapper<CustomerLevelEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerLevelEo);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<CustomerLevelRespDto> respDtoPageInfo = MybatisPlusUtils.selectPage(this.customerLevelDas, queryWrapper, CustomerLevelRespDto.class, pageNum, pageSize);
        return respDtoPageInfo;
    }

    @Override
    public List<CustomerLevelRespDto> queryByList(String filter) {
        CustomerLevelEo customerLevelEo = CustomerLevelEo.newInstance();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            CustomerLevelReqDto customerLevelReqDto = (CustomerLevelReqDto)JSONObject.parseObject((String)filter, CustomerLevelReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerLevelReqDto, (BaseEo)customerLevelEo);
        }
        customerLevelEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        customerLevelEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        Assert.notNull((Object)customerLevelEo.getType(), (String)CustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        List customerLevelEoList = this.customerLevelDas.select((BaseEo)customerLevelEo);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerLevelEoList, (Collection)respDtoList, CustomerLevelRespDto.class);
        return respDtoList;
    }

    private void validCustomerLevelName(CustomerLevelReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)CustomerExceptionCode.NAME_NULL.getMsg());
        Assert.notNull((Object)reqDto.getType(), (String)CustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        CustomerLevelEo eo = CustomerLevelEo.newInstance();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        eo.setId(reqDto.getId());
        eo.setTenantId(reqDto.getTenantId());
        eo.setType(reqDto.getType());
        MybatisPlusUtils.checkUnique(this.customerLevelDas, eo, CustomerExceptionCode.CUSTOMER_LEVEL_NAME_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_LEVEL_NAME_EXISTS.getMsg());
    }

    private void initCustomerLevelEo(CustomerLevelReqDto reqDto, CustomerLevelEo customerLevelEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerLevelEo);
    }
}

