/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaSubTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.constants.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerAreaServiceImpl
implements ICustomerAreaService {
    private Logger logger = LoggerFactory.getLogger(CustomerAreaServiceImpl.class);
    public static final String DEFAULT_CODE = "0";
    @Resource
    private IContext context;
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private ICustomerExtService customerExtService;

    private <DTO extends BaseReqDto> void setCommon(CustomerAreaEo customerAreaEo, DTO dto) {
        customerAreaEo.setTenantId(Objects.nonNull(dto.getTenantId()) ? dto.getTenantId() : this.context.tenantId());
        customerAreaEo.setInstanceId(Objects.nonNull(dto.getInstanceId()) ? dto.getInstanceId() : this.context.instanceId());
    }

    private Long getOrgId(Long orgId) {
        if (Objects.nonNull(orgId)) {
            return orgId;
        }
        return this.customerExtService.getCurrentUserOrgId();
    }

    @Override
    public Long saveCustomerArea(CustomerAreaReqDto customerAreaReqDto) {
        String name = customerAreaReqDto.getName();
        String parentCode = customerAreaReqDto.getParentCode();
        String code = IdUtil.fastSimpleUUID();
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setName(name);
        customerAreaEo.setAreaCode(customerAreaReqDto.getAreaCode());
        this.setCommon(customerAreaEo, customerAreaReqDto);
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaReqDto.getOrgInfoId()));
        this.checkCustomerAreaName(customerAreaEo.getOrgInfoId(), customerAreaReqDto);
        if (StrUtil.isNotBlank((CharSequence)parentCode)) {
            CustomerAreaEo parentCustomerAreaEo = this.checkCustomerAreaCode(customerAreaEo.getOrgInfoId(), parentCode);
            customerAreaEo.setLevel(Integer.valueOf(parentCustomerAreaEo.getLevel() + 1));
            customerAreaEo.setParentCode(parentCode);
            customerAreaEo.setTopId(parentCustomerAreaEo.getTopId());
        } else {
            customerAreaEo.setLevel(Integer.valueOf(1));
            customerAreaEo.setParentCode(DEFAULT_CODE);
            customerAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            customerAreaEo.setTopId(customerAreaEo.getId());
        }
        customerAreaEo.setSort(Integer.valueOf(1));
        this.customerAreaDas.insert((BaseEo)customerAreaEo);
        return customerAreaEo.getId();
    }

    @Override
    public void removeByCondition(CustomerAreaInfoReqDto customerAreaInfoReqDto) {
        Integer count;
        String code = customerAreaInfoReqDto.getCode();
        Long id = customerAreaInfoReqDto.getId();
        if (Objects.isNull(id) && StrUtil.isBlank((CharSequence)code)) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.INSUFFICIENT_PARAMETERS);
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setId(id);
        customerAreaEo = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            return;
        }
        CustomerAreaEo customerArea = new CustomerAreaEo();
        customerArea.setParentCode(code);
        List customerAreaEos = this.customerAreaDas.selectList((BaseEo)customerArea);
        if (CollUtil.isNotEmpty((Collection)customerAreaEos)) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.REGION_EXISTS_CHILD);
        }
        if ((count = this.customerAreaMapper.isExistCustomer(customerAreaEo)) > 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.REGION_EXISTS_CUSTOMER);
        }
        this.customerAreaDas.logicDeleteById(customerAreaEo.getId());
    }

    @Override
    public void modifyCustomerArea(Long id, CustomerAreaReqDto customerAreaReqDto) {
        CustomerAreaEo customerAreaEo = (CustomerAreaEo)this.customerAreaDas.selectByPrimaryKey(id);
        if (Objects.isNull(customerAreaEo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.INVALID_ZONE_ID);
        }
        Long orgId = customerAreaEo.getOrgInfoId();
        customerAreaReqDto.setId(id);
        this.checkCustomerAreaName(orgId, customerAreaReqDto);
        customerAreaEo.setName(customerAreaReqDto.getName());
        if (StrUtil.isNotBlank((CharSequence)customerAreaReqDto.getAreaCode())) {
            customerAreaEo.setAreaCode(customerAreaReqDto.getAreaCode());
        }
        if (StrUtil.isNotBlank((CharSequence)customerAreaReqDto.getParentCode())) {
            customerAreaEo.setParentCode(customerAreaReqDto.getParentCode());
        }
        this.customerAreaDas.update((BaseEo)customerAreaEo);
    }

    @Override
    public PageInfo<CustomerAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerAreaEo customerAreaEo = (CustomerAreaEo)JSON.parseObject((String)filter, CustomerAreaEo.class);
        if (Objects.isNull(customerAreaEo.getInstanceId())) {
            customerAreaEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(customerAreaEo.getTenantId())) {
            customerAreaEo.setTenantId(this.context.tenantId());
        }
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaEo.getOrgInfoId()));
        PageInfo pageInfo = this.customerAreaDas.selectPage((BaseEo)customerAreaEo, pageNum, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList list = new ArrayList(pageInfo.getList().size());
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), list, CustomerAreaRespDto.class);
            pageInfo.setList(list);
        }
        return pageInfo;
    }

    @Override
    public List<CustomerAreaTreeRespDto> queryForTree(CustomerAreaTreeReqDto customerAreaTreeReqDto) {
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaTreeReqDto.getOrgInfoId()));
        this.setCommon(customerAreaEo, customerAreaTreeReqDto);
        List areaList = this.customerAreaDas.select((BaseEo)customerAreaEo);
        if (CollUtil.isEmpty((Collection)areaList)) {
            return ListUtil.empty();
        }
        return this.getTreeList(areaList, DEFAULT_CODE);
    }

    private List<CustomerAreaTreeRespDto> getTreeList(List<CustomerAreaEo> areaList, String parentCode) {
        ArrayList<CustomerAreaTreeRespDto> areaTreeRespDtoList = new ArrayList<CustomerAreaTreeRespDto>();
        Map<String, List<CustomerAreaEo>> areaMap = areaList.stream().sorted(Comparator.comparing(StdCustomerAreaEo::getSort).thenComparing(BaseEo::getCreateTime).reversed()).collect(Collectors.groupingBy(StdCustomerAreaEo::getParentCode));
        DtoHelper.eoList2DtoList((Collection)areaMap.get(parentCode), areaTreeRespDtoList, CustomerAreaTreeRespDto.class);
        areaMap.remove(parentCode);
        this.getChildArea(areaTreeRespDtoList, areaMap);
        return areaTreeRespDtoList;
    }

    @Override
    public List<CustomerAreaRespDto> queryForList(CustomerAreaListReqDto customerAreaListReqDto) {
        List ids;
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaListReqDto, (BaseEo)customerAreaEo);
        this.setCommon(customerAreaEo, customerAreaListReqDto);
        LambdaQueryWrapper<CustomerAreaEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerAreaEo);
        List codes = customerAreaListReqDto.getCodes();
        if (CollUtil.isNotEmpty((Collection)codes)) {
            queryWrapper.in(StdCustomerAreaEo::getCode, (Collection)codes);
        }
        if (CollUtil.isNotEmpty((Collection)customerAreaListReqDto.getNames())) {
            queryWrapper.in(StdCustomerAreaEo::getName, (Collection)customerAreaListReqDto.getNames());
        }
        if (CollUtil.isNotEmpty((Collection)(ids = customerAreaListReqDto.getIds()))) {
            queryWrapper.in(BaseEo::getId, (Collection)ids);
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.orderByAsc(StdCustomerAreaEo::getSort);
        List list = this.customerAreaDas.getMapper().selectList(queryWrapper);
        return list.stream().map(item -> (CustomerAreaRespDto)item.toDto(CustomerAreaRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public CustomerAreaTreeRespDto queryForSubTree(CustomerAreaSubTreeReqDto customerAreaSubTreeReqDto) {
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaSubTreeReqDto, (BaseEo)customerAreaEo);
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaEo.getOrgInfoId()));
        this.setCommon(customerAreaEo, customerAreaSubTreeReqDto);
        customerAreaEo = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            return null;
        }
        CustomerAreaTreeRespDto customerAreaTreeRespDto = (CustomerAreaTreeRespDto)customerAreaEo.toDto(CustomerAreaTreeRespDto.class);
        List<CustomerAreaEo> list = this.getCustomerArea(customerAreaEo.getTopId(), customerAreaEo.getLevel());
        customerAreaTreeRespDto.setChildren(this.getTreeList(list, customerAreaTreeRespDto.getCode()));
        return customerAreaTreeRespDto;
    }

    @Override
    public List<String> querySubCodeAll(CustomerAreaListReqDto customerAreaListReqDto) {
        HashSet<String> codeSet = new HashSet<String>();
        List<CustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        for (CustomerAreaRespDto item : customerAreaRespDtos) {
            codeSet.add(item.getCode());
            List<CustomerAreaEo> list = this.getCustomerArea(item.getTopId(), item.getLevel());
            if (CollUtil.isEmpty(list)) continue;
            Integer level = item.getLevel();
            Map<Integer, List<CustomerAreaEo>> levelMap = list.stream().collect(Collectors.groupingBy(StdCustomerAreaEo::getLevel));
            this.setCode(levelMap, codeSet, level, item.getCode());
        }
        return ListUtil.toList(codeSet);
    }

    @Override
    public List<String> queryAllParentCode(ParentAreCodeReqDto reqDto) {
        List codes = reqDto.getCodes();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)codes));
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setSqlFilters(sqlFilters);
        List customerAreaEoList = this.customerAreaDas.selectList((BaseEo)customerAreaEo);
        ArrayList<String> allCodes = new ArrayList<String>();
        for (CustomerAreaEo customerEo : customerAreaEoList) {
            allCodes.add(customerEo.getCode());
            this.selectParentCode(allCodes, customerEo.getCode());
        }
        return allCodes;
    }

    private void selectParentCode(List<String> codes, String code) {
        CustomerAreaEo condition = new CustomerAreaEo();
        condition.setCode(code);
        CustomerAreaEo eo = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)condition);
        if (Objects.isNull(eo)) {
            return;
        }
        if (DEFAULT_CODE.equals(eo.getParentCode())) {
            codes.add(eo.getCode());
            return;
        }
        condition.setCode(eo.getParentCode());
        CustomerAreaEo parentEo = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)condition);
        if (Objects.nonNull(parentEo)) {
            codes.add(parentEo.getCode());
            if (!DEFAULT_CODE.equals(parentEo.getParentCode())) {
                this.selectParentCode(codes, parentEo.getParentCode());
            }
        }
    }

    @Override
    public String queryAreaNameByCode(List<String> areaCodeList) {
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(areaCodeList);
        List<CustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        if (CollUtil.isEmpty(customerAreaRespDtos)) {
            return null;
        }
        return customerAreaRespDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(","));
    }

    @Override
    public Map<String, String> queryAreaNameMapByCode(List<String> areaCodeList) {
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(areaCodeList);
        List<CustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        if (CollUtil.isEmpty(customerAreaRespDtos)) {
            return MapUtil.empty();
        }
        Map<String, String> areaNameMap = customerAreaRespDtos.stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o1, o2) -> o2));
        return areaNameMap;
    }

    @Override
    public List<String> queryLongestNodeByCodes(List<String> areaCodes) {
        ArrayList longestNodes = Lists.newArrayList();
        for (String areaCode : areaCodes) {
            if (longestNodes.contains(areaCode)) continue;
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{areaCode}));
            List<String> nodes = this.queryAllParentCode(parentAreCodeReqDto);
            longestNodes = longestNodes.size() > nodes.size() ? longestNodes : nodes;
        }
        return longestNodes;
    }

    private void setCode(Map<Integer, List<CustomerAreaEo>> levelMap, Set<String> codeSet, Integer level, String code) {
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level + 1);
        if (levelMap.containsKey(level)) {
            List<CustomerAreaEo> customerAreaEos = levelMap.get(level);
            customerAreaEos.forEach(item -> {
                if (Objects.equals(code, item.getParentCode())) {
                    codeSet.add(item.getCode());
                    this.setCode(levelMap, codeSet, item.getLevel(), item.getCode());
                }
            });
        }
    }

    private List<CustomerAreaEo> getCustomerArea(Long topId, Integer level) {
        CustomerAreaEo subCustomerAreaEo = new CustomerAreaEo();
        subCustomerAreaEo.setDr(0);
        subCustomerAreaEo.setTopId(topId);
        QueryWrapper queryWrapper = new QueryWrapper((Object)subCustomerAreaEo);
        queryWrapper.gt((Object)"level", (Object)level);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.customerAreaDas.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    private void getChildArea(List<CustomerAreaTreeRespDto> areaGroupTreeRespDtoList, Map<String, List<CustomerAreaEo>> areaGroupMap) {
        areaGroupTreeRespDtoList.forEach(areaGroupTreeDto -> {
            List areaGroupEoList = (List)areaGroupMap.get(areaGroupTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaGroupEoList)) {
                List<CustomerAreaTreeRespDto> areaGroupChildrenDtoList = areaGroupEoList.stream().sorted(Comparator.comparing(StdCustomerAreaEo::getSort)).map(item -> (CustomerAreaTreeRespDto)item.toDto(CustomerAreaTreeRespDto.class)).collect(Collectors.toList());
                areaGroupTreeDto.setChildren(areaGroupChildrenDtoList);
                areaGroupMap.remove(areaGroupTreeDto.getCode());
                this.getChildArea(areaGroupChildrenDtoList, areaGroupMap);
            }
        });
    }

    private void checkCustomerAreaName(Long orgId, CustomerAreaReqDto customerAreaReqDto) {
        Long id = customerAreaReqDto.getId();
        String name = customerAreaReqDto.getName();
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setOrgInfoId(orgId);
        customerAreaEo.setDr(0);
        QueryWrapper queryWrapper = new QueryWrapper((Object)customerAreaEo);
        if (Objects.nonNull(id)) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        customerAreaEo.setName(name);
        queryWrapper.setEntity((Object)customerAreaEo);
        Integer count = this.customerAreaDas.getMapper().selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.AREA_NAME_ALREADY_EXISTS);
        }
    }

    private CustomerAreaEo checkCustomerAreaCode(Long orgId, String code) {
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setOrgInfoId(orgId);
        customerAreaEo = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)CustomerExceptionCode.INVALID_AREA_CODE);
        }
        return customerAreaEo;
    }
}

