/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.audit;

import cn.hutool.core.map.MapUtil;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditInfo;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.IAudit;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class AuditHandler {
    @Resource
    private List<IAudit> audits;
    private static volatile ConcurrentHashMap<RelateTypeEnum, IAudit> auditMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAudit getAuditService(RelateTypeEnum relateTypeEnum) {
        if (Objects.isNull(relateTypeEnum)) {
            return null;
        }
        if (!Objects.isNull(auditMap)) return auditMap.get(relateTypeEnum);
        Class<AuditHandler> clazz = AuditHandler.class;
        synchronized (AuditHandler.class) {
            if (!Objects.isNull(auditMap)) return auditMap.get(relateTypeEnum);
            auditMap = MapUtil.newConcurrentHashMap();
            for (IAudit audit : this.audits) {
                auditMap.put(audit.relateType(), audit);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return auditMap.get(relateTypeEnum);
        }
    }

    public AuditInfo modifyStatus(AuditEo auditEo, AuditResultEnum auditResultEnum) {
        return this.getAuditService(RelateTypeEnum.toRelateTypeEnum((String)auditEo.getRelateType())).modifyStatus(auditEo, auditResultEnum);
    }

    public void changeStatus(AuditEo auditEo, AuditInfo auditInfo) {
        this.getAuditService(RelateTypeEnum.toRelateTypeEnum((String)auditEo.getRelateType())).changeStatus(auditEo.getRelateId(), auditInfo);
    }

    public void syncData(String relateType, Long relateId, Long taskId) {
        this.getAuditService(RelateTypeEnum.toRelateTypeEnum((String)relateType)).syncData(relateId, taskId);
    }
}

