/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.DiscountTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceModelSetTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BaseExcelDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ExcelImportDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IImportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseImportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.PriceItemImportRespVo;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.PriceItemImportVo;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PriceItemImportImpl
extends BaseImportImpl
implements IImportSevice<PriceItemImportVo> {
    private static final Logger logger = LoggerFactory.getLogger(PriceItemImportImpl.class);
    private static final String SHOP_ID = "shopId";
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;

    @Override
    public boolean needVerfiy() {
        return Boolean.TRUE;
    }

    @Override
    public ImportParams importParams() {
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerfiy(this.needVerfiy());
        return importParams;
    }

    @Override
    public Class<PriceItemImportVo> pojoClass() {
        return PriceItemImportVo.class;
    }

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.IMPORT_PRICE_ITEM;
    }

    @Override
    public void importData(ExcelImportDto excelImportDto, BaseExcelDto baseExcelDto, List<PriceItemImportVo> successList, List<PriceItemImportVo> failList) {
        logger.info("\u6210\u529f\u6570\u636e\uff1a{},\u5931\u8d25\u6570\u636e\uff1a{}", JSON.toJSON(successList), JSON.toJSON(failList));
        if (CollUtil.isNotEmpty(failList)) {
            baseExcelDto.setErrorMsgList(this.getErrorList(failList));
            baseExcelDto.setSuccessDataList(ListUtil.empty());
            return;
        }
        Long shopId = (Long)excelImportDto.popValue(SHOP_ID, Long.class);
        AssertUtils.isNonNull(shopId, PriceExceptionCode.ERROR.setParamValue("\u5e97\u94faid\u4e3a\u7a7a"));
        List<String> itemCodeList = successList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getItemCode())).map(PriceItemImportVo::getItemCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMapByItemCodeListAndShopId(itemCodeList, shopId);
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = null;
        if (CollUtil.isNotEmpty(skuQueryRespDtoMap)) {
            List skuIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getSkuId).distinct().collect(Collectors.toList());
            ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
            itemSkuPriceLimitQueryReqDto.setShopId(shopId);
            itemSkuPriceLimitQueryReqDto.setSkuIdList(skuIdList);
            itemSkuPriceLimitRespDto = this.basePriceApplyItemService.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
        }
        ArrayList list = ListUtil.toList((Object[])new PriceItemImportRespVo[0]);
        HashSet itemCodeSet = Sets.newHashSet();
        for (PriceItemImportVo importVo : successList) {
            PriceItemImportRespVo priceItemImportRespVo = new PriceItemImportRespVo();
            BeanUtil.copyProperties((Object)importVo, (Object)priceItemImportRespVo, (String[])new String[0]);
            String itemCode = importVo.getItemCode();
            ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(itemCode);
            if (this.verifyAndConvertParam(baseExcelDto, importVo, priceItemImportRespVo, itemSkuQueryRespDto, itemCodeSet)) continue;
            priceItemImportRespVo.setBrandName(itemSkuQueryRespDto.getBrandName());
            priceItemImportRespVo.setDirName(itemSkuQueryRespDto.getDirName());
            priceItemImportRespVo.setItemName(itemSkuQueryRespDto.getItemName());
            priceItemImportRespVo.setSkuAttr(itemSkuQueryRespDto.getSkuAttr());
            priceItemImportRespVo.setShopId(itemSkuQueryRespDto.getShopId());
            priceItemImportRespVo.setSubType(itemSkuQueryRespDto.getSubType());
            priceItemImportRespVo.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
            priceItemImportRespVo.setSkuId(itemSkuQueryRespDto.getSkuId());
            priceItemImportRespVo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
            ItemSkuPriceInfoRespDto itemSkuPriceInfoRespDto = (ItemSkuPriceInfoRespDto)itemSkuPriceLimitRespDto.getSkuPriceInfo().get(itemSkuQueryRespDto.getSkuId());
            if (Objects.nonNull(itemSkuPriceInfoRespDto)) {
                priceItemImportRespVo.setRetailPrice(itemSkuPriceInfoRespDto.getRetailPrice());
                priceItemImportRespVo.setLowerLimitPrice(itemSkuPriceInfoRespDto.getLowerLimitPrice());
                priceItemImportRespVo.setUpperLimitPrice(itemSkuPriceInfoRespDto.getUpperLimitPrice());
                priceItemImportRespVo.setDealerRetailPrice(itemSkuPriceInfoRespDto.getDealerRetailPrice());
            }
            list.add(priceItemImportRespVo);
        }
        if (baseExcelDto.isImportStatus()) {
            baseExcelDto.setSuccessDataList((List)list);
        }
    }

    private boolean verifyAndConvertParam(BaseExcelDto baseExcelDto, PriceItemImportVo importVo, PriceItemImportRespVo priceItemImportRespVo, ItemSkuQueryRespDto itemSkuQueryRespDto, Set<String> itemCodeSet) {
        String itemCode = priceItemImportRespVo.getItemCode();
        if (itemCodeSet.contains(itemCode)) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "]\u91cd\u590d");
            return true;
        }
        itemCodeSet.add(itemCode);
        if (itemSkuQueryRespDto == null || !Objects.equals(itemSkuQueryRespDto.getItemCode(), itemCode)) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "]\u4e0d\u5b58\u5728");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)importVo.getPriceModelSetTypeStr())) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + "\u5b9a\u4ef7\u65b9\u5f0f\u9519\u8bef");
            return true;
        }
        Integer priceModelSetType = PriceModelSetTypeEnum.getCodeByDesc((String)importVo.getPriceModelSetTypeStr());
        if (priceModelSetType == null) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + "\u5b9a\u4ef7\u65b9\u5f0f\u9519\u8bef");
            return true;
        }
        priceItemImportRespVo.setPriceModelSetType(priceModelSetType);
        if (StringUtils.isNotBlank((CharSequence)importVo.getItemPriceStr())) {
            if (!NumberUtils.isCreatable((String)importVo.getItemPriceStr())) {
                baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u5546\u54c1\u5b9a\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                return true;
            }
            BigDecimal itemPrice = new BigDecimal(importVo.getItemPriceStr());
            if (BigDecimal.ZERO.compareTo(itemPrice) >= 0) {
                baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u5546\u54c1\u5b9a\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                return true;
            }
            if (itemPrice.stripTrailingZeros().scale() > 2) {
                baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u5546\u54c1\u5b9a\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                return true;
            }
            priceItemImportRespVo.setItemPrice(itemPrice);
        }
        if (PriceModelSetTypeEnum.DISCOUNT_SET.getCode().equals(priceModelSetType)) {
            if (StringUtils.isNotBlank((CharSequence)importVo.getDiscountTypeStr())) {
                Integer discountType = DiscountTypeEnum.getTypeByDesc((String)importVo.getDiscountTypeStr());
                if (discountType == null) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + "\u6263\u7387\u7c7b\u578b\u9519\u8bef");
                    return true;
                }
                priceItemImportRespVo.setDiscountType(discountType);
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getDiscountRateStr())) {
                if (!NumberUtils.isCreatable((String)importVo.getDiscountRateStr())) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u6263\u7387%\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                BigDecimal discountRate = new BigDecimal(importVo.getDiscountRateStr());
                if (BigDecimal.ZERO.compareTo(discountRate) >= 0) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u6263\u7387%\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                if (discountRate.stripTrailingZeros().scale() > 2) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u6263\u7387%\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                priceItemImportRespVo.setDiscountRate(discountRate);
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getGiftboxIncrPriceStr())) {
                if (!NumberUtils.isCreatable((String)importVo.getGiftboxIncrPriceStr())) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u56fa\u5b9a\u52a0\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                BigDecimal giftboxIncrPrice = new BigDecimal(importVo.getGiftboxIncrPriceStr());
                if (BigDecimal.ZERO.compareTo(giftboxIncrPrice) >= 0) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u56fa\u5b9a\u52a0\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                if (giftboxIncrPrice.stripTrailingZeros().scale() > 2) {
                    baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u56fa\u5b9a\u52a0\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                    return true;
                }
                priceItemImportRespVo.setGiftboxIncrPrice(giftboxIncrPrice);
            }
        }
        return false;
    }
}

