/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AttachementRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAttachementService;
import com.dtyunxi.yundt.cube.center.price.dao.das.AttachementDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AttachementEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachementServiceImpl
implements IAttachementService {
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAttachement(AttachementAddReqDto reqDto) {
        AttachementEo attachementEo = new AttachementEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachementEo);
        this.attachementDas.insert((BaseEo)attachementEo);
        return attachementEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAttachement(AttachementModifyReqDto reqDto) {
        AttachementEo attachementEo = new AttachementEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachementEo);
        this.attachementDas.updateSelective((BaseEo)attachementEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAttachement(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.attachementDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public AttachementRespDto queryAttachementById(Long id) {
        AttachementEo attachementEo = (AttachementEo)this.attachementDas.selectByPrimaryKey(id);
        if (attachementEo == null) {
            return null;
        }
        AttachementRespDto attachementRespDto = new AttachementRespDto();
        DtoHelper.eo2Dto((BaseEo)attachementEo, (BaseVo)attachementRespDto);
        return attachementRespDto;
    }

    @Override
    public PageInfo<AttachementRespDto> queryAttachementByPage(AttachementQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        AttachementEo attachementEo = new AttachementEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachementEo);
        PageInfo eoPageInfo = this.attachementDas.selectPage((BaseEo)attachementEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AttachementRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchAttachement(List<AttachementAddReqDto> attachementDtoList) {
        if (CollUtil.isEmpty(attachementDtoList)) {
            return ListUtil.empty();
        }
        ArrayList attachementEoList = ListUtil.toList((Object[])new AttachementEo[0]);
        DtoHelper.dtoList2EoList(attachementDtoList, (Collection)attachementEoList, AttachementEo.class);
        if (CollUtil.isEmpty((Collection)attachementEoList)) {
            return ListUtil.empty();
        }
        for (AttachementEo attachementEo : attachementEoList) {
            attachementEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(attachementEo.getInstanceId())) {
                attachementEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(attachementEo.getTenantId())) continue;
            attachementEo.setTenantId(this.context.tenantId());
        }
        this.attachementDas.insertBatch((List)attachementEoList);
        return attachementEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void coverAttachement(List<AttachementAddReqDto> attachementDtoList, Long businessId) {
        AttachementEo attachementEo = new AttachementEo();
        attachementEo.setBusinessId(businessId);
        List attachementList = this.attachementDas.select((BaseEo)attachementEo);
        if (CollUtil.isEmpty(attachementDtoList)) {
            attachementList.stream().forEach(info -> this.attachementDas.logicDeleteById(info.getId()));
            return;
        }
        ArrayList delIdList = ListUtil.toList((Object[])new Long[0]);
        Map attachementMap = attachementDtoList.stream().collect(Collectors.toMap(AttachementAddReqDto::getPath, Function.identity(), (o1, o2) -> o2));
        for (AttachementEo attachement : attachementList) {
            String path = attachement.getPath();
            if (attachementMap.containsKey(path)) {
                attachementMap.remove(path);
                continue;
            }
            delIdList.add(attachement.getId());
        }
        if (CollUtil.isNotEmpty((Collection)delIdList)) {
            for (Long id : delIdList) {
                this.attachementDas.logicDeleteById(id);
            }
        }
        List<AttachementAddReqDto> batchAttachementList = attachementMap.values().stream().map(item -> {
            item.setBusinessId(businessId);
            return item;
        }).collect(Collectors.toList());
        this.batchAttachement(batchAttachementList);
    }

    @Override
    public List<AttachementRespDto> getAttachementListByBusinessId(Long businessId) {
        AttachementEo attachement = new AttachementEo();
        attachement.setBusinessId(businessId);
        List attachementEos = this.attachementDas.select((BaseEo)attachement);
        ArrayList<AttachementRespDto> dtoList = new ArrayList<AttachementRespDto>();
        DtoHelper.eoList2DtoList((Collection)attachementEos, dtoList, AttachementRespDto.class);
        return dtoList;
    }

    @Override
    public List<AttachementAddReqDto> convertAttachementDto(List<String> attachementList, Long tenantId, Long instanceId) {
        if (CollUtil.isEmpty(attachementList)) {
            return ListUtil.empty();
        }
        return attachementList.stream().filter(url -> StrUtil.isNotBlank((CharSequence)url)).map(url -> {
            AttachementAddReqDto attachementAddReqDto = new AttachementAddReqDto();
            attachementAddReqDto.setName(FileNameUtil.getName((String)url));
            attachementAddReqDto.setInstanceId(Objects.isNull(instanceId) ? this.context.instanceId() : instanceId);
            attachementAddReqDto.setTenantId(Objects.isNull(tenantId) ? this.context.tenantId() : tenantId);
            String fileType = url.substring(url.lastIndexOf(".") + 1);
            attachementAddReqDto.setFileType(fileType);
            attachementAddReqDto.setPath(url);
            return attachementAddReqDto;
        }).collect(Collectors.toList());
    }
}

