/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.SkuPolicyPriceReplaceInfoDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PricePolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalDiscountQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuDiscountRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceModelRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.ICommunalPriceQueryService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceModelService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceTypeService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IDiscountPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcReqVo;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcRespVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceLimitDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountQueryReqDto;
import com.yx.tcbj.center.price.api.dto.response.PrBaseDiscountRespDto;
import com.yx.tcbj.center.price.biz.service.IPrBaseDiscountService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="communalPriceQueryService")
public class CommunalPriceQueryServiceImpl
implements ICommunalPriceQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CommunalPriceQueryServiceImpl.class);
    @Resource
    private PriceDas priceDas;
    @Resource
    private PriceTypeDas priceTypeDas;
    @Resource
    private PriceItemDas priceItemDas;
    @Resource
    private DiscountDas discountDas;
    @Resource
    private PriceLimitDas priceLimitDas;
    @Resource
    private LimitItemDas limitItemDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private IContext context;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private IDiscountPolicyEsService discountPolicyEsService;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;
    @Resource
    private IPriceModelService priceModelService;
    @Resource
    private IBasePriceItemService basePriceItemService;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Autowired
    private IPriceTypeService priceTypeService;
    @Resource
    private CustomerHelper customerHelper;
    @Autowired
    private IPrBaseDiscountService prBaseDiscountService;
    @Value(value="${yundt.cube.center.price.enable:true}")
    private boolean priceCenterEnable;

    @Override
    public List<ItemPolicyPriceRespDto> queryChannelPriceByCon(CommunalPriceQueryReqDto reqDto) {
        reqDto.setInstanceId(this.context.instanceId());
        reqDto.setTenantId(this.context.tenantId());
        reqDto.setPriceCategoryCode(CategoryCodeEnum.SUPPLY_CHANNEL.getCode());
        if (!this.priceCenterEnable) {
            logger.warn("\u6ca1\u6709\u542f\u7528\u4ef7\u683c\u4e2d\u5fc3\u67e5\u4ef7\uff0c\u67e5\u8be2sku\u4e0a\u67b6\u4ef7\u683c");
            return this.queryFromItemCenter(reqDto);
        }
        List<ItemPolicyPriceRespDto> itemPolicyPriceRespDtoList = this.pricePolicyEsService.queryByBusiness(reqDto);
        CommunalDiscountQueryReqDto discountQueryReqDto = new CommunalDiscountQueryReqDto();
        CubeBeanUtils.copyProperties((Object)discountQueryReqDto, (Object)reqDto, (String[])new String[0]);
        List skuIdList = reqDto.getSkuList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
        discountQueryReqDto.setSkuIds(skuIdList);
        List<ItemSkuDiscountRespDto> itemSkuDiscountRespDtoList = this.discountPolicyEsService.queryByCondition(discountQueryReqDto);
        itemPolicyPriceRespDtoList.forEach(e -> {
            BigDecimal sellPrice = this.getSkuSellPrice(e.getSkuId(), reqDto);
            e.setPrice(sellPrice);
            if (!e.getHasLadderPrice()) {
                ItemSkuDiscountRespDto itemSkuDiscountRespDto = itemSkuDiscountRespDtoList.stream().filter(it -> it.getSkuId().equals(e.getSkuId())).findFirst().orElse(null);
                if (itemSkuDiscountRespDto != null) {
                    e.setItemSkuDiscountRespDto(itemSkuDiscountRespDto);
                    BigDecimal discountRate = e.getItemSkuDiscountRespDto().getDiscount();
                    discountRate = discountRate.divide(BigDecimal.TEN).setScale(2, 4);
                    if (e.getPrice() != null) {
                        BigDecimal discountPrice = e.getPrice().multiply(discountRate).setScale(2, 4);
                        e.setDiscountPrice(discountPrice);
                        e.setHasDiscountPrice(true);
                    }
                } else {
                    e.setHasDiscountPrice(false);
                }
            }
        });
        return itemPolicyPriceRespDtoList;
    }

    private List<ItemPolicyPriceRespDto> queryFromItemCenter(CommunalPriceQueryReqDto reqDto) {
        ArrayList<ItemPolicyPriceRespDto> res = new ArrayList<ItemPolicyPriceRespDto>();
        reqDto.getSkuList().forEach(e -> {
            ItemPolicyPriceRespDto esDto = new ItemPolicyPriceRespDto();
            CubeBeanUtils.copyProperties((Object)esDto, (Object)e, (String[])new String[0]);
            if (e.getSkuSellPrice() == null) {
                esDto.setPrice(this.getItemSkuPrice((CommunalPriceQueryReqDto.ItemSkuPriceReqDto)e));
            } else {
                esDto.setPrice(e.getSkuSellPrice());
            }
            esDto.setHasLadderPrice(false);
            esDto.setHasDiscountPrice(false);
            esDto.setCustId(String.valueOf(reqDto.getCustId()));
            res.add(esDto);
        });
        return res;
    }

    private BigDecimal getSkuSellPrice(Long skuId, CommunalPriceQueryReqDto reqDto) {
        CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = reqDto.getSkuList().stream().filter(e -> e.getSkuId().equals(skuId)).findFirst().get();
        BigDecimal sellPrice = skuPriceReqDto.getSkuSellPrice();
        if (sellPrice != null) {
            return sellPrice;
        }
        return this.getItemSkuPrice(skuPriceReqDto);
    }

    private BigDecimal getItemSkuPrice(CommunalPriceQueryReqDto.ItemSkuPriceReqDto reqDto) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setShopId(reqDto.getShopId());
        shelfReqDto.setItemId(reqDto.getItemId());
        shelfReqDto.setSkuId(reqDto.getSkuId());
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1000)).getData();
        if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List prices = pageInfo.getList().stream().map(ItemShelfRespDto::getPrice).sorted().collect(Collectors.toList());
            return (BigDecimal)prices.get(0);
        }
        logger.warn("\u6ca1\u6709\u67e5\u8be2\u5230sku={},shopId={]\u7684\u4ef7\u683c", (Object)reqDto.getSkuId(), (Object)reqDto.getShopId());
        return null;
    }

    @Deprecated
    public BigDecimal getCustDiscountRate(CommunalDiscountQueryReqDto discountQueryReqDto) {
        RestResponse custResp = this.customerQueryApi.queryById(discountQueryReqDto.getCustId());
        Long customerTypeId = ((CustomerRespDto)custResp.getData()).getCustomerTypeId();
        Long customerGroupId = ((CustomerRespDto)custResp.getData()).getCustomerGroupId();
        List customerRegionCodeList = ((CustomerRespDto)custResp.getData()).getRegionCodeList();
        Long itemId = (Long)discountQueryReqDto.getItemIds().get(0);
        Long skuId = (Long)discountQueryReqDto.getSkuIds().get(0);
        RestResponse itemResp = this.itemQueryApi.queryItemAndSku(itemId, skuId);
        Long itemDirId = ((ItemRespDto)itemResp.getData()).getDirId();
        Long brandId = ((ItemRespDto)itemResp.getData()).getBrandId();
        discountQueryReqDto.setRelationItemType("all");
        discountQueryReqDto.setBrandId(brandId);
        ArrayList<Long> parentDirList = new ArrayList<Long>();
        this.setItemParentBackDirId(itemDirId, parentDirList);
        parentDirList.add(itemDirId);
        discountQueryReqDto.setDirIdList(parentDirList);
        Comparator<DiscountEo> effectiveTimeCompare = new Comparator<DiscountEo>(){

            @Override
            public int compare(DiscountEo o1, DiscountEo o2) {
                return 0 - o1.getEffectiveTime().compareTo(o2.getEffectiveTime());
            }
        };
        discountQueryReqDto.setRelationCustomerType(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType());
        List custEnableDiscountPolicyList = this.discountDas.selectEnableDiscountPolicy(discountQueryReqDto);
        if (!CollectionUtils.isEmpty((Collection)custEnableDiscountPolicyList)) {
            custEnableDiscountPolicyList.sort(effectiveTimeCompare);
            DiscountEo discountEo = (DiscountEo)custEnableDiscountPolicyList.get(0);
            return discountEo.getDiscount();
        }
        discountQueryReqDto.setRelationCustomerType(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType());
        discountQueryReqDto.setCustomerTypeId(customerTypeId);
        ArrayList<Long> parentGroupIdList = new ArrayList<Long>();
        if (customerGroupId != null) {
            this.setCustParentGroupId(customerGroupId, parentGroupIdList);
            parentGroupIdList.add(customerGroupId);
        }
        discountQueryReqDto.setParentGroupIdList(parentGroupIdList);
        List<Object> parentRegionCodeList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)customerRegionCodeList)) {
            parentRegionCodeList = this.getCustParentRegionList(customerRegionCodeList);
        }
        discountQueryReqDto.setCustomerRegionCodeList(parentRegionCodeList);
        List custRangeList = this.discountDas.selectEnableDiscountPolicy(discountQueryReqDto);
        if (!CollectionUtils.isEmpty((Collection)custRangeList)) {
            custRangeList.sort(effectiveTimeCompare);
            DiscountEo discountEo = (DiscountEo)custRangeList.get(0);
            return discountEo.getDiscount();
        }
        return null;
    }

    private void setItemParentBackDirId(Long dirID, List<Long> parentDirIdList) {
        DirectoryItemRespDto directoryItemRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(dirID).getData();
        if (directoryItemRespDto != null && directoryItemRespDto.getParentId() != null && directoryItemRespDto.getParentId() != 0L) {
            parentDirIdList.add(directoryItemRespDto.getParentId());
            this.setItemParentBackDirId(directoryItemRespDto.getParentId(), parentDirIdList);
        }
    }

    private void setCustParentRegion(String region, List<String> parentRegionList) {
        AreaGroupDetailRespDto respDto = (AreaGroupDetailRespDto)this.areaGroupQueryApi.queryByCode(region).getData();
        if (respDto != null && respDto.getParentCode() != null && !respDto.getParentCode().equals("0")) {
            parentRegionList.add(respDto.getParentCode());
            this.setCustParentRegion(respDto.getParentCode(), parentRegionList);
        }
    }

    private List<String> getCustParentRegionList(List<String> regions) {
        List areaGroupTreeRespDto = (List)this.areaGroupQueryApi.queryForTree().getData();
        HashMap<String, String> nodeMaps = new HashMap<String, String>();
        for (AreaGroupTreeRespDto treeDto : areaGroupTreeRespDto) {
            LinkedList<AreaGroupTreeRespDto> queue = new LinkedList<AreaGroupTreeRespDto>();
            queue.offer(treeDto);
            while (!queue.isEmpty()) {
                AreaGroupTreeRespDto node = (AreaGroupTreeRespDto)queue.poll();
                String code = node.getCode();
                if (node.getChildren() == null || node.getChildren().isEmpty()) continue;
                for (AreaGroupTreeRespDto child : node.getChildren()) {
                    String parentCode = child.getParentCode();
                    String parentNodePath = nodeMaps.get(parentCode) == null ? code : (String)nodeMaps.get(parentCode);
                    nodeMaps.put(child.getCode(), parentNodePath + "," + child.getCode());
                    queue.offer(child);
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String region : regions) {
            String regionPath = nodeMaps.get(region) == null ? region : (String)nodeMaps.get(region);
            result.addAll(Arrays.asList(regionPath.split(",")));
        }
        return result;
    }

    private void setCustParentGroupId(Long customerGroupId, List<Long> parentList) {
        CustomerGroupRespDto customerGroupRespDto = (CustomerGroupRespDto)this.customerGroupQueryApi.queryById(customerGroupId).getData();
        if (customerGroupRespDto != null && customerGroupRespDto.getParentGroupId() != null && customerGroupRespDto.getParentGroupId() != 0L) {
            parentList.add(customerGroupRespDto.getParentGroupId());
            this.setCustParentGroupId(customerGroupRespDto.getParentGroupId(), parentList);
        }
    }

    private void setCustSubGroupId(Long customerGroupId, List<Long> subList) {
        CustomerGroupQueryReqDto customerGroupQueryReqDto = new CustomerGroupQueryReqDto();
        customerGroupQueryReqDto.setTenantId(this.context.tenantId());
        customerGroupQueryReqDto.setInstanceId(this.context.instanceId());
        customerGroupQueryReqDto.setParentGroupId(customerGroupId);
        RestResponse pageInfoRestResponse = this.customerGroupQueryApi.queryByPage(customerGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(1000));
        PageInfo pageData = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (pageData != null && !CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(e -> {
                subList.add(e.getId());
                this.setCustSubGroupId(e.getId(), subList);
            });
        }
    }

    @Override
    public List<ItemPolicyPriceRespDto> queryDistributionPrice(CommunalPriceQueryReqDto queryPriceReqDto) {
        logger.info("\u67e5\u4ef7\u8bf7\u6c42params{}", (Object)JSON.toJSONString((Object)queryPriceReqDto));
        ArrayList<ItemPolicyPriceRespDto> result = new ArrayList<ItemPolicyPriceRespDto>();
        if (queryPriceReqDto.getPolicyDate() == null) {
            queryPriceReqDto.setPolicyDate(new Date());
        }
        List<Long> skuIds = queryPriceReqDto.getSkuList().stream().map(e -> e.getSkuId()).distinct().collect(Collectors.toList());
        List<Long> shopIds = queryPriceReqDto.getSkuList().stream().map(e -> e.getShopId()).distinct().collect(Collectors.toList());
        Long dealerBasePriceTypeId = PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId();
        List<Long> brandPriceTypeIds = Arrays.asList(PriceTypeEnum.RETAIL_PRICE.getTypeId(), PriceTypeEnum.EXCHANGE_PRICE.getTypeId());
        List itemSkuListRespDto = (List)this.itemSkuQueryApi.querySkuExtBySkuId(skuIds).getData();
        if (CollectionUtils.isEmpty((Collection)itemSkuListRespDto)) {
            return result;
        }
        Map<Long, ItemSkuExtRespDto> skuExtRespDtoMap = itemSkuListRespDto.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
        List<Long> itemOrgIds = itemSkuListRespDto.stream().filter(e -> e.getOrganizationId() != null).map(e -> e.getOrganizationId()).distinct().collect(Collectors.toList());
        List<BasePriceItemEo> brandItemBasePriceList = this.basePriceItemService.queryBrandPriceBySkuIds(skuIds, brandPriceTypeIds, itemOrgIds);
        Map<String, List<PricePolicyEsDto>> pricePolicyMap = this.pricePolicyEsService.queryDistributionPricePolicyList(queryPriceReqDto);
        Set<Long> priceModelIdSet = this.extractPriceModelId(pricePolicyMap);
        List<PriceModelRespDto> priceModelRespDtos = this.priceModelService.queryByIds(new ArrayList<Long>(priceModelIdSet));
        Map<Long, PriceModelRespDto> priceModelRespDtoMap = priceModelRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, e -> e, (e1, e2) -> e1));
        List custIdList = queryPriceReqDto.getQueryCustIds();
        List customerRespDtoList = (List)this.customerExtQueryApi.queryListOnPostByCustomerIds(custIdList).getData();
        Map<Long, CustomerRespDto> customerRespDtoMap = customerRespDtoList.stream().collect(Collectors.toMap(com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto::getId, e -> e, (e1, e2) -> e1));
        PrBaseDiscountQueryReqDto prBaseDiscountRespDto = new PrBaseDiscountQueryReqDto();
        prBaseDiscountRespDto.setCustomerIdList(custIdList);
        prBaseDiscountRespDto.setPageNum(Integer.valueOf(1));
        prBaseDiscountRespDto.setPageSize(Integer.valueOf(1000));
        PageInfo baseDiscountPageInfo = this.prBaseDiscountService.queryByPage(prBaseDiscountRespDto);
        logger.info("[\u57fa\u7840\u6263\u7387]\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)baseDiscountPageInfo));
        Map<Object, Object> cusDiscountMap = Maps.newHashMap();
        if (baseDiscountPageInfo != null && !CollectionUtils.isEmpty((Collection)baseDiscountPageInfo.getList())) {
            cusDiscountMap = baseDiscountPageInfo.getList().stream().collect(Collectors.toMap(PrBaseDiscountRespDto::getCustomerId, e -> e, (e1, e2) -> e1));
        }
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setInSkuIdList(skuIds);
        PageInfo skuLibPageInfo = (PageInfo)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(skuIds.size())).getData();
        Map<Object, Object> skuBrandMap = Maps.newHashMap();
        if (skuLibPageInfo != null && !CollectionUtils.isEmpty((Collection)skuLibPageInfo.getList())) {
            skuBrandMap = skuLibPageInfo.getList().stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getSkuId, ItemSkuQueryRespDto::getBrandId));
        }
        for (Long custId : custIdList) {
            String custIdStr = String.valueOf(custId);
            CustomerRespDto customerRespDto = customerRespDtoMap.get(custId);
            Long sellerOrgId = customerRespDto.getMerchantId();
            List<BasePriceItemEo> dealerItemBasePriceList = this.basePriceItemService.queryDealerPriceBySkuIds(shopIds, skuIds, dealerBasePriceTypeId, sellerOrgId);
            PrBaseDiscountRespDto baseDiscountRespDto = (PrBaseDiscountRespDto)cusDiscountMap.get(custId);
            Map<Object, Object> brandDiscountRateMap = Maps.newHashMap();
            if (baseDiscountRespDto != null) {
                brandDiscountRateMap = Optional.ofNullable(baseDiscountRespDto.getBrandDiscountList()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(PrBaseDiscountBrandReqDto::getBrandId, PrBaseDiscountBrandReqDto::getBrandDiscount));
            }
            logger.info("[\u57fa\u7840\u6263\u7387],\u5ba2\u6237\u7f16\u53f7\uff1a{},\u57fa\u7840\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)customerRespDto.getCode(), (Object)JSON.toJSONString((Object)brandDiscountRateMap));
            for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto : queryPriceReqDto.getSkuList()) {
                PricePolicyEsDto bestMatchPricePolicy;
                Long brandId = (Long)skuBrandMap.get(itemSkuPriceReqDto.getSkuId());
                BigDecimal prBaseDiscountReate = baseDiscountRespDto != null ? brandDiscountRateMap.getOrDefault(brandId, baseDiscountRespDto.getStandardDiscount()) : null;
                logger.info("[\u57fa\u7840\u6263\u7387]\uff1a{}\uff0c\u5546\u54c1ID\uff1a{}", (Object)prBaseDiscountReate, (Object)itemSkuPriceReqDto.getItemId());
                Long curSkuId = itemSkuPriceReqDto.getSkuId();
                Long curShopId = itemSkuPriceReqDto.getShopId();
                String curSkuIdStr = String.valueOf(curSkuId);
                String curShopIdStr = String.valueOf(curShopId);
                ItemSkuExtRespDto curSkuExtDto = skuExtRespDtoMap.get(curSkuId);
                Long curItemOrgId = curSkuExtDto.getOrganizationId();
                String tmpKey = custIdStr + "-" + curShopIdStr + "-" + curSkuIdStr;
                List<PricePolicyEsDto> skuPricePolicyEsDtoList = pricePolicyMap.get(tmpKey);
                if (skuPricePolicyEsDtoList == null) {
                    logger.info("custId={} ,shopId = {},skuId={} has't matched policy,", new Object[]{custIdStr, curShopId, curSkuId});
                    continue;
                }
                BasePriceItemEo dealerSkuBasePriceEo = this.basePriceItemService.getDealerSkuBasePrice(curSkuId, curShopId, dealerItemBasePriceList);
                BasePriceItemEo brandSkuRetailPriceEo = this.basePriceItemService.getBrandSkuRetailPrice(curSkuId, curItemOrgId, brandItemBasePriceList);
                ItemPolicyPriceRespDto skuPolicyPriceRespDto = new ItemPolicyPriceRespDto();
                skuPolicyPriceRespDto.setCategoryCode(queryPriceReqDto.getPriceCategoryCode());
                skuPolicyPriceRespDto.setCustId(String.valueOf(custId));
                skuPolicyPriceRespDto.setSkuId(curSkuId);
                skuPolicyPriceRespDto.setItemId(curSkuExtDto.getItemId());
                skuPolicyPriceRespDto.setShopId(curShopId);
                skuPolicyPriceRespDto.setPricePolicyDate(queryPriceReqDto.getPolicyDate());
                PricePolicyEsDto pricePolicyEsDto = bestMatchPricePolicy = CollectionUtils.isEmpty(skuPricePolicyEsDtoList) ? null : skuPricePolicyEsDtoList.get(0);
                if (bestMatchPricePolicy != null) {
                    skuPolicyPriceRespDto.setPricePolicyId(bestMatchPricePolicy.getPolicyId());
                    skuPolicyPriceRespDto.setPricePolicyName(bestMatchPricePolicy.getName());
                    skuPolicyPriceRespDto.setPricePolicyCode(bestMatchPricePolicy.getPolicyCode());
                    skuPolicyPriceRespDto.setSellerOrgId(bestMatchPricePolicy.getOrganizationId());
                    skuPolicyPriceRespDto.setEffectiveTime(bestMatchPricePolicy.getEffectiveTime());
                    skuPolicyPriceRespDto.setInvalidTime(bestMatchPricePolicy.getInvalidTime());
                    skuPolicyPriceRespDto.setLongTermValid(bestMatchPricePolicy.getLongTermValid());
                    logger.info("sku={}\u6709\u5339\u914d\u7684\u5206\u9500\u653f\u7b56\uff0c\u5206\u9500\u653f\u7b56id={}", (Object)curSkuId, (Object)bestMatchPricePolicy.getPolicyId());
                    Long priceModeId = bestMatchPricePolicy.getPriceModeId();
                    PriceModelRespDto priceModelRespDto = priceModelRespDtoMap.get(priceModeId);
                    SkuPolicyPriceCalcReqVo reqVo = new SkuPolicyPriceCalcReqVo.SkuPolicyPriceCalcReqVoBuilder().skuId(curSkuId).brandId(brandId).shopId(curShopId).customerId(custId).pricePolicyEsDto(bestMatchPricePolicy).priceModelRespDto(priceModelRespDto).brandSkuRetailPriceEo(brandSkuRetailPriceEo).dealerSkuBasePriceEo(dealerSkuBasePriceEo).prBaseDiscountReate(prBaseDiscountReate).build();
                    SkuPolicyPriceCalcRespVo respVo = this.pricePolicyEsService.calcSkuPolicyPrice(reqVo);
                    logger.info("[\u653f\u7b56\u4ef7\u8ba1\u7b97\u7ed3\u679c]:{} ", (Object)JSON.toJSONString((Object)respVo));
                    if (respVo.isHasLadderPrice()) {
                        skuPolicyPriceRespDto.setHasLadderPrice(respVo.isHasLadderPrice());
                        skuPolicyPriceRespDto.setLadderPrices(this.convertSkuEsPriceList(respVo.getSkuLadderPrices()));
                    } else if (respVo.isHasDiscountPrice()) {
                        skuPolicyPriceRespDto.setHasDiscountPrice(respVo.isHasDiscountPrice());
                        if (Objects.equals(respVo.getUseBasePriceType(), 2)) {
                            skuPolicyPriceRespDto.setAdjustApplyCode(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getBusinessCode());
                            skuPolicyPriceRespDto.setAdjustApplyId(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getBusinessId());
                        } else if (Objects.equals(respVo.getUseBasePriceType(), 1)) {
                            skuPolicyPriceRespDto.setAdjustApplyCode(brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getBusinessCode());
                            skuPolicyPriceRespDto.setAdjustApplyId(brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getBusinessId());
                        }
                        skuPolicyPriceRespDto.setDiscountPrice(respVo.getSkuPolcyDiscountPrice());
                        skuPolicyPriceRespDto.setPrice(respVo.getSkuPolcyDiscountPrice());
                    }
                } else {
                    BigDecimal skuBasePrice;
                    skuPolicyPriceRespDto.setHasDiscountPrice(false);
                    skuPolicyPriceRespDto.setHasLadderPrice(false);
                    BigDecimal bigDecimal = skuBasePrice = dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getItemPrice();
                    if (skuBasePrice != null) {
                        logger.info("sku={}\u6ca1\u6709\u5339\u914d\u7684\u5206\u9500\u653f\u7b56\uff0c\u67e5\u4ef7\u4f7f\u7528\u7ecf\u9500\u5546\u914d\u7f6e\u7684\u57fa\u7840\u96f6\u552e\u4ef7={}", (Object)curSkuId, (Object)skuBasePrice);
                        skuPolicyPriceRespDto.setBasePriceSetType(Integer.valueOf(1));
                        skuPolicyPriceRespDto.setAdjustApplyCode(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getBusinessCode());
                        skuPolicyPriceRespDto.setAdjustApplyId(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getBusinessId());
                    } else {
                        skuPolicyPriceRespDto.setBasePriceSetType(Integer.valueOf(0));
                        skuBasePrice = brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getItemPrice();
                        skuPolicyPriceRespDto.setAdjustApplyCode(brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getBusinessCode());
                        skuPolicyPriceRespDto.setAdjustApplyId(brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getBusinessId());
                        logger.info("sku={}\u6ca1\u6709\u5339\u914d\u7684\u5206\u9500\u653f\u7b56\uff0c\u67e5\u4ef7\u4f7f\u7528\u54c1\u724c\u65b9\u914d\u7f6e\u7684\u57fa\u7840\u96f6\u552e\u4ef7={}", (Object)curSkuId, (Object)skuBasePrice);
                    }
                    skuPolicyPriceRespDto.setPrice(skuBasePrice);
                }
                result.add(skuPolicyPriceRespDto);
            }
        }
        this.modifyPolicyPriceOverLimit(queryPriceReqDto, result, itemSkuListRespDto, customerRespDtoMap);
        logger.info("\u67e5\u4ef7\u7ed3\u679c{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private List<ItemPolicyPriceRespDto.LadderPrice> convertSkuEsPriceList(List<SkuPolicyPriceCalcRespVo.SkuLadderPrice> skuLadderPrices) {
        if (!CollectionUtils.isEmpty(skuLadderPrices)) {
            List<ItemPolicyPriceRespDto.LadderPrice> skuLadderPriceList = skuLadderPrices.stream().map(limit -> {
                ItemPolicyPriceRespDto.LadderPrice skuLadderPrice = new ItemPolicyPriceRespDto.LadderPrice();
                skuLadderPrice.setPrice(limit.getLadderPrice());
                skuLadderPrice.setLower(limit.getLowerNum());
                skuLadderPrice.setUpper(limit.getUpperNum());
                return skuLadderPrice;
            }).collect(Collectors.toList());
            return skuLadderPriceList;
        }
        return null;
    }

    private void modifyPolicyPriceOverLimit(CommunalPriceQueryReqDto queryPriceReqDto, List<ItemPolicyPriceRespDto> skuPriceResult, List<ItemSkuExtRespDto> itemSkuListRespDto, Map<Long, CustomerRespDto> customerRespDtoMap) {
        List controlTypeConfList;
        Map<Long, ItemSkuExtRespDto> skuExtRespDtoMap = itemSkuListRespDto.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
        List<Long> itemOrgIds = itemSkuListRespDto.stream().filter(e -> e.getOrganizationId() != null).map(e -> e.getOrganizationId()).distinct().collect(Collectors.toList());
        List skuIds = queryPriceReqDto.getSkuList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
        Map<Object, Object> brandOrgIdConfMap = new HashMap();
        List<PriceBasicConfigRespDto> priceBasicConfigRespDtoList = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(itemOrgIds, PriceBasicConfigEnum.ConfigType.PRICE_SETTING);
        List list = controlTypeConfList = CollectionUtils.isEmpty(priceBasicConfigRespDtoList) ? null : priceBasicConfigRespDtoList.stream().filter(e -> e.getControlType() == PriceBasicConfigEnum.ControlType.CONTROL.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(controlTypeConfList)) {
            logger.info("\u54c1\u724c\u65b9\u914d\u7f6e\u7684\u4ef7\u76d8\u7ba1\u63a7\u4e3a\u7a7a\u6216\u8005\u662f\u63d0\u9192\uff0c\u4e0d\u7528\u7ba1\u63a7sku\u4ef7\u683c\u5728\u4ef7\u76d8\u8303\u56f4\u5185\uff1a");
            return;
        }
        brandOrgIdConfMap = controlTypeConfList.stream().collect(Collectors.toMap(PriceBasicConfigRespDto::getOrganizationId, e -> e, (e1, e2) -> e1));
        List<CustomerRespDto> sellerCustDtoList = this.querySellerCustDtoList(customerRespDtoMap, itemOrgIds);
        if (CollectionUtils.isEmpty(sellerCustDtoList)) {
            logger.info("small-custId and itemOrgId \u6ca1\u6709\u5339\u914d\u5230\u5927b\u5ba2\u6237id");
            return;
        }
        Set custIdSet = sellerCustDtoList.stream().map(e -> e.getId()).collect(Collectors.toSet());
        Set upperBrandOrgIdSet = sellerCustDtoList.stream().map(e -> e.getMerchantId()).collect(Collectors.toSet());
        PriceLimitEsQueryReqDto limitEsQueryReqDto = new PriceLimitEsQueryReqDto();
        limitEsQueryReqDto.setSkuIdList(skuIds);
        limitEsQueryReqDto.setCustomerIdList(new ArrayList(custIdSet));
        limitEsQueryReqDto.setOrganizationIdList(new ArrayList(upperBrandOrgIdSet));
        limitEsQueryReqDto.setPolicyDate(queryPriceReqDto.getPolicyDate());
        limitEsQueryReqDto.setQueryBestMatch(Integer.valueOf(1));
        Map<String, List<PriceLimitPolicyEsDto>> skulimitPolicyEsDtoMap = this.priceLimitPolicyEsService.queryPriceLimitPolicy(limitEsQueryReqDto);
        List custIdList = queryPriceReqDto.getQueryCustIds();
        for (Long custId : custIdList) {
            String custIdStr = String.valueOf(custId);
            CustomerRespDto customerRespDto = customerRespDtoMap.get(custId);
            Long sellerOrgId = customerRespDto.getMerchantId();
            List curSellerCustList = sellerCustDtoList.stream().filter(e -> e.getOrgInfoId().equals(sellerOrgId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(curSellerCustList)) continue;
            for (ItemPolicyPriceRespDto skuPriceRespDto : skuPriceResult) {
                Long curSkuId = skuPriceRespDto.getSkuId();
                ItemSkuExtRespDto curSkuExtDto = skuExtRespDtoMap.get(curSkuId);
                Long curItemOrgId = curSkuExtDto.getOrganizationId();
                CustomerRespDto sellerCustDto = curSellerCustList.stream().filter(e -> curItemOrgId.equals(e.getMerchantId())).findFirst().orElse(null);
                if (!custIdStr.equalsIgnoreCase(skuPriceRespDto.getCustId())) {
                    logger.info("skuId={},curCustId={}, skuPriceRespDto-custId={}\uff0csku-shopId\u5f52\u5c5e\u7684\u5ba2\u6237\u4e0d\u4e00\u81f4,\u4e0d\u7528\u6821\u9a8c\u4ef7\u76d8.", new Object[]{curSkuId, custIdStr, skuPriceRespDto.getCustId()});
                    continue;
                }
                if (sellerCustDto == null) {
                    logger.info("skuId={}\u7684\u7ec4\u7ec7id={}\u548c\u5546\u5bb6\u7ec4\u7ec7id={}\u6ca1\u6709\u627e\u5230\u5ba2\u6237id,\u6ca1\u6709\u5339\u914d\u7684\u4ef7\u76d8", new Object[]{curSkuId, curItemOrgId, sellerOrgId});
                    continue;
                }
                PriceBasicConfigRespDto brandLimitConf = (PriceBasicConfigRespDto)brandOrgIdConfMap.get(curItemOrgId);
                if (brandLimitConf == null) {
                    logger.info("skuId={}\u7684\u7ec4\u7ec7id={},\u6ca1\u6709\u914d\u7f6e\u4ef7\u76d8\u5f3a\u7ba1\u63a7\uff0csku\u653f\u7b56\u4ef7\u4e0d\u7528\u6bd4\u8f83\u4ef7\u76d8\u3002", (Object)curSkuId, (Object)curItemOrgId);
                    continue;
                }
                Long curSellerCustId = sellerCustDto.getId();
                String tmpLimitPolicyKey = String.valueOf(curSellerCustId) + "-" + String.valueOf(curSkuId);
                List<PriceLimitPolicyEsDto> skuMatchPriceLimitEsDto = skulimitPolicyEsDtoMap.get(tmpLimitPolicyKey);
                if (CollectionUtils.isEmpty(skuMatchPriceLimitEsDto)) continue;
                PriceLimitPolicyEsDto bestMatchLimitEsDto = skuMatchPriceLimitEsDto.get(0);
                BigDecimal lowerPrice = bestMatchLimitEsDto.getSkuLowerLimit(curSkuId);
                BigDecimal upperPrice = bestMatchLimitEsDto.getSkuUpperLimit(curSkuId);
                skuPriceRespDto.setPriceLimitPolicyId(bestMatchLimitEsDto.getPolicyId());
                skuPriceRespDto.setPriceLimitPolicyCode(bestMatchLimitEsDto.getPolicyCode());
                skuPriceRespDto.setSkuPriceLowerLimit(lowerPrice);
                skuPriceRespDto.setSkuPriceUpperLimit(upperPrice);
                skuPriceRespDto.setSkuLimitControlType(brandLimitConf.getControlType());
                this.replaceSkuPolicyPriceInLimit(lowerPrice, upperPrice, skuPriceRespDto);
            }
        }
    }

    public List<CustomerRespDto> querySellerCustDtoList(Map<Long, CustomerRespDto> customerRespDtoMap, List<Long> itemOrgIds) {
        ArrayList<CustomerRespDto> result = new ArrayList<CustomerRespDto>();
        if (customerRespDtoMap == null || customerRespDtoMap.isEmpty()) {
            return result;
        }
        ArrayList<Long> custIdList = new ArrayList<Long>(customerRespDtoMap.keySet());
        for (Long custId : custIdList) {
            String custIdStr = String.valueOf(custId);
            CustomerRespDto customerRespDto = customerRespDtoMap.get(custId);
            Long sellerOrgId = customerRespDto.getMerchantId();
            List<CustomerRespDto> sellerCustList = this.customerHelper.querySellerCustList(itemOrgIds, sellerOrgId);
            if (!CollectionUtils.isEmpty(sellerCustList)) {
                result.addAll(sellerCustList);
                logger.info("\u6309\u5546\u5bb6\u7ec4\u7ec7id={},\u4e0a\u6e38\u54c1\u724c\u65b9\u7ec4\u7ec7id\u4e2a\u6570={}\u67e5\u8be2custId={}\u4e2a", new Object[]{sellerOrgId, itemOrgIds.size(), sellerCustList.size()});
                continue;
            }
            logger.info("\u6309\u5546\u5bb6\u7ec4\u7ec7id={},\u4e0a\u6e38\u54c1\u724c\u65b9\u7ec4\u7ec7id\u4e2a\u6570={}\u67e5\u8be2custId={}\u4e2a", new Object[]{sellerOrgId, itemOrgIds.size(), 0});
        }
        return result;
    }

    private void replaceSkuPolicyPriceInLimit(BigDecimal lowerPrice, BigDecimal upperPrice, ItemPolicyPriceRespDto skuPriceRespDto) {
        SkuPolicyPriceReplaceInfoDto replaceInfoDto;
        Object tmpVal;
        SkuPolicyPriceReplaceInfoDto replaceInfoDto2;
        BigDecimal tmpVal2;
        if (lowerPrice != null) {
            if (skuPriceRespDto.getHasLadderPrice()) {
                for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : skuPriceRespDto.getLadderPrices()) {
                    if (ladderPrice.getPrice() == null || ladderPrice.getPrice().compareTo(lowerPrice) >= 0) continue;
                    tmpVal2 = ladderPrice.getPrice();
                    logger.info("skuId={}\u9636\u68af\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0b\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), ladderPrice.getPrice(), lowerPrice});
                    ladderPrice.setPrice(lowerPrice);
                    replaceInfoDto2 = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"ladderPrice", (BigDecimal)tmpVal2, (BigDecimal)lowerPrice);
                    skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto2);
                    skuPriceRespDto.setSkuOutOfLimitRange(true);
                }
            }
            if (skuPriceRespDto.getHasDiscountPrice() && skuPriceRespDto.getDiscountPrice() != null && skuPriceRespDto.getDiscountPrice().compareTo(lowerPrice) < 0) {
                tmpVal = skuPriceRespDto.getDiscountPrice();
                logger.info("skuId={}\u6298\u6263\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0b\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), tmpVal, lowerPrice});
                skuPriceRespDto.setDiscountPrice(lowerPrice);
                replaceInfoDto = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"discountPrice", (BigDecimal)tmpVal, (BigDecimal)lowerPrice);
                skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto);
                skuPriceRespDto.setSkuOutOfLimitRange(true);
            }
            if (!skuPriceRespDto.getHasLadderPrice() && !skuPriceRespDto.getHasDiscountPrice() && skuPriceRespDto.getBasePriceSetType() != null && skuPriceRespDto.getBasePriceSetType() == 1 && skuPriceRespDto.getPrice() != null && skuPriceRespDto.getPrice().compareTo(lowerPrice) < 0) {
                tmpVal = skuPriceRespDto.getPrice();
                logger.info("skuId={}\u57fa\u7840\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0b\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), tmpVal, lowerPrice});
                skuPriceRespDto.setPrice(lowerPrice);
                replaceInfoDto = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"price", (BigDecimal)tmpVal, (BigDecimal)lowerPrice);
                skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto);
                skuPriceRespDto.setSkuOutOfLimitRange(true);
            }
        }
        if (upperPrice != null) {
            if (skuPriceRespDto.getHasLadderPrice()) {
                for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : skuPriceRespDto.getLadderPrices()) {
                    if (ladderPrice.getPrice() == null || ladderPrice.getPrice().compareTo(upperPrice) <= 0) continue;
                    tmpVal2 = ladderPrice.getPrice();
                    logger.info("skuId={}\u9636\u68af\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0a\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), tmpVal2, upperPrice});
                    ladderPrice.setPrice(upperPrice);
                    replaceInfoDto2 = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"ladderPrice", (BigDecimal)tmpVal2, (BigDecimal)upperPrice);
                    skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto2);
                    skuPriceRespDto.setSkuOutOfLimitRange(true);
                }
            }
            if (skuPriceRespDto.getHasDiscountPrice() && skuPriceRespDto.getDiscountPrice() != null && skuPriceRespDto.getDiscountPrice().compareTo(upperPrice) > 0) {
                tmpVal = skuPriceRespDto.getDiscountPrice();
                logger.info("skuId={}\u6298\u6263\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0a\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), tmpVal, upperPrice});
                skuPriceRespDto.setDiscountPrice(upperPrice);
                replaceInfoDto = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"discountPrice", (BigDecimal)tmpVal, (BigDecimal)upperPrice);
                skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto);
                skuPriceRespDto.setSkuOutOfLimitRange(true);
            }
            if (!skuPriceRespDto.getHasLadderPrice() && !skuPriceRespDto.getHasDiscountPrice() && skuPriceRespDto.getBasePriceSetType() != null && skuPriceRespDto.getBasePriceSetType() == 1 && skuPriceRespDto.getPrice() != null && skuPriceRespDto.getPrice().compareTo(upperPrice) > 0) {
                tmpVal = skuPriceRespDto.getPrice();
                logger.info("skuId={}\u57fa\u7840\u4ef7\u683c={}\u8d85\u8fc7\u4ef7\u76d8\u4e0a\u9650\uff0c\u4fee\u6b63\u4e3a={}", new Object[]{skuPriceRespDto.getSkuId(), tmpVal, upperPrice});
                skuPriceRespDto.setPrice(upperPrice);
                replaceInfoDto = SkuPolicyPriceReplaceInfoDto.genRepalceInfo((String)"price", (BigDecimal)tmpVal, (BigDecimal)upperPrice);
                skuPriceRespDto.getSkuPolicyPriceReplaceInfoDtoList().add(replaceInfoDto);
                skuPriceRespDto.setSkuOutOfLimitRange(true);
            }
        }
    }

    private Set<Long> extractPriceModelId(Map<String, List<PricePolicyEsDto>> pricePolicyMap) {
        if (pricePolicyMap == null || pricePolicyMap.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> modelIdSet = new HashSet<Long>();
        for (String key : pricePolicyMap.keySet()) {
            List<PricePolicyEsDto> tmpList = pricePolicyMap.get(key);
            if (CollectionUtils.isEmpty(tmpList)) continue;
            modelIdSet.addAll(tmpList.stream().filter(e -> e != null).map(e -> e.getPriceModeId()).collect(Collectors.toSet()));
        }
        return modelIdSet;
    }
}

