/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectItemRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectItemService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceRejectItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.RejectInfoVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceRejectItemServiceImpl
implements IPriceRejectItemService {
    private static final Logger logger = LoggerFactory.getLogger(PriceRejectItemServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private PriceRejectItemDas priceRejectItemDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceRejectItem(PriceRejectItemAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        PriceRejectItemEo priceRejectItemEo = new PriceRejectItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectItemEo);
        priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(priceRejectItemEo.getInstanceId())) {
            priceRejectItemEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(priceRejectItemEo.getTenantId())) {
            priceRejectItemEo.setTenantId(this.context.tenantId());
        }
        this.priceRejectItemDas.insert((BaseEo)priceRejectItemEo);
        return priceRejectItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchPriceRejectItem(List<PriceRejectItemAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList priceRejectItemEoList = ListUtil.toList((Object[])new PriceRejectItemEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)priceRejectItemEoList, PriceRejectItemEo.class);
        if (CollUtil.isEmpty((Collection)priceRejectItemEoList)) {
            return ListUtil.empty();
        }
        for (PriceRejectItemEo priceRejectItemEo : priceRejectItemEoList) {
            priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(priceRejectItemEo.getInstanceId())) {
                priceRejectItemEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(priceRejectItemEo.getTenantId())) continue;
            priceRejectItemEo.setTenantId(this.context.tenantId());
        }
        this.priceRejectItemDas.insertBatch((List)priceRejectItemEoList);
        return priceRejectItemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceRejectItem(PriceRejectItemModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        PriceRejectItemEo priceRejectItemEo = (PriceRejectItemEo)this.priceRejectItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectItemEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectItemEo);
        this.priceRejectItemDas.update((BaseEo)priceRejectItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceRejectItemById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        PriceRejectItemEo priceRejectItemEo = (PriceRejectItemEo)this.priceRejectItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectItemEo)) {
            return;
        }
        this.priceRejectItemDas.logicDeleteById(priceRejectItemEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceRejectItemByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.priceRejectItemDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<PriceRejectItemRespDto> queryByPage(PriceRejectItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<PriceRejectItemEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.priceRejectItemDas, queryWrapper, PriceRejectItemRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<PriceRejectItemEo> getQueryWrapper(PriceRejectItemQueryReqDto reqDto) {
        PriceRejectItemEo priceRejectItemEo = new PriceRejectItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectItemEo);
        priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceRejectItemEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemOrgIdList())) {
            queryWrapper.in(StdPriceRejectItemEo::getItemOrgId, (Collection)reqDto.getItemOrgIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(StdPriceRejectItemEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemTypeList())) {
            queryWrapper.in(StdPriceRejectItemEo::getItemType, (Collection)reqDto.getItemTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdPriceRejectItemEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateTypeList())) {
            queryWrapper.in(StdPriceRejectItemEo::getRelateType, (Collection)reqDto.getRelateTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateIdList())) {
            queryWrapper.in(StdPriceRejectItemEo::getRelateId, (Collection)reqDto.getRelateIdList());
        }
        return queryWrapper;
    }

    @Override
    public List<PriceRejectItemRespDto> queryByList(PriceRejectItemQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        return this.priceRejectItemDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (PriceRejectItemRespDto)item.toDto(PriceRejectItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceRejectItemRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        PriceRejectItemEo priceRejectItemEo = (PriceRejectItemEo)this.priceRejectItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectItemEo)) {
            return null;
        }
        PriceRejectItemRespDto priceRejectItemRespDto = (PriceRejectItemRespDto)priceRejectItemEo.toDto(PriceRejectItemRespDto.class);
        return priceRejectItemRespDto;
    }

    @Override
    public List<PriceRejectItemRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return null;
        }
        PriceRejectItemEo priceRejectItemEo = new PriceRejectItemEo();
        priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceRejectItemEo).in(BaseEo::getId, idList);
        List priceRejectItemEoList = this.priceRejectItemDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceRejectItemEoList.stream().map(item -> (PriceRejectItemRespDto)item.toDto(PriceRejectItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public List<PriceRejectItemRespDto> queryByRelateIdAndType(Long relateId, String relateType) {
        if (relateId == null) {
            return null;
        }
        PriceRejectItemEo priceRejectItemEo = new PriceRejectItemEo();
        priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        priceRejectItemEo.setRelateId(relateId);
        priceRejectItemEo.setRelateType(relateType);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceRejectItemEo);
        List priceRejectItemEoList = this.priceRejectItemDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceRejectItemEoList.stream().map(item -> (PriceRejectItemRespDto)item.toDto(PriceRejectItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public Map<Long, Integer> getRejectItemCountMap(RelateTypeEnum relateTypeEnum, List<Long> relateIdList) {
        if (Objects.isNull(relateTypeEnum) || CollUtil.isEmpty(relateIdList)) {
            return MapUtil.empty();
        }
        List rejectCustomerList = this.priceRejectItemDas.getRejectItemList(relateTypeEnum, relateIdList);
        Map<Long, Integer> countMap = rejectCustomerList.stream().collect(Collectors.toMap(RejectInfoVo::getRelateId, RejectInfoVo::getCount));
        return countMap;
    }
}

