/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceTypeAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceTypeModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceTypeQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceTypeStatusModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceTypeInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceTypeRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceRelatedNum;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceRelatedNumEnum;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceTypeService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.CommonUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceRelationTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.GuidingPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceCategoryDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceRelationTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceCategoryEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdGuidingPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceTypeEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceTypeServiceImpl
implements IPriceTypeService {
    @Resource
    private PriceTypeDas priceTypeDas;
    @Resource
    private PriceCategoryDas priceCategoryDas;
    @Resource
    private IContext context;
    @Resource
    private PriceDas priceDas;
    @Resource
    private BasePriceRelationTypeDas basePriceRelationTypeDas;
    @Resource
    private GuidingPriceDas guidingPriceDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private GenerateCode<PriceTypeEo> generateCode;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceType(PriceTypeAddReqDto reqDto) {
        Long organizationId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
        this.validatePriceType(reqDto.getTypeName(), null, reqDto.getCategoryCode(), organizationId);
        PriceTypeEo priceTypeEo = new PriceTypeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceTypeEo);
        priceTypeEo.setOrganizationId(organizationId);
        priceTypeEo.setTypeCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGLX));
        priceTypeEo.setTenantId(this.context.tenantId());
        priceTypeEo.setInstanceId(this.context.instanceId());
        this.priceTypeDas.insert((BaseEo)priceTypeEo);
        if (CategoryCodeEnum.BASE.getCode().equals(reqDto.getCategoryCode()) && null != reqDto.getReference()) {
            ArrayList<BasePriceRelationTypeEo> basePriceRelationTypeEoList = new ArrayList<BasePriceRelationTypeEo>();
            for (String categoryCode : reqDto.getReference()) {
                BasePriceRelationTypeEo basePriceRelationTypeEo = new BasePriceRelationTypeEo();
                basePriceRelationTypeEo.setPriceTypeId(priceTypeEo.getId());
                basePriceRelationTypeEo.setPriceTypeName(priceTypeEo.getTypeName());
                basePriceRelationTypeEo.setCategoryCode(categoryCode);
                basePriceRelationTypeEoList.add(basePriceRelationTypeEo);
            }
            this.basePriceRelationTypeDas.insertBatch(basePriceRelationTypeEoList);
        }
        return priceTypeEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceType(PriceTypeModifyReqDto reqDto) {
        Long organizationId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
        this.validatePriceType(reqDto.getTypeName(), reqDto.getId(), reqDto.getCategoryCode(), organizationId);
        PriceTypeEo priceTypeEo = new PriceTypeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceTypeEo);
        this.priceTypeDas.updateSelective((BaseEo)priceTypeEo);
        if (CategoryCodeEnum.BASE.getCode().equals(reqDto.getCategoryCode()) && null != reqDto.getReference()) {
            BasePriceRelationTypeEo condition = new BasePriceRelationTypeEo();
            condition.setPriceTypeId(priceTypeEo.getId());
            this.basePriceRelationTypeDas.delete((BaseEo)condition);
            this.insertBasePriceRelationType(priceTypeEo.getId(), priceTypeEo.getTypeName(), reqDto.getReference());
        }
    }

    @Override
    public PriceTypeRespDto queryPriceTypeById(Long id) {
        PriceTypeEo priceTypeEo = (PriceTypeEo)this.priceTypeDas.selectByPrimaryKey(id);
        if (priceTypeEo == null) {
            return null;
        }
        PriceTypeRespDto priceTypeRespDto = new PriceTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)priceTypeEo, (BaseVo)priceTypeRespDto);
        PriceCategoryEo priceCategoryEo = this.priceCategoryDas.selectByCategoryCode(priceTypeEo.getCategoryCode());
        if (null != priceCategoryEo) {
            priceTypeRespDto.setCategoryShow(priceCategoryEo.getCategoryShow());
        }
        if (CategoryCodeEnum.BASE.getCode().equals(priceTypeEo.getCategoryCode())) {
            BasePriceRelationTypeEo condition = new BasePriceRelationTypeEo();
            condition.setPriceTypeId(priceTypeEo.getId());
            condition.setPriceTypeName(priceTypeEo.getTypeName());
            List basePriceRelationTypeEoList = this.basePriceRelationTypeDas.selectList((BaseEo)condition);
            ArrayList<String> reference = new ArrayList<String>();
            for (BasePriceRelationTypeEo eo : basePriceRelationTypeEoList) {
                reference.add(eo.getCategoryCode());
            }
            priceTypeRespDto.setReference(reference);
        }
        return priceTypeRespDto;
    }

    @Override
    public PageInfo<PriceTypeRespDto> queryPriceTypeByPage(PriceTypeQueryReqDto qry, Integer pageNum, Integer pageSize) {
        PageMethod.startPage((int)pageNum, (int)pageSize);
        qry.setTenantId(this.context.tenantId());
        qry.setInstanceId(this.context.instanceId());
        qry.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData());
        List respDtoList = this.priceTypeDas.selectPageList(qry);
        PageInfo resultPageInfo = new PageInfo(respDtoList);
        Long[] arr = new Long[]{CommonUtils.createIndexNo(pageNum, pageSize)};
        respDtoList.stream().forEach(e -> {
            Long l = arr[0];
            Long l2 = arr[0] = Long.valueOf(arr[0] + 1L);
            e.setIndexNo(l);
        });
        resultPageInfo.setList(respDtoList);
        return resultPageInfo;
    }

    @Override
    public void modifyPriceTypeStatus(PriceTypeStatusModifyReqDto reqDto) {
        PriceTypeEo eo = new PriceTypeEo();
        eo.setId(reqDto.getId());
        eo.setStatus(reqDto.getStatus());
        this.priceTypeDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void removePriceType(Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(StdPriceEo::getTypeId, (Object)id)).eq(BaseEo::getDr, (Object)0);
        Integer count = this.priceDas.getMapper().selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BizException("\u8be5\u4ef7\u683c\u7c7b\u578b\u5173\u8054\u4e86\u4ef7\u683c\u5546\u54c1\uff0c\u65e0\u6cd5\u5220\u9664\u3002");
        }
        LambdaQueryWrapper guidingPriceEoqueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)guidingPriceEoqueryWrapper.eq(StdGuidingPriceEo::getPriceTypeId, (Object)id)).eq(BaseEo::getDr, (Object)0);
        Integer guidingPriceCount = this.guidingPriceDas.getMapper().selectCount((Wrapper)guidingPriceEoqueryWrapper);
        if (guidingPriceCount > 0) {
            throw new BizException("\u8be5\u4ef7\u683c\u7c7b\u578b\u5173\u8054\u4e86\u4ef7\u683c\u5546\u54c1\uff0c\u65e0\u6cd5\u5220\u9664\u3002");
        }
        this.priceTypeDas.logicDeleteById(id);
    }

    @Override
    public List<PriceTypeDto> queryPriceTypeByCategoryCode(String categoryCode) {
        if (CategoryCodeEnum.BASE.getCode().equals(categoryCode)) {
            return this.priceTypeDas.queryPriceTypeByCategoryCode(categoryCode, this.context.tenantId(), this.context.instanceId());
        }
        List priceTypeIdList = this.basePriceRelationTypeDas.selectPriceTypeIdByCategoryCode(categoryCode, this.context.tenantId(), this.context.instanceId());
        ArrayList priceTypeDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)priceTypeIdList)) {
            List priceTypeEoList = this.priceTypeDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", (Collection)priceTypeIdList)).eq((Object)"status", (Object)"0"));
            for (PriceTypeEo priceTypeEo : priceTypeEoList) {
                PriceTypeDto priceTypeDto = new PriceTypeDto();
                priceTypeDto.setTypeId(priceTypeEo.getId());
                priceTypeDto.setTypeName(priceTypeEo.getTypeName());
                priceTypeDtoList.add(priceTypeDto);
            }
        }
        return priceTypeDtoList;
    }

    @Override
    public List<PriceTypeDto> queryPriceTypeDropDownListByCategoryCode(String categoryCode) {
        return this.priceTypeDas.queryPriceTypeByCategoryCode(categoryCode, this.context.tenantId(), this.context.instanceId());
    }

    @Override
    public List<PriceTypeInfoRespDto> queryPriceTypeByCategoryCodeAndPriceCode(String categoryCode, List<PriceTypeEnum> priceTypeEnumList) {
        PriceTypeEo priceTypeEo = new PriceTypeEo();
        LambdaQueryWrapper<PriceTypeEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(priceTypeEo);
        ((LambdaQueryWrapper)queryWrapper.eq(StdPriceTypeEo::getCategoryCode, (Object)categoryCode)).in(StdPriceTypeEo::getTypeCode, (Collection)priceTypeEnumList.stream().map(PriceTypeEnum::getType).collect(Collectors.toList()));
        List priceTypeEos = this.priceTypeDas.getMapper().selectList(queryWrapper);
        ArrayList list = ListUtil.toList((Object[])new PriceTypeInfoRespDto[0]);
        DtoHelper.eoList2DtoList((Collection)priceTypeEos, (Collection)list, PriceTypeInfoRespDto.class);
        return list;
    }

    @Override
    public void modifyPriceTypeRelatedNum(Long id, PriceRelatedNumEnum update) {
        if (PriceRelatedNum.ADD.equals(PriceRelatedNumEnum.get(PriceRelatedNum.ADD))) {
            this.priceTypeDas.modifyPriceTypeRelatedNum(id, PriceRelatedNum.ADD);
        }
        if (PriceRelatedNum.SUB.equals(PriceRelatedNumEnum.get(PriceRelatedNum.SUB))) {
            this.priceTypeDas.modifyPriceTypeRelatedNum(id, PriceRelatedNum.SUB);
        }
    }

    private void validatePriceType(String name, Long id, String categoryCode, Long organizationId) {
        boolean repeat;
        int countCategoryCode = this.priceCategoryDas.getMapper().selectCount((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"category_code", (Object)categoryCode)).eq((Object)"tenant_id", (Object)this.context.tenantId())).eq((Object)"instance_id", (Object)this.context.instanceId())).eq((Object)"dr", (Object)"0"));
        if (countCategoryCode <= 0) {
            throw new BizException("\u4ef7\u683c\u5927\u7c7b\u4e0d\u5b58\u5728");
        }
        PriceTypeEo condition = new PriceTypeEo();
        condition.setTypeName(name);
        condition.setOrganizationId(organizationId);
        List priceTypeEoList = this.priceTypeDas.select((BaseEo)condition);
        boolean bl = repeat = null == id && !priceTypeEoList.isEmpty() || null != id && !priceTypeEoList.isEmpty() && !((PriceTypeEo)priceTypeEoList.get(0)).getId().equals(id);
        if (repeat) {
            throw new BizException("\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u91cd\u590d");
        }
    }

    private void insertBasePriceRelationType(Long priceTypeId, String priceTypeName, List<String> categoryCodes) {
        ArrayList<BasePriceRelationTypeEo> basePriceRelationTypeEoList = new ArrayList<BasePriceRelationTypeEo>();
        for (String categoryCode : categoryCodes) {
            BasePriceRelationTypeEo basePriceRelationTypeEo = new BasePriceRelationTypeEo();
            basePriceRelationTypeEo.setPriceTypeId(priceTypeId);
            basePriceRelationTypeEo.setPriceTypeName(priceTypeName);
            basePriceRelationTypeEo.setCategoryCode(categoryCode);
            basePriceRelationTypeEoList.add(basePriceRelationTypeEo);
        }
        this.basePriceRelationTypeDas.insertBatch(basePriceRelationTypeEoList);
    }

    @Override
    public List<PriceTypeEo> queryPriceTypeByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.priceTypeDas.listByIds(ids);
    }
}

