/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.FastJsonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceModelSetTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PricePolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PricePolicyEsSkuExtDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SkuPolicyPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceModelRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.SkuPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceModelService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceTypeService;
import com.dtyunxi.yundt.cube.center.price.biz.service.ISkuPolicyPriceQueryService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.NumberUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcReqVo;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcRespVo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountQueryReqDto;
import com.yx.tcbj.center.price.api.dto.response.PrBaseDiscountRespDto;
import com.yx.tcbj.center.price.biz.service.IPrBaseDiscountService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SkuPolicyPriceQueryServiceImpl
implements ISkuPolicyPriceQueryService {
    private static final Logger logger = LoggerFactory.getLogger(SkuPolicyPriceQueryServiceImpl.class);
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;
    @Resource
    private IPriceModelService priceModelService;
    @Resource
    private IBasePriceItemService basePriceItemService;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Autowired
    private IPriceTypeService priceTypeService;
    @Resource
    private ShopHelper shopHelper;
    @Autowired
    private IPrBaseDiscountService prBaseDiscountService;

    @Override
    public PageInfo<SkuPolicyPriceRespDto> querySkuPolicyDistributePriceByPage(SkuPolicyPriceQueryReqDto skuPolicyPriceReqDto, Integer pageNum, Integer pageSize) {
        PageInfo skuLibPageInfo;
        Assert.isTrue((skuPolicyPriceReqDto.getCustomerId() != null || StringUtils.isNotBlank((String)skuPolicyPriceReqDto.getSkuCode()) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5ba2\u6237\u6216\u8005\u5546\u54c1");
        Long sellerOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        ArrayList<Long> shopIdList = new ArrayList<Long>();
        if (skuPolicyPriceReqDto.getShopId() != null) {
            shopIdList.add(skuPolicyPriceReqDto.getShopId());
        } else {
            shopIdList = this.queryShopIdList(sellerOrgInfoId);
        }
        if (CollectionUtils.isEmpty(shopIdList)) {
            return new PageInfo(ListUtil.empty());
        }
        List<ItemAuthRespDto> itemAuthRespDtos = this.shopHelper.queryShopSkuList(shopIdList);
        if (CollectionUtils.isEmpty(itemAuthRespDtos)) {
            return new PageInfo(ListUtil.empty());
        }
        Map<Long, List<ItemAuthRespDto>> skuShopListMap = itemAuthRespDtos.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getBusinessId));
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setInSkuIdList(itemAuthRespDtos.stream().map(ItemAuthRespDto::getBusinessId).distinct().collect(Collectors.toList()));
        itemSkuQueryReqDto.setItemLongCode(skuPolicyPriceReqDto.getSkuCode());
        itemSkuQueryReqDto.setSubType(skuPolicyPriceReqDto.getSubType());
        itemSkuQueryReqDto.setGiftBox(skuPolicyPriceReqDto.getGiftBox());
        itemSkuQueryReqDto.setBrandIds(skuPolicyPriceReqDto.getBrandIds());
        if (StringUtils.isNotBlank((String)skuPolicyPriceReqDto.getSkuCode())) {
            pageNum = 1;
        }
        if (CollectionUtils.isEmpty((Collection)(skuLibPageInfo = (PageInfo)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, pageNum, pageSize).getData()).getList())) {
            return new PageInfo(ListUtil.empty());
        }
        PageInfo result = new PageInfo();
        ArrayList<SkuPolicyPriceRespDto> skuPolicyPriceRespDtos = new ArrayList<SkuPolicyPriceRespDto>();
        CubeBeanUtils.copyCollection(skuPolicyPriceRespDtos, (Collection)skuLibPageInfo.getList(), SkuPolicyPriceRespDto.class);
        CubeBeanUtils.copyProperties((Object)result, (Object)skuLibPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList(skuPolicyPriceRespDtos);
        this.fillSkuPriceLimit(skuPolicyPriceRespDtos, sellerOrgInfoId, skuPolicyPriceReqDto);
        return this.fillSkuPricePolicy(skuPolicyPriceRespDtos, sellerOrgInfoId, skuPolicyPriceReqDto, skuShopListMap, (PageInfo<SkuPolicyPriceRespDto>)result);
    }

    private void fillSkuPriceLimit(List<SkuPolicyPriceRespDto> skuPolicyPriceRespDtos, Long sellerOrgInfoId, SkuPolicyPriceQueryReqDto skuPolicyPriceReqDto) {
        HashMap brandOrgIdConfMap;
        List skuIds = skuPolicyPriceRespDtos.stream().map(e -> e.getSkuId()).collect(Collectors.toList());
        List<Long> itemOrgIds = skuPolicyPriceRespDtos.stream().map(e -> e.getItemOrgId()).distinct().collect(Collectors.toList());
        List sellerCustList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds(itemOrgIds, sellerOrgInfoId));
        if (CollectionUtils.isEmpty((Collection)sellerCustList)) {
            return;
        }
        List custIdList = sellerCustList.stream().map(e -> e.getId()).collect(Collectors.toList());
        List brandOrgIdList = sellerCustList.stream().map(e -> e.getMerchantId()).collect(Collectors.toList());
        PriceLimitEsQueryReqDto limitEsReqDto = new PriceLimitEsQueryReqDto();
        limitEsReqDto.setOrganizationIdList(brandOrgIdList);
        limitEsReqDto.setCustomerIdList(custIdList);
        limitEsReqDto.setSkuIdList(skuIds);
        limitEsReqDto.setQueryBestMatch(Integer.valueOf(1));
        Map<String, List<PriceLimitPolicyEsDto>> skuEsLimitDtoMap = this.priceLimitPolicyEsService.queryPriceLimitPolicy(limitEsReqDto);
        List<PriceBasicConfigRespDto> priceBasicConfigRespDtoList = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(itemOrgIds, PriceBasicConfigEnum.ConfigType.PRICE_SETTING);
        Map<Object, Object> map = brandOrgIdConfMap = CollectionUtils.isEmpty(priceBasicConfigRespDtoList) ? Maps.newHashMap() : priceBasicConfigRespDtoList.stream().filter(e -> e.getControlType() == PriceBasicConfigEnum.ControlType.CONTROL.getCode()).collect(Collectors.toMap(PriceBasicConfigRespDto::getOrganizationId, e -> e, (e1, e2) -> e1));
        if (!CollectionUtils.isEmpty(skuEsLimitDtoMap)) {
            block0: for (SkuPolicyPriceRespDto skuPolicyPriceRespDto : skuPolicyPriceRespDtos) {
                for (CustomerRespDto custDto : sellerCustList) {
                    if (custDto.getMerchantId() == null || skuPolicyPriceRespDto.getItemOrgId() == null || !custDto.getMerchantId().equals(skuPolicyPriceRespDto.getItemOrgId())) continue;
                    String tmpKey = String.valueOf(custDto.getId()) + "-" + String.valueOf(skuPolicyPriceRespDto.getSkuId());
                    List<PriceLimitPolicyEsDto> policyEsDtos = skuEsLimitDtoMap.get(tmpKey);
                    if (CollectionUtils.isEmpty(policyEsDtos)) continue block0;
                    PriceLimitPolicyEsDto priceLimitPolicyEsDto = policyEsDtos.get(0);
                    skuPolicyPriceRespDto.setPriceLimitPolicyId(priceLimitPolicyEsDto.getPolicyId());
                    BigDecimal lowerLimit = priceLimitPolicyEsDto.getSkuLowerLimit(skuPolicyPriceRespDto.getSkuId());
                    BigDecimal upperLimit = priceLimitPolicyEsDto.getSkuUpperLimit(skuPolicyPriceRespDto.getSkuId());
                    skuPolicyPriceRespDto.setSkuLowerLimit(lowerLimit);
                    skuPolicyPriceRespDto.setSkuUpperLimit(upperLimit);
                    PriceBasicConfigRespDto priceBasicConfigRespDto = (PriceBasicConfigRespDto)brandOrgIdConfMap.get(skuPolicyPriceRespDto.getItemOrgId());
                    if (priceBasicConfigRespDto == null) continue block0;
                    skuPolicyPriceRespDto.setControlType(priceBasicConfigRespDto.getControlType());
                    continue block0;
                }
            }
        }
    }

    private PageInfo<SkuPolicyPriceRespDto> fillSkuPricePolicy(List<SkuPolicyPriceRespDto> skuPolicyPriceRespDtos, Long sellerOrgInfoId, SkuPolicyPriceQueryReqDto skuPolicyPriceReqDto, Map<Long, List<ItemAuthRespDto>> skuShopListMap, PageInfo<SkuPolicyPriceRespDto> resultPageInfo) {
        PageInfo pageInfo = new PageInfo();
        List<Object> customerIds = Lists.newArrayList();
        List customerRespDtos = Lists.newArrayList();
        Long retailCustId = skuPolicyPriceReqDto.getCustomerId();
        if (retailCustId == null) {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setTenantId(this.context.tenantId());
            searchReqDto.setListFlag(Boolean.valueOf(true));
            searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
            PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByPage(FastJsonUtil.toJSONString((Object)searchReqDto), skuPolicyPriceReqDto.getPageNum(), skuPolicyPriceReqDto.getPageSize()));
            if (customerRespDtoPageInfo == null || CollectionUtil.isEmpty((Collection)customerRespDtoPageInfo.getList())) {
                return new PageInfo();
            }
            customerIds = customerRespDtoPageInfo.getList().stream().map(com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto::getId).collect(Collectors.toList());
            customerRespDtos = customerRespDtoPageInfo.getList();
            BeanUtil.copyProperties((Object)customerRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        } else {
            customerIds.add(retailCustId);
            CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(retailCustId).getData();
            if (customerRespDto == null || !sellerOrgInfoId.equals(customerRespDto.getMerchantId())) {
                logger.info("customerId={},\u4e0d\u662f\u5546\u5bb6\u7684\u5ba2\u6237={}", (Object)retailCustId, (Object)sellerOrgInfoId);
                return new PageInfo();
            }
            customerRespDtos.add(customerRespDto);
            BeanUtil.copyProperties(resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        }
        HashSet<Long> shopIds = new HashSet<Long>();
        CommunalPriceQueryReqDto queryPriceReqDto = new CommunalPriceQueryReqDto();
        ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        for (SkuPolicyPriceRespDto skuPolicyPriceRespDto : skuPolicyPriceRespDtos) {
            Long curSkuId = skuPolicyPriceRespDto.getSkuId();
            List<ItemAuthRespDto> itemShopList = skuShopListMap.get(curSkuId);
            if (CollectionUtils.isEmpty(itemShopList)) continue;
            for (ItemAuthRespDto itemAuthRespDto : itemShopList) {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto reqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                reqDto.setSkuId(curSkuId);
                reqDto.setShopId(itemAuthRespDto.getTargetId());
                shopIds.add(itemAuthRespDto.getTargetId());
                reqDto.setItemId(skuPolicyPriceRespDto.getItemId());
                skuList.add(reqDto);
            }
        }
        queryPriceReqDto.setPolicyCode(skuPolicyPriceReqDto.getPolicyCode());
        queryPriceReqDto.setPolicyDate(new Date());
        queryPriceReqDto.setCustId(retailCustId);
        queryPriceReqDto.setCustomerIds((List)customerIds);
        queryPriceReqDto.setSkuList(skuList);
        if (skuPolicyPriceReqDto.getPriceTypeId() != null) {
            queryPriceReqDto.setPriceTypeIdList(Arrays.asList(skuPolicyPriceReqDto.getPriceTypeId()));
        }
        queryPriceReqDto.setOnlyBestMatch(Integer.valueOf(0));
        queryPriceReqDto.setOrganizationId(sellerOrgInfoId);
        Map<String, List<PricePolicyEsDto>> custPricePolicyMap = this.pricePolicyEsService.queryDistributionPricePolicyList(queryPriceReqDto);
        Set<Long> priceModelIdSet = this.extractPriceModelId(custPricePolicyMap);
        List<PriceModelRespDto> tmpPriceModeList = this.priceModelService.queryByIds(new ArrayList<Long>(priceModelIdSet));
        Map<Long, PriceModelRespDto> priceModelEoMap = tmpPriceModeList.stream().filter(e -> e != null).collect(Collectors.toMap(BaseRespDto::getId, e -> e, (e1, e2) -> e1));
        Set<Long> priceTypeIdList = this.extractPriceTypeId(custPricePolicyMap);
        ArrayList<PriceTypeEo> priceTypeList = new ArrayList<PriceTypeEo>();
        List<PriceTypeEo> tmpPriceTypeList = this.priceTypeService.queryPriceTypeByIds(new ArrayList<Long>(priceTypeIdList));
        if (!CollectionUtils.isEmpty(tmpPriceTypeList)) {
            priceTypeList.addAll(tmpPriceTypeList);
        }
        Map<Long, PriceTypeEo> priceTypeEoMap = priceTypeList.stream().filter(e -> e != null).collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        List<Long> skuIds = skuPolicyPriceRespDtos.stream().map(e -> e.getSkuId()).distinct().collect(Collectors.toList());
        List<Long> itemOrgIds = skuPolicyPriceRespDtos.stream().filter(e -> e.getItemOrgId() != null).map(e -> e.getItemOrgId()).distinct().collect(Collectors.toList());
        List<Long> brandPriceTypeIds = Arrays.asList(PriceTypeEnum.RETAIL_PRICE.getTypeId(), PriceTypeEnum.EXCHANGE_PRICE.getTypeId());
        List<BasePriceItemEo> brandItemBasePriceList = this.basePriceItemService.queryBrandPriceBySkuIds(skuIds, brandPriceTypeIds, itemOrgIds);
        Long dealerBasePriceTypeId = PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId();
        List<BasePriceItemEo> dealerItemBasePriceList = this.basePriceItemService.queryDealerPriceBySkuIds(new ArrayList<Long>(shopIds), skuIds, dealerBasePriceTypeId, sellerOrgInfoId);
        PrBaseDiscountQueryReqDto prBaseDiscountQueryReqDto = new PrBaseDiscountQueryReqDto();
        prBaseDiscountQueryReqDto.setCustomerIdList((List)customerIds);
        PageInfo baseDiscountPage = this.prBaseDiscountService.queryByPage(prBaseDiscountQueryReqDto);
        logger.info("[\u57fa\u7840\u6263\u7387]\uff0c\u5ba2\u6237ID:{},\u6263\u7387\u914d\u7f6e:{}", (Object)customerIds, (Object)JSON.toJsonString((Object)baseDiscountPage));
        Map<Object, Object> customerBrandDiscountMap = Maps.newHashMap();
        Map<Object, Object> prBaseDiscountMap = Maps.newHashMap();
        if (baseDiscountPage != null && !CollectionUtils.isEmpty((Collection)baseDiscountPage.getList())) {
            prBaseDiscountMap = baseDiscountPage.getList().stream().collect(Collectors.toMap(PrBaseDiscountRespDto::getCustomerId, e -> e, (e1, e2) -> e1));
            customerBrandDiscountMap = baseDiscountPage.getList().stream().filter(e -> !CollectionUtils.isEmpty((Collection)e.getBrandDiscountList())).collect(Collectors.toMap(PrBaseDiscountRespDto::getCustomerId, e -> e.getBrandDiscountList().stream().collect(Collectors.toMap(PrBaseDiscountBrandReqDto::getBrandId, PrBaseDiscountBrandReqDto::getBrandDiscount)), (e1, e2) -> e1));
        }
        ArrayList list = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        for (CustomerRespDto customerRespDto : customerRespDtos) {
            Long customerId = customerRespDto.getId();
            PrBaseDiscountRespDto prBaseDiscountRespDto = (PrBaseDiscountRespDto)prBaseDiscountMap.get(customerId);
            Map brandDiscountRateMap = customerBrandDiscountMap.getOrDefault(customerId, map);
            for (SkuPolicyPriceRespDto skuPolicyPriceRespDto : skuPolicyPriceRespDtos) {
                skuPolicyPriceRespDto.setPricePolicyEsSkuExtDtos(null);
                skuPolicyPriceRespDto.setCustomerId(customerId);
                skuPolicyPriceRespDto.setCustomerName(customerRespDto.getName());
                BigDecimal prBaseDiscountReate = prBaseDiscountRespDto != null ? brandDiscountRateMap.getOrDefault(skuPolicyPriceRespDto.getBrandId(), prBaseDiscountRespDto.getStandardDiscount()) : null;
                logger.info("[\u57fa\u7840\u6263\u7387]\uff1a{}\uff0c\u5546\u54c1\u7f16\u53f7\uff1a{}", (Object)prBaseDiscountReate, (Object)skuPolicyPriceRespDto.getItemCode());
                Long curSkuId = skuPolicyPriceRespDto.getSkuId();
                String curSkuIdStr = String.valueOf(curSkuId);
                Long curItemOrgId = skuPolicyPriceRespDto.getItemOrgId();
                List<ItemAuthRespDto> itemShopList = skuShopListMap.get(curSkuId);
                for (ItemAuthRespDto authRespDto : itemShopList) {
                    Long curShopId = authRespDto.getTargetId();
                    String curShopIdStr = String.valueOf(curShopId);
                    String tmpKey = String.valueOf(customerId) + "-" + curShopIdStr + "-" + curSkuIdStr;
                    List<PricePolicyEsDto> pricePolicyEsDtos = custPricePolicyMap.get(tmpKey);
                    BasePriceItemEo brandSkuRetailPriceEo = this.basePriceItemService.getBrandSkuRetailPrice(curSkuId, curItemOrgId, brandItemBasePriceList);
                    skuPolicyPriceRespDto.setSkubrandBasePrice(brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getItemPrice());
                    BasePriceItemEo dealerSkuBasePriceEo = this.basePriceItemService.getDealerSkuBasePrice(curSkuId, curShopId, dealerItemBasePriceList);
                    skuPolicyPriceRespDto.setSkuDealerBasePrice(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getItemPrice());
                    if (!CollectionUtils.isEmpty(pricePolicyEsDtos)) {
                        List<PricePolicyEsSkuExtDto> esSkuExtDtoList = this.convertPricePolicyEsDtos(pricePolicyEsDtos, dealerItemBasePriceList, skuPolicyPriceRespDto, curShopId, customerId, priceModelEoMap, priceTypeEoMap, brandSkuRetailPriceEo, prBaseDiscountReate);
                        logger.info("curShopId={},curSkuId={},\u7684\u653f\u7b56\u67e5\u4ef7\u7ed3\u679c={}", new Object[]{curShopId, curSkuId, esSkuExtDtoList.size()});
                        if (skuPolicyPriceRespDto.getPricePolicyEsSkuExtDtos() != null) {
                            skuPolicyPriceRespDto.getPricePolicyEsSkuExtDtos().addAll(esSkuExtDtoList);
                        } else {
                            skuPolicyPriceRespDto.setPricePolicyEsSkuExtDtos(esSkuExtDtoList);
                        }
                    }
                    this.findBaseSupplyPrice(skuPolicyPriceRespDto);
                    SkuPolicyPriceRespDto result = new SkuPolicyPriceRespDto();
                    BeanUtil.copyProperties((Object)skuPolicyPriceRespDto, (Object)result, (String[])new String[0]);
                    list.add(result);
                }
            }
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    private void findBaseSupplyPrice(SkuPolicyPriceRespDto skuPolicyPriceRespDto) {
        if (CollectionUtil.isNotEmpty((Collection)skuPolicyPriceRespDto.getPricePolicyEsSkuExtDtos())) {
            return;
        }
        BigDecimal skubrandBasePrice = skuPolicyPriceRespDto.getSkubrandBasePrice();
        BigDecimal skuDealerBasePrice = skuPolicyPriceRespDto.getSkuDealerBasePrice();
        skuPolicyPriceRespDto.setSupplyPrice(skuDealerBasePrice != null ? skuDealerBasePrice : skubrandBasePrice);
    }

    private List<PricePolicyEsSkuExtDto> convertPricePolicyEsDtos(List<PricePolicyEsDto> pricePolicyEsDtos, List<BasePriceItemEo> dealerItemBasePriceList, SkuPolicyPriceRespDto skuPolicyPriceRespDto, Long curShopId, Long retailCustId, Map<Long, PriceModelRespDto> priceModelDtoMap, Map<Long, PriceTypeEo> priceTypeEoMap, BasePriceItemEo brandSkuRetailPriceEo, BigDecimal prBaseDiscountReate) {
        BigDecimal curSkuLowerPrice = skuPolicyPriceRespDto.getSkuLowerLimit();
        BigDecimal curSkuUpperPrice = skuPolicyPriceRespDto.getSkuUpperLimit();
        Integer controlType = skuPolicyPriceRespDto.getControlType();
        Long curSkuId = skuPolicyPriceRespDto.getSkuId();
        Long brandId = skuPolicyPriceRespDto.getBrandId();
        Comparator pricePolicyComp = this.pricePolicyEsService.getPricePolicyComp(priceTypeEoMap);
        pricePolicyEsDtos.sort(pricePolicyComp);
        AtomicReference<Integer> rankNo = new AtomicReference<Integer>(0);
        List<PricePolicyEsSkuExtDto> res = pricePolicyEsDtos.stream().map(e -> {
            Long priceModelId = e.getPriceModeId();
            Long priceTypeId = e.getPriceTypeId();
            Integer curGiftBox = skuPolicyPriceRespDto.getGiftBox() == null ? 1 : skuPolicyPriceRespDto.getGiftBox();
            BasePriceItemEo dealerSkuBasePriceEo = this.basePriceItemService.getDealerSkuBasePrice(curSkuId, curShopId, dealerItemBasePriceList);
            skuPolicyPriceRespDto.setSkuDealerBasePrice(dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getItemPrice());
            PricePolicyEsSkuExtDto esSkuExtDto = new PricePolicyEsSkuExtDto();
            CubeBeanUtils.copyProperties((Object)esSkuExtDto, (Object)e, (String[])new String[]{"skuLadderPriceList"});
            rankNo.updateAndGet(v -> v + 1);
            esSkuExtDto.setRankNo((Integer)rankNo.get());
            esSkuExtDto.setItemRangeDescList(e.getItemRangeList());
            esSkuExtDto.setCustomerRangeDescList(e.getCustomerRangeDescList());
            PriceModelRespDto priceModelDto = (PriceModelRespDto)priceModelDtoMap.get(priceModelId);
            if (priceModelDto == null) {
                logger.error("priceModelDto={} is null,can't calc price", (Object)priceModelId);
                return null;
            }
            esSkuExtDto.setPriceModeName(priceModelDto.getModelName());
            PriceTypeEo priceTypeEo = (PriceTypeEo)priceTypeEoMap.get(priceTypeId);
            esSkuExtDto.setPriceTypeName(priceTypeEo == null ? null : priceTypeEo.getTypeName());
            SkuPolicyPriceCalcReqVo reqVo = new SkuPolicyPriceCalcReqVo.SkuPolicyPriceCalcReqVoBuilder().skuId(curSkuId).brandId(brandId).shopId(curShopId).giftBox(curGiftBox).customerId(retailCustId).pricePolicyEsDto((PricePolicyEsDto)e).priceModelRespDto(priceModelDto).brandSkuRetailPriceEo(brandSkuRetailPriceEo).dealerSkuBasePriceEo(dealerSkuBasePriceEo).prBaseDiscountReate(prBaseDiscountReate).build();
            SkuPolicyPriceCalcRespVo respVo = this.pricePolicyEsService.calcSkuPolicyPrice(reqVo);
            logger.info("[\u653f\u7b56\u4ef7\u8ba1\u7b97\u7ed3\u679c]:{} ", (Object)JSON.toJsonString((Object)respVo));
            esSkuExtDto.setPriceModelSetType(PriceModelSetTypeEnum.DISCOUNT_SET.getCode());
            if (respVo.isHasDiscountPrice()) {
                esSkuExtDto.setHasDiscountPrice(respVo.isHasDiscountPrice());
                esSkuExtDto.setSkuPolicyPrice(respVo.getSkuPolcyDiscountPrice());
                logger.info("[\u653f\u7b56\u6298\u6263\u4ef7\u8ba1\u7b97\u7ed3\u679c]\uff0cSku={} PolcyDiscountPrice = {} ", (Object)curSkuId, (Object)respVo.getSkuPolcyDiscountPrice());
                if (respVo.getSkuPolcyDiscountPrice() != null) {
                    boolean inRange = NumberUtils.isInRange(respVo.getSkuPolcyDiscountPrice(), curSkuLowerPrice, curSkuUpperPrice);
                    esSkuExtDto.setSkuPolicyPriceOutRange(!inRange);
                    esSkuExtDto.setSupplyPrice(this.findPolicySupplyPrice(controlType, respVo.getSkuPolcyDiscountPrice(), curSkuLowerPrice, curSkuUpperPrice));
                }
            } else if (respVo.isHasLadderPrice()) {
                esSkuExtDto.setHasLadderPrice(respVo.isHasLadderPrice());
                logger.info("[\u653f\u7b56\u9636\u68af\u4ef7\u8ba1\u7b97\u7ed3\u679c]\uff0cSku={} HasLadderPrice = {} ", (Object)curSkuId, (Object)respVo.isHasLadderPrice());
                List skuLadderPriceList = null;
                if (!CollectionUtils.isEmpty(respVo.getSkuLadderPrices())) {
                    skuLadderPriceList = respVo.getSkuLadderPrices().stream().map(limit -> {
                        PricePolicyEsSkuExtDto.SkuLadderPrice skuLadderPrice = new PricePolicyEsSkuExtDto.SkuLadderPrice();
                        skuLadderPrice.setLadderPrice(limit.getLadderPrice());
                        skuLadderPrice.setLowerNum(limit.getLowerNum());
                        skuLadderPrice.setUpperNum(limit.getUpperNum());
                        skuLadderPrice.setSkuId(curSkuId);
                        boolean inRange = NumberUtils.isInRange(limit.getLadderPrice(), curSkuLowerPrice, curSkuUpperPrice);
                        skuLadderPrice.setOutPriceRange(!inRange);
                        skuLadderPrice.setSupplyPrice(this.findPolicySupplyPrice(controlType, limit.getLadderPrice(), curSkuLowerPrice, curSkuUpperPrice));
                        return skuLadderPrice;
                    }).collect(Collectors.toList());
                }
                esSkuExtDto.setSkuLadderPriceList(skuLadderPriceList);
                esSkuExtDto.setPriceModelSetType(PriceModelSetTypeEnum.DIRECT_SET.getCode());
            }
            esSkuExtDto.setCalcPriceDescriptionRespDto(respVo.getCalcPriceDescriptionRespDto());
            return esSkuExtDto;
        }).filter(e -> e != null).collect(Collectors.toList());
        return res;
    }

    private BigDecimal findPolicySupplyPrice(Integer controyType, BigDecimal val, BigDecimal lower, BigDecimal upper) {
        if (val == null || PriceBasicConfigEnum.ControlType.WARN.getCode().equals(controyType)) {
            return val;
        }
        if (lower != null && val.compareTo(lower) < 0) {
            return lower;
        }
        if (upper != null && val.compareTo(upper) > 0) {
            return upper;
        }
        return val;
    }

    private Set<Long> extractPriceTypeId(Map<String, List<PricePolicyEsDto>> pricePolicyMap) {
        if (pricePolicyMap.isEmpty()) {
            return null;
        }
        HashSet<Long> priceTypeIdSet = new HashSet<Long>();
        for (String key : pricePolicyMap.keySet()) {
            List<PricePolicyEsDto> tmpList = pricePolicyMap.get(key);
            if (CollectionUtils.isEmpty(tmpList)) continue;
            priceTypeIdSet.addAll(tmpList.stream().filter(e -> e != null).map(e -> e.getPriceTypeId()).collect(Collectors.toSet()));
        }
        return priceTypeIdSet;
    }

    private Set<Long> extractPriceModelId(Map<String, List<PricePolicyEsDto>> pricePolicyMap) {
        if (pricePolicyMap.isEmpty()) {
            return null;
        }
        HashSet<Long> modelIdSet = new HashSet<Long>();
        for (String key : pricePolicyMap.keySet()) {
            List<PricePolicyEsDto> tmpList = pricePolicyMap.get(key);
            if (CollectionUtils.isEmpty(tmpList)) continue;
            modelIdSet.addAll(tmpList.stream().filter(e -> e != null).map(e -> e.getPriceModeId()).collect(Collectors.toSet()));
        }
        return modelIdSet;
    }

    private List<Long> queryShopIdList(Long userOrgInfoId) {
        ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
        shopToBQueryReqDto.setOrganizationIdList((List)ListUtil.toList((Object[])new Long[]{userOrgInfoId}));
        shopToBQueryReqDto.setPageNum(1);
        shopToBQueryReqDto.setPageSize(1000);
        shopToBQueryReqDto.setStatus("NORMAL");
        shopToBQueryReqDto.setSellerStatus("NORMAL");
        PageInfo shopToBListRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryPage(shopToBQueryReqDto));
        if (CollUtil.isEmpty((Collection)shopToBListRespDtoPageInfo.getList())) {
            return null;
        }
        List<Long> shopIdList = shopToBListRespDtoPageInfo.getList().stream().map(ShopToBListRespDto::getId).distinct().collect(Collectors.toList());
        return shopIdList;
    }
}

