/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BaseExcelDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ExcelImportDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.OssHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IXlsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IExportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IImportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.ExcelUtils;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.BaseExcelImport;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XlsServiceImpl
implements IXlsService {
    private static final Logger log = LoggerFactory.getLogger(XlsServiceImpl.class);
    @Resource
    private List<IImportSevice> importSevices;
    @Resource
    private List<IExportSevice> exportSevices;
    @Resource
    private OssHelper ossHelper;
    @Resource
    private CustomerHelper customerHelper;
    private static ConcurrentHashMap<ExcelUseTypeEnum, IImportSevice> importSeviceMap = null;
    private static ConcurrentHashMap<ExcelUseTypeEnum, IExportSevice> exportSeviceMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IImportSevice getImportSevice(ExcelUseTypeEnum excelUseTypeEnum) {
        if (Objects.isNull(excelUseTypeEnum)) {
            return null;
        }
        if (!Objects.isNull(importSeviceMap)) return importSeviceMap.get(excelUseTypeEnum);
        Class<XlsServiceImpl> clazz = XlsServiceImpl.class;
        synchronized (XlsServiceImpl.class) {
            if (!Objects.isNull(importSeviceMap)) return importSeviceMap.get(excelUseTypeEnum);
            importSeviceMap = MapUtil.newConcurrentHashMap();
            for (IImportSevice importSevice : this.importSevices) {
                importSeviceMap.put(importSevice.excelUseType(), importSevice);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return importSeviceMap.get(excelUseTypeEnum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IExportSevice getExportSevice(ExcelUseTypeEnum excelUseTypeEnum) {
        if (Objects.isNull(excelUseTypeEnum)) {
            return null;
        }
        if (!Objects.isNull(exportSeviceMap)) return exportSeviceMap.get(excelUseTypeEnum);
        Class<XlsServiceImpl> clazz = XlsServiceImpl.class;
        synchronized (XlsServiceImpl.class) {
            if (!Objects.isNull(exportSeviceMap)) return exportSeviceMap.get(excelUseTypeEnum);
            exportSeviceMap = MapUtil.newConcurrentHashMap();
            for (IExportSevice exportSevice : this.exportSevices) {
                exportSeviceMap.put(exportSevice.excelUseType(), exportSevice);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return exportSeviceMap.get(excelUseTypeEnum);
        }
    }

    @Override
    public BaseExcelDto excelImport(ExcelImportDto excelImportDto) {
        String useType = excelImportDto.getUseType();
        String url = excelImportDto.getUrl();
        AssertUtils.isNonNull(url, PriceExceptionCode.ERROR.setParamValue("\u65e0\u6548\u7684url"));
        AssertUtils.isNonNull(useType, PriceExceptionCode.INVALID_USE_TYPE);
        ExcelUseTypeEnum excelUseTypeEnum = ExcelUseTypeEnum.toExcelUseTypeEnum((String)useType);
        AssertUtils.isNonNull(excelUseTypeEnum, PriceExceptionCode.INVALID_USE_TYPE);
        IImportSevice importSevice = this.getImportSevice(excelUseTypeEnum);
        AssertUtils.isNonNull(importSevice, PriceExceptionCode.ERROR.setParamValue("\u5bfc\u5165\u65e0\u5b9e\u73b0\u7c7b"));
        BaseExcelDto baseExcelDto = importSevice.exportCustom(excelImportDto, ExcelUtils.getWorkbook(url));
        if (Objects.nonNull(baseExcelDto)) {
            return baseExcelDto;
        }
        ImportParams params = importSevice.importParams();
        if (Objects.isNull(params)) {
            params = new ImportParams();
        }
        params.setNeedVerfiy(importSevice.needVerfiy());
        baseExcelDto = new BaseExcelDto();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)URLUtil.getStream((URL)URLUtil.url((String)url)), importSevice.pojoClass(), (ImportParams)params);
            importSevice.setSerialNumber((ExcelImportResult<BaseExcelImport>)result);
            List failList = result.getFailList();
            List successList = result.getList();
            importSevice.importData(excelImportDto, baseExcelDto, successList, failList);
        }
        catch (Exception e) {
            log.error("[excel\u5bfc\u5165] >>> \u5bfc\u5165\u5931\u8d25", (Throwable)e);
            baseExcelDto.setErrorMsgList((List)ListUtil.toList((Object[])new String[]{"\u8bf7\u68c0\u67e5\u662f\u5426\u6309\u89c4\u5b9a\u6b63\u786e\u586b\u5199\u6570\u636e"}));
            baseExcelDto.setImportStatus(Boolean.FALSE.booleanValue());
        }
        return baseExcelDto;
    }

    @Override
    public RestResponse<String> excelExport(ExcelUseTypeEnum excelUseTypeEnum, Object param) {
        IExportSevice exportSevice = this.getExportSevice(excelUseTypeEnum);
        String filePath = exportSevice.exportCustom(param);
        if (StrUtil.isNotBlank((CharSequence)filePath)) {
            return new RestResponse((Object)filePath);
        }
        ExportParams exportParams = exportSevice.exportParams();
        Workbook workbook = ExcelUtils.exportBigData(exportParams, exportSevice.pojoClass(), pageIndex -> exportSevice.exportDataList(param, pageIndex));
        filePath = this.ossHelper.upload(workbook, this.customerHelper.getUserId() + "/" + exportSevice.fileName());
        return new RestResponse((Object)filePath);
    }
}

