/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckDimensionVo;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckRepeatInfoVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdCustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemConditionEo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CheckRepeatHelper {
    private static final Logger log = LoggerFactory.getLogger(CheckRepeatHelper.class);
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private PriceItemConditionDas priceItemConditionDas;
    @Resource
    private CustomerConditionDas customerConditionDas;

    public List<String> checkDimension(CheckDimensionVo checkDimensionVo) {
        List<CheckRepeatInfoVo> checkRepeatInfoList = checkDimensionVo.getCheckRepeatInfoList();
        RelateTypeEnum relateTypeEnum = checkDimensionVo.getRelateTypeEnum();
        CustomerConditionEo customerCondition = checkDimensionVo.getCustomerCondition();
        Integer relationCustomerType = checkDimensionVo.getRelationCustomerType();
        PriceItemConditionEo itemCondition = checkDimensionVo.getItemCondition();
        Integer relationItemType = checkDimensionVo.getRelationItemType();
        List<String> itemRepeatCodeList = this.checkItemDimension(checkRepeatInfoList, relateTypeEnum, itemCondition, relationItemType);
        List<String> customerRepeatCodeList = this.checkCustomerDimension(checkDimensionVo.getCheckRepeatInfoList(), relateTypeEnum, customerCondition, relationCustomerType);
        if (CollUtil.isNotEmpty(itemRepeatCodeList) && CollUtil.isNotEmpty(customerRepeatCodeList)) {
            itemRepeatCodeList.retainAll(customerRepeatCodeList);
            if (CollUtil.isNotEmpty(itemRepeatCodeList)) {
                log.info("[\u91cd\u590d\u6821\u9a8c] >>> {}[{}]\u51fa\u73b0\u91cd\u590d\u4e86\uff0c\u91cd\u590d\u7684\u7f16\u7801{}", new Object[]{relateTypeEnum.getType(), checkDimensionVo.getCode(), itemRepeatCodeList});
                return itemRepeatCodeList;
            }
        }
        return ListUtil.empty();
    }

    public void checkDimension(CheckDimensionVo checkDimensionVo, PriceExceptionCode priceExceptionCode) {
        List<String> repeatCodeList = this.checkDimension(checkDimensionVo);
        if (CollUtil.isNotEmpty(repeatCodeList)) {
            String codeStr = repeatCodeList.stream().collect(Collectors.joining(","));
            BizExceptionHelper.throwBizException((IExceptionCode)priceExceptionCode.setParamValue(codeStr));
        }
    }

    private List<String> convertIdList(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return ListUtil.empty();
        }
        return ListUtil.toList((Object[])ids.split(","));
    }

    private List<String> checkItemDimension(List<CheckRepeatInfoVo> checkRepeatInfoList, RelateTypeEnum relateTypeEnum, PriceItemConditionEo itemCondition, Integer relationItemType) {
        List<String> itemTypeList;
        List<String> itemBackDirIdList;
        if (Objects.equals(String.valueOf(relationItemType), ItemDimensionEnum.ITEM_ALL_ENUM.getType())) {
            return checkRepeatInfoList.stream().map(CheckRepeatInfoVo::getCode).collect(Collectors.toList());
        }
        List idList = checkRepeatInfoList.stream().map(CheckRepeatInfoVo::getId).collect(Collectors.toList());
        PriceItemConditionEo priceItemCondition = new PriceItemConditionEo();
        priceItemCondition.setRelateType(relateTypeEnum.getType());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(priceItemCondition).in(StdPriceItemConditionEo::getRelateId, idList);
        List priceItemConditionList = this.priceItemConditionDas.getMapper().selectList((Wrapper)queryWrapper);
        Map<Long, String> codeMap = checkRepeatInfoList.stream().collect(Collectors.toMap(CheckRepeatInfoVo::getId, CheckRepeatInfoVo::getCode));
        ArrayList itemRepeatPriceCodeList = ListUtil.toList((Object[])new String[0]);
        if (Objects.equals(String.valueOf(relationItemType), ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType())) {
            List<String> skuIds = this.convertIdList(itemCondition.getSkuIds());
            this.testItem(priceItemConditionList, codeMap, itemRepeatPriceCodeList, skuIds, PriceUseTypeEnum.ITEM_SPECIFIED);
            return itemRepeatPriceCodeList;
        }
        List<String> itemBrandIdList = this.convertIdList(itemCondition.getItemBrandIds());
        if (CollUtil.isNotEmpty(itemBrandIdList)) {
            this.testItem(priceItemConditionList, codeMap, itemRepeatPriceCodeList, itemBrandIdList, PriceUseTypeEnum.ITEM_RANGE_BRAND);
            if (CollUtil.isNotEmpty((Collection)itemRepeatPriceCodeList)) {
                return itemRepeatPriceCodeList;
            }
        }
        if (CollUtil.isNotEmpty(itemBackDirIdList = this.convertIdList(itemCondition.getItemBackDirIdsExt()))) {
            this.testItem(priceItemConditionList, codeMap, itemRepeatPriceCodeList, itemBackDirIdList, PriceUseTypeEnum.ITEM_RANGE_DIR);
        }
        if (CollUtil.isNotEmpty(itemTypeList = this.convertIdList(itemCondition.getItemTypes()))) {
            this.testItem(priceItemConditionList, codeMap, itemRepeatPriceCodeList, itemTypeList, PriceUseTypeEnum.ITEM_RANGE_TYPE);
            if (CollUtil.isNotEmpty((Collection)itemRepeatPriceCodeList)) {
                return itemRepeatPriceCodeList;
            }
        }
        return itemRepeatPriceCodeList;
    }

    private void testItem(List<PriceItemConditionEo> priceItemConditionList, Map<Long, String> codeMap, List<String> itemRepeatPriceCodeList, List<String> ids, PriceUseTypeEnum type) {
        for (PriceItemConditionEo priceItemConditionEo : priceItemConditionList) {
            List<Object> testIdList = ListUtil.toList((Object[])new String[0]);
            switch (type) {
                case ITEM_SPECIFIED: {
                    testIdList = this.convertIdList(priceItemConditionEo.getSkuIds());
                    break;
                }
                case ITEM_RANGE_DIR: {
                    if (!StrUtil.isNotBlank((CharSequence)priceItemConditionEo.getItemBackDirIds())) break;
                    DirectoryReqDto directoryReqDto = new DirectoryReqDto();
                    directoryReqDto.setStatus(Integer.valueOf(1));
                    directoryReqDto.setIds(Arrays.stream(priceItemConditionEo.getItemBackDirIds().split(",")).map(Long::valueOf).collect(Collectors.toList()));
                    List dirIdList = (List)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto));
                    testIdList = CollUtil.isEmpty((Collection)dirIdList) ? ListUtil.empty() : dirIdList.stream().map(String::valueOf).collect(Collectors.toList());
                    break;
                }
                case ITEM_RANGE_TYPE: {
                    testIdList = this.convertIdList(priceItemConditionEo.getItemTypes());
                    break;
                }
                case ITEM_RANGE_BRAND: {
                    testIdList = this.convertIdList(priceItemConditionEo.getItemBrandIds());
                    break;
                }
            }
            testIdList.retainAll(ids);
            if (!CollUtil.isNotEmpty((Collection)testIdList)) continue;
            itemRepeatPriceCodeList.add(codeMap.get(priceItemConditionEo.getRelateId()));
        }
    }

    private void testCustomer(List<CustomerConditionEo> customerConditionList, Map<Long, String> codeMap, List<String> customerRepeatPriceCodeList, List<String> ids, PriceUseTypeEnum type) {
        for (CustomerConditionEo customerConditionEo : customerConditionList) {
            List<Object> testIdList = ListUtil.toList((Object[])new String[0]);
            switch (type) {
                case CUSTOMER_SPECIFIED: {
                    testIdList = this.convertIdList(customerConditionEo.getCustomerIds());
                    break;
                }
                case CUSTOMER_RANGE_TYPE: {
                    testIdList = this.convertIdList(customerConditionEo.getCustomerTypeIds());
                    break;
                }
                case CUSTOMER_RANGE_REGION: {
                    if (!StrUtil.isNotBlank((CharSequence)customerConditionEo.getCustomerAreaCodes())) break;
                    CustomerAreaListReqDto areaReqDto = new CustomerAreaListReqDto();
                    areaReqDto.setCodes(this.convertIdList(customerConditionEo.getCustomerAreaCodes()));
                    testIdList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(areaReqDto));
                    break;
                }
            }
            testIdList.retainAll(ids);
            if (!CollUtil.isNotEmpty((Collection)testIdList)) continue;
            customerRepeatPriceCodeList.add(codeMap.get(customerConditionEo.getRelateId()));
        }
    }

    private List<String> checkCustomerDimension(List<CheckRepeatInfoVo> checkRepeatInfoList, RelateTypeEnum relateTypeEnum, CustomerConditionEo customerCondition, Integer relationCustomerType) {
        List<String> customerAreaCodeList;
        if (Objects.equals(String.valueOf(relationCustomerType), CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType())) {
            return checkRepeatInfoList.stream().map(CheckRepeatInfoVo::getCode).collect(Collectors.toList());
        }
        List idList = checkRepeatInfoList.stream().map(CheckRepeatInfoVo::getId).collect(Collectors.toList());
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        customerConditionEo.setRelateType(relateTypeEnum.getType());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(customerConditionEo).in(StdCustomerConditionEo::getRelateId, idList);
        List customerConditionList = this.customerConditionDas.getMapper().selectList((Wrapper)queryWrapper);
        Map<Long, String> codeMap = checkRepeatInfoList.stream().collect(Collectors.toMap(CheckRepeatInfoVo::getId, CheckRepeatInfoVo::getCode));
        ArrayList customerRepeatPriceCodeList = ListUtil.toList((Object[])new String[0]);
        if (Objects.equals(String.valueOf(relationCustomerType), CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType())) {
            List<String> customerIds = this.convertIdList(customerCondition.getCustomerIds());
            this.testCustomer(customerConditionList, codeMap, customerRepeatPriceCodeList, customerIds, PriceUseTypeEnum.CUSTOMER_SPECIFIED);
            return customerRepeatPriceCodeList;
        }
        List<String> customerTypeIdList = this.convertIdList(customerCondition.getCustomerTypeIds());
        if (CollUtil.isNotEmpty(customerTypeIdList)) {
            this.testCustomer(customerConditionList, codeMap, customerRepeatPriceCodeList, customerTypeIdList, PriceUseTypeEnum.CUSTOMER_RANGE_TYPE);
            if (CollUtil.isNotEmpty((Collection)customerRepeatPriceCodeList)) {
                return customerRepeatPriceCodeList;
            }
        }
        if (CollUtil.isNotEmpty(customerAreaCodeList = this.convertIdList(customerCondition.getCustomerAreaCodeExt()))) {
            this.testCustomer(customerConditionList, codeMap, customerRepeatPriceCodeList, customerAreaCodeList, PriceUseTypeEnum.CUSTOMER_RANGE_REGION);
            if (CollUtil.isNotEmpty((Collection)customerRepeatPriceCodeList)) {
                return customerRepeatPriceCodeList;
            }
        }
        return customerRepeatPriceCodeList;
    }
}

