/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BrandOrgNameRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CustomerHelper {
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICacheService cacheService;

    public Long getUserId() {
        return this.context.userId();
    }

    public Long getOrgId() {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.getUserId()));
    }

    public List<Long> getCustomerIdList() {
        return (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(this.getUserId()));
    }

    public List<BrandOrgNameRespDto> getBrandOrgNameList() {
        List orgIdList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryUpstreamOrgIdsByUserId(this.getUserId()));
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", (Object)orgIdList));
        JSONObject filterJson = new JSONObject();
        filterJson.put("filters", (Object)filters);
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryBizOrganizationByPage(filterJson.toJSONString(), Integer.valueOf(1), Integer.valueOf(orgIdList.size())));
        List list = page.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return ListUtil.empty();
        }
        return list.stream().map(item -> {
            BrandOrgNameRespDto brandOrgNameRespDto = new BrandOrgNameRespDto();
            brandOrgNameRespDto.setOrgName(item.getName());
            brandOrgNameRespDto.setOrgId(item.getId());
            return brandOrgNameRespDto;
        }).collect(Collectors.toList());
    }

    public Map<Long, CustomerRespDto> getCustomerMap(List<Long> customerIdList) {
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(customerIdList));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return MapUtil.empty();
        }
        return customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (o1, o2) -> o2));
    }

    public List<CustomerRespDto> querySellerCustList(List<Long> itemOrgIds, Long sellerOrgId) {
        if (CollUtil.isEmpty(itemOrgIds)) {
            return null;
        }
        Collections.sort(itemOrgIds);
        String itemOrgIdStrs = StringUtils.join((Object[])itemOrgIds.toArray(), (String)"-");
        String cahceKey = "querysellerCustList_" + sellerOrgId + "_" + itemOrgIdStrs;
        List cacheValue = (List)this.cacheService.getCache(cahceKey, (TypeReference)new TypeReference<List<CustomerRespDto>>(){});
        if (null != cacheValue) {
            return cacheValue;
        }
        List sellerCustList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds(itemOrgIds, sellerOrgId));
        if (!CollUtil.isEmpty((Collection)sellerCustList)) {
            this.cacheService.add(cahceKey, (Object)sellerCustList, 600);
        }
        return sellerCustList;
    }
}

