/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.NumberUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckSkuPriceVo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PriceHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceHelper.class);
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;

    public void checkPriceLimit(Long id, Integer channel, List<CheckSkuPriceVo> skuDtoList) {
        if (!Objects.equals(channel, CustomerTypeEnum.DEALER.getCode()) || CollUtil.isEmpty(skuDtoList)) {
            return;
        }
        log.info("[\u4ef7\u683c\u9a8c\u8bc1] >>> \u76ee\u6807[{}]\u6821\u9a8c\u8bbe\u7f6e\u7684\u4ef7\u683c\u662f\u5426\u7b26\u5408\u4ef7\u76d8\u9650\u5236", (Object)id);
        Map<Long, BigDecimal> typePriceMap = skuDtoList.stream().collect(Collectors.toMap(CheckSkuPriceVo::getSkuId, CheckSkuPriceVo::getPriceLimit, (o1, o2) -> o2));
        HashMap skuMap = MapUtil.newHashMap();
        ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
        itemSkuPriceLimitQueryReqDto.setSkuIdList((List)ListUtil.toList(typePriceMap.keySet()));
        itemSkuPriceLimitQueryReqDto.setPriceLimitStatus(Boolean.TRUE.booleanValue());
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = this.basePriceApplyItemService.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
        Map skuPriceInfo = itemSkuPriceLimitRespDto.getSkuPriceInfo();
        StringBuilder error = new StringBuilder();
        typePriceMap.forEach((skuId, skuPrice) -> {
            ItemSkuPriceInfoRespDto skuPriceInfo1 = (ItemSkuPriceInfoRespDto)skuPriceInfo.get(skuId);
            if (Objects.isNull(skuPriceInfo1)) {
                return;
            }
            Integer controlType = skuPriceInfo1.getControlType();
            BigDecimal lowerLimitPrice = skuPriceInfo1.getLowerLimitPrice();
            BigDecimal upperLimitPrice = skuPriceInfo1.getUpperLimitPrice();
            boolean controlStatus = Objects.equals(PriceBasicConfigEnum.ControlType.CONTROL.getCode(), controlType);
            boolean limitStatus = NumberUtils.isInRange(skuPrice, lowerLimitPrice, upperLimitPrice);
            if (!limitStatus) {
                StringBuilder err = new StringBuilder().append("sku:[").append((String)skuMap.get(skuId)).append("]\u8bbe\u7f6e\u4ef7\u683c[").append(skuPrice).append("]\u4e0d\u7b26\u5408\u4ef7\u76d8\u533a\u95f4[").append(lowerLimitPrice).append(",").append(upperLimitPrice).append("]");
                if (controlStatus) {
                    error.append((CharSequence)err).append("\n");
                } else {
                    log.info("[\u4ef7\u683c\u9a8c\u8bc1] >>> {}", (Object)err);
                }
            }
        });
        if (StrUtil.isNotBlank((CharSequence)error.toString())) {
            log.info("[\u4ef7\u683c\u9a8c\u8bc1] >>> \u76ee\u6807[{}]\u4ef7\u76d8\u9650\u5236\u4e0d\u6b63\u786e\uff0c{}", (Object)id, (Object)error);
            BizExceptionHelper.throwBizException((String)"10000", (String)error.toString());
        }
    }

    public void setPriceLimit(List<Long> customerIdList, Map<String, List<PriceLimitPolicyEsDto>> priceLimitMap, Long skuId, ItemSkuPriceInfoRespDto skuPriceInfo) {
        if (MapUtil.isEmpty(priceLimitMap)) {
            return;
        }
        for (Long customerId : customerIdList) {
            PriceLimitPolicyEsDto priceLimitPolicyEsDto;
            String key = customerId + "-" + skuId;
            if (!priceLimitMap.containsKey(key) || Objects.isNull(priceLimitPolicyEsDto = this.findFirstPriceLimitPolicyEsDto(priceLimitMap.get(key)))) continue;
            skuPriceInfo.setUpperLimitPrice(priceLimitPolicyEsDto.getSkuUpperLimit(skuId));
            skuPriceInfo.setLowerLimitPrice(priceLimitPolicyEsDto.getSkuLowerLimit(skuId));
        }
    }

    public PriceLimitPolicyEsDto findFirstPriceLimitPolicyEsDto(List<PriceLimitPolicyEsDto> priceLimitPolicyEsDtos) {
        if (CollUtil.isEmpty(priceLimitPolicyEsDtos)) {
            return null;
        }
        return priceLimitPolicyEsDtos.stream().findFirst().orElse(null);
    }
}

