/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuRetailPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuRetailPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IExportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseExportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.ExcelExportStylerCustomImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.ExcelUtils;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.ItemSkuDealerRetailPriceExportVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DealerRetailPriceExportImpl
extends BaseExportImpl
implements IExportSevice<ItemSkuDealerRetailPriceExportVo, ItemSkuRetailPriceReqDto> {
    private static final Logger log = LoggerFactory.getLogger(DealerRetailPriceExportImpl.class);
    public static final Integer PAGE_SIZE = 500;
    @Resource
    private IBasePriceItemService basePriceItemService;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private CustomerHelper customerHelper;

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.EXPORT_DEALER_RETAIL_PRICE;
    }

    @Override
    public Class<ItemSkuDealerRetailPriceExportVo> pojoClass() {
        return ItemSkuDealerRetailPriceExportVo.class;
    }

    @Override
    public ExportParams exportParams() {
        return new ExportParams();
    }

    @Override
    public String fileName() {
        return "\u57fa\u7840\u4ef7\u5bfc\u51fa\u7ed3\u679c" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "." + "xlsx";
    }

    @Override
    public List<ItemSkuDealerRetailPriceExportVo> exportDataList(ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto, Integer pageNum) {
        PageInfo<ItemSkuRetailPriceRespDto> pageInfo = this.basePriceItemService.querySkuRetailPriceByPage(itemSkuRetailPriceReqDto, pageNum, PAGE_SIZE);
        List list = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return ListUtil.empty();
        }
        AtomicInteger serialNumber = new AtomicInteger((pageNum - 1) * PAGE_SIZE);
        return list.stream().map(item -> {
            ItemSkuDealerRetailPriceExportVo itemSkuRetailPriceExportVo = new ItemSkuDealerRetailPriceExportVo();
            itemSkuRetailPriceExportVo.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)item.getSubType()));
            itemSkuRetailPriceExportVo.setSerialNumber(serialNumber.incrementAndGet());
            itemSkuRetailPriceExportVo.setItemName(item.getItemName());
            itemSkuRetailPriceExportVo.setItemOrgName(item.getItemOrgName());
            itemSkuRetailPriceExportVo.setBrandName(item.getBrandName());
            itemSkuRetailPriceExportVo.setItemCode(item.getItemCode());
            itemSkuRetailPriceExportVo.setSkuCode(item.getSkuCode());
            ShelfStatusEnum shelfStatusEnum = ShelfStatusEnum.getByCode((int)item.getShelfStatus());
            if (shelfStatusEnum != null) {
                itemSkuRetailPriceExportVo.setShelfStatusName(shelfStatusEnum.getName());
            }
            if (StrUtil.isNotBlank((CharSequence)item.getSkuAttr())) {
                Map map = (Map)JSON.parseObject((String)item.getSkuAttr(), Map.class);
                String skuAttr = map.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";"));
                itemSkuRetailPriceExportVo.setSkuAttr(skuAttr);
            }
            itemSkuRetailPriceExportVo.setDirName(item.getDirName());
            itemSkuRetailPriceExportVo.setGiftBox(item.getGiftBox());
            ItemSkuPriceInfoRespDto itemSkuPriceInfo = item.getItemSkuPriceInfo();
            if (Objects.nonNull(itemSkuPriceInfo)) {
                itemSkuRetailPriceExportVo.setRetailPrice(itemSkuPriceInfo.getRetailPrice());
                itemSkuRetailPriceExportVo.setExchangePrice(itemSkuPriceInfo.getExchangePrice());
                BigDecimal lowerLimitPrice = itemSkuPriceInfo.getLowerLimitPrice();
                BigDecimal upperLimitPrice = itemSkuPriceInfo.getUpperLimitPrice();
                String limitPriceStr = (Objects.nonNull(lowerLimitPrice) ? String.valueOf(lowerLimitPrice) : "") + "-";
                if (Objects.nonNull(upperLimitPrice)) {
                    limitPriceStr = limitPriceStr + String.valueOf(upperLimitPrice);
                }
                itemSkuRetailPriceExportVo.setLimitPriceStr(limitPriceStr);
                itemSkuRetailPriceExportVo.setDealerRetailPrice(itemSkuPriceInfo.getDealerRetailPrice());
            }
            return itemSkuRetailPriceExportVo;
        }).collect(Collectors.toList());
    }

    @Override
    public String exportCustom(ItemSkuRetailPriceReqDto param) {
        List<Object> shopIdList = ListUtil.toList((Object[])new Long[0]);
        Long limitShopId = param.getShopId();
        if (Objects.isNull(limitShopId)) {
            shopIdList = this.shopHelper.getShopIdListByOrgIdList(ListUtil.toList((Object[])new Long[]{this.customerHelper.getOrgId()}));
        } else {
            shopIdList.add(limitShopId);
        }
        Map<Long, String> shopNameMap = this.shopHelper.getShopNameMap(shopIdList);
        Workbook workbook = null;
        for (Long shopId : shopIdList) {
            param.setShopId(shopId);
            log.info("[\u6570\u636e\u5bfc\u51fa] >>> [{}]\u5206\u9875\u5bfc\u51fa\uff0c\u9002\u7528\u4e8e\u5927\u6570\u636e\u91cf", (Object)PAGE_SIZE);
            ExportParams exportParams = this.exportParams();
            exportParams.setSheetName(shopNameMap.getOrDefault(shopId, String.valueOf(shopId)));
            exportParams.setTitleHeight((short)30);
            exportParams.setStyle(ExcelExportStylerCustomImpl.class);
            exportParams.setType(ExcelType.XSSF);
            workbook = ExcelUtils.exportBigData(exportParams, this.pojoClass(), startPageNum -> this.exportDataList(param, (Integer)startPageNum));
        }
        return this.upload(workbook, String.valueOf(this.customerHelper.getUserId()), this.fileName());
    }
}

