/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditHandler;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditInfo;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.AuditDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdAuditEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditServiceImpl
implements IAuditService {
    private static final Logger logger = LoggerFactory.getLogger(AuditServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private AuditDas auditDas;
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private AuditHandler auditHandler;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAudit(AuditAddReqDto reqDto) {
        AuditResultEnum auditResultEnum;
        if (Objects.isNull(reqDto)) {
            return null;
        }
        AuditEo auditEo = new AuditEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)auditEo);
        auditEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(auditEo.getInstanceId())) {
            auditEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(auditEo.getTenantId())) {
            auditEo.setTenantId(this.context.tenantId());
        }
        auditEo.setAuditTime(new Date());
        if (StrUtil.isBlank((CharSequence)auditEo.getAuditPerson())) {
            auditEo.setAuditPerson(Objects.isNull(this.context.userName()) ? "\u672a\u77e5" : this.context.userName());
        }
        auditEo.setAuditStatus(Objects.equals(auditResultEnum = AuditResultEnum.fromCode((String)reqDto.getAuditResult()), AuditResultEnum.PASS) ? PriceStatusEnum.AUDIT_PASS.getCode() : PriceStatusEnum.AUDIT_REJECT.getCode());
        this.auditDas.insert((BaseEo)auditEo);
        AuditInfo auditInfo = this.auditHandler.modifyStatus(auditEo, auditResultEnum);
        this.auditHandler.changeStatus(auditEo, auditInfo);
        return auditEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchAudit(List<AuditAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList auditEoList = ListUtil.toList((Object[])new AuditEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)auditEoList, AuditEo.class);
        if (CollUtil.isEmpty((Collection)auditEoList)) {
            return ListUtil.empty();
        }
        for (AuditEo auditEo : auditEoList) {
            auditEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(auditEo.getInstanceId())) {
                auditEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(auditEo.getTenantId())) continue;
            auditEo.setTenantId(this.context.tenantId());
        }
        this.auditDas.insertBatch((List)auditEoList);
        return auditEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAudit(AuditModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        AuditEo auditEo = (AuditEo)this.auditDas.selectByPrimaryKey(id);
        if (Objects.isNull(auditEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)auditEo);
        this.auditDas.update((BaseEo)auditEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAuditById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        AuditEo auditEo = (AuditEo)this.auditDas.selectByPrimaryKey(id);
        if (Objects.isNull(auditEo)) {
            return;
        }
        this.auditDas.logicDeleteById(auditEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAuditByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.auditDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<AuditRespDto> queryByPage(AuditQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<AuditEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.auditDas, queryWrapper, AuditRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<AuditEo> getQueryWrapper(AuditQueryReqDto reqDto) {
        AuditEo auditEo = new AuditEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)auditEo);
        auditEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)auditEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateIdList())) {
            queryWrapper.in(StdAuditEo::getRelateId, (Collection)reqDto.getRelateIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateTypeList())) {
            queryWrapper.in(StdAuditEo::getRelateType, (Collection)reqDto.getRelateTypeList());
        }
        return queryWrapper;
    }

    @Override
    public List<AuditRespDto> queryByList(AuditQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return ListUtil.empty();
        }
        return this.auditDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (AuditRespDto)item.toDto(AuditRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public AuditRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        AuditEo auditEo = (AuditEo)this.auditDas.selectByPrimaryKey(id);
        if (Objects.isNull(auditEo)) {
            return null;
        }
        return (AuditRespDto)auditEo.toDto(AuditRespDto.class);
    }

    @Override
    public List<AuditRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return ListUtil.empty();
        }
        AuditEo auditEo = new AuditEo();
        auditEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)auditEo).in(BaseEo::getId, idList);
        List auditEoList = this.auditDas.getMapper().selectList((Wrapper)queryWrapper);
        return auditEoList.stream().map(item -> (AuditRespDto)item.toDto(AuditRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public AuditRespDto getAuditLastOne(RelateTypeEnum relateTypeEnum, Long relateId) {
        AuditEo auditEo = new AuditEo();
        auditEo.setRelateId(relateId);
        auditEo.setRelateType(relateTypeEnum.getType());
        List auditEos = this.auditDas.selectList((BaseEo)auditEo);
        if (CollUtil.isEmpty((Collection)auditEos)) {
            return null;
        }
        return (AuditRespDto)((AuditEo)auditEos.get(0)).toDto(AuditRespDto.class);
    }

    @Override
    public Map<Long, AuditRespDto> getAuditLastOneMap(RelateTypeEnum basePriceApply, List<Long> idLst) {
        List list = this.auditDas.getAuditLastOneList(basePriceApply.getType(), idLst);
        return list.stream().collect(Collectors.toMap(AuditRespDto::getRelateId, Function.identity(), (o1, o2) -> o2));
    }
}

