/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuOptionalQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceApplyItemExtRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceApplyItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuOptionalQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.PriceHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPriceVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BasePriceApplyItemServiceImpl
implements IBasePriceApplyItemService {
    private static final Logger logger = LoggerFactory.getLogger(BasePriceApplyItemServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private BasePriceApplyItemDas basePriceApplyItemDas;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private PriceHelper priceHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBasePriceApplyItem(BasePriceApplyItemAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        BasePriceApplyItemEo basePriceApplyItemEo = new BasePriceApplyItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyItemEo);
        basePriceApplyItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(basePriceApplyItemEo.getInstanceId())) {
            basePriceApplyItemEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(basePriceApplyItemEo.getTenantId())) {
            basePriceApplyItemEo.setTenantId(this.context.tenantId());
        }
        this.basePriceApplyItemDas.insert((BaseEo)basePriceApplyItemEo);
        return basePriceApplyItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchBasePriceApplyItem(List<BasePriceApplyItemAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList basePriceApplyItemEoList = ListUtil.toList((Object[])new BasePriceApplyItemEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)basePriceApplyItemEoList, BasePriceApplyItemEo.class);
        if (CollUtil.isEmpty((Collection)basePriceApplyItemEoList)) {
            return ListUtil.empty();
        }
        for (BasePriceApplyItemEo basePriceApplyItemEo : basePriceApplyItemEoList) {
            basePriceApplyItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(basePriceApplyItemEo.getInstanceId())) {
                basePriceApplyItemEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(basePriceApplyItemEo.getTenantId())) continue;
            basePriceApplyItemEo.setTenantId(this.context.tenantId());
        }
        this.basePriceApplyItemDas.insertBatch((List)basePriceApplyItemEoList);
        return basePriceApplyItemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBasePriceApplyItem(BasePriceApplyItemModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceApplyItemEo basePriceApplyItemEo = (BasePriceApplyItemEo)this.basePriceApplyItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceApplyItemEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyItemEo);
        this.basePriceApplyItemDas.update((BaseEo)basePriceApplyItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceApplyItemById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceApplyItemEo basePriceApplyItemEo = (BasePriceApplyItemEo)this.basePriceApplyItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceApplyItemEo)) {
            return;
        }
        this.basePriceApplyItemDas.logicDeleteById(basePriceApplyItemEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceApplyItemByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.basePriceApplyItemDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<BasePriceApplyItemRespDto> queryByPage(BasePriceApplyItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<BasePriceApplyItemEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.basePriceApplyItemDas, queryWrapper, BasePriceApplyItemRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<BasePriceApplyItemEo> getQueryWrapper(BasePriceApplyItemQueryReqDto reqDto) {
        BasePriceApplyItemEo basePriceApplyItemEo = new BasePriceApplyItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyItemEo);
        basePriceApplyItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)basePriceApplyItemEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemOrgIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getItemOrgId, (Collection)reqDto.getItemOrgIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getSkuCode, (Collection)reqDto.getSkuCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getTypeIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getTypeId, (Collection)reqDto.getTypeIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getApplyIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getApplyId, (Collection)reqDto.getApplyIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getItemId, (Collection)reqDto.getItemIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSkuIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getSkuId, (Collection)reqDto.getSkuIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSubTypeList())) {
            queryWrapper.in(StdBasePriceApplyItemEo::getSubType, (Collection)reqDto.getSubTypeList());
        }
        return queryWrapper;
    }

    @Override
    public List<BasePriceApplyItemRespDto> queryByList(BasePriceApplyItemQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return ListUtil.empty();
        }
        return this.basePriceApplyItemDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (BasePriceApplyItemRespDto)item.toDto(BasePriceApplyItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public BasePriceApplyItemRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        BasePriceApplyItemEo basePriceApplyItemEo = (BasePriceApplyItemEo)this.basePriceApplyItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceApplyItemEo)) {
            return null;
        }
        return (BasePriceApplyItemRespDto)basePriceApplyItemEo.toDto(BasePriceApplyItemRespDto.class);
    }

    @Override
    public List<BasePriceApplyItemRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return ListUtil.empty();
        }
        BasePriceApplyItemEo basePriceApplyItemEo = new BasePriceApplyItemEo();
        basePriceApplyItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)basePriceApplyItemEo).in(BaseEo::getId, idList);
        List basePriceApplyItemEoList = this.basePriceApplyItemDas.getMapper().selectList((Wrapper)queryWrapper);
        return basePriceApplyItemEoList.stream().map(item -> (BasePriceApplyItemRespDto)item.toDto(BasePriceApplyItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceApplyItemByApplyId(Long applyId) {
        LambdaUpdateWrapper applyItemUpdateWrapper = Wrappers.lambdaUpdate(BasePriceApplyItemEo.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)applyItemUpdateWrapper.eq(StdBasePriceApplyItemEo::getApplyId, (Object)applyId)).eq(BaseEo::getDr, (Object)PriceCommonEnum.Dr.VALID.getCode())).set(BaseEo::getDr, (Object)PriceCommonEnum.Dr.DELETED.getCode());
        this.basePriceApplyItemDas.getMapper().updateAll(null, (Wrapper)applyItemUpdateWrapper);
    }

    @Override
    public PageInfo<BasePriceApplyItemExtRespDto> queryItemByPage(Long applyId, Integer channel, Integer pageNum, Integer pageSize) {
        BasePriceApplyEo basePriceApplyEo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.basePriceApplyItemDas.queryItemByPage(applyId);
        if (CollUtil.isEmpty((Collection)list)) {
            return new PageInfo(list);
        }
        List<Long> skuIdList = list.stream().map(BasePriceApplyItemRespDto::getSkuId).collect(Collectors.toList());
        Map<Long, ItemSkuQueryRespDto> skuMap = this.skuHelper.querySkuMap(skuIdList);
        for (BasePriceApplyItemExtRespDto itemInfo : list) {
            Long skuId = itemInfo.getSkuId();
            if (!skuMap.containsKey(skuId)) {
                logger.info("[\u7533\u8bf7\u5355\u660e\u7ec6] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0skuId[{}]\u65e0\u6548\u60c5\u51b5", (Object)applyId, (Object)skuId);
                continue;
            }
            ItemSkuQueryRespDto itemSkuQueryRespDto = skuMap.get(skuId);
            itemInfo.setItemId(itemSkuQueryRespDto.getItemId());
            itemInfo.setItemBrand(itemSkuQueryRespDto.getBrandName());
            itemInfo.setItemCode(itemSkuQueryRespDto.getItemCode());
            itemInfo.setApplyId(applyId);
            itemInfo.setGiftBox(itemSkuQueryRespDto.getGiftBox());
            itemInfo.setItemName(itemSkuQueryRespDto.getItemName());
            itemInfo.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
            itemInfo.setItemOrgId(itemSkuQueryRespDto.getItemOrgId());
            itemInfo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
            itemInfo.setSkuSpec(itemSkuQueryRespDto.getSkuAttr());
            itemInfo.setSubType(itemSkuQueryRespDto.getSubType());
            itemInfo.setUnitName(itemSkuQueryRespDto.getUnitName());
        }
        if (Objects.equals(channel, CustomerTypeEnum.DEALER.getCode()) && Objects.nonNull(basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(applyId)) && Objects.nonNull(basePriceApplyEo.getShopId())) {
            Long shopId = basePriceApplyEo.getShopId();
            ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
            itemSkuPriceLimitQueryReqDto.setShopId(shopId);
            itemSkuPriceLimitQueryReqDto.setPriceLimitStatus(Boolean.FALSE.booleanValue());
            itemSkuPriceLimitQueryReqDto.setSkuIdList(skuIdList);
            ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = this.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
            for (BasePriceApplyItemExtRespDto applyItemExtRespDto : list) {
                ItemSkuPriceInfoRespDto itemSkuPriceInfoRespDto = (ItemSkuPriceInfoRespDto)itemSkuPriceLimitRespDto.getSkuPriceInfo().get(applyItemExtRespDto.getSkuId());
                applyItemExtRespDto.setItemSkuPriceInfo(itemSkuPriceInfoRespDto);
            }
        }
        return new PageInfo(list);
    }

    @Override
    public PageInfo<ItemSkuOptionalQueryRespDto> queryOptionalItemByPage(ItemSkuOptionalQueryReqDto itemSkuOptionalQueryReqDto, Integer pageNum, Integer pageSize) {
        Long userOrgInfoId = Objects.nonNull(itemSkuOptionalQueryReqDto.getOrgId()) ? itemSkuOptionalQueryReqDto.getOrgId() : this.customerHelper.getOrgId();
        Integer channel = itemSkuOptionalQueryReqDto.getChannel();
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        DtoHelper.vo2Dto((BaseVo)itemSkuOptionalQueryReqDto, (BaseVo)itemSkuQueryReqDto);
        if (Objects.equals(channel, CustomerTypeEnum.DEALER.getCode())) {
            List<Long> shopIdList = this.shopHelper.getShopIdListByOrgIdList(ListUtil.toList((Object[])new Long[]{userOrgInfoId}));
            if (CollUtil.isEmpty(shopIdList)) {
                return new PageInfo(ListUtil.empty());
            }
            Long shopId = itemSkuOptionalQueryReqDto.getShopId();
            if (Objects.nonNull(shopId)) {
                shopIdList.retainAll(ListUtil.toList((Object[])new Long[]{shopId}));
            }
            if (CollUtil.isEmpty(shopIdList)) {
                return new PageInfo(ListUtil.empty());
            }
            itemSkuQueryReqDto.setShopIdList(shopIdList);
        } else {
            itemSkuQueryReqDto.setItemOrgId(userOrgInfoId);
        }
        RestResponse pageInfo = this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, pageNum, pageSize);
        PageInfo page = (PageInfo)pageInfo.getData();
        PageInfo resultPage = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPage, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)page.getList(), ItemSkuOptionalQueryRespDto.class);
        resultPage.setList((List)resultList);
        return resultPage;
    }

    @Override
    public ItemSkuPriceLimitRespDto queryItemPriceList(ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto) {
        List<Long> ppfOrgIdList;
        Long shopId = itemSkuPriceLimitQueryReqDto.getShopId();
        HashMap skuPriceInfoMap = MapUtil.newHashMap();
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = new ItemSkuPriceLimitRespDto();
        List skuIdList = itemSkuPriceLimitQueryReqDto.getSkuIdList();
        List<Object> customerIdList = Objects.isNull(shopId) ? ListUtil.toList((Object[])new Long[0]) : this.customerHelper.getCustomerIdList();
        Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMap(skuIdList);
        if (CollUtil.isEmpty(skuQueryRespDtoMap)) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        if (CollUtil.isEmpty(ppfOrgIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getItemOrgId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            for (Long skuId2 : skuIdList) {
                skuPriceInfoMap.put(skuId2, new ItemSkuPriceInfoRespDto());
            }
            itemSkuPriceLimitRespDto.setSkuPriceInfo((Map)skuPriceInfoMap);
            return itemSkuPriceLimitRespDto;
        }
        List<PriceBasicConfigRespDto> configList = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(ppfOrgIdList, PriceBasicConfigEnum.ConfigType.PRICE_SETTING);
        Map orgConfigMap = configList.stream().collect(Collectors.toMap(PriceBasicConfigRespDto::getOrganizationId, Function.identity(), (o1, o2) -> o2));
        SkuPriceVo skuPriceVo = itemSkuPriceLimitQueryReqDto.isPriceLimitStatus() ? null : this.skuHelper.getSkuPriceInfo(ppfOrgIdList, null, skuIdList, new Long[0]);
        SkuPriceVo dbSkuPriceVo = null;
        if (Objects.nonNull(shopId)) {
            dbSkuPriceVo = itemSkuPriceLimitQueryReqDto.isPriceLimitStatus() ? null : this.skuHelper.getSkuPriceInfo(ListUtil.toList((Object[])new Long[]{this.customerHelper.getOrgId()}), ListUtil.toList((Object[])new Long[]{shopId}), skuIdList, new Long[0]);
        }
        Map<Object, Object> priceLimitMap = MapUtil.newHashMap();
        if (CollUtil.isNotEmpty((Collection)customerIdList)) {
            PriceLimitEsQueryReqDto priceLimitEsQueryReqDto = new PriceLimitEsQueryReqDto();
            priceLimitEsQueryReqDto.setQueryBestMatch(Integer.valueOf(1));
            priceLimitEsQueryReqDto.setCustomerIdList((List)customerIdList);
            priceLimitEsQueryReqDto.setSkuIdList(skuIdList);
            priceLimitEsQueryReqDto.setOrganizationIdList(ppfOrgIdList);
            logger.info("[\u4ef7\u76d8\u67e5\u8be2] >>> \u5ba2\u6237{}\u5728\u54c1\u724c\u65b9{}\u4e0b\u67e5\u8be2\u9488\u5bf9sku:{}\u67e5\u8be2\u751f\u6548\u7684\u6700\u5339\u914d\u7684\u4ef7\u76d8", new Object[]{customerIdList, ppfOrgIdList, skuIdList});
            priceLimitMap = this.priceLimitPolicyEsService.queryPriceLimitPolicy(priceLimitEsQueryReqDto);
            String priceLimitStr = JSON.toJsonString((Object)priceLimitMap);
            logger.info("[\u4ef7\u76d8\u67e5\u8be2] >>> \u67e5\u8be2\u7ed3\u679c\u5982\u4e0b\uff1a{}", (Object)priceLimitStr);
        }
        SkuPriceVo finalDbSkuPriceVo = dbSkuPriceVo;
        HashMap finalPriceLimitMap = priceLimitMap;
        skuQueryRespDtoMap.forEach((skuId, itemInfo) -> {
            ItemSkuPriceInfoRespDto skuPriceInfo = new ItemSkuPriceInfoRespDto();
            Long itemOrgId = itemInfo.getItemOrgId();
            if (orgConfigMap.containsKey(itemOrgId)) {
                skuPriceInfo.setControlType(((PriceBasicConfigRespDto)orgConfigMap.get(itemOrgId)).getControlType());
            }
            this.setPrice(itemSkuPriceLimitQueryReqDto, shopId, skuPriceVo, finalDbSkuPriceVo, (Long)skuId, skuPriceInfo);
            if (CollUtil.isNotEmpty((Map)finalPriceLimitMap)) {
                this.priceHelper.setPriceLimit((List<Long>)customerIdList, finalPriceLimitMap, (Long)skuId, skuPriceInfo);
            }
            skuPriceInfoMap.put(skuId, skuPriceInfo);
        });
        itemSkuPriceLimitRespDto.setSkuPriceInfo((Map)skuPriceInfoMap);
        return itemSkuPriceLimitRespDto;
    }

    private void setPrice(ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto, Long shopId, SkuPriceVo skuPriceVo, SkuPriceVo finalDbSkuPriceVo, Long skuId, ItemSkuPriceInfoRespDto skuPriceInfo) {
        Map<Long, BigDecimal> dbSkuPrice;
        Map<Long, BigDecimal> skuPrice;
        if (itemSkuPriceLimitQueryReqDto.isPriceLimitStatus()) {
            return;
        }
        if (Objects.nonNull(skuPriceVo) && MapUtil.isNotEmpty(skuPrice = skuPriceVo.findSkuPrice(null, skuId))) {
            skuPriceInfo.setExchangePrice(skuPrice.get(PriceTypeEnum.EXCHANGE_PRICE.getTypeId()));
            skuPriceInfo.setRetailPrice(skuPrice.get(PriceTypeEnum.RETAIL_PRICE.getTypeId()));
        }
        if (Objects.nonNull(finalDbSkuPriceVo) && MapUtil.isNotEmpty(dbSkuPrice = finalDbSkuPriceVo.findSkuPrice(shopId, skuId))) {
            skuPriceInfo.setDealerRetailPrice(dbSkuPrice.get(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId()));
        }
    }
}

