/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SyncStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BasePriceApplySkuInfo;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AttachementRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceApplyCountRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceApplyItemExtRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceApplyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceTypeInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.PriceHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAttachementService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceTypeService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckSkuPriceVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.StatusCountVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BasePriceApplyServiceImpl
implements IBasePriceApplyService {
    private static final Logger logger = LoggerFactory.getLogger(BasePriceApplyServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private GenerateCode<BasePriceApplyEo> generateCode;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;
    @Resource
    private IPriceTypeService priceTypeService;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private IAttachementService attachementService;
    @Resource
    private IAuditService auditService;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private PriceHelper priceHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBasePriceApply(BasePriceApplyAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        BasePriceApplyEo basePriceApplyEo = new BasePriceApplyEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyEo);
        if (Objects.isNull(basePriceApplyEo.getOrganizationId())) {
            Long orgId = this.customerHelper.getOrgId();
            basePriceApplyEo.setOrganizationId(orgId);
        }
        this.checkPriceApplyNameUnique(basePriceApplyEo);
        List<BasePriceApplyItemAddReqDto> skuDtoList = this.convertApplyItemDto(reqDto.getSkuList(), basePriceApplyEo, reqDto.getChannel());
        List<AttachementAddReqDto> attachementDtoList = this.attachementService.convertAttachementDto(reqDto.getAttachementList(), basePriceApplyEo.getTenantId(), basePriceApplyEo.getInstanceId());
        basePriceApplyEo.setSyncStatus(SyncStatusEnum.NOT_SYNC.getCode());
        basePriceApplyEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        basePriceApplyEo.setApplyCode(this.generateCode.createCode(GeneralRuleTypeEnum.TJSQ));
        if (Objects.isNull(basePriceApplyEo.getInstanceId())) {
            basePriceApplyEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(basePriceApplyEo.getTenantId())) {
            basePriceApplyEo.setTenantId(this.context.tenantId());
        }
        this.basePriceApplyDas.insert((BaseEo)basePriceApplyEo);
        Long applyId = basePriceApplyEo.getId();
        skuDtoList.forEach(info -> info.setApplyId(applyId));
        this.basePriceApplyItemService.batchBasePriceApplyItem(skuDtoList);
        if (CollUtil.isNotEmpty(attachementDtoList)) {
            attachementDtoList.forEach(info -> info.setBusinessId(applyId));
            this.attachementService.batchAttachement(attachementDtoList);
        }
        return applyId;
    }

    private void checkPriceApplyNameUnique(BasePriceApplyEo basePriceApplyEo) {
        String status = basePriceApplyEo.getStatus();
        if (!Objects.equals(status, PriceStatusEnum.WAIT_AUDIT.getCode())) {
            return;
        }
        BasePriceApplyEo basePriceApply = this.basePriceApplyDas.checkPriceApplyNameUnique(basePriceApplyEo.getOrganizationId(), basePriceApplyEo.getId(), basePriceApplyEo.getApplyName(), Boolean.TRUE.booleanValue());
        AssertUtils.isNull(basePriceApply, PriceExceptionCode.APPLICATION_FORM_NAME_ALREADY_EXISTS);
    }

    private List<BasePriceApplyItemAddReqDto> convertApplyItemDto(List<BasePriceApplySkuInfo> skuList, BasePriceApplyEo basePriceApplyEo, Integer channel) {
        Long orgId = basePriceApplyEo.getOrganizationId();
        List<PriceTypeInfoRespDto> priceTypeInfoRespDtos = this.priceTypeService.queryPriceTypeByCategoryCodeAndPriceCode(CategoryCodeEnum.BASE.getCode(), ListUtil.toList((Object[])new PriceTypeEnum[]{PriceTypeEnum.RETAIL_PRICE, PriceTypeEnum.EXCHANGE_PRICE, PriceTypeEnum.DEALER_RETAIL_PRICE}));
        if (CollUtil.isEmpty(priceTypeInfoRespDtos)) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.MISSING_PRICE_TYPE_INITIALIZATION);
        }
        Map priceTypeMap = priceTypeInfoRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (o1, o2) -> o2));
        List<Long> skuIdList = skuList.stream().map(BasePriceApplySkuInfo::getSkuId).collect(Collectors.toList());
        if (CollUtil.isEmpty(skuIdList)) {
            logger.info("[\u8c03\u4ef7\u7533\u8bf7] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0\u65e0\u6548\u7684\u9002\u7528\u5546\u54c1\u6570\u636e1[{}]", (Object)basePriceApplyEo.getApplyName(), skuList);
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        basePriceApplyEo.setSkuNum(Integer.valueOf(skuIdList.size()));
        Map<Long, ItemSkuQueryRespDto> skuMap = this.skuHelper.querySkuMap(skuIdList);
        if (CollUtil.isEmpty(skuMap)) {
            String skuStr = JSON.toJsonString(skuList);
            logger.info("[\u8c03\u4ef7\u7533\u8bf7] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0\u65e0\u6548\u7684\u9002\u7528\u5546\u54c1\u6570\u636e2[{}]", (Object)basePriceApplyEo.getApplyName(), (Object)skuStr);
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        ArrayList skuDtoList = ListUtil.toList((Object[])new BasePriceApplyItemAddReqDto[0]);
        for (BasePriceApplySkuInfo skuInfo : skuList) {
            Long skuId = skuInfo.getSkuId();
            if (!skuMap.containsKey(skuId)) {
                String skuStr = JSON.toJsonString(skuList);
                logger.info("[\u8c03\u4ef7\u7533\u8bf7] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0\u65e0\u6548\u7684\u9002\u7528\u5546\u54c1\u6570\u636eskuId:{}[{}]", new Object[]{basePriceApplyEo.getApplyName(), skuId, skuStr});
                BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
            }
            ItemSkuQueryRespDto itemSkuQueryRespDto = skuMap.get(skuId);
            Map skuPrice = skuInfo.getSkuPrice();
            if (CollUtil.isEmpty((Map)skuPrice)) {
                BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_PRICE_SETTING);
            }
            skuPrice.forEach((key, value) -> {
                if (Objects.isNull(key) || !priceTypeMap.containsKey(key)) {
                    logger.info("[\u8c03\u4ef7\u7533\u8bf7] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0\u65e0\u6548\u7684\u4ef7\u683c\u7c7b\u578bid:{}", (Object)basePriceApplyEo.getApplyName(), key);
                    BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_PRICE_TYPE);
                }
                BasePriceApplyItemAddReqDto basePriceApplyItemAddReqDto = new BasePriceApplyItemAddReqDto();
                basePriceApplyItemAddReqDto.setOrganizationId(orgId);
                basePriceApplyItemAddReqDto.setTypeId(key);
                basePriceApplyItemAddReqDto.setItemPrice(value);
                basePriceApplyItemAddReqDto.setItemId(itemSkuQueryRespDto.getItemId());
                basePriceApplyItemAddReqDto.setItemBrand(itemSkuQueryRespDto.getBrandName());
                basePriceApplyItemAddReqDto.setGiftBox(itemSkuQueryRespDto.getGiftBox());
                basePriceApplyItemAddReqDto.setItemCode(itemSkuQueryRespDto.getItemCode());
                basePriceApplyItemAddReqDto.setItemName(itemSkuQueryRespDto.getItemName());
                basePriceApplyItemAddReqDto.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
                basePriceApplyItemAddReqDto.setItemOrgId(itemSkuQueryRespDto.getItemOrgId());
                basePriceApplyItemAddReqDto.setSkuSpec(itemSkuQueryRespDto.getSkuAttr());
                basePriceApplyItemAddReqDto.setSubType(itemSkuQueryRespDto.getSubType());
                basePriceApplyItemAddReqDto.setUnitName(itemSkuQueryRespDto.getUnitName());
                basePriceApplyItemAddReqDto.setInstanceId(basePriceApplyEo.getInstanceId());
                basePriceApplyItemAddReqDto.setTenantId(basePriceApplyEo.getTenantId());
                basePriceApplyItemAddReqDto.setSkuId(skuId);
                basePriceApplyItemAddReqDto.setSkuCode(itemSkuQueryRespDto.getSkuCode());
                basePriceApplyItemAddReqDto.setItemPic(itemSkuQueryRespDto.getItemPic());
                skuDtoList.add(basePriceApplyItemAddReqDto);
            });
        }
        if (CollUtil.isEmpty((Collection)skuDtoList)) {
            String skuStr = JSON.toJsonString(skuList);
            logger.info("[\u8c03\u4ef7\u7533\u8bf7] >>> \u7533\u8bf7\u5355[{}]\u51fa\u73b0\u65e0\u6548\u7684\u9002\u7528\u5546\u54c1\u6570\u636e3[{}]", (Object)basePriceApplyEo.getApplyName(), (Object)skuStr);
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        List<CheckSkuPriceVo> checkSkuDtoList = skuDtoList.stream().map(sku -> {
            CheckSkuPriceVo skuPriceVo = new CheckSkuPriceVo();
            skuPriceVo.setPriceLimit(sku.getItemPrice());
            skuPriceVo.setSkuId(sku.getSkuId());
            return skuPriceVo;
        }).collect(Collectors.toList());
        this.priceHelper.checkPriceLimit(null, channel, checkSkuDtoList);
        return skuDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchBasePriceApply(List<BasePriceApplyAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList basePriceApplyEoList = ListUtil.toList((Object[])new BasePriceApplyEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)basePriceApplyEoList, BasePriceApplyEo.class);
        if (CollUtil.isEmpty((Collection)basePriceApplyEoList)) {
            return ListUtil.empty();
        }
        for (BasePriceApplyEo basePriceApplyEo : basePriceApplyEoList) {
            basePriceApplyEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(basePriceApplyEo.getInstanceId())) {
                basePriceApplyEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(basePriceApplyEo.getTenantId())) continue;
            basePriceApplyEo.setTenantId(this.context.tenantId());
        }
        this.basePriceApplyDas.insertBatch((List)basePriceApplyEoList);
        return basePriceApplyEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBasePriceApply(BasePriceApplyModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceApplyEo basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceApplyEo)) {
            return;
        }
        String originalStatus = basePriceApplyEo.getStatus();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyEo);
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)originalStatus), id, PriceStatusEnum.DRAFT, PriceStatusEnum.AUDIT_REJECT);
        this.checkPriceApplyNameUnique(basePriceApplyEo);
        List<BasePriceApplyItemAddReqDto> skuDtoList = this.convertApplyItemDto(reqDto.getSkuList(), basePriceApplyEo, reqDto.getChannel());
        List<AttachementAddReqDto> attachementDtoList = this.attachementService.convertAttachementDto(reqDto.getAttachementList(), basePriceApplyEo.getTenantId(), basePriceApplyEo.getInstanceId());
        Long applyId = basePriceApplyEo.getId();
        basePriceApplyEo.setSyncStatus(SyncStatusEnum.NOT_SYNC.getCode());
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
        skuDtoList.forEach(info -> info.setApplyId(applyId));
        this.basePriceApplyItemService.removeBasePriceApplyItemByApplyId(applyId);
        this.basePriceApplyItemService.batchBasePriceApplyItem(skuDtoList);
        this.attachementService.coverAttachement(attachementDtoList, applyId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceApplyById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceApplyEo basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceApplyEo)) {
            return;
        }
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)basePriceApplyEo.getStatus()), id, PriceStatusEnum.DRAFT, PriceStatusEnum.AUDIT_REJECT);
        this.basePriceApplyDas.logicDeleteById(basePriceApplyEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceApplyByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.basePriceApplyDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<BasePriceApplyRespDto> queryByPage(BasePriceApplyQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<BasePriceApplyEo> queryWrapper = this.getQueryWrapper(reqDto);
        Long orgId = this.customerHelper.getOrgId();
        queryWrapper.eq(StdBasePriceApplyEo::getOrganizationId, (Object)orgId);
        Date startApplyTime = reqDto.getStartApplyTime();
        Date endApplyTime = reqDto.getEndApplyTime();
        if (Objects.nonNull(startApplyTime)) {
            queryWrapper.ge(BaseEo::getCreateTime, (Object)DateUtil.format((Date)startApplyTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.nonNull(endApplyTime)) {
            queryWrapper.le(BaseEo::getCreateTime, (Object)DateUtil.format((Date)endApplyTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<BasePriceApplyRespDto> pageInfo = MybatisPlusUtils.selectPage(this.basePriceApplyDas, queryWrapper, BasePriceApplyRespDto.class, pageNum, pageSize);
        List list = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return pageInfo;
        }
        List<Long> idList = list.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        Map<Long, AuditRespDto> auditLastOneMap = this.auditService.getAuditLastOneMap(RelateTypeEnum.BASE_PRICE_APPLY, idList);
        for (BasePriceApplyRespDto basePriceApplyRespDto : list) {
            Long id = basePriceApplyRespDto.getId();
            if (auditLastOneMap.containsKey(id) && Objects.equals(auditLastOneMap.get(id).getAuditStatus(), basePriceApplyRespDto.getStatus())) {
                basePriceApplyRespDto.setAuditLog(auditLastOneMap.get(id));
            }
            if (!Objects.equals(basePriceApplyRespDto.getStatus(), PriceStatusEnum.AUDIT_PASS.getCode())) continue;
            Date effectTime = basePriceApplyRespDto.getEffectTime();
            basePriceApplyRespDto.setStatus(effectTime.getTime() > System.currentTimeMillis() ? PriceStatusEnum.WAIT_TAKE_EFFECT.getCode() : PriceStatusEnum.EFFECT.getCode());
        }
        this.setShopName(pageInfo);
        return pageInfo;
    }

    @Override
    public BasePriceApplyCountRespDto count(BasePriceApplyQueryReqDto reqDto) {
        reqDto.setOrganizationId(this.customerHelper.getOrgId());
        List statusCountVos = this.basePriceApplyDas.count(reqDto);
        HashMap countMap = Maps.newHashMap();
        Integer totalNum = 0;
        for (StatusCountVo statusCountVo : statusCountVos) {
            countMap.put(statusCountVo.getStatus(), statusCountVo.getNum());
            totalNum = totalNum + statusCountVo.getNum();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StdBasePriceApplyEo::getOrganizationId, (Object)reqDto.getOrganizationId())).eq(StdBasePriceApplyEo::getStatus, (Object)PriceStatusEnum.AUDIT_PASS.getCode())).gt(StdBasePriceApplyEo::getEffectTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (StringUtils.isNotBlank((String)reqDto.getKeyword())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(StdBasePriceApplyEo::getApplyCode, (Object)("%" + reqDto.getKeyword() + "%"))).or()).like(StdBasePriceApplyEo::getApplyName, (Object)("%" + reqDto.getKeyword() + "%")));
        }
        Integer waitTakeEffectNum = this.basePriceApplyDas.getMapper().selectCount((Wrapper)queryWrapper);
        BasePriceApplyCountRespDto basePriceApplyCountRespDto = new BasePriceApplyCountRespDto();
        basePriceApplyCountRespDto.setTotalNum(totalNum);
        basePriceApplyCountRespDto.setDraftNum(countMap.getOrDefault(PriceStatusEnum.DRAFT.getCode(), 0));
        basePriceApplyCountRespDto.setWaitAuditNum(countMap.getOrDefault(PriceStatusEnum.WAIT_AUDIT.getCode(), 0));
        basePriceApplyCountRespDto.setInvalidNum(countMap.getOrDefault(PriceStatusEnum.INVALID.getCode(), 0));
        basePriceApplyCountRespDto.setAuditRejectNum(countMap.getOrDefault(PriceStatusEnum.AUDIT_REJECT.getCode(), 0));
        basePriceApplyCountRespDto.setWaitTakeEffectNum(waitTakeEffectNum);
        int effectNum = totalNum - basePriceApplyCountRespDto.getDraftNum() - basePriceApplyCountRespDto.getWaitAuditNum() - basePriceApplyCountRespDto.getInvalidNum() - basePriceApplyCountRespDto.getAuditRejectNum() - waitTakeEffectNum;
        basePriceApplyCountRespDto.setEffectNum(Integer.valueOf(effectNum));
        return basePriceApplyCountRespDto;
    }

    private void setShopName(PageInfo<BasePriceApplyRespDto> pageInfo) {
        List list = pageInfo.getList();
        List<Long> shopIdList = list.stream().map(BasePriceApplyRespDto::getShopId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, String> shopNameMap = this.shopHelper.getShopNameMap(shopIdList);
        for (BasePriceApplyRespDto basePriceApplyRespDto : list) {
            if (Objects.isNull(basePriceApplyRespDto.getShopId())) continue;
            basePriceApplyRespDto.setShopName(shopNameMap.get(basePriceApplyRespDto.getShopId()));
        }
    }

    private LambdaQueryWrapper<BasePriceApplyEo> getQueryWrapper(BasePriceApplyQueryReqDto reqDto) {
        BasePriceApplyEo basePriceApplyEo = new BasePriceApplyEo();
        String status = reqDto.getStatus();
        reqDto.setStatus(null);
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceApplyEo);
        if (Objects.isNull(basePriceApplyEo.getInstanceId())) {
            basePriceApplyEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(basePriceApplyEo.getTenantId())) {
            basePriceApplyEo.setTenantId(this.context.tenantId());
        }
        basePriceApplyEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)basePriceApplyEo);
        if (Objects.nonNull(status)) {
            if (Objects.equals(status, PriceStatusEnum.WAIT_TAKE_EFFECT.getCode())) {
                queryWrapper.eq(StdBasePriceApplyEo::getStatus, (Object)PriceStatusEnum.AUDIT_PASS.getCode());
                queryWrapper.gt(StdBasePriceApplyEo::getEffectTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (Objects.equals(status, PriceStatusEnum.EFFECT.getCode())) {
                queryWrapper.eq(StdBasePriceApplyEo::getStatus, (Object)PriceStatusEnum.AUDIT_PASS.getCode());
                queryWrapper.le(StdBasePriceApplyEo::getEffectTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                queryWrapper.eq(StdBasePriceApplyEo::getStatus, (Object)status);
            }
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getApplyCodeList())) {
            queryWrapper.in(StdBasePriceApplyEo::getApplyCode, (Collection)reqDto.getApplyCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getShopIdList())) {
            queryWrapper.in(StdBasePriceApplyEo::getShopId, (Collection)reqDto.getShopIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdBasePriceApplyEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getStatusList())) {
            queryWrapper.in(StdBasePriceApplyEo::getStatus, (Collection)reqDto.getStatusList());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getKeyword())) {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(StdBasePriceApplyEo::getApplyName, (Object)reqDto.getKeyword())).or()).like(StdBasePriceApplyEo::getApplyCode, (Object)reqDto.getKeyword());
            });
        }
        return queryWrapper;
    }

    @Override
    public List<BasePriceApplyRespDto> queryByList(BasePriceApplyQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return ListUtil.empty();
        }
        return this.basePriceApplyDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (BasePriceApplyRespDto)item.toDto(BasePriceApplyRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public BasePriceApplyRespDto queryById(Long id) {
        BasePriceApplyEo basePriceApplyEo = this.getApplyInfo(id);
        BasePriceApplyRespDto basePriceApplyRespDto = (BasePriceApplyRespDto)basePriceApplyEo.toDto(BasePriceApplyRespDto.class);
        AuditRespDto auditLastOne = this.auditService.getAuditLastOne(RelateTypeEnum.BASE_PRICE_APPLY, id);
        if (Objects.nonNull(auditLastOne) && Objects.equals(auditLastOne.getAuditStatus(), basePriceApplyRespDto.getStatus())) {
            basePriceApplyRespDto.setAuditLog(auditLastOne);
        }
        Long shopId = basePriceApplyRespDto.getShopId();
        basePriceApplyRespDto.setShopName(this.shopHelper.getShopName(shopId));
        List<AttachementRespDto> attachementList = this.attachementService.getAttachementListByBusinessId(id);
        basePriceApplyRespDto.setAttachementList(attachementList);
        return basePriceApplyRespDto;
    }

    @Override
    public List<BasePriceApplyRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return ListUtil.empty();
        }
        BasePriceApplyEo basePriceApplyEo = new BasePriceApplyEo();
        basePriceApplyEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)basePriceApplyEo).in(BaseEo::getId, idList);
        List basePriceApplyEoList = this.basePriceApplyDas.getMapper().selectList((Wrapper)queryWrapper);
        return basePriceApplyEoList.stream().map(item -> (BasePriceApplyRespDto)item.toDto(BasePriceApplyRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public void invalidBasePriceApplyById(Long id) {
        BasePriceApplyEo basePriceApplyEo = this.getApplyInfo(id);
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)basePriceApplyEo.getStatus()), id, PriceStatusEnum.AUDIT_PASS);
        if (System.currentTimeMillis() >= basePriceApplyEo.getEffectTime().getTime()) {
            logger.info("[\u7533\u8bf7\u5355] >>> \u5df2\u751f\u6548\u7684\u7533\u8bf7\u5355[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (Object)id);
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.OPERATION_NOT_ALLOWED);
        }
        basePriceApplyEo.setStatus(PriceStatusEnum.INVALID.getCode());
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
    }

    @Override
    public void submitBasePriceApply(Long id, Integer channel) {
        BasePriceApplyEo basePriceApplyEo = this.getApplyInfo(id);
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)basePriceApplyEo.getStatus()), id, PriceStatusEnum.DRAFT);
        basePriceApplyEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        basePriceApplyEo.setSyncStatus(SyncStatusEnum.NOT_SYNC.getCode());
        this.checkPriceApplyNameUnique(basePriceApplyEo);
        PageInfo<BasePriceApplyItemExtRespDto> basePriceApplyItemExtRespDtoPageInfo = this.basePriceApplyItemService.queryItemByPage(id, channel, 1, 10000);
        List list = basePriceApplyItemExtRespDtoPageInfo.getList();
        List<CheckSkuPriceVo> checkSkuDtoList = list.stream().map(sku -> {
            CheckSkuPriceVo skuPriceVo = new CheckSkuPriceVo();
            skuPriceVo.setPriceLimit(sku.getItemPrice());
            skuPriceVo.setSkuId(sku.getSkuId());
            return skuPriceVo;
        }).collect(Collectors.toList());
        this.priceHelper.checkPriceLimit(id, channel, checkSkuDtoList);
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
    }

    private BasePriceApplyEo getApplyInfo(Long applyId) {
        BasePriceApplyEo basePriceApplyEo;
        if (Objects.isNull(applyId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_APPLY);
        }
        if (Objects.isNull(basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(applyId))) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_APPLY);
        }
        return basePriceApplyEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long syncErpBasePriceApplyAndAudit(BasePriceApplyAddReqDto basePriceApplyAddReqDto) {
        Long id = this.addBasePriceApply(basePriceApplyAddReqDto);
        AuditAddReqDto auditAddReqDto = new AuditAddReqDto();
        auditAddReqDto.setRelateId(id);
        auditAddReqDto.setRelateType("3");
        auditAddReqDto.setAuditResult("1");
        auditAddReqDto.setInstanceId(basePriceApplyAddReqDto.getInstanceId());
        auditAddReqDto.setTenantId(basePriceApplyAddReqDto.getTenantId());
        this.auditService.addAudit(auditAddReqDto);
        return id;
    }
}

