/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelationItemTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.DiscountItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.DiscountRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IDiscountService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IDiscountPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.CommonUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdDiscountItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DiscountServiceImpl
implements IDiscountService {
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private IPriceService priceService;
    @Resource
    private DiscountDas discountDas;
    @Resource
    private DiscountItemDas discountItemDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private IContext iContext;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IDiscountPolicyEsService discountPolicyEsService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addDiscount(DiscountAddReqDto reqDto) {
        DiscountEo discountByCode;
        Assert.isTrue((!StringUtils.isBlank((CharSequence)reqDto.getName()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List discountsByName = this.discountDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"name", (Object)reqDto.getName())).ne((Object)"status", (Object)PriceStatusEnum.AUDIT_REJECT)).ne((Object)"status", (Object)PriceStatusEnum.CHANGED)).ne((Object)"status", (Object)PriceStatusEnum.INVALID));
        if (StringUtils.isBlank((CharSequence)reqDto.getCode())) {
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)discountsByName), (String)"\u8be5\u540d\u79f0\u5df2\u91cd\u590d");
        }
        List reqCustomerIds = reqDto.getCustomerConditionAddReqDto().getCustomerIds();
        DiscountEo discountEo = discountByCode = StringUtils.isBlank((CharSequence)reqDto.getCode()) ? null : this.discountDas.findAuditPassOriginalByCode(reqDto.getCode());
        if (!CollectionUtils.isEmpty((Collection)reqCustomerIds)) {
            List<Long> reqSkuIds = reqDto.getDiscountItemAddReqDtos().stream().map(DiscountItemAddReqDto::getSkuId).collect(Collectors.toList());
            this.validRepeat(reqSkuIds, reqCustomerIds, discountByCode == null ? null : discountByCode.getId());
        }
        DiscountEo discountEo2 = this.insertDiscount(reqDto);
        this.saveDiscountPriceItem(reqDto.getDiscountItemAddReqDtos(), discountEo2.getId());
        this.insertCustomerCondition(reqDto, discountEo2);
        this.discountPolicyEsService.createPricePolicy(discountEo2.getId());
        return discountEo2.getId();
    }

    private void insertCustomerCondition(DiscountAddReqDto reqDto, DiscountEo discountEo) {
        CustomerConditionAddReqDto customerConditionReqDto = reqDto.getCustomerConditionAddReqDto();
        if (null != customerConditionReqDto) {
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            DtoHelper.dto2Eo((BaseVo)customerConditionReqDto, (BaseEo)customerConditionEo);
            customerConditionEo.setRelateId(discountEo.getId());
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerIds())) {
                customerConditionEo.setCustomerIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerTypeIds())) {
                customerConditionEo.setCustomerTypeIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerTypeIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerGroupIds())) {
                customerConditionEo.setCustomerGroupIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerGroupIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerAreaCodes())) {
                customerConditionEo.setCustomerAreaCodes(StringUtils.join((Iterable)customerConditionReqDto.getCustomerAreaCodes(), (String)","));
            }
            customerConditionEo.setRelateType(RelateTypeEnum.DISCOUNT.getType());
            this.customerConditionDas.insert((BaseEo)customerConditionEo);
        }
    }

    private DiscountEo insertDiscount(DiscountAddReqDto reqDto) {
        DiscountEo discountEo = new DiscountEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)discountEo);
        discountEo.setStatus(reqDto.isDraft() ? PriceStatusEnum.DRAFT.getCode() : PriceStatusEnum.WAIT_AUDIT.getCode());
        discountEo.setCode(StringUtils.isBlank((CharSequence)reqDto.getCode()) ? this.generateCode.createCode(GeneralRuleTypeEnum.KHZK) : reqDto.getCode());
        this.discountDas.insert((BaseEo)discountEo);
        return discountEo;
    }

    private void validRepeat(List<Long> reqSkuIds, List<String> reqCustomerIds, Long discountId) {
        Map<Long, List<DiscountItemEo>> discountIdAndDiscountItems;
        HashMap<Long, List<DiscountEo>> customerIdAndDiscountEos = this.getCustomerIdAndDiscountMap(reqCustomerIds, discountId);
        HashMap<Long, Set<Long>> customerIdAndSkus = this.getCustomerIdAndSkusMap(customerIdAndDiscountEos, discountIdAndDiscountItems = this.getDiscountIdAndDiscountItemsMap(customerIdAndDiscountEos));
        if (customerIdAndSkus == null) {
            return;
        }
        for (Long customerId : customerIdAndSkus.keySet()) {
            Set<Long> skuIds = customerIdAndSkus.get(customerId);
            List<Long> duplicateSkuIds = CommonUtils.getDuplicateElements(new ArrayList<Long>(skuIds), reqSkuIds);
            Assert.isTrue((boolean)CollectionUtils.isEmpty(duplicateSkuIds), (String)"\u540c\u4e00\u5ba2\u6237\u7ef4\u5ea6/\u540c\u4e00\u5c42\u7ea7\uff0c\u540c\u4e00\u5546\u54c1sku\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u4e8e\u591a\u6761\u5f85\u5ba1\u6838\u3001\u751f\u6548\u4e2d\u3001\u5f85\u751f\u6548\u7684\u6298\u6263");
        }
    }

    private HashMap<Long, Set<Long>> getCustomerIdAndSkusMap(HashMap<Long, List<DiscountEo>> customerIdAndDiscountEos, Map<Long, List<DiscountItemEo>> discountIdAndDiscountItems) {
        if (discountIdAndDiscountItems == null) {
            return null;
        }
        HashMap<Long, Set<Long>> customerIdAndSkus = new HashMap<Long, Set<Long>>();
        for (Long customerId : customerIdAndDiscountEos.keySet()) {
            List<DiscountEo> discountEos = customerIdAndDiscountEos.get(customerId);
            List discountEoIds = discountEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            for (Map.Entry<Long, List<DiscountItemEo>> longListEntry : discountIdAndDiscountItems.entrySet()) {
                if (!discountEoIds.contains(longListEntry.getKey())) continue;
                List<DiscountItemEo> value = longListEntry.getValue();
                HashSet valueSkuIds = !CollectionUtils.isEmpty(value) ? value.stream().map(StdDiscountItemEo::getSkuId).collect(Collectors.toSet()) : new HashSet();
                HashSet skus = customerIdAndSkus.get(customerId);
                skus = CollectionUtils.isEmpty(skus) ? new HashSet() : skus;
                valueSkuIds.addAll(skus);
                customerIdAndSkus.put(customerId, valueSkuIds);
            }
        }
        return customerIdAndSkus;
    }

    private Map<Long, List<DiscountItemEo>> getDiscountIdAndDiscountItemsMap(HashMap<Long, List<DiscountEo>> customerIdAndDiscountEos) {
        if (customerIdAndDiscountEos == null) {
            return null;
        }
        Collection<List<DiscountEo>> values = customerIdAndDiscountEos.values();
        ArrayList parentDiscountIds = new ArrayList();
        for (List<DiscountEo> value : values) {
            List sonDiscountIds = value.stream().map(BaseEo::getId).collect(Collectors.toList());
            parentDiscountIds.addAll(sonDiscountIds);
        }
        ArrayList discountItems = CollectionUtils.isEmpty(parentDiscountIds) ? new ArrayList() : this.discountItemDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"discount_id", parentDiscountIds));
        return discountItems.stream().collect(Collectors.groupingBy(StdDiscountItemEo::getDiscountId, Collectors.toList()));
    }

    private HashMap<Long, List<DiscountEo>> getCustomerIdAndDiscountMap(List<String> reqCustomerIds, Long discountId) {
        HashMap<Long, List<DiscountEo>> customerIdAndDiscountEos = new HashMap<Long, List<DiscountEo>>();
        List discounts = this.discountDas.findAllEffectValid();
        if (CollectionUtils.isEmpty((Collection)discounts)) {
            return null;
        }
        if (CollectionUtils.isEmpty(discounts = discounts.stream().filter(data -> !data.getId().equals(discountId)).collect(Collectors.toList()))) {
            return null;
        }
        Map idAndDiscounts = discounts.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        List ids = discounts.stream().map(BaseEo::getId).collect(Collectors.toList());
        List customerConditionEos = this.customerConditionDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"relate_id", ids));
        if (CollectionUtils.isEmpty((Collection)customerConditionEos)) {
            return customerIdAndDiscountEos;
        }
        for (CustomerConditionEo customerConditionEo : customerConditionEos) {
            if (StringUtils.isBlank((CharSequence)customerConditionEo.getCustomerIds())) continue;
            String[] customerIds = customerConditionEo.getCustomerIds().split(",");
            List customerIdList = Arrays.stream(customerIds).map(Long::parseLong).collect(Collectors.toList());
            List<Long> repeatCustomerIds = CommonUtils.getDuplicateElements(customerIdList, reqCustomerIds.stream().map(Long::valueOf).collect(Collectors.toList()));
            for (Long customerId : repeatCustomerIds) {
                ArrayList discountEos = customerIdAndDiscountEos.get(customerId);
                discountEos = !CollectionUtils.isEmpty(discountEos) ? discountEos : new ArrayList();
                discountEos.addAll(idAndDiscounts.get(customerConditionEo.getRelateId()));
                customerIdAndDiscountEos.put(customerId, discountEos);
            }
        }
        return customerIdAndDiscountEos;
    }

    private void saveDiscountPriceItem(List<DiscountItemAddReqDto> discountPriceItemAddReqDtos, Long priceId) {
        if (CollectionUtils.isNotEmpty(discountPriceItemAddReqDtos)) {
            ArrayList discountPriceItemEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList(discountPriceItemAddReqDtos, (Collection)discountPriceItemEos, DiscountItemEo.class);
            discountPriceItemEos.forEach(bean -> {
                bean.setDiscountId(priceId);
                this.discountItemDas.insert((BaseEo)bean);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDiscount(DiscountModifyReqDto reqDto) {
        Assert.isTrue((!StringUtils.isBlank((CharSequence)reqDto.getName()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List discountsByName = this.discountDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"name", (Object)reqDto.getName())).ne((Object)"status", (Object)PriceStatusEnum.AUDIT_REJECT)).ne((Object)"status", (Object)PriceStatusEnum.CHANGED)).ne((Object)"status", (Object)PriceStatusEnum.INVALID));
        DiscountEo discountEoFromId = this.getDiscountEo(reqDto.getId());
        Assert.isTrue((CollectionUtils.isEmpty((Collection)discountsByName) || ((DiscountEo)discountsByName.get(0)).getCode().equals(discountEoFromId.getCode()) ? 1 : 0) != 0, (String)"\u8be5\u540d\u79f0\u5df2\u91cd\u590d");
        DiscountEo discountEo = new DiscountEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)discountEo);
        List reqCustomerIds = reqDto.getCustomerConditionAddReqDto().getCustomerIds();
        if (!CollectionUtils.isEmpty((Collection)reqCustomerIds)) {
            List<Long> reqSkuIds = reqDto.getDiscountItemAddReqDtos().stream().map(DiscountItemAddReqDto::getSkuId).collect(Collectors.toList());
            this.validRepeat(reqSkuIds, reqCustomerIds, reqDto.getId());
        }
        if (discountEoFromId.getStatus().equals(PriceStatusEnum.AUDIT_PASS.getCode())) {
            this.extractedCopy(reqDto, discountEoFromId);
            return;
        }
        this.discountItemDas.deleteByDiscountId(reqDto.getId());
        this.customerConditionDas.extracted(reqDto.getId());
        this.saveDiscountPriceItem(reqDto.getDiscountItemAddReqDtos(), discountEo.getId());
        if (null != reqDto.getCustomerConditionAddReqDto()) {
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            DtoHelper.dto2Eo((BaseVo)reqDto.getCustomerConditionAddReqDto(), (BaseEo)customerConditionEo);
            customerConditionEo.setRelateId(discountEo.getId());
            customerConditionEo.setRelateType(RelateTypeEnum.DISCOUNT.getType());
            CustomerConditionAddReqDto customerConditionAddReqDto = reqDto.getCustomerConditionAddReqDto();
            if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerIds())) {
                customerConditionEo.setCustomerIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerTypeIds())) {
                customerConditionEo.setCustomerTypeIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerTypeIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerGroupIds())) {
                customerConditionEo.setCustomerGroupIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerGroupIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerAreaCodes())) {
                customerConditionEo.setCustomerAreaCodes(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerAreaCodes(), (String)","));
            }
            this.customerConditionDas.insert((BaseEo)customerConditionEo);
        }
        discountEo.setStatus(reqDto.getDraft() != false ? PriceStatusEnum.DRAFT.getCode() : PriceStatusEnum.WAIT_AUDIT.getCode());
        this.discountDas.updateSelective((BaseEo)discountEo);
    }

    private DiscountEo getDiscountEo(Long id) {
        DiscountEo selectItemDiscount = new DiscountEo();
        selectItemDiscount.setId(id);
        selectItemDiscount.setInstanceId(this.iContext.instanceId());
        selectItemDiscount.setTenantId(this.iContext.tenantId());
        return (DiscountEo)this.discountDas.selectOne((BaseEo)selectItemDiscount);
    }

    private void extractedCopy(DiscountModifyReqDto reqDto, DiscountEo discountEo) {
        DiscountEo waitAuditCopy = this.discountDas.findWaitAuditCopyByCode(discountEo.getCode());
        if (waitAuditCopy != null && !waitAuditCopy.getId().equals(reqDto.getId())) {
            waitAuditCopy.setStatus(PriceStatusEnum.INVALID.getCode());
            this.discountDas.update((BaseEo)waitAuditCopy);
        }
        DiscountAddReqDto priceLimitAddReqDto = new DiscountAddReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)priceLimitAddReqDto);
        priceLimitAddReqDto.setCode(discountEo.getCode());
        this.addDiscount(priceLimitAddReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDiscount(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.discountDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public DiscountRespDto queryDiscountById(Long id) {
        if (id == null) {
            return new DiscountRespDto();
        }
        DiscountEo discountEoSearch = new DiscountEo();
        discountEoSearch.setId(id);
        discountEoSearch.setInstanceId(this.iContext.instanceId());
        discountEoSearch.setTenantId(this.iContext.tenantId());
        discountEoSearch.setDr(0);
        List select = this.discountDas.select((BaseEo)discountEoSearch);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return new DiscountRespDto();
        }
        DiscountEo discountEo = (DiscountEo)select.get(0);
        DiscountRespDto discountRespDto = new DiscountRespDto();
        DtoHelper.eo2Dto((BaseEo)discountEo, (BaseVo)discountRespDto);
        CustomerConditionEo customerConditionEo = this.customerConditionDas.findDiscountTypeByRelateId(id);
        Assert.notNull((Object)customerConditionEo, (String)" \u5ba2\u6237\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
        DtoHelper.eo2Dto((BaseEo)customerConditionEo, (BaseVo)customerConditionRespDto);
        if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerIds())) {
            String[] customerIds = customerConditionEo.getCustomerIds().split(",");
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            List ids = Arrays.stream(customerIds).map(Long::parseLong).collect(Collectors.toList());
            customerSearchReqDto.setIdList(ids);
            RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(JSON.toJSONString((Object)customerSearchReqDto), Integer.valueOf(1), Integer.valueOf(1000));
            if (null != pageInfoRestResponse && null != pageInfoRestResponse.getData()) {
                ArrayList customerInfoDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)customerInfoDtos, (Collection)((PageInfo)pageInfoRestResponse.getData()).getList(), CustomerInfoDto.class);
                this.priceService.buildConditionRegionNames(customerInfoDtos);
                customerConditionRespDto.setCustomerInfoDtos((List)customerInfoDtos);
            }
        }
        discountRespDto.setCustomerConditionRespDto(customerConditionRespDto);
        return discountRespDto;
    }

    @Override
    public PageInfo<DiscountRespDto> queryDiscountByPage(DiscountQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List discountRespDtos = this.discountDas.selectPageList(reqDto);
        for (DiscountRespDto discountRespDto : discountRespDtos) {
            discountRespDto.setStatusName(PriceStatusEnum.toName((String)discountRespDto.getStatus()));
            discountRespDto.setRelationCustomerTypeName(CustomerDimensionEnum.toName((String)discountRespDto.getRelationCustomerType()));
            discountRespDto.setRelationItemTypeName(RelationItemTypeEnum.toName((String)discountRespDto.getRelationItemTypeName()));
        }
        return new PageInfo(discountRespDtos);
    }

    @Override
    public void cancelPrice(Long id) {
        DiscountEo discountEo = new DiscountEo();
        discountEo.setId(id);
        discountEo.setInstanceId(this.iContext.instanceId());
        discountEo.setTenantId(this.iContext.tenantId());
        DiscountEo priceEo = (DiscountEo)this.discountDas.selectOne((BaseEo)discountEo);
        if (null == priceEo) {
            throw new BizException("\u6298\u6263\u4e0d\u5b58\u5728");
        }
        priceEo.setStatus(PriceStatusEnum.INVALID.getCode());
        this.discountDas.updateSelective((BaseEo)priceEo);
        this.discountPolicyEsService.updatePricePolicy(priceEo.getId());
    }

    @Override
    public void auditPrice(AuditReqDto reqDto) {
        DiscountEo waitAuditCopyByCode;
        DiscountEo priceEo = (DiscountEo)this.discountDas.selectByPrimaryKey(reqDto.getId());
        if (null == priceEo) {
            throw new BizException("\u6298\u6263\u4e0d\u5b58\u5728");
        }
        if (!PriceStatusEnum.WAIT_AUDIT.getCode().equals(priceEo.getStatus())) {
            throw new BizException("\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u5ba1\u6838");
        }
        if (AuditResultEnum.NOT_PASS.toCode().equals(reqDto.getAuditResult()) && (waitAuditCopyByCode = this.discountDas.findAuditPassOriginalByCode(priceEo.getCode())) != null && waitAuditCopyByCode.getStatus().equals(PriceStatusEnum.AUDIT_PASS.getCode())) {
            waitAuditCopyByCode.setStatus(PriceStatusEnum.CHANGED.getCode());
            this.discountDas.updateSelective((BaseEo)waitAuditCopyByCode);
            this.discountPolicyEsService.updatePricePolicy(waitAuditCopyByCode.getId());
        }
        priceEo.setStatus(AuditResultEnum.NOT_PASS.toCode().equals(reqDto.getAuditResult()) ? PriceStatusEnum.AUDIT_REJECT.getCode() : PriceStatusEnum.AUDIT_PASS.getCode());
        priceEo.setRemark(reqDto.getRemark());
        this.discountDas.updateSelective((BaseEo)priceEo);
        this.discountPolicyEsService.updatePricePolicy(reqDto.getId());
    }

    @Override
    public PageInfo<DiscountItemRespDto> queryDiscountItemByPage(Long discountId, Integer pageNum, Integer pageSize) {
        if (discountId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List select = this.discountItemDas.selectDiscountId(discountId);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return new PageInfo();
        }
        List supplierReturnList = select.stream().map(this::buildDiscountItemEo).collect(Collectors.toList());
        return new PageInfo(supplierReturnList);
    }

    @Override
    public void submitPrice(Long id) {
        DiscountEo priceEo = (DiscountEo)this.discountDas.selectByPrimaryKey(id);
        if (null == priceEo) {
            throw new BizException("\u6298\u6263\u4e0d\u5b58\u5728");
        }
        if (!PriceStatusEnum.DRAFT.getCode().equals(priceEo.getStatus())) {
            throw new BizException("\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u63d0\u4ea4");
        }
        priceEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        this.discountDas.updateSelective((BaseEo)priceEo);
    }

    private DiscountItemRespDto buildDiscountItemEo(DiscountItemEo discountItemEo) {
        DiscountItemRespDto discountItemRespDto = new DiscountItemRespDto();
        CubeBeanUtils.copyProperties((Object)discountItemRespDto, (Object)discountItemEo, (String[])new String[0]);
        return discountItemRespDto;
    }
}

