/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfSearchDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemListRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceItemService;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceRelationTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceItemServiceImpl
implements IPriceItemService {
    private static final Logger logger = LoggerFactory.getLogger(PriceItemServiceImpl.class);
    @Resource
    private PriceItemDas priceItemDas;
    @Resource
    private IContext context;
    @Resource
    private IItemQueryApi iItemQueryApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;
    @Resource
    private BasePriceRelationTypeDas basePriceRelationTypeDas;
    @Resource
    private PriceDas priceDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private IUnitQueryApi unitQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceItem(PriceItemAddReqDto reqDto) {
        PriceItemEo priceItemEo = new PriceItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceItemEo);
        this.priceItemDas.insert((BaseEo)priceItemEo);
        return priceItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceItem(PriceItemModifyReqDto reqDto) {
        PriceItemEo priceItemEo = new PriceItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceItemEo);
        this.priceItemDas.updateSelective((BaseEo)priceItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceItem(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.priceItemDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public PriceItemRespDto queryPriceItemById(Long id) {
        PriceItemEo priceItemEo = (PriceItemEo)this.priceItemDas.selectByPrimaryKey(id);
        if (priceItemEo == null) {
            return null;
        }
        PriceItemRespDto priceItemRespDto = new PriceItemRespDto();
        DtoHelper.eo2Dto((BaseEo)priceItemEo, (BaseVo)priceItemRespDto);
        return priceItemRespDto;
    }

    @Override
    public PageInfo<PriceItemListRespDto> queryPriceItemByPage(PriceItemQueryReqDto qry, Integer pageNum, Integer pageSize) {
        boolean needCustomerName;
        qry.setTenantId(this.context.tenantId());
        qry.setInstanceId(this.context.instanceId());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        if (StringUtils.isNotBlank((String)qry.getCustomerName())) {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setKeyword(qry.getCustomerName());
            RestResponse response = this.iCustomerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
            if ("0".equals(response.getResultCode())) {
                List customerRespDtoList = (List)response.getData();
                List customerIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                qry.setCustomerIds(customerIds);
            }
        }
        List itemListRespDtoList = this.priceItemDas.selectPageList(qry);
        boolean bl = needCustomerName = CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode().equals(qry.getCategoryCode()) || CategoryCodeEnum.SUPPLY_CHANNEL.getCode().equals(qry.getCategoryCode()) || CategoryCodeEnum.RETAIL.getCode().equals(qry.getCategoryCode());
        if (needCustomerName) {
            itemListRespDtoList.forEach(item -> {
                if (null != item.getRelationCustomerType() && 0 == item.getRelationCustomerType()) {
                    String[] ids;
                    List<String> idList;
                    List userIdList;
                    RestResponse response;
                    CustomerConditionEo conditionEo = new CustomerConditionEo();
                    conditionEo.setTenantId(this.context.tenantId());
                    conditionEo.setInstanceId(this.context.instanceId());
                    conditionEo.setRelateType("0");
                    conditionEo.setRelateId(item.getPriceId());
                    conditionEo = (CustomerConditionEo)this.customerConditionDas.selectOne((BaseEo)conditionEo);
                    if (StringUtils.isNotBlank((String)conditionEo.getCustomerIds()) && "0".equals((response = this.iCustomerQueryApi.queryListByIds(userIdList = (idList = Arrays.asList(ids = conditionEo.getCustomerIds().split(","))).stream().map(Long::parseLong).collect(Collectors.toList()))).getResultCode())) {
                        List result = (List)response.getData();
                        StringBuilder sb = new StringBuilder();
                        result.forEach(customerNameSimpleRespDto -> {
                            sb.append(customerNameSimpleRespDto.getName());
                            sb.append(",");
                        });
                        if (sb.length() > 1) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        item.setCustomerName(sb.toString());
                    }
                }
            });
        }
        return new PageInfo(itemListRespDtoList);
    }

    @Override
    public PageInfo<ItemSkuListRespDto> getSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, Integer pageNum, Integer pageSize) {
        ItemOnShelfSearchDto itemOnShelfSearchDto = new ItemOnShelfSearchDto();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getDirId()) {
            ids.add(itemSkuListQueryReqDto.getDirId());
        }
        ArrayList<Long> backDirIds = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getBackDirId()) {
            backDirIds.add(itemSkuListQueryReqDto.getBackDirId());
        }
        itemOnShelfSearchDto.setOutSkuIds(itemSkuListQueryReqDto.getOutSkuIds());
        itemOnShelfSearchDto.setDirIds(ids);
        itemOnShelfSearchDto.setBackDirIds(backDirIds);
        itemOnShelfSearchDto.setInstanceId(this.context.instanceId());
        itemOnShelfSearchDto.setPageNum(pageNum);
        itemOnShelfSearchDto.setPageSize(pageSize);
        itemOnShelfSearchDto.setSearchValue(itemSkuListQueryReqDto.getKeyword());
        itemOnShelfSearchDto.setTenantId(this.context.tenantId());
        if (null != itemSkuListQueryReqDto.getBusType()) {
            itemOnShelfSearchDto.setBusType(itemSkuListQueryReqDto.getBusType());
        } else {
            itemOnShelfSearchDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        RestResponse pageInfoRestResponse = this.iItemQueryApi.findItemOnSelf(JSON.toJSONString((Object)itemOnShelfSearchDto), pageNum, pageSize);
        PageInfo itemOnShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(itemOnShelfRespDtoPageInfo) || CollectionUtils.isEmpty((Collection)itemOnShelfRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        HashSet unitIds = new HashSet(itemOnShelfRespDtoPageInfo.getList().size());
        List<ItemSkuListRespDto> itemSkuListRespDtos = itemOnShelfRespDtoPageInfo.getList().stream().map(bean -> {
            ItemSkuListRespDto itemSkuListRespDto = new ItemSkuListRespDto();
            BeanUtils.copyProperties((Object)bean, (Object)itemSkuListRespDto);
            itemSkuListRespDto.setId(null);
            itemSkuListRespDto.setItemNum(Long.valueOf(Objects.nonNull(itemSkuListRespDto.getWholesaleLimitMin()) ? itemSkuListRespDto.getWholesaleLimitMin() : 1L));
            Map skuAttr = (Map)ObjectHelper.Json2Bean((String)itemSkuListRespDto.getAttr(), Map.class);
            if (null != skuAttr) {
                String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                itemSkuListRespDto.setSkuName(skuDesc);
            } else {
                itemSkuListRespDto.setSkuName("");
            }
            Long balance = this.queryVirStorage(bean.getShopId(), bean.getSkuId());
            itemSkuListRespDto.setBalance(Long.valueOf(balance != null && balance > 0L ? balance : 0L));
            if (StringUtils.isNotEmpty((String)itemSkuListRespDto.getUnit())) {
                try {
                    unitIds.add(Long.valueOf(itemSkuListRespDto.getUnit()));
                }
                catch (Exception e) {
                    logger.info("\u8f6c\u5316\u5355\u4f4d\u5931\u8d25,data:{}, \u5931\u8d25\u539f\u56e0: {}", (Object)JSONObject.toJSONString((Object)itemSkuListRespDto.getUnit()), (Object)e.getMessage());
                }
            }
            return itemSkuListRespDto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)itemOnShelfRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList(itemSkuListRespDtos);
        if (CollectionUtils.isNotEmpty(unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
            Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
            for (ItemSkuListRespDto itemSkuInfo : itemSkuListRespDtos) {
                if (!StringUtils.isNotEmpty((String)itemSkuInfo.getUnit())) continue;
                try {
                    String unitName = unitNameMap.get(Long.valueOf(itemSkuInfo.getUnit()));
                    itemSkuInfo.setUnitName(unitName);
                }
                catch (Exception e) {
                    logger.info("\u8f6c\u5316\u5355\u4f4d\u5931\u8d25,data:{}, \u5931\u8d25\u539f\u56e0:{}", (Object)JSONObject.toJSONString((Object)itemSkuInfo.getUnit()), (Object)e.getMessage());
                }
            }
        }
        if (!CategoryCodeEnum.BASE.getCode().equals(itemSkuListQueryReqDto.getCategoryCode()) && itemSkuListRespDtos.size() > 0) {
            ArrayList skuIdList = new ArrayList();
            itemSkuListRespDtos.forEach(itemSkuListRespDto -> skuIdList.add(itemSkuListRespDto.getSkuId()));
            List priceTypeIdList = this.basePriceRelationTypeDas.selectPriceTypeIdByCategoryCode(itemSkuListQueryReqDto.getCategoryCode(), this.context.tenantId(), this.context.instanceId());
            if (priceTypeIdList != null && priceTypeIdList.size() > 0) {
                List priceTypes = this.priceDas.selectPriceItemList(skuIdList, priceTypeIdList, this.context.tenantId(), this.context.instanceId());
                itemSkuListRespDtos.forEach(itemSkuListRespDto -> {
                    if (itemSkuListRespDto.getPriceTypeList() == null) {
                        itemSkuListRespDto.setPriceTypeList(new ArrayList());
                    }
                    priceTypes.forEach(priceTypeDto -> {
                        if (itemSkuListRespDto.getSkuId().equals(priceTypeDto.getSkuId())) {
                            itemSkuListRespDto.getPriceTypeList().add(priceTypeDto);
                        }
                    });
                });
            }
        }
        return result;
    }

    public Long queryVirStorage(Long shopId, Long skuId) {
        ItemStorageQueryReqDto itemStorageQueryReqDto = new ItemStorageQueryReqDto();
        itemStorageQueryReqDto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        itemStorageQueryReqDto.setTenantId(this.context.tenantId());
        itemStorageQueryReqDto.setInstanceId(this.context.instanceId());
        itemStorageQueryReqDto.setShopId(shopId);
        String filters = ObjectHelper.bean2Json((Object)itemStorageQueryReqDto);
        List virStorageList = (List)this.itemStorageQueryApi.queryItemStorage(filters).getData();
        if (CollectionUtils.isEmpty((Collection)virStorageList)) {
            return 0L;
        }
        return ((ItemStorageQueryRespDto)virStorageList.get(0)).getAvaNum();
    }
}

