/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModelAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModelModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModelQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceModelRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceRelatedNum;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceModelService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.CommonUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceRelationTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceModelDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceRelationTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceModelEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceRelationTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceModelEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceModelServiceImpl
implements IPriceModelService {
    private static final Logger logger = LoggerFactory.getLogger(PriceModelServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private PriceModelDas priceModelDas;
    @Resource
    private BasePriceRelationTypeDas basePriceRelationTypeDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private GenerateCode<PriceModelEo> generateCode;
    @Resource
    private PriceDas priceDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceModel(PriceModelAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        Long organizationId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
        this.validatePriceModel(reqDto.getModelName(), null, organizationId);
        PriceModelEo priceModelEo = new PriceModelEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceModelEo);
        priceModelEo.setOrganizationId(organizationId);
        priceModelEo.setModelCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGMX));
        this.priceModelDas.insert((BaseEo)priceModelEo);
        if (null != reqDto.getReference()) {
            this.insertBasePriceRelationType(priceModelEo.getId(), priceModelEo.getModelName(), reqDto.getReference());
        }
        return priceModelEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchPriceModel(List<PriceModelAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList priceModelEoList = ListUtil.toList((Object[])new PriceModelEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)priceModelEoList, PriceModelEo.class);
        if (CollUtil.isEmpty((Collection)priceModelEoList)) {
            return ListUtil.empty();
        }
        this.priceModelDas.insertBatch((List)priceModelEoList);
        return priceModelEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceModel(PriceModelModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        Long organizationId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
        this.validatePriceModel(reqDto.getModelName(), reqDto.getId(), organizationId);
        PriceModelEo priceModelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceModelEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceModelEo);
        this.priceModelDas.update((BaseEo)priceModelEo);
        if (null != reqDto.getReference()) {
            BasePriceRelationTypeEo condition = new BasePriceRelationTypeEo();
            condition.setPriceModelId(priceModelEo.getId());
            this.basePriceRelationTypeDas.delete((BaseEo)condition);
            this.insertBasePriceRelationType(priceModelEo.getId(), priceModelEo.getModelName(), reqDto.getReference());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceModelById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(StdPriceEo::getModelId, (Object)id)).eq(BaseEo::getDr, (Object)0);
        Integer count = this.priceDas.getMapper().selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BizException("\u5df2\u5173\u8054\u653f\u7b56\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.priceModelDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceModelByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.priceModelDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<PriceModelRespDto> queryByPage(PriceModelQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<PriceModelEo> queryWrapper = this.getQueryWrapper(reqDto);
        pageNum = reqDto.getPageNum();
        pageSize = reqDto.getPageSize();
        if (ObjectUtil.isEmpty((Object)pageNum)) {
            pageNum = 1;
        }
        if (ObjectUtil.isEmpty((Object)pageSize)) {
            pageSize = 10;
        }
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<PriceModelRespDto> resultPageInfo = MybatisPlusUtils.selectPage(this.priceModelDas, queryWrapper, PriceModelRespDto.class, pageNum, pageSize);
        Long[] arr = new Long[]{CommonUtils.createIndexNo(pageNum, pageSize)};
        List result = resultPageInfo.getList().stream().peek(e -> {
            Long l = arr[0];
            Long l2 = arr[0] = Long.valueOf(arr[0] + 1L);
            e.setIndexNo(l);
        }).collect(Collectors.toList());
        resultPageInfo.setList(result);
        return resultPageInfo;
    }

    private LambdaQueryWrapper<PriceModelEo> getQueryWrapper(PriceModelQueryReqDto reqDto) {
        PriceModelEo priceModelEo = new PriceModelEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceModelEo);
        priceModelEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        priceModelEo.setModelName(null);
        priceModelEo.setModelCode(null);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceModelEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getCategoryCodeList())) {
            queryWrapper.in(StdPriceModelEo::getCategoryCode, (Collection)reqDto.getCategoryCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getModelCodeList())) {
            queryWrapper.in(StdPriceModelEo::getModelCode, (Collection)reqDto.getModelCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getStatusList())) {
            queryWrapper.in(StdPriceModelEo::getStatus, (Collection)reqDto.getStatusList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdPriceModelEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getModelName())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(StdPriceModelEo::getModelName, (Object)reqDto.getModelName())).or()).like(StdPriceModelEo::getModelCode, (Object)reqDto.getModelName());
        }
        priceModelEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData());
        queryWrapper.eq(StdPriceModelEo::getOrganizationId, (Object)priceModelEo.getOrganizationId());
        return queryWrapper;
    }

    @Override
    public List<PriceModelRespDto> queryByList(PriceModelQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        return this.priceModelDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (PriceModelRespDto)item.toDto(PriceModelRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceModelRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        PriceModelEo priceModelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceModelEo)) {
            return null;
        }
        PriceModelRespDto priceModelRespDto = (PriceModelRespDto)priceModelEo.toDto(PriceModelRespDto.class);
        BasePriceRelationTypeEo relationTypeEo = new BasePriceRelationTypeEo();
        relationTypeEo.setPriceModelId(priceModelEo.getId());
        List relationTypeEoList = this.basePriceRelationTypeDas.select((BaseEo)relationTypeEo);
        if (CollUtil.isNotEmpty((Collection)relationTypeEoList)) {
            ArrayList priceTypeDtos = Lists.newArrayList();
            relationTypeEoList.forEach(bean -> {
                PriceTypeDto priceTypeDto = new PriceTypeDto();
                priceTypeDto.setTypeId(bean.getPriceTypeId());
                priceTypeDto.setTypeName(bean.getPriceTypeName());
                priceTypeDto.setTypeCode(bean.getPriceTypeCode());
                priceTypeDtos.add(priceTypeDto);
            });
            priceModelRespDto.setReference((List)priceTypeDtos);
        }
        return priceModelRespDto;
    }

    @Override
    public List<PriceModelRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        PriceModelEo priceModelEo = new PriceModelEo();
        priceModelEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceModelEo).in(BaseEo::getId, idList);
        List priceModelEoList = this.priceModelDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)priceModelEoList)) {
            HashSet moduleIds = Sets.newHashSet();
            for (PriceModelEo modelEo : priceModelEoList) {
                moduleIds.add(modelEo.getId());
                PriceModelRespDto priceModelRespDto = new PriceModelRespDto();
                DtoHelper.eo2Dto((BaseEo)modelEo, (BaseVo)priceModelRespDto);
                result.add(priceModelRespDto);
            }
            LambdaQueryWrapper priceRelaQueryWapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)priceRelaQueryWapper.in(StdBasePriceRelationTypeEo::getPriceModelId, (Collection)moduleIds)).eq(BaseEo::getDr, (Object)0);
            List relationTypeEoList = this.basePriceRelationTypeDas.getMapper().selectList((Wrapper)priceRelaQueryWapper);
            Map<Long, List<BasePriceRelationTypeEo>> priceRelateGroup = relationTypeEoList.stream().collect(Collectors.groupingBy(StdBasePriceRelationTypeEo::getPriceModelId));
            for (PriceModelRespDto priceModelRespDto : result) {
                List<BasePriceRelationTypeEo> basePriceRelationTypeEos = priceRelateGroup.get(priceModelRespDto.getId());
                if (!CollUtil.isNotEmpty(basePriceRelationTypeEos)) continue;
                ArrayList priceTypeDtos = Lists.newArrayList();
                basePriceRelationTypeEos.forEach(bean -> {
                    PriceTypeDto priceTypeDto = new PriceTypeDto();
                    priceTypeDto.setTypeId(bean.getPriceTypeId());
                    priceTypeDto.setTypeName(bean.getPriceTypeName());
                    priceTypeDto.setTypeCode(bean.getPriceTypeCode());
                    priceTypeDtos.add(priceTypeDto);
                });
                priceModelRespDto.setReference((List)priceTypeDtos);
            }
        }
        return result;
    }

    @Override
    public List<PriceModelEo> queryEoByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return null;
        }
        PriceModelEo priceModelEo = new PriceModelEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceModelEo).in(BaseEo::getId, idList);
        List priceModelEoList = this.priceModelDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceModelEoList;
    }

    @Override
    public void modifyPriceModelRelatedNum(Long id, Integer update) {
        if (PriceRelatedNum.ADD.equals(update)) {
            this.priceModelDas.modifyPriceModelRelatedNum(id, PriceRelatedNum.ADD);
        }
        if (PriceRelatedNum.SUB.equals(update)) {
            this.priceModelDas.modifyPriceModelRelatedNum(id, PriceRelatedNum.SUB);
        }
    }

    @Override
    public void modifyPriceModelStatus(PriceModelModifyReqDto reqDto) {
        PriceModelEo priceModelEo = new PriceModelEo();
        priceModelEo.setStatus(reqDto.getStatus());
        priceModelEo.setId(reqDto.getId());
        this.priceModelDas.updateSelective((BaseEo)priceModelEo);
    }

    private void insertBasePriceRelationType(Long priceModelId, String priceModelName, List<PriceTypeDto> priceTypeDtos) {
        ArrayList<BasePriceRelationTypeEo> basePriceRelationTypeEoList = new ArrayList<BasePriceRelationTypeEo>();
        for (PriceTypeDto priceTypeDto : priceTypeDtos) {
            BasePriceRelationTypeEo basePriceRelationTypeEo = new BasePriceRelationTypeEo();
            basePriceRelationTypeEo.setPriceTypeId(priceTypeDto.getTypeId());
            basePriceRelationTypeEo.setPriceTypeName(priceTypeDto.getTypeName());
            basePriceRelationTypeEo.setPriceTypeCode(priceTypeDto.getTypeCode());
            basePriceRelationTypeEo.setPriceModelId(priceModelId);
            basePriceRelationTypeEo.setPriceModelName(priceModelName);
            basePriceRelationTypeEoList.add(basePriceRelationTypeEo);
        }
        this.basePriceRelationTypeDas.insertBatch(basePriceRelationTypeEoList);
    }

    private void validatePriceModel(String name, Long id, Long organizationId) {
        boolean repeat;
        PriceModelEo condition = new PriceModelEo();
        condition.setModelName(name);
        condition.setOrganizationId(organizationId);
        List priceModelEoList = this.priceModelDas.select((BaseEo)condition);
        boolean bl = repeat = null == id && !priceModelEoList.isEmpty() || null != id && priceModelEoList.size() > 0 && !((PriceModelEo)priceModelEoList.get(0)).getId().equals(id);
        if (repeat) {
            throw new BizException("\u4ef7\u683c\u6a21\u578b\u540d\u79f0\u91cd\u590d");
        }
    }
}

