/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceAndNumLimitDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAuditReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AttachementRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBrandRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.exception.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.ICustomerConditionService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceItemConditionService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectCustomerService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceService;
import com.dtyunxi.yundt.cube.center.price.biz.service.ValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.BasePriceValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.ChannelDistributionPriceValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.InternalSettlementPriceValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.RetailPricePriceValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.SupplyChannelPriceValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.biz.util.PriceUtil;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.AttachementDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.AuditDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceRelationTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.GuidingPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.ModifyPriceLogDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceBrandDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AttachementEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.GuidingPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.ModifyPriceLogEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceTypeEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceServiceImpl
implements IPriceService {
    @Resource
    private PriceDas priceDas;
    @Resource
    private PriceItemDas priceItemDas;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private ModifyPriceLogDas modifyPriceLogDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private PriceTypeDas priceTypeDas;
    @Resource
    private GuidingPriceDas guidingPriceDas;
    @Resource
    private BasePriceRelationTypeDas basePriceRelationTypeDas;
    @Resource
    private AuditDas auditDas;
    @Resource
    private IContext context;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;
    @Resource
    private IPriceItemConditionService priceItemConditionService;
    @Resource
    private IPriceRejectItemService priceRejectItemService;
    @Resource
    private IPriceRejectCustomerService priceRejectCustomerService;
    @Resource
    private IAuditService auditService;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private ICustomerConditionService customerConditionService;
    @Autowired
    private PriceBrandDas priceBrandDas;
    static HashMap<String, ValidateStrategy> validateMap = new HashMap();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceAddOrModifyRespDto addPrice(PriceBeanReqDto reqDto) {
        PriceAddOrModifyRespDto validate;
        PriceAddOrModifyRespDto priceAddOrModifyRespDto = new PriceAddOrModifyRespDto();
        if (StringUtils.isEmpty((CharSequence)reqDto.getCategoryCode())) {
            throw new BizException(PriceExceptionCode.PRICE_CATEGORY_IS_NULL.getCode(), PriceExceptionCode.PRICE_CATEGORY_IS_NULL.getMsg());
        }
        ValidateStrategy validateStrategy = validateMap.get(reqDto.getCategoryCode());
        if (null != validateStrategy && reqDto.getCheckPriceLimit().booleanValue() && null != (validate = validateStrategy.validate(reqDto, null)) && CollectionUtils.isNotEmpty((Collection)validate.getPriceOfferLimitItemRespDtos())) {
            return validate;
        }
        PriceEo priceEo = new PriceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceEo);
        priceEo.setId(null);
        if (StringUtils.isEmpty((CharSequence)reqDto.getCode())) {
            priceEo.setCode(PriceUtil.generateCode(""));
            priceEo.setVersion(Integer.valueOf(1));
        } else {
            PriceEo queryEo = new PriceEo();
            queryEo.setCode(reqDto.getCode());
            List select = this.priceDas.select((BaseEo)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)select)) {
                priceEo.setVersion(Integer.valueOf(select.size() + 1));
            }
            queryEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
            List needDeleteList = this.priceDas.select((BaseEo)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)needDeleteList)) {
                List needPriceIds = needDeleteList.stream().map(BaseEo::getId).collect(Collectors.toList());
                List priceItemList = this.priceItemDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"price_id", needPriceIds));
                List needPriceItemIds = priceItemList.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.priceDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"id", needPriceIds));
                this.customerConditionDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"relate_id", needPriceIds));
                this.attachementDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"business_id", needPriceIds));
                this.priceItemDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"id", needPriceItemIds));
                this.modifyPriceLogDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"price_item_id", needPriceItemIds));
                this.guidingPriceDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"price_item_id", needPriceItemIds));
            }
        }
        if (reqDto.getOrganizationId() != null && StringUtils.isEmpty((CharSequence)reqDto.getOrganizationName())) {
            RestResponse response = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrganizationId());
            OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)response);
            reqDto.setOrganizationName(orgInfoRespDto.getOrganizationDto().getName());
            priceEo.setOrganizationName(orgInfoRespDto.getOrganizationDto().getName());
        }
        if (reqDto.getDraft().booleanValue()) {
            priceEo.setStatus(PriceStatusEnum.DRAFT.getCode());
        } else {
            priceEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        }
        this.priceDas.insert((BaseEo)priceEo);
        this.savePriceItem(reqDto.getPriceItemReqDtos(), priceEo.getId(), reqDto.getCategoryCode(), reqDto.getTypeId());
        if (null != reqDto.getCustomerConditionReqDto()) {
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            CustomerConditionModifyReqDto customerConditionReqDto = reqDto.getCustomerConditionReqDto();
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerIds())) {
                customerConditionEo.setCustomerIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerTypeIds())) {
                customerConditionEo.setCustomerTypeIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerTypeIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerGroupIds())) {
                customerConditionEo.setCustomerGroupIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerGroupIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerAreaCodes())) {
                customerConditionEo.setCustomerAreaCodes(StringUtils.join((Iterable)customerConditionReqDto.getCustomerAreaCodes(), (String)","));
                List<String> customerAreaCodeExts = this.getSubCustAreaCodes(customerConditionReqDto.getCustomerAreaCodes());
                customerConditionEo.setCustomerAreaCodeExt(StringUtils.join(customerAreaCodeExts, (String)","));
            }
            customerConditionEo.setRelateId(priceEo.getId());
            customerConditionEo.setRelateType(RelateTypeEnum.PRICE.getType());
            this.customerConditionDas.insert((BaseEo)customerConditionEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getAttachementReqDtos())) {
            ArrayList attachementEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)reqDto.getAttachementReqDtos(), (Collection)attachementEos, AttachementEo.class);
            attachementEos.stream().forEach(bean -> bean.setBusinessId(priceEo.getId()));
            this.attachementDas.insertBatch((List)attachementEos);
        }
        priceAddOrModifyRespDto.setId(priceEo.getId());
        this.pricePolicyEsService.updatePricePolicy(priceEo.getId());
        return priceAddOrModifyRespDto;
    }

    private List<String> getSubCustAreaCodes(List<String> parentAreaCode) {
        CustomerAreaListReqDto reqDto = new CustomerAreaListReqDto();
        reqDto.setCodes(parentAreaCode);
        List subAreaCodes = (List)this.customerAreaQueryApi.querySubCodeAll(reqDto).getData();
        return subAreaCodes;
    }

    private void savePriceItem(List<PriceItemModifyReqDto> priceItemAddReqDtos, Long priceId, String categoryCode, Long priceTypeId) {
        if (CollectionUtils.isNotEmpty(priceItemAddReqDtos)) {
            ArrayList guidingPriceEos = Lists.newArrayList();
            boolean channelFlag = CategoryCodeEnum.SUPPLY_CHANNEL.getCode().equals(categoryCode) || CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode().equals(categoryCode);
            ArrayList needPriceItemList = Lists.newArrayList();
            ArrayList<ModifyPriceLogEo> needModifyPriceLogList = new ArrayList<ModifyPriceLogEo>();
            for (PriceItemModifyReqDto priceItemAddReqDto : priceItemAddReqDtos) {
                ModifyPriceLogEo modifyPriceLogEo;
                PriceItemEo priceItemEo;
                if (channelFlag) {
                    List priceNumLimitList = priceItemAddReqDto.getPriceNumLimitList();
                    PriceAndNumLimitDto priceAndNumLimitDto = (PriceAndNumLimitDto)priceNumLimitList.get(0);
                    if (Objects.nonNull(priceAndNumLimitDto.getUpperLimit()) && priceAndNumLimitDto.getUpperLimit() == -1) {
                        priceItemEo = new PriceItemEo();
                        DtoHelper.dto2Eo((BaseVo)priceItemAddReqDto, (BaseEo)priceItemEo);
                        long id = IdGenrator.getDistributedId();
                        priceItemEo.setId(Long.valueOf(id));
                        priceItemEo.setPriceId(priceId);
                        priceItemEo.setSkuDesc(priceItemAddReqDto.getSkuName());
                        priceItemEo.setItemPrice(priceAndNumLimitDto.getItemPrice());
                        priceItemEo.setLowerLimit(priceAndNumLimitDto.getLowerLimit());
                        priceItemEo.setUpperLimit(priceAndNumLimitDto.getUpperLimit());
                        needPriceItemList.add(priceItemEo);
                        modifyPriceLogEo = new ModifyPriceLogEo();
                        CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                        modifyPriceLogEo.setId(null);
                        modifyPriceLogEo.setApprovedTime(new Date());
                        modifyPriceLogEo.setOriginalPrice(BigDecimal.ZERO);
                        modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                        modifyPriceLogEo.setPriceTypeId(priceTypeId);
                        modifyPriceLogEo.setPriceItemId(Long.valueOf(id));
                        needModifyPriceLogList.add(modifyPriceLogEo);
                        continue;
                    }
                    for (PriceAndNumLimitDto priceNumLimitDto : priceNumLimitList) {
                        priceItemEo = new PriceItemEo();
                        DtoHelper.dto2Eo((BaseVo)priceItemAddReqDto, (BaseEo)priceItemEo);
                        long id = IdGenrator.getDistributedId();
                        priceItemEo.setId(Long.valueOf(id));
                        priceItemEo.setPriceId(priceId);
                        priceItemEo.setSkuDesc(priceItemAddReqDto.getSkuName());
                        priceItemEo.setItemPrice(priceNumLimitDto.getItemPrice());
                        priceItemEo.setLowerLimit(priceNumLimitDto.getLowerLimit());
                        priceItemEo.setUpperLimit(priceNumLimitDto.getUpperLimit());
                        needPriceItemList.add(priceItemEo);
                        modifyPriceLogEo = new ModifyPriceLogEo();
                        CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                        modifyPriceLogEo.setId(null);
                        modifyPriceLogEo.setApprovedTime(new Date());
                        modifyPriceLogEo.setOriginalPrice(BigDecimal.ZERO);
                        modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                        modifyPriceLogEo.setPriceTypeId(priceTypeId);
                        modifyPriceLogEo.setPriceItemId(Long.valueOf(id));
                        needModifyPriceLogList.add(modifyPriceLogEo);
                    }
                    continue;
                }
                priceItemEo = new PriceItemEo();
                DtoHelper.dto2Eo((BaseVo)priceItemAddReqDto, (BaseEo)priceItemEo);
                long id = IdGenrator.getDistributedId();
                priceItemEo.setId(Long.valueOf(id));
                priceItemEo.setPriceId(priceId);
                priceItemEo.setSkuDesc(priceItemAddReqDto.getSkuName());
                needPriceItemList.add(priceItemEo);
                if (CategoryCodeEnum.BASE.getCode().equals(categoryCode)) {
                    List priceTypeList = priceItemAddReqDto.getPriceTypeList();
                    for (PriceTypeDto priceTypeDto : priceTypeList) {
                        modifyPriceLogEo = new ModifyPriceLogEo();
                        CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                        modifyPriceLogEo.setId(null);
                        modifyPriceLogEo.setApprovedTime(new Date());
                        modifyPriceLogEo.setOriginalPrice(BigDecimal.ZERO);
                        modifyPriceLogEo.setPrice(priceTypeDto.getPrice());
                        modifyPriceLogEo.setPriceTypeId(priceTypeDto.getTypeId());
                        modifyPriceLogEo.setPriceItemId(Long.valueOf(id));
                        needModifyPriceLogList.add(modifyPriceLogEo);
                        GuidingPriceEo guidingPriceEo = new GuidingPriceEo();
                        guidingPriceEo.setPriceItemId(Long.valueOf(id));
                        guidingPriceEo.setPriceTypeId(priceTypeDto.getTypeId());
                        guidingPriceEo.setPrice(priceTypeDto.getPrice());
                        guidingPriceEos.add(guidingPriceEo);
                    }
                    continue;
                }
                modifyPriceLogEo = new ModifyPriceLogEo();
                CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                modifyPriceLogEo.setId(null);
                modifyPriceLogEo.setApprovedTime(new Date());
                modifyPriceLogEo.setOriginalPrice(BigDecimal.ZERO);
                modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                modifyPriceLogEo.setPriceTypeId(priceTypeId);
                modifyPriceLogEo.setPriceItemId(Long.valueOf(id));
                needModifyPriceLogList.add(modifyPriceLogEo);
            }
            if (CollectionUtils.isNotEmpty((Collection)needPriceItemList)) {
                this.priceItemDas.insertBatch((List)needPriceItemList);
            }
            if (CollectionUtils.isNotEmpty(needModifyPriceLogList)) {
                this.modifyPriceLogDas.insertBatch(needModifyPriceLogList);
            }
            if (CategoryCodeEnum.BASE.getCode().equals(categoryCode) && CollectionUtils.isNotEmpty((Collection)guidingPriceEos)) {
                this.guidingPriceDas.insertBatch((List)guidingPriceEos);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceAddOrModifyRespDto modifyPrice(PriceModifyReqDto reqDto) {
        PriceAddOrModifyRespDto validate;
        PriceAddOrModifyRespDto priceAddOrModifyRespDto = new PriceAddOrModifyRespDto();
        if (Objects.isNull(reqDto.getId())) {
            throw new BizException(PriceExceptionCode.PRICE_ID_IS_NULL.getCode(), PriceExceptionCode.PRICE_ID_IS_NULL.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getCategoryCode())) {
            throw new BizException(PriceExceptionCode.PRICE_CATEGORY_IS_NULL.getCode(), PriceExceptionCode.PRICE_CATEGORY_IS_NULL.getMsg());
        }
        PriceEo primaryPriceEo = (PriceEo)this.priceDas.selectByPrimaryKey(reqDto.getId());
        if (Objects.isNull(primaryPriceEo)) {
            throw new BizException(PriceExceptionCode.PRICE_IS_NOT_EXIST.getCode(), PriceExceptionCode.PRICE_IS_NOT_EXIST.getMsg());
        }
        reqDto.setStatus(primaryPriceEo.getStatus());
        reqDto.setCode(primaryPriceEo.getCode());
        if (PriceStatusEnum.AUDIT_PASS.getCode().equals(reqDto.getStatus())) {
            return this.addPrice((PriceBeanReqDto)reqDto);
        }
        if (PriceStatusEnum.AUDIT_REJECT.getCode().equals(reqDto.getStatus())) {
            reqDto.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        } else if (PriceStatusEnum.DRAFT.getCode().equals(reqDto.getStatus()) && !reqDto.getDraft().booleanValue()) {
            reqDto.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        }
        ValidateStrategy validateStrategy = validateMap.get(reqDto.getCategoryCode());
        if (null != validateStrategy && null != (validate = validateStrategy.validate((PriceBeanReqDto)reqDto, reqDto.getId())) && CollectionUtils.isNotEmpty((Collection)validate.getPriceOfferLimitItemRespDtos())) {
            return validate;
        }
        PriceEo priceEo = new PriceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceEo);
        this.priceDas.updateSelective((BaseEo)priceEo);
        List priceItemModifyReqDtos = reqDto.getPriceItemReqDtos();
        PriceItemEo priceItemEo = new PriceItemEo();
        priceItemEo.setPriceId(reqDto.getId());
        List priceItemEos = this.priceItemDas.select((BaseEo)priceItemEo);
        if (CollectionUtils.isNotEmpty((Collection)priceItemEos)) {
            List<PriceItemModifyReqDto> addPriceItems = priceItemModifyReqDtos.stream().filter(bean -> null == bean.getId()).collect(Collectors.toList());
            List<PriceItemModifyReqDto> updatePriceItems = priceItemModifyReqDtos.stream().filter(bean -> null != bean.getId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(updatePriceItems)) {
                boolean channelFlag;
                List<Object> collect = Lists.newArrayList();
                boolean bl = channelFlag = CategoryCodeEnum.SUPPLY_CHANNEL.getCode().equals(reqDto.getCategoryCode()) || CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode().equals(reqDto.getCategoryCode());
                if (channelFlag) {
                    for (PriceItemModifyReqDto updatePriceItem : updatePriceItems) {
                        for (PriceAndNumLimitDto priceNumLimitDto : updatePriceItem.getPriceNumLimitList()) {
                            collect.add(priceNumLimitDto.getPriceItemId());
                        }
                    }
                } else {
                    collect = updatePriceItems.stream().map(PriceItemModifyReqDto::getId).collect(Collectors.toList());
                }
                ArrayList finalCollect = collect;
                List deletePriceItems = priceItemEos.stream().filter(bean -> !finalCollect.contains(bean.getId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(deletePriceItems)) {
                    deletePriceItems.stream().forEach(bean -> {
                        this.priceItemDas.deleteById(bean.getId());
                        ModifyPriceLogEo deleteModifyPriceLogEo = new ModifyPriceLogEo();
                        deleteModifyPriceLogEo.setPriceItemId(bean.getId());
                        this.modifyPriceLogDas.delete((BaseEo)deleteModifyPriceLogEo);
                        GuidingPriceEo deleteGuidingPriceEo = new GuidingPriceEo();
                        deleteGuidingPriceEo.setPriceItemId(bean.getId());
                        this.guidingPriceDas.delete((BaseEo)deleteGuidingPriceEo);
                    });
                }
                this.updatePriceItems(updatePriceItems, reqDto.getCategoryCode(), reqDto.getTypeId(), channelFlag, collect);
            } else {
                List priceItemIds = priceItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.priceItemDas.getMapper().deleteBatchIds(priceItemIds);
                this.modifyPriceLogDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"price_item_id", priceItemIds));
                this.guidingPriceDas.getMapper().delete((Wrapper)new QueryWrapper().in((Object)"price_item_id", priceItemIds));
            }
            if (CollectionUtils.isNotEmpty(addPriceItems)) {
                this.savePriceItem(addPriceItems, reqDto.getId(), reqDto.getCategoryCode(), reqDto.getTypeId());
            }
        }
        AttachementEo queryAttachementEo = new AttachementEo();
        queryAttachementEo.setBusinessId(reqDto.getId());
        this.attachementDas.delete((BaseEo)queryAttachementEo);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getAttachementReqDtos())) {
            ArrayList attachementEoList = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)reqDto.getAttachementReqDtos(), (Collection)attachementEoList, AttachementEo.class);
            attachementEoList.stream().forEach(bean -> bean.setBusinessId(reqDto.getId()));
            this.attachementDas.insertBatch((List)attachementEoList);
        }
        CustomerConditionEo deleteCustomerConditionEo = new CustomerConditionEo();
        deleteCustomerConditionEo.setRelateId(reqDto.getId());
        deleteCustomerConditionEo.setRelateType(RelateTypeEnum.PRICE.getType());
        this.customerConditionDas.delete((BaseEo)deleteCustomerConditionEo);
        if (null != reqDto.getCustomerConditionReqDto()) {
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            CustomerConditionModifyReqDto customerConditionReqDto = reqDto.getCustomerConditionReqDto();
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerIds())) {
                customerConditionEo.setCustomerIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerTypeIds())) {
                customerConditionEo.setCustomerTypeIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerTypeIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerGroupIds())) {
                customerConditionEo.setCustomerGroupIds(StringUtils.join((Iterable)customerConditionReqDto.getCustomerGroupIds(), (String)","));
            }
            if (CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerAreaCodes())) {
                customerConditionEo.setCustomerAreaCodes(StringUtils.join((Iterable)customerConditionReqDto.getCustomerAreaCodes(), (String)","));
            }
            customerConditionEo.setRelateId(reqDto.getId());
            customerConditionEo.setRelateType(RelateTypeEnum.PRICE.getType());
            this.customerConditionDas.insert((BaseEo)customerConditionEo);
        }
        return priceAddOrModifyRespDto;
    }

    private void updatePriceItems(List<PriceItemModifyReqDto> updatePriceItems, String categoryCode, Long priceTypeId, boolean channelFlag, List<Long> originPriceItemIds) {
        Map<Object, Object> priceTypeListMap = new HashMap();
        if (CategoryCodeEnum.BASE.getCode().equals(categoryCode)) {
            priceTypeListMap = updatePriceItems.stream().collect(Collectors.toMap(PriceItemModifyReqDto::getId, PriceItemModifyReqDto::getPriceTypeList, (v1, v2) -> v2));
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        PriceItemEo queryItemEo = new PriceItemEo();
        sqlFilters.add(SqlFilter.in((String)"id", originPriceItemIds));
        queryItemEo.setSqlFilters(sqlFilters);
        List priceItemEos = this.priceItemDas.select((BaseEo)queryItemEo);
        Map<Long, List<PriceItemEo>> priceItemEoMap = priceItemEos.stream().collect(Collectors.groupingBy(BaseEo::getId));
        ArrayList priceItemEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(updatePriceItems, (Collection)priceItemEoList, PriceItemEo.class);
        ArrayList guidingPriceEos = Lists.newArrayList();
        for (PriceItemModifyReqDto updatePriceItem : updatePriceItems) {
            ModifyPriceLogEo modifyPriceLogEo;
            PriceItemEo priceItemEo;
            if (channelFlag) {
                List priceNumLimitList = updatePriceItem.getPriceNumLimitList();
                PriceAndNumLimitDto priceAndNumLimitDto = (PriceAndNumLimitDto)priceNumLimitList.get(0);
                if (Objects.nonNull(priceAndNumLimitDto.getUpperLimit()) && priceAndNumLimitDto.getUpperLimit() == -1) {
                    priceItemEo = new PriceItemEo();
                    DtoHelper.dto2Eo((BaseVo)updatePriceItem, (BaseEo)priceItemEo);
                    priceItemEo.setItemPrice(priceAndNumLimitDto.getItemPrice());
                    priceItemEo.setLowerLimit(priceAndNumLimitDto.getLowerLimit());
                    priceItemEo.setUpperLimit(priceAndNumLimitDto.getUpperLimit());
                    this.priceItemDas.updateSelective((BaseEo)priceItemEo);
                    List<PriceItemEo> tempPriceItemEos = priceItemEoMap.get(priceItemEo.getId());
                    if (!CollectionUtils.isNotEmpty((Collection)tempPriceItemEos)) continue;
                    PriceItemEo tempPriceItemEo = (PriceItemEo)tempPriceItemEos.get(0);
                    if (null == priceItemEo.getItemPrice() || priceItemEo.getItemPrice().compareTo(tempPriceItemEo.getItemPrice()) == 0) continue;
                    modifyPriceLogEo = new ModifyPriceLogEo();
                    CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                    modifyPriceLogEo.setId(null);
                    modifyPriceLogEo.setApprovedTime(new Date());
                    modifyPriceLogEo.setOriginalPrice(tempPriceItemEo.getItemPrice());
                    modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                    modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
                    modifyPriceLogEo.setPriceTypeId(priceTypeId);
                    this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
                    continue;
                }
                for (PriceAndNumLimitDto priceNumLimitDto : priceNumLimitList) {
                    if (Objects.nonNull(priceAndNumLimitDto.getPriceItemId())) {
                        priceItemEo = new PriceItemEo();
                        DtoHelper.dto2Eo((BaseVo)updatePriceItem, (BaseEo)priceItemEo);
                        priceItemEo.setItemPrice(priceNumLimitDto.getItemPrice());
                        priceItemEo.setLowerLimit(priceNumLimitDto.getLowerLimit());
                        priceItemEo.setUpperLimit(priceNumLimitDto.getUpperLimit());
                        priceItemEo.setId(priceNumLimitDto.getPriceItemId());
                        this.priceItemDas.updateSelective((BaseEo)priceItemEo);
                        List<PriceItemEo> tempPriceItemEos = priceItemEoMap.get(priceItemEo.getId());
                        if (!CollectionUtils.isNotEmpty(tempPriceItemEos)) continue;
                        PriceItemEo tempPriceItemEo = tempPriceItemEos.get(0);
                        if (null == priceItemEo.getItemPrice() || priceItemEo.getItemPrice().compareTo(tempPriceItemEo.getItemPrice()) == 0) continue;
                        modifyPriceLogEo = new ModifyPriceLogEo();
                        CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                        modifyPriceLogEo.setId(null);
                        modifyPriceLogEo.setApprovedTime(new Date());
                        modifyPriceLogEo.setOriginalPrice(tempPriceItemEo.getItemPrice());
                        modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                        modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
                        modifyPriceLogEo.setPriceTypeId(priceTypeId);
                        this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
                        continue;
                    }
                    priceItemEo = new PriceItemEo();
                    DtoHelper.dto2Eo((BaseVo)updatePriceItem, (BaseEo)priceItemEo);
                    priceItemEo.setItemPrice(priceNumLimitDto.getItemPrice());
                    priceItemEo.setLowerLimit(priceNumLimitDto.getLowerLimit());
                    priceItemEo.setUpperLimit(priceNumLimitDto.getUpperLimit());
                    this.priceItemDas.insert((BaseEo)priceItemEo);
                    modifyPriceLogEo = new ModifyPriceLogEo();
                    CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                    modifyPriceLogEo.setId(null);
                    modifyPriceLogEo.setApprovedTime(new Date());
                    modifyPriceLogEo.setOriginalPrice(BigDecimal.ZERO);
                    modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
                    modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
                    modifyPriceLogEo.setPriceTypeId(priceTypeId);
                    this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
                }
                continue;
            }
            priceItemEo = new PriceItemEo();
            DtoHelper.dto2Eo((BaseVo)updatePriceItem, (BaseEo)priceItemEo);
            this.priceItemDas.updateSelective((BaseEo)priceItemEo);
            List priceTypeDtos = (List)priceTypeListMap.get(priceItemEo.getId());
            if (CollectionUtils.isNotEmpty((Collection)priceTypeDtos)) {
                for (PriceTypeDto priceTypeDto : priceTypeDtos) {
                    GuidingPriceEo guidingPriceEo = new GuidingPriceEo();
                    guidingPriceEo.setPriceItemId(priceItemEo.getId());
                    guidingPriceEo.setPriceTypeId(priceTypeDto.getTypeId());
                    GuidingPriceEo guidingPriceEoLog = (GuidingPriceEo)this.guidingPriceDas.selectOne((BaseEo)guidingPriceEo);
                    if (Objects.nonNull(guidingPriceEoLog)) {
                        if (null != priceTypeDto.getPrice() && null != guidingPriceEoLog.getPrice() && priceTypeDto.getPrice().compareTo(guidingPriceEoLog.getPrice()) != 0) {
                            modifyPriceLogEo = new ModifyPriceLogEo();
                            CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                            modifyPriceLogEo.setId(null);
                            modifyPriceLogEo.setApprovedTime(new Date());
                            modifyPriceLogEo.setOriginalPrice(guidingPriceEoLog.getPrice());
                            modifyPriceLogEo.setPrice(priceTypeDto.getPrice());
                            modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
                            modifyPriceLogEo.setPriceTypeId(priceTypeDto.getTypeId());
                            if (null != priceTypeDto.getPrice()) {
                                this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
                            }
                        }
                    } else {
                        modifyPriceLogEo = new ModifyPriceLogEo();
                        CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
                        modifyPriceLogEo.setId(null);
                        modifyPriceLogEo.setApprovedTime(new Date());
                        modifyPriceLogEo.setOriginalPrice(guidingPriceEoLog.getPrice());
                        modifyPriceLogEo.setPrice(priceTypeDto.getPrice());
                        modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
                        modifyPriceLogEo.setPriceTypeId(priceTypeDto.getTypeId());
                        if (null != priceTypeDto.getPrice()) {
                            this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
                        }
                    }
                    guidingPriceEo.setPrice(priceTypeDto.getPrice());
                    guidingPriceEos.add(guidingPriceEo);
                }
            }
            if (CategoryCodeEnum.BASE.getCode().equals(categoryCode)) {
                GuidingPriceEo deleteGuidingPriceEo = new GuidingPriceEo();
                deleteGuidingPriceEo.setPriceItemId(priceItemEo.getId());
                this.guidingPriceDas.delete((BaseEo)deleteGuidingPriceEo);
                continue;
            }
            List<PriceItemEo> tempPriceItemEos = priceItemEoMap.get(priceItemEo.getId());
            if (!CollectionUtils.isNotEmpty(tempPriceItemEos)) continue;
            PriceItemEo tempPriceItemEo = tempPriceItemEos.get(0);
            if (null == priceItemEo.getItemPrice() || priceItemEo.getItemPrice().compareTo(tempPriceItemEo.getItemPrice()) == 0) continue;
            modifyPriceLogEo = new ModifyPriceLogEo();
            CubeBeanUtils.copyProperties((Object)modifyPriceLogEo, (Object)priceItemEo, (String[])new String[0]);
            modifyPriceLogEo.setId(null);
            modifyPriceLogEo.setApprovedTime(new Date());
            modifyPriceLogEo.setOriginalPrice(tempPriceItemEo.getItemPrice());
            modifyPriceLogEo.setPrice(priceItemEo.getItemPrice());
            modifyPriceLogEo.setPriceItemId(priceItemEo.getId());
            modifyPriceLogEo.setPriceTypeId(priceTypeId);
            if (null == priceItemEo.getItemPrice()) continue;
            this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)guidingPriceEos)) {
            this.guidingPriceDas.insertBatch((List)guidingPriceEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePrice(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.priceDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public PriceRespDto queryPriceById(Long id) {
        AuditRespDto auditLastOne;
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(id);
        if (priceEo == null) {
            return null;
        }
        PriceRespDto priceRespDto = new PriceRespDto();
        DtoHelper.eo2Dto((BaseEo)priceEo, (BaseVo)priceRespDto);
        if (Objects.nonNull(priceEo.getTypeId())) {
            PriceTypeEo priceTypeEo = (PriceTypeEo)this.priceTypeDas.selectByPrimaryKey(priceEo.getTypeId());
            priceRespDto.setTypeName(priceTypeEo.getTypeName());
        }
        PriceItemEo priceItemEo = new PriceItemEo();
        priceItemEo.setPriceId(priceEo.getId());
        List priceItemEos = this.priceItemDas.select((BaseEo)priceItemEo);
        if (CollectionUtils.isNotEmpty((Collection)priceItemEos)) {
            ArrayList priceItemRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)priceItemEos, (Collection)priceItemRespDtos, PriceItemRespDto.class);
            List<PriceItemRespDto> newPriceItemList = this.createPriceItemRespDtos(priceItemRespDtos, priceEo.getCategoryCode());
            priceRespDto.setPriceItemRespDtos(newPriceItemList);
            this.createPriceTypeList(newPriceItemList, priceEo.getCategoryCode());
        }
        PriceItemConditionRespDto priceItemConditionRespDto = this.priceItemConditionService.queryByRelateIdAndType(priceEo.getId(), RelateTypeEnum.PRICE.getType());
        priceRespDto.setPriceItemConditionRespDto(priceItemConditionRespDto);
        if (priceEo.getRelationItemType() == Integer.valueOf(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            List priceBrandEos = ((ExtQueryChainWrapper)this.priceBrandDas.filter().eq((Object)"price_id", (Object)priceEo.getId())).list();
            ArrayList priceBrandRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)priceBrandRespDtos, (Collection)priceBrandEos, PriceBrandRespDto.class);
            priceRespDto.setPriceBrandRespDtos((List)priceBrandRespDtos);
            List<PriceRejectItemRespDto> priceRejectItemRespDtos = this.priceRejectItemService.queryByRelateIdAndType(priceEo.getId(), RelateTypeEnum.PRICE.getType());
            priceRespDto.setPriceRejectItemRespDtoList(priceRejectItemRespDtos);
        }
        if (priceEo.getRelationCustomerType() == Integer.valueOf(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType())) {
            List<PriceRejectCustomerRespDto> priceRejectCustomerRespDtos = this.priceRejectCustomerService.queryByRelateIdAndType(priceEo.getId(), RelateTypeEnum.PRICE.getType());
            priceRespDto.setPriceRejectCustomerRespDtoList(priceRejectCustomerRespDtos);
        }
        CustomerConditionEo queryCustomerConditionEo = new CustomerConditionEo();
        queryCustomerConditionEo.setRelateId(priceEo.getId());
        queryCustomerConditionEo.setRelateType(RelateTypeEnum.PRICE.getType());
        List customerConditionEos = this.customerConditionDas.select((BaseEo)queryCustomerConditionEo);
        if (CollectionUtils.isNotEmpty((Collection)customerConditionEos)) {
            CustomerConditionEo customerConditionEo = (CustomerConditionEo)customerConditionEos.get(0);
            CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerTypeIds())) {
                ArrayList<String> customerTypeIds = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerTypeIds().split(",")));
                customerConditionRespDto.setCustomerTypeIds(customerTypeIds);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerGroupIds())) {
                ArrayList<String> customerGroupIds = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerGroupIds().split(",")));
                customerConditionRespDto.setCustomerGroupIds(customerGroupIds);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerAreaCodes())) {
                ArrayList<String> customerAreaCodes = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerAreaCodes().split(",")));
                customerConditionRespDto.setCustomerAreaCodes(customerAreaCodes);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerAreaCodeExt())) {
                ArrayList<String> customerAreaCodeExts = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerAreaCodeExt().split(",")));
                customerConditionRespDto.setCustomerAreaCodeExts(customerAreaCodeExts);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerIds())) {
                String[] customerIds = customerConditionEo.getCustomerIds().split(",");
                customerConditionRespDto.setCustomerIds(Arrays.asList(customerIds));
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                List ids = Arrays.asList(customerIds).stream().map(bean -> Long.parseLong(bean)).collect(Collectors.toList());
                customerSearchReqDto.setIdList(ids);
                RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(1000));
                if (null != pageInfoRestResponse && null != pageInfoRestResponse.getData()) {
                    ArrayList customerInfoDtos = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)customerInfoDtos, (Collection)((PageInfo)pageInfoRestResponse.getData()).getList(), CustomerInfoDto.class);
                    customerConditionRespDto.setCustomerInfoDtos((List)customerInfoDtos);
                }
            }
            priceRespDto.setCustomerConditionRespDto(customerConditionRespDto);
        }
        if (Objects.nonNull(auditLastOne = this.auditService.getAuditLastOne(RelateTypeEnum.PRICE, id)) && Objects.equals(auditLastOne.getAuditStatus(), priceEo.getStatus())) {
            priceRespDto.setAuditLog(auditLastOne);
        }
        AttachementEo queryAttEo = new AttachementEo();
        queryAttEo.setBusinessId(id);
        List attachementEoList = this.attachementDas.select((BaseEo)queryAttEo);
        ArrayList attachementRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attachementEoList)) {
            DtoHelper.eoList2DtoList((Collection)attachementEoList, (Collection)attachementRespDtos, AttachementRespDto.class);
        }
        priceRespDto.setAttachementRespDtos((List)attachementRespDtos);
        return priceRespDto;
    }

    @Override
    public void buildConditionRegionNames(List<CustomerInfoDto> customerInfoDtoList) {
        ArrayList<String> regionCodeList = new ArrayList<String>();
        customerInfoDtoList.forEach(customerInfoDto -> {
            if (StringUtils.isNotBlank((CharSequence)customerInfoDto.getRegionCodes())) {
                regionCodeList.addAll(Arrays.asList(StringUtils.split((String)customerInfoDto.getRegionCodes(), (String)",")));
            }
        });
        Map<String, String> finalRegionNameMap = this.buildAreaCodeAndName(regionCodeList);
        customerInfoDtoList.forEach(customerInfoDto -> {
            if (StringUtils.isNotBlank((CharSequence)customerInfoDto.getRegionCodes())) {
                String[] regionCodes = customerInfoDto.getRegionCodes().split(",");
                StringBuilder regionNames = this.buildRegionNames(finalRegionNameMap, regionCodes);
                customerInfoDto.setRegionNames(regionNames.toString());
            }
        });
    }

    public StringBuilder buildRegionNames(Map<String, String> finalRegionNameMap, String[] regionList) {
        StringBuilder sb = new StringBuilder();
        for (String regionCode : regionList) {
            String regionName = finalRegionNameMap.get(regionCode);
            if (!StringUtils.isNotEmpty((CharSequence)regionName)) continue;
            sb.append(regionName).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public Map<String, String> buildAreaCodeAndName(List<String> regionCodeList) {
        Map<String, String> regionNameMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(regionCodeList)) {
            ArrayList sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)StringUtils.join(regionCodeList, (String)",")));
            HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>();
            filterMap.put("sqlFilters", sqlFilterList);
            filterMap.put("tenantId", this.context.tenantId());
            filterMap.put("instanceId", this.context.instanceId());
            RestResponse areaGroupRestResp = this.areaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo areaGroupPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)areaGroupRestResp);
            if (Objects.nonNull(areaGroupPageInfo)) {
                regionNameMap = areaGroupPageInfo.getList().stream().collect(Collectors.toMap(AreaGroupRespDto::getCode, AreaGroupRespDto::getName));
            }
        }
        return regionNameMap;
    }

    private List<PriceItemRespDto> createPriceItemRespDtos(List<PriceItemRespDto> priceItemRespDtos, String categoryCode) {
        if (CategoryCodeEnum.SUPPLY_CHANNEL.getCode().equals(categoryCode) || CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode().equals(categoryCode)) {
            Map<Long, List<PriceItemRespDto>> priceItemMap = priceItemRespDtos.stream().collect(Collectors.groupingBy(PriceItemRespDto::getSkuId));
            ArrayList newPriceItemList = Lists.newArrayList();
            for (Map.Entry<Long, List<PriceItemRespDto>> priceItemEntryMap : priceItemMap.entrySet()) {
                Long key = priceItemEntryMap.getKey();
                List<PriceItemRespDto> value = priceItemEntryMap.getValue();
                PriceItemRespDto priceItem = value.get(0);
                ArrayList<PriceAndNumLimitDto> priceNumLimitList = new ArrayList<PriceAndNumLimitDto>(value.size());
                for (PriceItemRespDto priceItemRespDto : value) {
                    PriceAndNumLimitDto priceNumLimitDto = new PriceAndNumLimitDto();
                    priceNumLimitDto.setItemPrice(priceItemRespDto.getItemPrice());
                    priceNumLimitDto.setPriceItemId(priceItemRespDto.getId());
                    priceNumLimitDto.setLowerLimit(priceItemRespDto.getLowerLimit());
                    priceNumLimitDto.setUpperLimit(priceItemRespDto.getUpperLimit());
                    priceNumLimitList.add(priceNumLimitDto);
                }
                priceItem.setPriceNumLimitList(priceNumLimitList);
                newPriceItemList.add(priceItem);
            }
            return newPriceItemList;
        }
        return priceItemRespDtos;
    }

    private void createPriceTypeList(List<PriceItemRespDto> priceItemRespDtos, String categoryCode) {
        if (CategoryCodeEnum.BASE.getCode().equals(categoryCode)) {
            List priceItemIds = priceItemRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            GuidingPriceEo guidingPriceEo = new GuidingPriceEo();
            sqlFilters.add(SqlFilter.in((String)"price_item_id", priceItemIds));
            guidingPriceEo.setSqlFilters(sqlFilters);
            List guidingPriceEoList = this.guidingPriceDas.select((BaseEo)guidingPriceEo);
            if (CollectionUtils.isNotEmpty((Collection)guidingPriceEoList)) {
                ArrayList<PriceTypeDto> priceTypes = new ArrayList<PriceTypeDto>(guidingPriceEoList.size());
                for (GuidingPriceEo guiding : guidingPriceEoList) {
                    PriceTypeDto priceTypeDto = new PriceTypeDto();
                    priceTypeDto.setPriceItemId(guiding.getPriceItemId());
                    priceTypeDto.setPrice(guiding.getPrice());
                    priceTypeDto.setTypeId(guiding.getPriceTypeId());
                    priceTypes.add(priceTypeDto);
                }
                Map<Long, List<PriceTypeDto>> priceTypeListMap = priceTypes.stream().collect(Collectors.groupingBy(PriceTypeDto::getPriceItemId));
                PriceTypeEo queryType = new PriceTypeEo();
                queryType.setCategoryCode(categoryCode);
                List priceTypeEos = this.priceTypeDas.select((BaseEo)queryType);
                Map<Long, String> typeNameMap = priceTypeEos.stream().collect(Collectors.toMap(BaseEo::getId, StdPriceTypeEo::getTypeName, (v1, v2) -> v2));
                List standardPriceTypeDtoList = this.priceTypeDas.queryPriceTypeByCategoryCode(CategoryCodeEnum.BASE.getCode(), this.context.tenantId(), this.context.instanceId());
                for (PriceItemRespDto priceItemRespDto : priceItemRespDtos) {
                    List<PriceTypeDto> priceTypeDtoList = priceTypeListMap.get(priceItemRespDto.getId());
                    if (!CollectionUtils.isNotEmpty(priceTypeDtoList)) continue;
                    for (PriceTypeDto typeDto : priceTypeDtoList) {
                        typeDto.setTypeName(typeNameMap.get(typeDto.getTypeId()));
                    }
                    List priceTypeIdList = priceTypeDtoList.stream().map(PriceTypeDto::getTypeId).collect(Collectors.toList());
                    List incrementPriceTypeDtoList = standardPriceTypeDtoList.stream().filter(dto -> !priceTypeIdList.contains(dto.getTypeId())).collect(Collectors.toList());
                    if (!incrementPriceTypeDtoList.isEmpty()) {
                        priceTypeDtoList.addAll(incrementPriceTypeDtoList);
                    }
                    priceItemRespDto.setPriceTypeList(priceTypeDtoList);
                    priceItemRespDto.setSkuName(priceItemRespDto.getSkuDesc());
                }
            }
        } else {
            ArrayList skuIdList = new ArrayList();
            priceItemRespDtos.forEach(itemSkuListRespDto -> {
                itemSkuListRespDto.setSkuName(itemSkuListRespDto.getSkuDesc());
                skuIdList.add(itemSkuListRespDto.getSkuId());
            });
            List priceTypeIdList = this.basePriceRelationTypeDas.selectPriceTypeIdByCategoryCode(categoryCode, this.context.tenantId(), this.context.instanceId());
            if (CollectionUtils.isNotEmpty((Collection)priceTypeIdList)) {
                List priceTypes = this.priceDas.selectPriceItemList(skuIdList, priceTypeIdList, this.context.tenantId(), this.context.instanceId());
                priceItemRespDtos.forEach(itemSkuListRespDto -> {
                    if (itemSkuListRespDto.getPriceTypeList() == null) {
                        itemSkuListRespDto.setPriceTypeList(new ArrayList());
                    }
                    priceTypes.forEach(priceTypeDto -> {
                        if (itemSkuListRespDto.getSkuId().equals(priceTypeDto.getSkuId())) {
                            itemSkuListRespDto.getPriceTypeList().add(priceTypeDto);
                        }
                    });
                });
            }
        }
    }

    @Override
    public PageInfo<PriceRespDto> queryPriceByPage(PriceQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        reqDto.setOrganizationId(this.customerHelper.getOrgId());
        List priceRespDtos = this.priceDas.selectPageList(reqDto);
        if (CollUtil.isEmpty((Collection)priceRespDtos)) {
            return PageInfo.of((List)priceRespDtos);
        }
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.PRICE;
        List<Long> idList = priceRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        List<Long> shopIdList = priceRespDtos.stream().filter(item -> Objects.nonNull(item.getShopId())).map(PriceRespDto::getShopId).collect(Collectors.toList());
        Map<Long, String> shopNameMap = this.shopHelper.getShopNameMap(shopIdList);
        Map<Long, AuditRespDto> auditLastOneMap = this.auditService.getAuditLastOneMap(relateTypeEnum, idList);
        Map<Long, Integer> rejectCustomerCountMap = this.priceRejectCustomerService.getRejectCustomerCountMap(relateTypeEnum, idList);
        Map<Long, Integer> rejectItemCountMap = this.priceRejectItemService.getRejectItemCountMap(relateTypeEnum, idList);
        Map<Long, PriceItemConditionRespDto> priceItemConditionMap = this.priceItemConditionService.getPriceItemConditionMap(relateTypeEnum, idList);
        Map<Long, CustomerConditionRespDto> priceCustomerConditionMap = this.customerConditionService.getPriceCustomerConditionMap(relateTypeEnum, idList);
        for (PriceRespDto priceRespDto : priceRespDtos) {
            Long id = priceRespDto.getId();
            priceRespDto.setStatus(PriceStatusUtils.convertStatus(priceRespDto.getStatus(), priceRespDto.getEffectiveTime(), priceRespDto.getInvalidTime()));
            if (Objects.nonNull(priceRespDto.getShopId()) && shopNameMap.containsKey(priceRespDto.getShopId())) {
                priceRespDto.setShopName(shopNameMap.get(priceRespDto.getShopId()));
            }
            if (auditLastOneMap.containsKey(id)) {
                priceRespDto.setAuditLog(auditLastOneMap.get(id));
            }
            priceRespDto.setRejectCustomerCount(rejectCustomerCountMap.getOrDefault(id, 0));
            priceRespDto.setRejectItemCount(rejectItemCountMap.getOrDefault(id, 0));
            priceRespDto.setPriceItemConditionRespDto(priceItemConditionMap.get(id));
            priceRespDto.setCustomerConditionRespDto(priceCustomerConditionMap.get(id));
        }
        return PageInfo.of((List)priceRespDtos);
    }

    @Override
    public void cancelPrice(Long id) {
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(id);
        if (null == priceEo) {
            throw new BizException(PriceExceptionCode.PRICE_IS_NOT_EXIST.getCode(), PriceExceptionCode.PRICE_IS_NOT_EXIST.getMsg());
        }
        priceEo.setStatus(PriceStatusEnum.INVALID.getCode());
        this.priceDas.updateSelective((BaseEo)priceEo);
        this.pricePolicyEsService.updatePriceStatus(id, PriceStatusEnum.INVALID.getCode());
    }

    @Override
    public void auditPrice(PriceAuditReqDto reqDto) {
        if (Objects.isNull(reqDto.getPriceId())) {
            throw new BizException(PriceExceptionCode.PRICE_ID_IS_NULL.getCode(), PriceExceptionCode.PRICE_ID_IS_NULL.getMsg());
        }
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(reqDto.getPriceId());
        if (null == priceEo) {
            throw new BizException(PriceExceptionCode.PRICE_IS_NOT_EXIST.getCode(), PriceExceptionCode.PRICE_IS_NOT_EXIST.getMsg());
        }
        if (AuditStatusEnum.PASS.getCode().equals(reqDto.getAuditStatus())) {
            priceEo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
            PriceEo queryEo = new PriceEo();
            queryEo.setCode(priceEo.getCode());
            List select = this.priceDas.select((BaseEo)queryEo);
            if (select.size() > 1) {
                queryEo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
                List needOriPrice = this.priceDas.select((BaseEo)queryEo);
                PriceEo oriPrice = (PriceEo)needOriPrice.get(0);
                oriPrice.setStatus(PriceStatusEnum.CHANGED.getCode());
                this.priceDas.updateSelective((BaseEo)oriPrice);
                this.pricePolicyEsService.updatePriceStatus(oriPrice.getId(), PriceStatusEnum.CHANGED.getCode());
            }
        } else {
            priceEo.setStatus(PriceStatusEnum.AUDIT_REJECT.getCode());
        }
        this.priceDas.updateSelective((BaseEo)priceEo);
        if (PriceStatusEnum.AUDIT_PASS.getCode().equals(priceEo.getStatus())) {
            this.pricePolicyEsService.updatePricePolicy(reqDto.getPriceId());
        }
        AuditEo auditEo = new AuditEo();
        auditEo.setAuditPerson(this.context.userName());
        auditEo.setAuditTime(new Date());
        auditEo.setAuditComments(reqDto.getAuditDesc());
        auditEo.setRelateType("0");
        auditEo.setRelateId(reqDto.getPriceId());
        this.auditDas.insert((BaseEo)auditEo);
    }

    @Override
    public void submit(Long id) {
        PriceRespDto priceRespDto = this.queryPriceById(id);
        PriceModifyReqDto reqDto = new PriceModifyReqDto();
        reqDto.setAttachementReqDtos(new ArrayList());
        reqDto.setPriceItemReqDtos(new ArrayList());
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)priceRespDto, (String[])new String[0]);
        reqDto.setDraft(Boolean.valueOf(false));
        reqDto.setId(id);
        if (priceRespDto.getCustomerConditionRespDto() != null) {
            CustomerConditionRespDto source = priceRespDto.getCustomerConditionRespDto();
            CustomerConditionModifyReqDto target = new CustomerConditionModifyReqDto();
            target.setCustomerAreaCodes(new ArrayList());
            target.setCustomerGroupIds(new ArrayList());
            target.setCustomerTypeIds(new ArrayList());
            target.setCustomerIds(new ArrayList());
            BeanUtils.copyProperties((Object)source, (Object)target);
            if (source.getCustomerIds() != null && source.getCustomerIds().size() > 0) {
                target.setCustomerIds(source.getCustomerIds());
            }
            if (source.getCustomerAreaCodes() != null && source.getCustomerAreaCodes().size() > 0) {
                target.setCustomerAreaCodes(source.getCustomerAreaCodes());
            }
            if (source.getCustomerTypeIds() != null && source.getCustomerTypeIds().size() > 0) {
                target.setCustomerTypeIds(source.getCustomerTypeIds());
            }
            if (source.getCustomerGroupIds() != null && source.getCustomerGroupIds().size() > 0) {
                target.setCustomerGroupIds(source.getCustomerGroupIds());
            }
            reqDto.setCustomerConditionReqDto(target);
        }
        if (priceRespDto.getPriceItemRespDtos() != null && priceRespDto.getPriceItemRespDtos().size() > 0) {
            ArrayList priceItemReqDtos = new ArrayList();
            CubeBeanUtils.copyCollection(priceItemReqDtos, (Collection)priceRespDto.getPriceItemRespDtos(), PriceItemModifyReqDto.class);
            reqDto.setPriceItemReqDtos(priceItemReqDtos);
        }
        this.modifyPrice(reqDto);
    }

    static {
        validateMap.put(CategoryCodeEnum.BASE.getCode(), new BasePriceValidateStrategy());
        validateMap.put(CategoryCodeEnum.INTERNAL_SETTLEMENT.getCode(), new InternalSettlementPriceValidateStrategy());
        validateMap.put(CategoryCodeEnum.SUPPLY_CHANNEL.getCode(), new SupplyChannelPriceValidateStrategy());
        validateMap.put(CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode(), new ChannelDistributionPriceValidateStrategy());
        validateMap.put(CategoryCodeEnum.RETAIL.getCode(), new RetailPricePriceValidateStrategy());
    }
}

