/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.AbleStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.DiscountTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAddReqV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBrandReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModifyReqV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceQueryReqV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBrandRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceInfoRespV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespV2Dto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.PriceItemSkuLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.PriceItemSkuSectionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationCustomerInfoVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationInfoVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationItemInfoVo;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceRelatedNum;
import com.dtyunxi.yundt.cube.center.price.biz.event.PriceModifyEvent;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CheckRepeatHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.PriceHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAttachementService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectCustomerService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceV2Service;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckDimensionVo;
import com.dtyunxi.yundt.cube.center.price.biz.vo.CheckRepeatInfoVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceBrandDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceModelDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectCustomerDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceBrandEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceModelEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceV2ServiceImpl
implements IPriceV2Service {
    private static final Logger logger = LoggerFactory.getLogger(PriceV2ServiceImpl.class);
    @Resource
    private PriceDas priceDas;
    @Resource
    private PriceItemDas priceItemDas;
    @Resource
    private IAttachementService attachementService;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private PriceTypeDas priceTypeDas;
    @Resource
    private PriceModelDas priceModelDas;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;
    @Resource
    private IPriceRejectItemService priceRejectItemService;
    @Resource
    private IPriceRejectCustomerService priceRejectCustomerService;
    @Resource
    private IAuditService auditService;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private PriceHelper priceHelper;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private GenerateCode<PriceEo> generateCode;
    @Resource
    private PriceRejectCustomerDas priceRejectCustomerDas;
    @Resource
    private PriceItemConditionDas priceItemConditionDas;
    @Resource
    private PriceRejectItemDas priceRejectItemDas;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Resource
    private CheckRepeatHelper checkRepeatHelper;
    @Autowired
    private PriceBrandDas priceBrandDas;
    @Autowired
    private ApplicationEventPublisher publisher;
    private static final String STR = "]\u7684sku\u7f16\u7801[";

    @Override
    public Long addPrice(PriceAddReqV2Dto reqDto) {
        return this.createPrice(reqDto, null);
    }

    private void setPriceEffectiveTime(PriceAddReqV2Dto reqDto, PriceEo price) {
        boolean effectiveStatus = reqDto.isEffectiveStatus();
        if (effectiveStatus) {
            AssertUtils.isNonNull(reqDto.getEffectiveTime(), PriceExceptionCode.INVALID_PRICE_TIME);
            price.setEffectiveTime(reqDto.getEffectiveTime());
            price.setInvalidTime(null);
        } else {
            price.setEffectiveTime(reqDto.getEffectiveTime());
            price.setInvalidTime(reqDto.getInvalidTime());
            if (Objects.isNull(reqDto.getEffectiveTime()) || Objects.isNull(reqDto.getInvalidTime()) || reqDto.getInvalidTime().getTime() < reqDto.getEffectiveTime().getTime()) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u975e\u957f\u671f\u751f\u6548\u7684\u653f\u7b56\uff0c\u9700\u8981\u8bbe\u7f6e\u5f00\u59cb\u65f6\u95f4[{}]\u4e0e\u7ed3\u675f\u65f6\u95f4[{}]\uff0c\u5e76\u4e14\u7ed3\u675f\u65f6\u95f4\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object)reqDto.getEffectiveTime(), (Object)reqDto.getInvalidTime());
                BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_PRICE_TIME);
            }
        }
    }

    private PriceEo getPrice(Long id) {
        AssertUtils.isNonNull(id, PriceExceptionCode.INVALID_PRICE);
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(id);
        return priceEo;
    }

    private PriceEo buildPrice(Long id) {
        return Objects.isNull(id) ? new PriceEo() : this.getPrice(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modifyPrice(PriceModifyReqV2Dto reqDto) {
        Long id = this.createPrice(reqDto, reqDto.getId());
        if (id != null) {
            this.publisher.publishEvent((Object)new PriceModifyEvent(id));
        }
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public <D extends PriceAddReqV2Dto> Long createPrice(D reqDto, Long id) {
        if (PriceStatusEnum.EFFECT.getCode().equals(reqDto.getStatus())) {
            reqDto.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        }
        this.verifyParam(reqDto);
        if (Objects.isNull(reqDto)) {
            return null;
        }
        PriceEo price = this.buildPrice(id);
        MybatisPlusUtils.setCommonInfo(price);
        Long orgId = this.customerHelper.getOrgId();
        Long tenantId = price.getTenantId();
        Long instanceId = price.getInstanceId();
        String relateType = RelateTypeEnum.PRICE.getType();
        Long typeId = reqDto.getTypeId();
        this.checkCondition(reqDto, id, price, orgId, typeId);
        List<PriceItemEo> priceItemList = this.getPriceItemList(orgId, reqDto.getModelId(), price, reqDto);
        RelationInfoVo relationInfoVo = new RelationInfoVo();
        Integer relationCustomerType = reqDto.getRelationCustomerType();
        CustomerConditionEo customerConditionEo = this.getCustomerConditionEo(id, relateType);
        List<Object> priceRejectCustomerlist = ListUtil.toList((Object[])new PriceRejectCustomerEo[0]);
        CustomerConditionAddReqDto customerConditionReqDto = reqDto.getCustomerConditionReqDto();
        ArrayList priceBrandEoList = Lists.newArrayList();
        RelationCustomerInfoVo relationCustomerInfo = null;
        if (Objects.equals(Integer.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()), relationCustomerType)) {
            this.checkCustomerLimit(customerConditionReqDto);
            List customerIds = customerConditionReqDto.getCustomerIds();
            customerConditionEo = this.getCustomerConditionEo(customerConditionEo);
            customerConditionEo.setCustomerIds(customerIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationCustomerInfo = new RelationCustomerInfoVo();
            relationCustomerInfo.setCustomerIdNum(Integer.valueOf(customerConditionEo.getCustomerIds().split(",").length));
        } else if (Objects.equals(Integer.valueOf(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()), relationCustomerType)) {
            AssertUtils.isNonNull(customerConditionReqDto, PriceExceptionCode.CUSTOMER_RANGE_EMPTY);
            List customerTypeIds = customerConditionReqDto.getCustomerTypeIds();
            List customerAreaCodes = customerConditionReqDto.getCustomerAreaCodes();
            List rejectCustomerIdList = reqDto.getRejectCustomerIdList();
            this.checkCustomerRangeLimit(customerTypeIds, customerAreaCodes);
            relationCustomerInfo = new RelationCustomerInfoVo();
            customerConditionEo = this.getCustomerConditionEo(customerConditionEo);
            this.buildCustomerAreaLimit(customerConditionEo, relationCustomerInfo, customerAreaCodes);
            this.buildCustomerTypeLimit(customerConditionEo, relationCustomerInfo, customerTypeIds);
            priceRejectCustomerlist = this.getPriceRejectCustomerEos(price, relateType, priceRejectCustomerlist, relationCustomerInfo, rejectCustomerIdList);
        }
        Integer relationItemType = reqDto.getRelationItemType();
        PriceItemConditionEo priceItemConditionEo = this.getPriceItemConditionEo(id, relateType);
        List<Object> priceRejectItemList = ListUtil.toList((Object[])new PriceRejectItemEo[0]);
        PriceItemConditionAddReqDto itemConditionReqDto = reqDto.getItemConditionReqDto();
        RelationItemInfoVo relationItemInfoVo = null;
        if (Objects.equals(Integer.valueOf(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()), relationItemType)) {
            this.checkItemLimit(priceItemList, itemConditionReqDto);
            List<String> skuIds = this.getSkuIdList(priceItemList, itemConditionReqDto);
            priceItemConditionEo = this.getPriceItemConditionEo(priceItemConditionEo);
            priceItemConditionEo.setSkuIds(skuIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationItemInfoVo = new RelationItemInfoVo();
            relationItemInfoVo.setSkuIdNum(Integer.valueOf(priceItemConditionEo.getSkuIds().split(",").length));
            priceItemList = this.getPriceItemEos(reqDto, priceItemList, priceItemConditionEo);
        } else if (Objects.equals(Integer.valueOf(ItemDimensionEnum.ITEM_RANGE_ENUM.getType()), relationItemType)) {
            AssertUtils.isNonNull(itemConditionReqDto, PriceExceptionCode.ITEM_RANGE_EMPTY);
            List itemBackDirIds = itemConditionReqDto.getItemBackDirIds();
            List itemTypes = itemConditionReqDto.getItemTypes();
            List priceBrandReqDtos = Optional.ofNullable(itemConditionReqDto.getPriceBrandReqDtos()).orElse(Lists.newArrayList());
            List<String> itemBrandIds = priceBrandReqDtos.stream().map(e -> e.getBrandId() + "").collect(Collectors.toList());
            CubeBeanUtils.copyCollection((Collection)priceBrandEoList, (Collection)priceBrandReqDtos, PriceBrandEo.class);
            List rejectItemSkuIdList = reqDto.getRejectItemSkuIdList();
            this.checkItemRangeLimit(itemBackDirIds, itemTypes, itemBrandIds);
            priceItemConditionEo = this.getPriceItemConditionEo(priceItemConditionEo);
            relationItemInfoVo = new RelationItemInfoVo();
            this.buildItemDirLimit(priceItemConditionEo, relationItemInfoVo, itemBackDirIds);
            this.buildItemTypeLimit(priceItemConditionEo, relationItemInfoVo, itemTypes);
            this.buildItemBrandLimit(priceItemConditionEo, relationItemInfoVo, itemBrandIds);
            priceRejectItemList = this.getPriceRejectItemEos(orgId, tenantId, instanceId, relateType, priceRejectItemList, relationItemInfoVo, rejectItemSkuIdList);
        }
        List<AttachementAddReqDto> attachementList = this.attachementService.convertAttachementDto(reqDto.getAttachementList(), tenantId, instanceId);
        this.setPriceEffectiveTime(reqDto, price);
        relationInfoVo.setRelationCustomerInfo(relationCustomerInfo);
        relationInfoVo.setRelationItemInfo(relationItemInfoVo);
        price.setName(reqDto.getName());
        price.setShopId(reqDto.getShopId());
        price.setStatus(reqDto.getStatus());
        price.setModelId(reqDto.getModelId());
        price.setRelationCustomerType(relationCustomerType);
        price.setRelationItemType(relationItemType);
        price.setTypeId(typeId);
        price.setExtension(JSON.toJsonString((Object)relationInfoVo));
        price.setRemark(reqDto.getRemark());
        if (Objects.isNull(price.getOrganizationId())) {
            price.setOrganizationId(orgId);
        }
        this.checkDimension(price, customerConditionEo, priceItemConditionEo, reqDto.getOriginalPriceId());
        if (reqDto.getOriginalPriceId() != null) {
            PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(reqDto.getOriginalPriceId());
            price.setFirstPriceId(priceEo != null && priceEo.getFirstPriceId() != null ? priceEo.getFirstPriceId() : reqDto.getOriginalPriceId());
        }
        if (Objects.isNull(id)) {
            PriceEo waitAuditPriceEo;
            if (reqDto.getOriginalPriceId() != null && (waitAuditPriceEo = (PriceEo)((ExtQueryChainWrapper)this.priceDas.filter().select(new String[]{"id", "code"}).eq((Object)"original_price_id", (Object)reqDto.getOriginalPriceId())).one()) != null) {
                throw new BizException("\u8be5\u4ef7\u683c\u653f\u7b56\u5b58\u5728\u88ab\u4fee\u6539\u7684\u4ef7\u683c\u653f\u7b56\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u6539,\u4ef7\u683c\u653f\u7b56\uff1a" + waitAuditPriceEo.getCode());
            }
            price.setOriginalPriceId(reqDto.getOriginalPriceId());
            price.setDr(PriceCommonEnum.Dr.VALID.getCode());
            price.setTenantId(tenantId);
            price.setInstanceId(instanceId);
            price.setCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGZC));
            this.priceDas.insert((BaseEo)price);
            id = price.getId();
            if (price.getFirstPriceId() == null) {
                price.setFirstPriceId(id);
                this.priceDas.updateSelective((BaseEo)price);
            }
            this.saveRelatedNum(price);
        } else {
            this.priceDas.update((BaseEo)price);
        }
        this.saveAttachement(id, price, attachementList);
        this.savePriceCustomerCondition(id, price, relateType, customerConditionEo);
        this.savePriceRejectCustomer(id, price, relateType, priceRejectCustomerlist);
        this.savePriceItemCondition(id, price, relateType, priceItemList, priceItemConditionEo);
        this.saveItemBrands(id, priceBrandEoList);
        this.savePriceRejectItem(id, price, relateType, priceRejectItemList);
        this.savePriceItem(id, price, priceItemList);
        this.pricePolicyEsService.updatePricePolicy(price.getId());
        return price.getId();
    }

    private void saveItemBrands(Long id, List<PriceBrandEo> priceBrandEoList) {
        if (id != null) {
            PriceBrandEo priceBrandEo = new PriceBrandEo();
            priceBrandEo.setPriceId(id);
            this.priceBrandDas.logicDeleteByExample((BaseEo)priceBrandEo);
        }
        if (CollectionUtil.isNotEmpty(priceBrandEoList)) {
            for (PriceBrandEo eo : priceBrandEoList) {
                eo.setId(null);
                eo.setPriceId(id);
            }
            this.priceBrandDas.insertBatch(priceBrandEoList);
        }
    }

    private <D extends PriceAddReqV2Dto> void verifyParam(D reqDto) {
        block13: {
            PriceModelEo priceModelEo;
            block14: {
                block12: {
                    priceModelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(reqDto.getModelId());
                    logger.info("[\u65b0\u589e\u7b56\u7565\u6821\u9a8c]\uff0c\u5f53\u524d\u4ef7\u683c\u6a21\u578b\u914d\u7f6e\uff1a{}", (Object)JSON.toJsonString((Object)priceModelEo));
                    AssertUtils.isNonNull(priceModelEo, PriceExceptionCode.PRICE_MODULE_IS_EMPTY);
                    if (!Objects.equals(1, reqDto.getRelationItemType())) break block12;
                    AssertUtils.isTrue(Objects.equals(priceModelEo.getDiscountSet(), 1), PriceExceptionCode.DISCOUNT_SET_NOT_ENABLE);
                    if (CollectionUtil.isNotEmpty((Collection)reqDto.getItemConditionReqDto().getPriceBrandReqDtos())) {
                        for (PriceBrandReqDto priceBrandReqDto : reqDto.getItemConditionReqDto().getPriceBrandReqDtos()) {
                            if (priceBrandReqDto.getBrandId() == null) {
                                throw new BizException("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            if (priceBrandReqDto.getBrandName() == null) {
                                throw new BizException("\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            if (priceBrandReqDto.getDiscountType() == null) {
                                throw new BizException("\u6298\u6263\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            if (Objects.equals(reqDto.getDiscountType(), DiscountTypeEnum.FIXED_DISCOUNT.getType())) {
                                AssertUtils.isTrue(Objects.equals(priceModelEo.getFixedDiscount(), 1), PriceExceptionCode.FIXED_DISCOUNT_NOT_ENABLE);
                            }
                            if (!Objects.equals(reqDto.getDiscountType(), DiscountTypeEnum.TEMPORARY_DISCOUNT.getType())) continue;
                            AssertUtils.isTrue(Objects.equals(priceModelEo.getTemporaryDiscount(), 1), PriceExceptionCode.TEMPORARY_DISCOUNT_NOT_ENABLE);
                        }
                    } else if (reqDto.getDiscountType() == null) {
                        throw new BizException("\u6298\u6263\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    break block13;
                }
                if (!Objects.equals(2, reqDto.getRelationItemType())) break block14;
                AssertUtils.isTrue(Objects.equals(priceModelEo.getDiscountSet(), 1), PriceExceptionCode.DISCOUNT_SET_NOT_ENABLE);
                if (Objects.equals(reqDto.getDiscountType(), DiscountTypeEnum.FIXED_DISCOUNT.getType())) {
                    AssertUtils.isTrue(Objects.equals(priceModelEo.getFixedDiscount(), 1), PriceExceptionCode.FIXED_DISCOUNT_NOT_ENABLE);
                }
                if (!Objects.equals(reqDto.getDiscountType(), DiscountTypeEnum.TEMPORARY_DISCOUNT.getType())) break block13;
                AssertUtils.isTrue(Objects.equals(priceModelEo.getTemporaryDiscount(), 1), PriceExceptionCode.TEMPORARY_DISCOUNT_NOT_ENABLE);
                break block13;
            }
            for (ItemPriceReqDto itemPriceReqDto : reqDto.getPriceItemList()) {
                if (Objects.equals(itemPriceReqDto.getPriceModelSetType(), 0)) {
                    AssertUtils.isTrue(Objects.equals(priceModelEo.getDirectSet(), 1), PriceExceptionCode.DIRECT_SET_NOT_ENABLE);
                    AssertUtils.isNonNull((Object)itemPriceReqDto.getItemPrice(), "\u76f4\u63a5\u5b9a\u4ef7\uff0c\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
                }
                if (!Objects.equals(itemPriceReqDto.getPriceModelSetType(), 1)) continue;
                AssertUtils.isTrue(Objects.equals(priceModelEo.getDiscountSet(), 1), PriceExceptionCode.DISCOUNT_SET_NOT_ENABLE);
                if (Objects.equals(itemPriceReqDto.getDiscountType(), DiscountTypeEnum.FIXED_DISCOUNT.getType())) {
                    AssertUtils.isTrue(Objects.equals(priceModelEo.getFixedDiscount(), 1), PriceExceptionCode.FIXED_DISCOUNT_NOT_ENABLE);
                }
                if (!Objects.equals(reqDto.getDiscountType(), DiscountTypeEnum.TEMPORARY_DISCOUNT.getType())) continue;
                AssertUtils.isTrue(Objects.equals(priceModelEo.getTemporaryDiscount(), 1), PriceExceptionCode.TEMPORARY_DISCOUNT_NOT_ENABLE);
            }
        }
    }

    private PriceItemConditionEo getPriceItemConditionEo(PriceItemConditionEo priceItemConditionEo) {
        if (Objects.isNull(priceItemConditionEo)) {
            priceItemConditionEo = new PriceItemConditionEo();
        }
        return priceItemConditionEo;
    }

    private CustomerConditionEo getCustomerConditionEo(CustomerConditionEo customerConditionEo) {
        if (Objects.isNull(customerConditionEo)) {
            customerConditionEo = new CustomerConditionEo();
        }
        return customerConditionEo;
    }

    private void checkItemRangeLimit(List<String> itemBackDirIds, List<String> itemTypes, List<String> itemBrandIds) {
        AssertUtils.isFalse(CollUtil.isEmpty(itemBackDirIds) && CollUtil.isEmpty(itemTypes) && CollUtil.isEmpty(itemBrandIds), PriceExceptionCode.ITEM_RANGE_EMPTY);
    }

    private void checkItemLimit(List<PriceItemEo> priceItemList, PriceItemConditionAddReqDto itemConditionReqDto) {
        AssertUtils.isFalse(CollUtil.isEmpty(priceItemList) && (Objects.isNull(itemConditionReqDto) || CollUtil.isEmpty((Collection)itemConditionReqDto.getSkuIds())), PriceExceptionCode.INVALID_ITEM_DATA);
    }

    private void checkCustomerRangeLimit(List<String> customerTypeIds, List<String> customerAreaCodes) {
        AssertUtils.isFalse(CollUtil.isEmpty(customerTypeIds) && CollUtil.isEmpty(customerAreaCodes), PriceExceptionCode.CUSTOMER_RANGE_EMPTY);
    }

    private void checkCustomerLimit(CustomerConditionAddReqDto customerConditionReqDto) {
        AssertUtils.isFalse(Objects.isNull(customerConditionReqDto) || CollUtil.isEmpty((Collection)customerConditionReqDto.getCustomerIds()), PriceExceptionCode.CUSTOMER_IS_NULL);
    }

    private List<PriceRejectItemEo> getPriceRejectItemEos(Long orgId, Long tenantId, Long instanceId, String relateType, List<PriceRejectItemEo> priceRejectItemList, RelationItemInfoVo relationItemInfoVo, List<Long> rejectItemSkuIdList) {
        if (CollUtil.isNotEmpty(rejectItemSkuIdList)) {
            Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMap(rejectItemSkuIdList);
            priceRejectItemList = rejectItemSkuIdList.stream().map(skuId -> {
                PriceRejectItemEo priceRejectItemEo = new PriceRejectItemEo();
                priceRejectItemEo.setSkuId(skuId);
                priceRejectItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
                priceRejectItemEo.setRelateType(relateType);
                priceRejectItemEo.setInstanceId(instanceId);
                priceRejectItemEo.setTenantId(tenantId);
                priceRejectItemEo.setOrganizationId(orgId);
                if (skuQueryRespDtoMap.containsKey(skuId)) {
                    ItemSkuQueryRespDto itemSkuQueryRespDto = (ItemSkuQueryRespDto)skuQueryRespDtoMap.get(skuId);
                    priceRejectItemEo.setItemName(itemSkuQueryRespDto.getItemName());
                    priceRejectItemEo.setItemOrgId(itemSkuQueryRespDto.getItemOrgId());
                    priceRejectItemEo.setItemCode(itemSkuQueryRespDto.getItemCode());
                    priceRejectItemEo.setItemType(Objects.isNull(itemSkuQueryRespDto.getSubType()) ? null : String.valueOf(itemSkuQueryRespDto.getSubType()));
                }
                return priceRejectItemEo;
            }).collect(Collectors.toList());
            relationItemInfoVo.setRejectItemCount(Integer.valueOf(priceRejectItemList.size()));
        }
        return priceRejectItemList;
    }

    private void buildItemBrandLimit(PriceItemConditionEo priceItemConditionEo, RelationItemInfoVo relationItemInfoVo, List<String> itemBrandIds) {
        if (CollUtil.isNotEmpty(itemBrandIds)) {
            priceItemConditionEo.setItemBrandIds(itemBrandIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationItemInfoVo.setItemBrandIdNum(Integer.valueOf(priceItemConditionEo.getItemBrandIds().split(",").length));
        } else {
            priceItemConditionEo.setItemBrandIds(null);
            priceItemConditionEo.setItemBackDirIdsExt(null);
        }
    }

    private void buildItemTypeLimit(PriceItemConditionEo priceItemConditionEo, RelationItemInfoVo relationItemInfoVo, List<String> itemTypes) {
        if (CollUtil.isNotEmpty(itemTypes)) {
            priceItemConditionEo.setItemTypes(itemTypes.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationItemInfoVo.setItemTypeNum(Integer.valueOf(priceItemConditionEo.getItemTypes().split(",").length));
        } else {
            priceItemConditionEo.setItemTypes(null);
        }
    }

    private void buildItemDirLimit(PriceItemConditionEo priceItemConditionEo, RelationItemInfoVo relationItemInfoVo, List<String> itemBackDirIds) {
        if (CollUtil.isNotEmpty(itemBackDirIds)) {
            priceItemConditionEo.setItemBackDirIds(itemBackDirIds.stream().distinct().collect(Collectors.joining(",")));
            relationItemInfoVo.setItemBackDirIdNum(Integer.valueOf(priceItemConditionEo.getItemBackDirIds().split(",").length));
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            directoryReqDto.setStatus(Integer.valueOf(1));
            directoryReqDto.setIds(Arrays.stream(priceItemConditionEo.getItemBackDirIds().split(",")).map(Long::valueOf).collect(Collectors.toList()));
            List dirIdList = (List)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto));
            priceItemConditionEo.setItemBackDirIdsExt(CollUtil.isNotEmpty((Collection)dirIdList) ? dirIdList.stream().map(String::valueOf).collect(Collectors.joining(",")) : null);
        } else {
            priceItemConditionEo.setItemBackDirIds(null);
        }
    }

    private <D extends PriceAddReqV2Dto> List<PriceItemEo> getPriceItemEos(D reqDto, List<PriceItemEo> priceItemList, PriceItemConditionEo priceItemConditionEo) {
        if (CollUtil.isEmpty(priceItemList)) {
            List<ItemPriceReqDto> itemList = Arrays.stream(priceItemConditionEo.getSkuIds().split(",")).map(skuIdStr -> {
                ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
                itemPriceReqDto.setSkuId(Long.valueOf(skuIdStr));
                return itemPriceReqDto;
            }).collect(Collectors.toList());
            priceItemList = this.convertPriceItemList(itemList, reqDto.getShopId(), Boolean.FALSE);
        }
        return priceItemList;
    }

    private List<String> getSkuIdList(List<PriceItemEo> priceItemList, PriceItemConditionAddReqDto itemConditionReqDto) {
        if (CollUtil.isEmpty(priceItemList)) {
            return itemConditionReqDto.getSkuIds();
        }
        return priceItemList.stream().map(sku -> String.valueOf(sku.getSkuId())).distinct().collect(Collectors.toList());
    }

    private PriceItemConditionEo getPriceItemConditionEo(Long id, String relateType) {
        PriceItemConditionEo priceItemConditionEo = null;
        if (Objects.nonNull(id)) {
            priceItemConditionEo = new PriceItemConditionEo();
            priceItemConditionEo.setRelateId(id);
            priceItemConditionEo.setRelateType(relateType);
            priceItemConditionEo = (PriceItemConditionEo)this.priceItemConditionDas.selectOne((BaseEo)priceItemConditionEo);
        }
        return priceItemConditionEo;
    }

    private List<PriceRejectCustomerEo> getPriceRejectCustomerEos(PriceEo price, String relateType, List<PriceRejectCustomerEo> priceRejectCustomerlist, RelationCustomerInfoVo relationCustomerInfo, List<Long> rejectCustomerIdList) {
        if (CollUtil.isNotEmpty(rejectCustomerIdList)) {
            Map<Long, CustomerRespDto> customerMap = this.customerHelper.getCustomerMap(rejectCustomerIdList);
            priceRejectCustomerlist = rejectCustomerIdList.stream().map(customerId -> {
                PriceRejectCustomerEo priceRejectCustomerEo = new PriceRejectCustomerEo();
                priceRejectCustomerEo.setCustomerId(customerId);
                priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
                priceRejectCustomerEo.setRelateType(relateType);
                priceRejectCustomerEo.setInstanceId(price.getInstanceId());
                priceRejectCustomerEo.setTenantId(price.getTenantId());
                if (customerMap.containsKey(customerId)) {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(customerId);
                    priceRejectCustomerEo.setCustomerCode(customerRespDto.getCode());
                    priceRejectCustomerEo.setCustomerName(customerRespDto.getName());
                }
                return priceRejectCustomerEo;
            }).collect(Collectors.toList());
            relationCustomerInfo.setRejectCustomerCount(Integer.valueOf(rejectCustomerIdList.size()));
        }
        return priceRejectCustomerlist;
    }

    private void buildCustomerTypeLimit(CustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerTypeIds) {
        if (CollUtil.isNotEmpty(customerTypeIds)) {
            customerConditionEo.setCustomerTypeIds(customerTypeIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerTypeIdNum(Integer.valueOf(customerConditionEo.getCustomerTypeIds().split(",").length));
        } else {
            customerConditionEo.setCustomerTypeIds(null);
        }
    }

    private void buildCustomerAreaLimit(CustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerAreaCodes) {
        if (CollUtil.isNotEmpty(customerAreaCodes)) {
            customerConditionEo.setCustomerAreaCodes(customerAreaCodes.stream().distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerAreaCodeNum(Integer.valueOf(customerConditionEo.getCustomerAreaCodes().split(",").length));
            CustomerAreaListReqDto areaReqDto = new CustomerAreaListReqDto();
            areaReqDto.setCodes(customerAreaCodes);
            List subAreaCodes = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(areaReqDto));
            customerConditionEo.setCustomerAreaCodeExt(CollUtil.isNotEmpty((Collection)subAreaCodes) ? String.join((CharSequence)",", subAreaCodes) : null);
        } else {
            customerConditionEo.setCustomerAreaCodes(null);
            customerConditionEo.setCustomerAreaCodeExt(null);
        }
    }

    private CustomerConditionEo getCustomerConditionEo(Long id, String relateType) {
        CustomerConditionEo customerConditionEo = null;
        if (Objects.nonNull(id)) {
            customerConditionEo = new CustomerConditionEo();
            customerConditionEo.setRelateType(relateType);
            customerConditionEo.setRelateId(id);
            customerConditionEo = (CustomerConditionEo)this.customerConditionDas.selectOne((BaseEo)customerConditionEo);
        }
        return customerConditionEo;
    }

    private <D extends PriceAddReqV2Dto> void checkCondition(D reqDto, Long id, PriceEo price, Long orgId, Long typeId) {
        if (Objects.nonNull(id)) {
            PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)price.getStatus()), id, PriceStatusEnum.DRAFT, PriceStatusEnum.AUDIT_REJECT, PriceStatusEnum.WAIT_AUDIT, PriceStatusEnum.AUDIT_PASS);
        }
        this.checkOriginalPrice(reqDto.getOriginalPriceId());
        this.setPriceCategoryCode(orgId, typeId, price);
        String status = reqDto.getStatus();
        if (Objects.equals(status, PriceStatusEnum.DRAFT.getCode())) {
            return;
        }
    }

    private void saveAttachement(Long id, PriceEo price, List<AttachementAddReqDto> attachementList) {
        if (CollUtil.isNotEmpty(attachementList)) {
            attachementList.forEach(info -> info.setBusinessId(price.getId()));
        }
        if (Objects.isNull(id)) {
            this.attachementService.batchAttachement(attachementList);
        } else {
            this.attachementService.coverAttachement(attachementList, id);
        }
    }

    private void savePriceCustomerCondition(Long id, PriceEo price, String relateType, CustomerConditionEo customerConditionEo) {
        if (Objects.nonNull(customerConditionEo)) {
            customerConditionEo.setRelateType(relateType);
            customerConditionEo.setRelateId(id);
            customerConditionEo.setTenantId(price.getTenantId());
            customerConditionEo.setInstanceId(price.getInstanceId());
            customerConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(customerConditionEo.getId())) {
                this.customerConditionDas.insert((BaseEo)customerConditionEo);
            } else {
                this.customerConditionDas.update((BaseEo)customerConditionEo);
            }
        }
    }

    private void savePriceRejectCustomer(Long id, PriceEo price, String relateType, List<PriceRejectCustomerEo> priceRejectCustomerlist) {
        if (Objects.nonNull(id)) {
            PriceRejectCustomerEo priceRejectCustomerDel = new PriceRejectCustomerEo();
            priceRejectCustomerDel.setRelateType(relateType);
            priceRejectCustomerDel.setRelateId(id);
            List delList = this.priceRejectCustomerDas.select((BaseEo)priceRejectCustomerDel);
            if (CollUtil.isNotEmpty((Collection)delList)) {
                delList.forEach(del -> this.priceRejectCustomerDas.logicDeleteById(del.getId()));
            }
        }
        if (CollUtil.isNotEmpty(priceRejectCustomerlist)) {
            priceRejectCustomerlist.forEach(info -> info.setRelateId(price.getId()));
            this.priceRejectCustomerDas.insertBatch(priceRejectCustomerlist);
        }
    }

    private void savePriceItemCondition(Long id, PriceEo price, String relateType, List<PriceItemEo> priceItemList, PriceItemConditionEo priceItemConditionEo) {
        if (Objects.nonNull(priceItemConditionEo)) {
            priceItemConditionEo.setRelateType(relateType);
            priceItemConditionEo.setRelateId(id);
            priceItemConditionEo.setTenantId(price.getTenantId());
            priceItemConditionEo.setInstanceId(price.getInstanceId());
            priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            priceItemConditionEo.setOrganizationId(price.getOrganizationId());
            if (CollUtil.isNotEmpty(priceItemList)) {
                priceItemConditionEo.setItemIds(priceItemList.stream().map(sku -> String.valueOf(sku.getItemId())).distinct().collect(Collectors.joining(",")));
            }
            if (Objects.isNull(priceItemConditionEo.getId())) {
                this.priceItemConditionDas.insert((BaseEo)priceItemConditionEo);
            } else {
                this.priceItemConditionDas.update((BaseEo)priceItemConditionEo);
            }
        }
    }

    private void savePriceRejectItem(Long id, PriceEo price, String relateType, List<PriceRejectItemEo> priceRejectItemList) {
        if (Objects.nonNull(id)) {
            PriceRejectItemEo priceRejectItemDel = new PriceRejectItemEo();
            priceRejectItemDel.setRelateType(relateType);
            priceRejectItemDel.setRelateId(id);
            List delList1 = this.priceRejectItemDas.select((BaseEo)priceRejectItemDel);
            if (CollUtil.isNotEmpty((Collection)delList1)) {
                delList1.forEach(del -> this.priceRejectItemDas.logicDeleteById(del.getId()));
            }
        }
        if (CollUtil.isNotEmpty(priceRejectItemList)) {
            priceRejectItemList.forEach(info -> info.setRelateId(price.getId()));
            this.priceRejectItemDas.insertBatch(priceRejectItemList);
        }
    }

    private void savePriceItem(Long id, PriceEo price, List<PriceItemEo> priceItemList) {
        if (Objects.nonNull(id)) {
            PriceItemEo priceItemDel = new PriceItemEo();
            priceItemDel.setPriceId(id);
            List priceItemDelList = this.priceItemDas.select((BaseEo)priceItemDel);
            if (CollUtil.isNotEmpty((Collection)priceItemDelList)) {
                priceItemDelList.forEach(del -> this.priceItemDas.logicDeleteById(del.getId()));
            }
        }
        if (CollUtil.isNotEmpty(priceItemList)) {
            priceItemList.forEach(info -> {
                info.setPriceId(price.getId());
                info.setTenantId(price.getTenantId());
                info.setInstanceId(price.getInstanceId());
            });
            this.priceItemDas.insertBatch(priceItemList);
        }
    }

    private void saveRelatedNum(PriceEo price) {
        this.priceModelDas.modifyPriceModelRelatedNum(price.getModelId(), PriceRelatedNum.ADD);
        this.priceTypeDas.modifyPriceTypeRelatedNum(price.getTypeId(), PriceRelatedNum.ADD);
    }

    private void checkDimension(PriceEo price, CustomerConditionEo customerCondition, PriceItemConditionEo itemCondition, Long originalPriceId) {
        if (!Objects.equals(price.getStatus(), PriceStatusEnum.WAIT_AUDIT.getCode())) {
            return;
        }
        PriceBasicConfigRespDto priceBasicConfigRespDto = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(price.getOrganizationId(), PriceBasicConfigEnum.ConfigType.BASIC_SETTINGS);
        if (Objects.nonNull(priceBasicConfigRespDto) && Objects.equals(priceBasicConfigRespDto.getRuleSameDim(), PriceBasicConfigEnum.RuleSameDim.CREATE_TIME_DESC.getCode())) {
            return;
        }
        if (Objects.isNull(price.getId())) {
            price.setOriginalPriceId(originalPriceId);
        }
        Integer relationItemType = price.getRelationItemType();
        Integer relationCustomerType = price.getRelationCustomerType();
        List priceDimensionList = this.priceDas.queryEffectivePriceList(price, relationCustomerType, relationItemType);
        if (CollUtil.isEmpty((Collection)priceDimensionList)) {
            return;
        }
        List<CheckRepeatInfoVo> checkRepeatInfoList = priceDimensionList.stream().map(priceInfo -> {
            CheckRepeatInfoVo checkRepeatInfoVo = new CheckRepeatInfoVo();
            checkRepeatInfoVo.setCode(priceInfo.getCode());
            checkRepeatInfoVo.setId(priceInfo.getId());
            return checkRepeatInfoVo;
        }).collect(Collectors.toList());
        CheckDimensionVo checkDimensionVo = new CheckDimensionVo();
        checkDimensionVo.setCheckRepeatInfoList(checkRepeatInfoList);
        checkDimensionVo.setCode(price.getCode());
        checkDimensionVo.setCustomerCondition(customerCondition);
        checkDimensionVo.setRelationCustomerType(relationCustomerType);
        checkDimensionVo.setItemCondition(itemCondition);
        checkDimensionVo.setRelationItemType(relationItemType);
        checkDimensionVo.setRelateTypeEnum(RelateTypeEnum.PRICE);
        this.checkRepeatHelper.checkDimension(checkDimensionVo, PriceExceptionCode.PRICE_POLICY_DUPLICATION);
    }

    private void checkOriginalPrice(Long originalPriceId) {
        if (Objects.isNull(originalPriceId)) {
            return;
        }
        PriceEo price = this.getPrice(originalPriceId);
        String priceStatus = PriceStatusUtils.convertStatus(price.getStatus(), price.getEffectiveTime(), price.getInvalidTime());
        if (!Objects.equals(priceStatus, PriceStatusEnum.EFFECT.getCode()) && !Objects.equals(priceStatus, PriceStatusEnum.WAIT_TAKE_EFFECT.getCode())) {
            logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u975e\u5f85\u751f\u6548\u3001\u751f\u6548\u4e2d\u7684\u653f\u7b56[{}]\u4e0d\u5141\u8bb8\u88ab\u5f15\u7528", (Object)price.getCode());
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.CANNOT_REFERENCE_PRICE);
        }
    }

    private void setPriceCategoryCode(Long orgId, Long typeId, PriceEo price) {
        PriceTypeEo priceTypeEo = (PriceTypeEo)this.priceTypeDas.selectByPrimaryKey(typeId);
        AssertUtils.isTrue(Objects.nonNull(priceTypeEo) && Objects.equals(priceTypeEo.getOrganizationId(), orgId), PriceExceptionCode.INVALID_PRICE_TYPE);
        if (Objects.equals(AbleStatusEnum.DISABLE.getCode(), priceTypeEo.getStatus())) {
            logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u65e0\u6548\u7684\u4ef7\u683c\u7c7b\u578b[{}]\uff0c\u88ab\u7981\u7528\u7684\u4ef7\u683c\u7c7b\u578b\uff0c\u65e0\u6cd5\u88ab\u4ef7\u683c\u653f\u7b56\u4f7f\u7528", (Object)priceTypeEo.getTypeName());
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_PRICE_TYPE);
        }
        price.setCategoryCode(priceTypeEo.getCategoryCode());
    }

    private List<PriceItemEo> convertPriceItemList(List<ItemPriceReqDto> itemList, Long shopId, boolean checkInterval) {
        if (CollUtil.isEmpty(itemList)) {
            return ListUtil.empty();
        }
        List<Long> skuIdList = itemList.stream().map(ItemPriceReqDto::getSkuId).distinct().collect(Collectors.toList());
        ArrayList priceItemList = ListUtil.toList((Object[])new PriceItemEo[0]);
        Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMap(skuIdList);
        for (ItemPriceReqDto itemInfo : itemList) {
            Long skuId = itemInfo.getSkuId();
            BigDecimal itemPrice = itemInfo.getItemPrice();
            Integer lowerLimit = itemInfo.getLowerLimit();
            Integer upperLimit = itemInfo.getUpperLimit();
            PriceItemEo priceItemEo = new PriceItemEo();
            priceItemEo.setItemPrice(itemPrice);
            priceItemEo.setLowerLimit(lowerLimit);
            priceItemEo.setUpperLimit(upperLimit);
            priceItemEo.setSkuId(skuId);
            priceItemEo.setShopId(shopId);
            priceItemEo.setPriceModelSetType(itemInfo.getPriceModelSetType());
            priceItemEo.setDiscountType(itemInfo.getDiscountType());
            priceItemEo.setDiscountRate(itemInfo.getDiscountRate());
            priceItemEo.setGiftboxIncrPrice(itemInfo.getGiftboxIncrPrice());
            if (skuQueryRespDtoMap.containsKey(skuId)) {
                ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(skuId);
                priceItemEo.setItemId(itemSkuQueryRespDto.getItemId());
                priceItemEo.setItemName(itemSkuQueryRespDto.getItemName());
                priceItemEo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
                priceItemEo.setSkuDesc(itemSkuQueryRespDto.getSkuAttr());
                priceItemEo.setItemBrand(itemSkuQueryRespDto.getBrandName());
                priceItemEo.setItemOrgId(itemSkuQueryRespDto.getItemOrgId());
                priceItemEo.setGiftBox(itemSkuQueryRespDto.getGiftBox());
            }
            priceItemList.add(priceItemEo);
        }
        if (checkInterval) {
            this.checkSkuInterval(priceItemList);
        }
        return priceItemList;
    }

    @Override
    public void checkSkuInterval(List<PriceItemEo> priceItemList) {
        if (CollUtil.isEmpty(priceItemList)) {
            return;
        }
        Map<Long, List<PriceItemEo>> skuMap = priceItemList.stream().sorted(Comparator.comparing(StdPriceItemEo::getLowerLimit)).collect(Collectors.groupingBy(StdPriceItemEo::getSkuId));
        skuMap.forEach((skuId, priceList) -> {
            int size = priceList.size();
            PriceItemEo startPrice = (PriceItemEo)priceList.get(0);
            PriceItemEo endPrice = (PriceItemEo)priceList.get(size - 1);
            Integer startLowerLimit = startPrice.getLowerLimit();
            Integer endUpperLimit = endPrice.getUpperLimit();
            if (!Objects.equals(startLowerLimit, 1) || !Objects.isNull(endUpperLimit)) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> skuId[{}]\u5546\u54c1\u540d\u5b57[{}]\u8bbe\u7f6e\u533a\u95f4\u4ef7\u683c\u65f6\uff0c\u9700\u8981\u6570\u91cf1\u5f00\u59cb[{}]\uff0cnull\u7ed3\u675f[{}]", new Object[]{skuId, startPrice.getItemName(), startLowerLimit, endUpperLimit});
                throw new BizException("\u5546\u54c1[" + startPrice.getItemName() + STR + startPrice.getSkuCode() + "]\u4e0d\u662f\u6570\u91cf1\u5f00\u59cb\uff0c\u4e0d\u9650\u7ed3\u675f");
            }
            int lastValue = 0;
            for (int i = 0; i < size; ++i) {
                PriceItemEo skuPrice = (PriceItemEo)priceList.get(i);
                lastValue = this.checkPriceValueCoherent((Long)skuId, size, startPrice, lastValue, i, skuPrice);
            }
        });
    }

    private int checkPriceValueCoherent(Long skuId, int size, PriceItemEo startPrice, int lastValue, int i, PriceItemEo skuPrice) {
        Integer lowerLimit = skuPrice.getLowerLimit();
        Integer upperLimit = skuPrice.getUpperLimit();
        if (i == size - 1) {
            if (lastValue + 1 != lowerLimit) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> skuId[{}]\u5546\u54c1\u540d\u5b57[{}]\u8bbe\u7f6e\u533a\u95f4\u4ef7\u683c\u65f6\uff0c\u6700\u540e\u9879\u8bbe\u7f6e\u7684\u5f00\u59cb\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u73b0\u5728\u503c\u4e3a[{}]\uff0c\u5e94\u4e3a[{}]", new Object[]{skuId, startPrice.getItemName(), lowerLimit, lastValue + 1});
                throw new BizException("\u5546\u54c1[" + startPrice.getItemName() + STR + startPrice.getSkuCode() + "]\u6700\u540e\u9879\u8bbe\u7f6e\u7684\u5f00\u59cb\u6570\u91cf\u4e0d\u6b63\u786e");
            }
        } else {
            if (Objects.isNull(lowerLimit) || Objects.isNull(upperLimit)) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> skuId[{}]\u5546\u54c1\u540d\u5b57[{}]\u8bbe\u7f6e\u533a\u95f4\u4ef7\u683c\u65f6\uff0c\u9700\u8981\u6570\u91cf\u5f00\u59cb[{}]\u548c\u7ed3\u675f[{}]\u4e0d\u5141\u8bb8\u672a\u7ed3\u675f\u4e0d\u8bbe\u7f6e", new Object[]{skuId, startPrice.getItemName(), lowerLimit, upperLimit});
                throw new BizException("\u5546\u54c1[" + startPrice.getItemName() + STR + startPrice.getSkuCode() + "]\u672a\u7ed3\u675f\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u4e0d\u9650");
            }
            if (lowerLimit > upperLimit) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> skuId[{}]\u5546\u54c1\u540d\u5b57[{}]\u8bbe\u7f6e\u533a\u95f4\u4ef7\u683c\u65f6\uff0c\u5f00\u59cb\u6570\u91cf[{}]\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed3\u675f\u6570\u91cf[{}]", new Object[]{skuId, startPrice.getItemName(), lowerLimit, upperLimit});
                throw new BizException("\u5546\u54c1[" + startPrice.getItemName() + STR + startPrice.getSkuCode() + "]\u5f00\u59cb\u6570\u91cf[" + lowerLimit + "]\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed3\u675f\u6570\u91cf[" + upperLimit + "]");
            }
            if (lastValue + 1 == lowerLimit) {
                lastValue = upperLimit;
            } else {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> skuId[{}]\u5546\u54c1\u540d\u5b57[{}]\u8bbe\u7f6e\u533a\u95f4\u4ef7\u683c\u65f6\uff0c\u4e0a\u4e00\u9879\u662f[{}]\uff0c\u4e0b\u4e00\u9879\u5e94\u8be5\u662f[{}]\uff0c\u73b0\u5728\u662f[{}]", new Object[]{skuId, startPrice.getItemName(), lastValue, lastValue + 1, lowerLimit});
                throw new BizException("\u5546\u54c1[" + startPrice.getItemName() + STR + startPrice.getSkuCode() + "]\u6570\u91cf[" + lastValue + "]\u4e0b\u4e00\u9879\u7684\u5f00\u59cb\u503c\u4e0d\u6b63\u786e");
            }
        }
        return lastValue;
    }

    private <D extends PriceAddReqV2Dto> List<PriceItemEo> getPriceItemList(Long orgId, Long modelId, PriceEo price, D reqDto) {
        PriceModelEo priceModelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(modelId);
        AssertUtils.isTrue(Objects.nonNull(priceModelEo) && Objects.equals(priceModelEo.getOrganizationId(), orgId), PriceExceptionCode.INVALID_MODEL);
        if (Objects.equals(AbleStatusEnum.DISABLE.getCode(), priceModelEo.getStatus())) {
            logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u65e0\u6548\u7684\u4ef7\u683c\u6a21\u578b[{}]\uff0c\u88ab\u7981\u7528\u7684\u4ef7\u683c\u6a21\u578b\uff0c\u65e0\u6cd5\u88ab\u4ef7\u683c\u653f\u7b56\u4f7f\u7528", (Object)priceModelEo.getModelName());
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_MODEL);
        }
        List<Object> priceItemList = ListUtil.toList((Object[])new PriceItemEo[0]);
        Integer relationItemType = reqDto.getRelationItemType();
        if (Objects.equals(relationItemType, 0)) {
            List itemList = reqDto.getPriceItemList();
            if (CollUtil.isEmpty((Collection)itemList)) {
                logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u4ef7\u683c\u653f\u7b56\u4e0d\u5141\u8bb8\u4e0d\u8bbe\u7f6e\u9002\u7528\u7684\u5546\u54c1");
                BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
            }
            priceItemList = this.convertPriceItemList(itemList, reqDto.getShopId(), Boolean.TRUE);
        } else {
            price.setDiscountRate(reqDto.getDiscountRate());
            price.setGiftboxIncrPrice(reqDto.getGiftboxIncrPrice());
        }
        return priceItemList;
    }

    private void checkPriceNameUnique(String name, Long id, Long orgId, boolean limitStatus) {
        PriceEo priceEo = this.priceDas.checkPriceNameUnique(orgId, id, name, limitStatus);
        AssertUtils.isNull(priceEo, PriceExceptionCode.POLICY_NAME_EXISTS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePrice(Long id) {
        PriceEo price = this.getPrice(id);
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)price.getStatus()), id, PriceStatusEnum.DRAFT, PriceStatusEnum.AUDIT_REJECT);
        AssertUtils.isTrue(Objects.equals(price.getReadStatus(), 0), "\u9ed8\u8ba4\u4ef7\u683c\u653f\u7b56\u4e0d\u5141\u8bb8\u5220\u9664", new Object[0]);
        this.priceDas.logicDeleteById(price.getId());
        this.priceModelDas.modifyPriceModelRelatedNum(price.getModelId(), PriceRelatedNum.SUB);
        this.priceTypeDas.modifyPriceTypeRelatedNum(price.getTypeId(), PriceRelatedNum.SUB);
        this.pricePolicyEsService.deletePricePolicy(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelPrice(Long id) {
        PriceEo price = this.getPrice(id);
        String priceStatus = PriceStatusUtils.convertStatus(price.getStatus(), price.getEffectiveTime(), price.getInvalidTime());
        if (!Objects.equals(priceStatus, PriceStatusEnum.WAIT_TAKE_EFFECT.getCode()) && !Objects.equals(priceStatus, PriceStatusEnum.EFFECT.getCode())) {
            logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u975e\u5f85\u751f\u6548\u548c\u751f\u6548\u4e2d\u7684\u4ef7\u683c\u653f\u7b56[{}]\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u64cd\u4f5c", (Object)id);
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.OPERATION_NOT_ALLOWED);
        }
        price.setStatus(PriceStatusEnum.INVALID.getCode());
        this.priceDas.update((BaseEo)price);
        logger.info("[\u4ef7\u683c\u653f\u7b56] >>> \u4ef7\u683c\u653f\u7b56[{}]\u5df2\u5931\u6548\uff0c\u540c\u6b65\u5230es", (Object)price.getCode());
        this.pricePolicyEsService.updatePriceStatus(id, PriceStatusEnum.INVALID.getCode());
    }

    @Override
    public void submit(Long id) {
    }

    @Override
    public PriceInfoRespV2Dto queryPriceById(Long id) {
        RelationInfoVo relationInfoVo;
        PriceEo originalPrice;
        PriceEo price = this.priceDas.queryById(id);
        PriceInfoRespV2Dto priceRespV2Dto = new PriceInfoRespV2Dto();
        DtoHelper.eo2Dto((BaseEo)price, (BaseVo)priceRespV2Dto);
        Long originalPriceId = priceRespV2Dto.getOriginalPriceId();
        if (Objects.nonNull(originalPriceId) && (originalPrice = this.getPrice(originalPriceId)) != null) {
            priceRespV2Dto.setOriginalPriceCode(originalPrice.getCode());
        }
        priceRespV2Dto.setShopName(this.shopHelper.getShopName(priceRespV2Dto.getShopId()));
        Long typeId = priceRespV2Dto.getTypeId();
        if (Objects.nonNull(typeId)) {
            PriceTypeEo priceTypeEo = (PriceTypeEo)this.priceTypeDas.selectByPrimaryKey(typeId);
            priceRespV2Dto.setTypeName(Objects.isNull(priceTypeEo) ? null : priceTypeEo.getTypeName());
        }
        this.buildPriceModel(priceRespV2Dto);
        priceRespV2Dto.setEffectiveStatus(Objects.isNull(priceRespV2Dto.getInvalidTime()));
        String extension = priceRespV2Dto.getExtension();
        if (StrUtil.isNotBlank((CharSequence)extension) && Objects.nonNull(relationInfoVo = (RelationInfoVo)JSON.parseObject((String)extension, RelationInfoVo.class))) {
            priceRespV2Dto.setRelationCustomerInfo(relationInfoVo.getRelationCustomerInfo());
            priceRespV2Dto.setRelationItemInfo(relationInfoVo.getRelationItemInfo());
        }
        priceRespV2Dto.setExtension(null);
        AuditRespDto auditLastOne = this.auditService.getAuditLastOne(RelateTypeEnum.PRICE, id);
        if (Objects.nonNull(auditLastOne) && Objects.equals(auditLastOne.getAuditStatus(), priceRespV2Dto.getStatus())) {
            priceRespV2Dto.setAuditLog(auditLastOne);
        }
        priceRespV2Dto.setStatus(PriceStatusUtils.convertStatus(priceRespV2Dto.getStatus(), priceRespV2Dto.getEffectiveTime(), priceRespV2Dto.getInvalidTime()));
        priceRespV2Dto.setAttachementList(this.attachementService.getAttachementListByBusinessId(id));
        this.buildPriceItem(id, priceRespV2Dto);
        String relationCustomerType = String.valueOf(priceRespV2Dto.getRelationCustomerType());
        String relationItemType = String.valueOf(priceRespV2Dto.getRelationItemType());
        String relateType = RelateTypeEnum.PRICE.getType();
        if (!Objects.equals(relationCustomerType, CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType())) {
            this.buildCustomerCondition(id, priceRespV2Dto, relateType);
        }
        if (Objects.equals(relationCustomerType, CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType())) {
            priceRespV2Dto.setPriceRejectCustomerRespDtoList(this.buildRejectCustomerCondition(id, relateType));
        }
        if (!Objects.equals(relationItemType, ItemDimensionEnum.ITEM_ALL_ENUM.getType())) {
            this.buildPriceItemCondition(id, priceRespV2Dto, relateType);
        }
        if (Objects.equals(relationItemType, ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            priceRespV2Dto.setPriceRejectItemRespDtoList(this.buildRejectItemCondition(id, relateType));
        }
        return priceRespV2Dto;
    }

    private List<PriceRejectCustomerRespDto> buildRejectCustomerCondition(Long id, String relateType) {
        List<PriceRejectCustomerRespDto> priceRejectCustomerRespDtos = this.priceRejectCustomerService.queryByRelateIdAndType(id, relateType);
        if (CollectionUtil.isNotEmpty(priceRejectCustomerRespDtos)) {
            List<Long> customerIds = priceRejectCustomerRespDtos.stream().map(PriceRejectCustomerRespDto::getCustomerId).collect(Collectors.toList());
            Map<Long, CustomerRespDto> customerMap = this.customerHelper.getCustomerMap(customerIds);
            for (PriceRejectCustomerRespDto priceRejectCustomerRespDto : priceRejectCustomerRespDtos) {
                CustomerRespDto customerRespDto = customerMap.get(priceRejectCustomerRespDto.getCustomerId());
                if (customerRespDto == null) continue;
                priceRejectCustomerRespDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                priceRejectCustomerRespDto.setCustomerTypeName(customerRespDto.getCustomerTypeName());
                priceRejectCustomerRespDto.setRegionCodeList(customerRespDto.getRegionCodeList());
                priceRejectCustomerRespDto.setRegionNames(customerRespDto.getRegionNames());
            }
        }
        return priceRejectCustomerRespDtos;
    }

    private List<PriceRejectItemRespDto> buildRejectItemCondition(Long id, String relateType) {
        List<PriceRejectItemRespDto> priceRejectItemRespDtos = this.priceRejectItemService.queryByRelateIdAndType(id, relateType);
        if (CollectionUtil.isNotEmpty(priceRejectItemRespDtos)) {
            List<Long> skuIds = priceRejectItemRespDtos.stream().map(PriceRejectItemRespDto::getSkuId).collect(Collectors.toList());
            Map<Long, ItemSkuQueryRespDto> skuDtoMap = this.skuHelper.querySkuMap(skuIds);
            for (PriceRejectItemRespDto priceRejectItemRespDto : priceRejectItemRespDtos) {
                ItemSkuQueryRespDto itemSkuQueryRespDto = skuDtoMap.get(priceRejectItemRespDto.getSkuId());
                if (itemSkuQueryRespDto == null) continue;
                priceRejectItemRespDto.setBrandName(itemSkuQueryRespDto.getBrandName());
                priceRejectItemRespDto.setSkuSpec(itemSkuQueryRespDto.getSkuAttr());
                priceRejectItemRespDto.setSubType(itemSkuQueryRespDto.getSubType());
                priceRejectItemRespDto.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemSkuQueryRespDto.getSubType()));
            }
        }
        return priceRejectItemRespDtos;
    }

    private void buildPriceModel(PriceInfoRespV2Dto priceRespV2Dto) {
        Long modelId = priceRespV2Dto.getModelId();
        if (Objects.nonNull(modelId)) {
            PriceModelEo priceModelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(modelId);
            priceRespV2Dto.setModelName(Objects.isNull(priceModelEo) ? null : priceModelEo.getModelName());
        }
    }

    private void buildCustomerCondition(Long id, PriceInfoRespV2Dto priceRespV2Dto, String relateType) {
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        customerConditionEo.setRelateType(relateType);
        customerConditionEo.setRelateId(id);
        customerConditionEo = (CustomerConditionEo)this.customerConditionDas.selectOne((BaseEo)customerConditionEo);
        if (Objects.nonNull(customerConditionEo)) {
            String customerIds;
            String customerAreaCodes;
            String customerGroupIds;
            CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
            String customerTypeIds = customerConditionEo.getCustomerTypeIds();
            if (StrUtil.isNotBlank((CharSequence)customerTypeIds)) {
                customerConditionRespDto.setCustomerTypeIds(Arrays.asList(customerTypeIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerGroupIds = customerConditionEo.getCustomerGroupIds()))) {
                customerConditionRespDto.setCustomerGroupIds(Arrays.asList(customerGroupIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerAreaCodes = customerConditionEo.getCustomerAreaCodes()))) {
                customerConditionRespDto.setCustomerAreaCodes(Arrays.asList(customerAreaCodes.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerIds = customerConditionEo.getCustomerIds()))) {
                customerConditionRespDto.setCustomerIds(Arrays.asList(customerIds.split(",")));
                List<Long> ids = customerConditionRespDto.getCustomerIds().stream().map(Long::valueOf).collect(Collectors.toList());
                Map<Long, CustomerRespDto> customerMap = this.customerHelper.getCustomerMap(ids);
                List customerInfoDtos = customerMap.values().stream().map(customerInfo -> {
                    CustomerInfoDto customerInfoDto = new CustomerInfoDto();
                    customerInfoDto.setCustomerId(customerInfo.getId());
                    customerInfoDto.setCustomerName(customerInfo.getName());
                    customerInfoDto.setCode(customerInfo.getCode());
                    customerInfoDto.setCustomerTypeId(customerInfo.getCustomerTypeId());
                    customerInfoDto.setCustomerTypeName(customerInfo.getCustomerTypeName());
                    customerInfoDto.setRegionCodeList(customerInfo.getRegionCodeList());
                    customerInfoDto.setRegionNames(customerInfo.getRegionNames());
                    return customerInfoDto;
                }).collect(Collectors.toList());
                customerConditionRespDto.setCustomerInfoDtos(customerInfoDtos);
            }
            priceRespV2Dto.setCustomerConditionRespDto(customerConditionRespDto);
        }
    }

    private void buildPriceItem(Long id, PriceInfoRespV2Dto priceRespV2Dto) {
        PriceItemEo priceItemEo = new PriceItemEo();
        priceItemEo.setPriceId(id);
        List priceItemList = this.priceItemDas.select((BaseEo)priceItemEo);
        if (CollUtil.isEmpty((Collection)priceItemList)) {
            priceRespV2Dto.setPriceItemList(ListUtil.empty());
            return;
        }
        Map<Long, List<PriceItemEo>> skuLimitMap = priceItemList.stream().collect(Collectors.groupingBy(StdPriceItemEo::getSkuId));
        ArrayList skuIdList = ListUtil.toList(skuLimitMap.keySet());
        Map<Long, ItemSkuQueryRespDto> skuDtoMap = this.skuHelper.querySkuMap(skuIdList);
        List priceItemDtoList = skuLimitMap.entrySet().stream().map(map -> {
            List priceItemEos;
            Long skuId = (Long)map.getKey();
            ItemSkuQueryRespDto itemSkuQueryRespDto = (ItemSkuQueryRespDto)skuDtoMap.get(skuId);
            PriceItemSkuLimitRespDto priceItemSkuLimitRespDto = new PriceItemSkuLimitRespDto();
            priceItemSkuLimitRespDto.setSkuId(skuId);
            if (Objects.nonNull(itemSkuQueryRespDto)) {
                priceItemSkuLimitRespDto.setItemId(itemSkuQueryRespDto.getItemId());
                priceItemSkuLimitRespDto.setBrandName(itemSkuQueryRespDto.getBrandName());
                priceItemSkuLimitRespDto.setGiftBox(itemSkuQueryRespDto.getGiftBox());
                priceItemSkuLimitRespDto.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
                priceItemSkuLimitRespDto.setSkuCode(itemSkuQueryRespDto.getSkuCode());
                priceItemSkuLimitRespDto.setSkuSpec(itemSkuQueryRespDto.getSkuAttr());
                priceItemSkuLimitRespDto.setItemCode(itemSkuQueryRespDto.getItemCode());
                priceItemSkuLimitRespDto.setItemName(itemSkuQueryRespDto.getItemName());
                priceItemSkuLimitRespDto.setSubType(itemSkuQueryRespDto.getSubType());
                priceItemSkuLimitRespDto.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemSkuQueryRespDto.getSubType()));
            }
            if (CollUtil.isNotEmpty((Collection)(priceItemEos = (List)map.getValue()))) {
                PriceItemEo priceItem = (PriceItemEo)priceItemEos.get(0);
                priceItemSkuLimitRespDto.setPriceModelSetType(priceItem.getPriceModelSetType());
                priceItemSkuLimitRespDto.setDiscountType(priceItem.getDiscountType());
                priceItemSkuLimitRespDto.setDiscountRate(priceItem.getDiscountRate());
                priceItemSkuLimitRespDto.setGiftboxIncrPrice(priceItem.getGiftboxIncrPrice());
                List skuSectionList = priceItemEos.stream().filter(sku -> Objects.nonNull(sku.getItemPrice())).map(sku -> {
                    PriceItemSkuSectionRespDto priceItemSkuSectionRespDto = new PriceItemSkuSectionRespDto();
                    priceItemSkuSectionRespDto.setItemPrice(sku.getItemPrice());
                    priceItemSkuSectionRespDto.setLowerLimit(sku.getLowerLimit());
                    priceItemSkuSectionRespDto.setUpperLimit(sku.getUpperLimit());
                    return priceItemSkuSectionRespDto;
                }).collect(Collectors.toList());
                priceItemSkuLimitRespDto.setSkuPriceLimitList(skuSectionList);
            } else {
                priceItemSkuLimitRespDto.setSkuPriceLimitList(ListUtil.empty());
            }
            return priceItemSkuLimitRespDto;
        }).collect(Collectors.toList());
        ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
        itemSkuPriceLimitQueryReqDto.setSkuIdList((List)skuIdList);
        itemSkuPriceLimitQueryReqDto.setShopId(priceRespV2Dto.getShopId());
        itemSkuPriceLimitQueryReqDto.setPriceLimitStatus(Boolean.FALSE.booleanValue());
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = this.basePriceApplyItemService.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
        Map skuPriceInfo = itemSkuPriceLimitRespDto.getSkuPriceInfo();
        for (PriceItemSkuLimitRespDto priceItemSkuLimitRespDto : priceItemDtoList) {
            Long skuId = priceItemSkuLimitRespDto.getSkuId();
            if (!skuPriceInfo.containsKey(skuId)) continue;
            ItemSkuPriceInfoRespDto itemSkuPriceInfoRespDto = (ItemSkuPriceInfoRespDto)skuPriceInfo.get(skuId);
            priceItemSkuLimitRespDto.setLowerLimitPrice(itemSkuPriceInfoRespDto.getLowerLimitPrice());
            priceItemSkuLimitRespDto.setUpperLimitPrice(itemSkuPriceInfoRespDto.getUpperLimitPrice());
            priceItemSkuLimitRespDto.setRetailPrice(itemSkuPriceInfoRespDto.getRetailPrice());
            priceItemSkuLimitRespDto.setDealerRetailPrice(itemSkuPriceInfoRespDto.getDealerRetailPrice());
            priceItemSkuLimitRespDto.setControlType(itemSkuPriceInfoRespDto.getControlType());
            priceItemSkuLimitRespDto.setExchangePrice(itemSkuPriceInfoRespDto.getExchangePrice());
        }
        priceRespV2Dto.setPriceItemList(priceItemDtoList);
    }

    private void buildPriceItemCondition(Long id, PriceInfoRespV2Dto priceRespV2Dto, String relateType) {
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        priceItemConditionEo.setRelateType(relateType);
        priceItemConditionEo.setRelateId(id);
        priceItemConditionEo = (PriceItemConditionEo)this.priceItemConditionDas.selectOne((BaseEo)priceItemConditionEo);
        if (Objects.nonNull(priceItemConditionEo)) {
            String itemBrandIds;
            String itemBackDirIds;
            String itemTypes;
            String skuIds;
            PriceItemConditionRespDto priceItemConditionRespDto = new PriceItemConditionRespDto();
            String itemIds = priceItemConditionEo.getItemIds();
            if (StrUtil.isNotBlank((CharSequence)itemIds)) {
                priceItemConditionRespDto.setItemIds(itemIds);
            }
            if (StrUtil.isNotBlank((CharSequence)(skuIds = priceItemConditionEo.getSkuIds()))) {
                priceItemConditionRespDto.setSkuIds((List)ListUtil.toList((Object[])skuIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(itemTypes = priceItemConditionEo.getItemTypes()))) {
                priceItemConditionRespDto.setItemTypes((List)ListUtil.toList((Object[])itemTypes.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(itemBackDirIds = priceItemConditionEo.getItemBackDirIds()))) {
                priceItemConditionRespDto.setItemBackDirIds((List)ListUtil.toList((Object[])itemBackDirIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(itemBrandIds = priceItemConditionEo.getItemBrandIds()))) {
                priceItemConditionRespDto.setItemBrandIds((List)ListUtil.toList((Object[])itemBrandIds.split(",")));
            }
            List priceBrandEos = ((ExtQueryChainWrapper)this.priceBrandDas.filter().eq((Object)"price_id", (Object)id)).list();
            ArrayList priceBrandRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)priceBrandEos, (Collection)priceBrandRespDtos, PriceBrandRespDto.class);
            priceItemConditionRespDto.setPriceBrandRespDtos((List)priceBrandRespDtos);
            priceRespV2Dto.setPriceItemConditionRespDto(priceItemConditionRespDto);
        }
    }

    @Override
    public PageInfo<PriceRespV2Dto> queryPriceByPage(PriceQueryReqV2Dto reqDto) {
        reqDto.setOrganizationId(this.customerHelper.getOrgId());
        reqDto.setNowTime(new Date());
        List list = this.priceDas.queryPriceByPage(reqDto);
        if (CollUtil.isEmpty((Collection)list)) {
            return PageInfo.of((List)ListUtil.empty());
        }
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.PRICE;
        List<Long> idList = list.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        List<Long> shopIdList = list.stream().map(PriceRespV2Dto::getShopId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, String> shopNameMap = this.shopHelper.getShopNameMap(shopIdList);
        Map<Long, AuditRespDto> auditLastOneMap = this.auditService.getAuditLastOneMap(relateTypeEnum, idList);
        for (PriceRespV2Dto priceRespV2Dto : list) {
            RelationInfoVo relationInfoVo;
            String extension;
            if (Objects.nonNull(priceRespV2Dto.getShopId()) && shopNameMap.containsKey(priceRespV2Dto.getShopId())) {
                priceRespV2Dto.setShopName(shopNameMap.get(priceRespV2Dto.getShopId()));
            }
            priceRespV2Dto.setStatus(PriceStatusUtils.convertStatus(priceRespV2Dto.getStatus(), priceRespV2Dto.getEffectiveTime(), priceRespV2Dto.getInvalidTime()));
            if (auditLastOneMap.containsKey(priceRespV2Dto.getId())) {
                priceRespV2Dto.setAuditTime(auditLastOneMap.get(priceRespV2Dto.getId()).getAuditTime());
            }
            if (StrUtil.isNotBlank((CharSequence)(extension = priceRespV2Dto.getExtension())) && Objects.nonNull(relationInfoVo = (RelationInfoVo)JSON.parseObject((String)extension, RelationInfoVo.class))) {
                priceRespV2Dto.setRelationCustomerInfo(relationInfoVo.getRelationCustomerInfo());
                priceRespV2Dto.setRelationItemInfo(relationInfoVo.getRelationItemInfo());
            }
            priceRespV2Dto.setExtension(null);
        }
        return PageInfo.of((List)list);
    }
}

