/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.task;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.SyncPriceTaskService;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class PriceSyncCheckTask
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PriceSyncCheckTask.class);
    @Resource
    private SyncPriceTaskService syncPriceTaskService;
    @Value(value="${price.task.local.check.status:true}")
    private boolean checkStatus;
    @Value(value="${price.task.local.check.cron:0 */10 * * * ?}")
    private String checkCron;
    @Resource
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;

    public synchronized void check() {
        try {
            log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u672c\u5730\u68c0\u67e5\u4efb\u52a1...");
            List<BasePriceApplyEo> notSyncApplyList = this.syncPriceTaskService.findNotSyncApplyList();
            if (CollUtil.isEmpty(notSyncApplyList)) {
                return;
            }
            for (BasePriceApplyEo basePriceApplyEo : notSyncApplyList) {
                this.syncPriceTaskService.newTask(basePriceApplyEo);
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4efb\u52a1\u5931\u8d25\u4e86", (Throwable)e);
        }
    }

    public void run(ApplicationArguments args) {
        if (this.syncPriceTaskService.isLocal()) {
            log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u542f\u7528\u672c\u5730\u4efb\u52a1\uff0c\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1");
            this.check();
            this.initLocalCheck();
        }
    }

    public void initLocalCheck() {
        if (!this.checkStatus) {
            return;
        }
        this.threadPoolTaskScheduler.schedule(() -> this.check(), (Trigger)new CronTrigger(this.checkCron));
    }
}

