/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.audit.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditInfo;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.IAudit;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceAuditServiceImpl
implements IAudit {
    private static final Logger log = LoggerFactory.getLogger(PriceAuditServiceImpl.class);
    @Resource
    private PriceDas priceDas;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;

    @Override
    public RelateTypeEnum relateType() {
        return RelateTypeEnum.PRICE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AuditInfo modifyStatus(AuditEo auditEo, AuditResultEnum auditResultEnum) {
        Long relateId = auditEo.getRelateId();
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(relateId);
        if (Objects.isNull(priceEo)) {
            return null;
        }
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)priceEo.getStatus()), relateId, PriceStatusEnum.WAIT_AUDIT);
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setOldStatus(PriceStatusEnum.getByCode((String)priceEo.getStatus()));
        String status = null;
        if (Objects.equals(auditResultEnum, AuditResultEnum.PASS)) {
            auditInfo.setNewStatus(PriceStatusEnum.AUDIT_PASS);
            status = PriceStatusEnum.AUDIT_PASS.getCode();
        } else {
            auditInfo.setNewStatus(PriceStatusEnum.AUDIT_REJECT);
            status = PriceStatusEnum.AUDIT_REJECT.getCode();
        }
        priceEo.setStatus(status);
        this.priceDas.update((BaseEo)priceEo);
        if (Objects.equals(auditResultEnum, AuditResultEnum.PASS)) {
            this.cancel(priceEo);
        }
        log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u4ef7\u683c\u653f\u7b56[{}]\u5ba1\u6838\u901a\u8fc7\uff0c\u5199\u5165es", (Object)priceEo.getCode());
        this.pricePolicyEsService.updatePriceStatus(relateId, status);
        return auditInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancel(PriceEo newPriceEo) {
        Long originalPriceId = newPriceEo.getOriginalPriceId();
        if (Objects.isNull(originalPriceId)) {
            return;
        }
        PriceEo originalPriceEo = (PriceEo)this.priceDas.selectByPrimaryKey(originalPriceId);
        if (Objects.isNull(originalPriceEo)) {
            return;
        }
        if (Objects.equals(originalPriceEo.getStatus(), PriceStatusEnum.INVALID.getCode())) {
            log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u4ef7\u683c\u653f\u7b56[{}]\u5ba1\u6838\u901a\u8fc7\uff0c\u539f\u4ef7\u683c\u653f\u7b56\u5df2\u7ecf\u662f\u4f5c\u5e9f\u72b6\u6001\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u540c\u6b65\u5230es[{}]", (Object)newPriceEo.getCode(), (Object)originalPriceEo.getCode());
            return;
        }
        String status = PriceStatusUtils.convertStatus(originalPriceEo.getStatus(), originalPriceEo.getEffectiveTime(), originalPriceEo.getInvalidTime());
        PriceEo updateEo = new PriceEo();
        updateEo.setId(originalPriceEo.getId());
        log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u4ef7\u683c\u653f\u7b56[{}]\u5ba1\u6838\u901a\u8fc7\uff0c\u539f\u4ef7\u683c\u653f\u7b56\u53d8\u66f4\u4e3a\u4f5c\u5e9f[{}]", (Object)newPriceEo.getCode(), (Object)originalPriceEo.getCode());
        if (PriceStatusEnum.EFFECT.getCode().equals(status)) {
            updateEo.setDr(1);
        }
        updateEo.setStatus(PriceStatusEnum.INVALID.getCode());
        this.priceDas.updateSelective((BaseEo)updateEo);
        log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u65b0\u4ef7\u683c\u653f\u7b56[{}]\u5df2\u751f\u6548, \u539f\u4ef7\u683c\u653f\u7b56[{}]\u5df2\u5931\u6548\uff0c\u540c\u6b65\u5230es", (Object)newPriceEo.getCode(), (Object)originalPriceEo.getCode());
        if (PriceStatusEnum.EFFECT.getCode().equals(status)) {
            this.pricePolicyEsService.deletePricePolicy(originalPriceId);
        } else {
            this.pricePolicyEsService.updatePriceStatus(originalPriceId, PriceStatusEnum.INVALID.getCode());
        }
    }
}

