/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.styler.ExcelExportStylerBorderImpl;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.BatchExportServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final ThreadLocal<Workbook> THREAD_LOCAL = new ThreadLocal();

    private ExcelUtils() {
    }

    public static <R> void exportBigData(Workbook workbook, ExportParams exportParams, Class<?> pojoClass, IntFunction<Collection<R>> function) {
        BatchExportServer batchServer = BatchExportServer.getExcelBatchExportServer(workbook, exportParams, pojoClass);
        ExcelUtils.export(function, batchServer);
    }

    public static <R> void exportBigData(Workbook workbook, ExportParams exportParams, List<ExcelExportEntity> excelParams, IntFunction<Collection<R>> function) {
        BatchExportServer batchServer = BatchExportServer.getExcelBatchExportServer(workbook, exportParams, excelParams);
        ExcelUtils.export(function, batchServer);
    }

    private static <R> void export(IntFunction<Collection<R>> function, BatchExportServer batchServer) {
        Integer startIndex = 1;
        do {
            Collection<R> list;
            if (CollUtil.isNotEmpty(list = function.apply(startIndex))) {
                batchServer.appendData(list);
                Integer n = startIndex;
                Integer n2 = startIndex = Integer.valueOf(startIndex + 1);
                continue;
            }
            startIndex = 0;
        } while (startIndex > 0);
        batchServer.closeExportBigExcel();
        ExcelUtils.unload();
    }

    public static <R> Workbook exportBigData(ExportParams exportParams, Class<?> pojoClass, IntFunction<Collection<R>> function) {
        Workbook workbook = ExcelUtils.getSheets();
        ExcelUtils.exportBigData(workbook, exportParams, pojoClass, function);
        return workbook;
    }

    public static <R> Workbook exportBigData(ExportParams exportParams, List<ExcelExportEntity> excelParams, IntFunction<Collection<R>> function) {
        Workbook workbook = ExcelUtils.getSheets();
        if (Objects.isNull(exportParams.getStyle())) {
            exportParams.setStyle(ExcelExportStylerBorderImpl.class);
        }
        ExcelUtils.exportBigData(workbook, exportParams, excelParams, function);
        return workbook;
    }

    private static Workbook getSheets() {
        SXSSFWorkbook workbook;
        if (Objects.isNull(THREAD_LOCAL.get())) {
            workbook = new SXSSFWorkbook();
            THREAD_LOCAL.set((Workbook)workbook);
        } else {
            workbook = THREAD_LOCAL.get();
        }
        return workbook;
    }

    public static void unload() {
        THREAD_LOCAL.remove();
    }

    public static Workbook getWorkbook(String url) {
        try {
            if (StrUtil.isBlank((CharSequence)url)) {
                return null;
            }
            return WorkbookFactory.create((InputStream)URLUtil.getStream((URL)URLUtil.url((String)url)));
        }
        catch (IOException | InvalidFormatException e) {
            log.error("[workbook] >>> url\u8f6cworkbook\u5931\u8d25", e);
            return null;
        }
    }
}

