/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectCustomerModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectCustomerService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectCustomerDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.RejectInfoVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceRejectCustomerServiceImpl
implements IPriceRejectCustomerService {
    private static final Logger logger = LoggerFactory.getLogger(PriceRejectCustomerServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private PriceRejectCustomerDas priceRejectCustomerDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceRejectCustomer(PriceRejectCustomerAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = new PriceRejectCustomerEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectCustomerEo);
        priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(priceRejectCustomerEo.getInstanceId())) {
            priceRejectCustomerEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(priceRejectCustomerEo.getTenantId())) {
            priceRejectCustomerEo.setTenantId(this.context.tenantId());
        }
        this.priceRejectCustomerDas.insert((BaseEo)priceRejectCustomerEo);
        return priceRejectCustomerEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchPriceRejectCustomer(List<PriceRejectCustomerAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList priceRejectCustomerEoList = ListUtil.toList((Object[])new PriceRejectCustomerEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)priceRejectCustomerEoList, PriceRejectCustomerEo.class);
        if (CollUtil.isEmpty((Collection)priceRejectCustomerEoList)) {
            return ListUtil.empty();
        }
        for (PriceRejectCustomerEo priceRejectCustomerEo : priceRejectCustomerEoList) {
            priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(priceRejectCustomerEo.getInstanceId())) {
                priceRejectCustomerEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(priceRejectCustomerEo.getTenantId())) continue;
            priceRejectCustomerEo.setTenantId(this.context.tenantId());
        }
        this.priceRejectCustomerDas.insertBatch((List)priceRejectCustomerEoList);
        return priceRejectCustomerEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceRejectCustomer(PriceRejectCustomerModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = (PriceRejectCustomerEo)this.priceRejectCustomerDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectCustomerEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectCustomerEo);
        this.priceRejectCustomerDas.update((BaseEo)priceRejectCustomerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceRejectCustomerById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = (PriceRejectCustomerEo)this.priceRejectCustomerDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectCustomerEo)) {
            return;
        }
        this.priceRejectCustomerDas.logicDeleteById(priceRejectCustomerEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceRejectCustomerByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.priceRejectCustomerDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<PriceRejectCustomerRespDto> queryByPage(PriceRejectCustomerQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<PriceRejectCustomerEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.priceRejectCustomerDas, queryWrapper, PriceRejectCustomerRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<PriceRejectCustomerEo> getQueryWrapper(PriceRejectCustomerQueryReqDto reqDto) {
        PriceRejectCustomerEo priceRejectCustomerEo = new PriceRejectCustomerEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceRejectCustomerEo);
        priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceRejectCustomerEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateIdList())) {
            queryWrapper.in(StdPriceRejectCustomerEo::getRelateId, (Collection)reqDto.getRelateIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateTypeList())) {
            queryWrapper.in(StdPriceRejectCustomerEo::getRelateType, (Collection)reqDto.getRelateTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getCustomerIdList())) {
            queryWrapper.in(StdPriceRejectCustomerEo::getCustomerId, (Collection)reqDto.getCustomerIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getCustomerCodeList())) {
            queryWrapper.in(StdPriceRejectCustomerEo::getCustomerCode, (Collection)reqDto.getCustomerCodeList());
        }
        return queryWrapper;
    }

    @Override
    public List<PriceRejectCustomerRespDto> queryByList(PriceRejectCustomerQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        return this.priceRejectCustomerDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (PriceRejectCustomerRespDto)item.toDto(PriceRejectCustomerRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceRejectCustomerRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = (PriceRejectCustomerEo)this.priceRejectCustomerDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceRejectCustomerEo)) {
            return null;
        }
        PriceRejectCustomerRespDto priceRejectCustomerRespDto = (PriceRejectCustomerRespDto)priceRejectCustomerEo.toDto(PriceRejectCustomerRespDto.class);
        return priceRejectCustomerRespDto;
    }

    @Override
    public List<PriceRejectCustomerRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return null;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = new PriceRejectCustomerEo();
        priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceRejectCustomerEo).in(BaseEo::getId, idList);
        List priceRejectCustomerEoList = this.priceRejectCustomerDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceRejectCustomerEoList.stream().map(item -> (PriceRejectCustomerRespDto)item.toDto(PriceRejectCustomerRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public List<PriceRejectCustomerRespDto> queryByRelateIdAndType(Long relateId, String relateType) {
        if (relateId == null) {
            return null;
        }
        PriceRejectCustomerEo priceRejectCustomerEo = new PriceRejectCustomerEo();
        priceRejectCustomerEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        priceRejectCustomerEo.setRelateId(relateId);
        priceRejectCustomerEo.setRelateType(relateType);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceRejectCustomerEo);
        List priceRejectCustomerEoList = this.priceRejectCustomerDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceRejectCustomerEoList.stream().map(item -> (PriceRejectCustomerRespDto)item.toDto(PriceRejectCustomerRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public Map<Long, Integer> getRejectCustomerCountMap(RelateTypeEnum relateTypeEnum, List<Long> relateIdList) {
        if (Objects.isNull(relateTypeEnum) || CollUtil.isEmpty(relateIdList)) {
            return MapUtil.empty();
        }
        List rejectCustomerList = this.priceRejectCustomerDas.getRejectCustomerList(relateTypeEnum, relateIdList);
        Map<Long, Integer> countMap = rejectCustomerList.stream().collect(Collectors.toMap(RejectInfoVo::getRelateId, RejectInfoVo::getCount));
        return countMap;
    }
}

