/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.service;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.BatchEditReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.OperatorReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TaskReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 主动营销服务接口:营销任务
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：主动营销服务接口API"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-marketing-api-marketingengine-service-IMarketingTaskApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/mkt-task", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingTaskApi {


    @PostMapping
    @ResponseBody
    @ApiOperation(value = "新增主动营销", notes = "新增主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-add")
    RestResponse<Long> add(@RequestBody TaskReqDto taskReqDto);

    @PutMapping("/{id}/enable")
    @ResponseBody
    @ApiOperation(value = "根据主键id启用主动营销", notes = "根据主键id启用主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-enable")
    RestResponse<Void> enable(@PathVariable(value = "id")Long id, OperatorReqDto operatorReqDto);

    @PutMapping("/enable/batch")
    @ResponseBody
    @ApiOperation(value = "根据主键ids批量启用主动营销", notes = "根据主键ids批量启用主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-batch-enable")
    RestResponse<Void> batchEnable(@RequestBody BatchEditReqDto<Long> batchEditReqDto);

    @PutMapping("/{id}/disable")
    @ResponseBody
    @ApiOperation(value = "根据主键id更新状态为禁用主动营销", notes = "根据主键id更新状态为禁用主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-disable")
    RestResponse<Void> disable(@PathVariable(value = "id")Long id, OperatorReqDto operatorReqDto);

    @PutMapping("/disable/batch")
    @ResponseBody
    @ApiOperation(value = "根据主键ids批量禁用主动营销", notes = "根据主键ids批量禁用主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-batch-disable")
    RestResponse<Void> batchDisable(@RequestBody BatchEditReqDto<Long> batchEditReqDto);

    @DeleteMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "根据主键id删除主动营销", notes = "根据主键id删除主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-delete")
    RestResponse<Void> delete(@PathVariable(value = "id")Long id);

    @DeleteMapping("/batch")
    @ResponseBody
    @ApiOperation(value = "根据主键ids批量删除主动营销", notes = "根据主键ids批量删除主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-batch-delete")
    RestResponse<Void> batchDelete(@RequestBody BatchEditReqDto<Long> batchEditReqDto);

    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "编辑主动营销", notes = "编辑主动营销")
    @Capability(capabilityCode = "marketingengine-marketing-update")
    RestResponse<Void> edit(@PathVariable(value = "id")Long id, @RequestBody TaskReqDto dto);


    @PutMapping("/{id}/retry")
    @ResponseBody
    @ApiOperation(value = "营销任务异常重试", notes = "营销任务异常重试")
    @Capability(capabilityCode = "marketingengine-marketing-retry")
    RestResponse<Void> retry(@PathVariable(value = "id") Long id, @RequestBody OperatorReqDto operatorReqDto);

}
