package com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.service;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.Set;

/**
 * @author lan.zifan
 * @date 2019年7月16日09点30分
 */
@Api(tags = {"营销中心：主动营销推送渠道相关接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-marketingengine-service-ITaskPushChannelApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}",
        path = "/v1/taskPushChannel",
        url = "${yundt.cube.center.marketing.api:}")
public interface ITaskPushChannelApi {

    /**
     * 获取已被主动营销引用的消息模板id集合
     *
     * @return 已被主动营销引用的消息模板id集合
     */
    @GetMapping("/msgTemplate")
    @ApiOperation(value = "获取已被主动营销引用的消息模板id集合", notes = "获取已被主动营销引用的消息模板id集合")
    @Capability(capabilityCode = "marketingengine-marketing-msgTemplate")
    RestResponse<Set<Long>> queryUsedMessageTemplateIdSet();
}
