/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.service.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.TaskRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collection;
import java.util.List;

/**
 * 查询营销任务服务接口
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：主动营销服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-marketingengine-service-query-IMarketingTaskInnerQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/mkt-task", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingTaskInnerQueryApi{


    /**
     * 根据主动营销id列表返回记录信息
     * @author : 萧玄
     * @Date   : 10:24 2019/8/16
     * @param ids
     * @return : java.util.List<java.lang.Object>
     */
    @ApiOperation("根据主动营销id集合返回营销详情列表信息")
    @GetMapping("/raw/list")
    @Capability(capabilityCode = "marketingengine-marketing-tasks")
    RestResponse<List<TaskRespDto>> getMarketingTaskRawListByIds(@RequestParam("ids") Collection<Long> ids);

}
