/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.service.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.ComboBoxRespDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.TaskAbstractRespDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.task.RightsRelationValidDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.task.TaskDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 查询营销任务服务接口
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：主动营销服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-marketingengine-service-query-IMarketingTaskQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/mkt-task", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingTaskQueryApi {

    @GetMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "获得详情", notes = "获得详情")
    @Capability(capabilityCode = "marketingengine-marketing-detail")
    RestResponse<TaskDetailRespDto> getDetail(@PathVariable("id") Long id);

    @GetMapping("/page")
    @ResponseBody
    @ApiOperation(value = "分页查询列表", notes = "分页查询列表")
    @Capability(capabilityCode = "marketingengine-marketing-page")
    RestResponse<PageInfo<TaskAbstractRespDto>> queryPage(@SpringQueryMap TaskQueryReqDto query);

    @GetMapping("/combo/box/list")
    @ResponseBody
    @ApiOperation(value = "下拉框选择列表", notes = "下拉框选择列表")
    @Capability(capabilityCode = "marketingengine-marketing-boxList")
    RestResponse<List<ComboBoxRespDto<String, Long>>> selectComboBoxList(@SpringQueryMap TaskQueryReqDto query);

    /**
     * 根据权益包id，查询权益是否被主动营销引用
     *
     * @param id 权益包id
     * @return 如果被主动营销触发条件引用，
     */
    @GetMapping(value = {"/right/relation/{id}"})
    @ApiOperation(value = "根据权益id查询权益是否被主动营销引用", notes = "根据权益id，查询权益是否被主动营销引用（true 代表可以操作）")
    @Capability(capabilityCode = "marketingengine-marketing-rightsRelation")
    RestResponse<RightsRelationValidDto> queryRightRelationById(@PathVariable("id") Long id);


}
