package com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.service.query;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.dto.request.MarketingTaskDetailRecordReqDto;
import com.dtyunxi.yundt.imkt.bundle.marketingengine.center.marketing.api.dto.response.MarketingTaskDetailRecordRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 主动营销详情查询服务API
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：主动营销详情查询服务API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-query-MarketingTaskDetailRecordQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/marketing/task", url = "${yundt.cube.center.marketing.api:}")
public interface MarketingTaskDetailRecordQueryApi {

    @GetMapping("/page")
    @ResponseBody
    @ApiOperation(value = "主动营销记录查询", notes = "主动营销记录查询")
    @Capability(capabilityCode = "marketingengine-marketing-record")
    RestResponse<PageInfo<MarketingTaskDetailRecordRespDto>> queryMarketingTaskRecordByPage(@SpringQueryMap MarketingTaskDetailRecordReqDto dto);


    /**
     * 获取会员最后触达时间1
     * @param memberId
     * @return
     */
    @ApiOperation("获取会员在主动营销任务内最后触达时间,返回时间戳")
    @GetMapping("/{memberId}")
    @Capability(capabilityCode = "marketingengine-marketing-memberId")
    RestResponse<Long> getLastArriveTime(@PathVariable("memberId") Long memberId);
}
