/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.constant;

public class ComConstants {
    public static final Long TENANT = 1L;
    public static final int DR_ENABLE = 0;
    public static final int DR_DISABLE = 1;
    public static final int STATUS_ZERO = 0;
    public static final int STATUS_ONE = 1;
    public static final String COMMA_SEPARATOR = ",";

    public static enum OrderInventoryStatus {
        PENDING(1, "\u672a\u6d41\u8f6c"),
        DELIVERED(2, "\u4ed3\u5e93\u5df2\u53d7\u7406"),
        PICKED(3, "\u62e3\u8d27\u4e2d"),
        SHIPPED(4, "\u5df2\u53d1\u8d27");

        private Integer code;
        private String desc;

        public static String getDescByCode(Integer code) {
            if (code != null) {
                for (OrderInventoryStatus status : OrderInventoryStatus.values()) {
                    if (!status.getCode().equals(code)) continue;
                    return status.getDesc();
                }
            }
            return OrderInventoryStatus.PENDING.desc;
        }

        private OrderInventoryStatus(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static enum Message {
        GFSC_REGSUCESS(1, "GFSC_RegSucess_", "\u5b98\u65b9\u5546\u57ce\u53d1\u9001\u6ce8\u518c\u6210\u529f\u6d88\u606f"),
        APP_REGSUCESS(2, "APP_RegSucess_", "APP\u53d1\u9001\u6ce8\u518c\u6210\u529f\u6d88\u606f"),
        SMS_REGSUCESS(3, "SMS_RegSucess_", "\u77ed\u4fe1\u53d1\u9001\u6ce8\u518c\u6210\u529f\u6d88\u606f"),
        MODACPW(4, "SMS_ModAcPw_", "\u4fee\u6539\u8d26\u53f7\u5bc6\u7801"),
        GRADECHANGE(8, "GFSC_GradeChange_", "\u4f1a\u5458\u7b49\u7ea7\u53d8\u66f4"),
        GFSCORDERDELIVERY(11, "GFSC_OrderDelivery_", "\u8ba2\u5355\u53d1\u8d27(\u5b98\u65b9\u5546\u57ce)"),
        APPORDERDELIVERY(50, "APP_OrderDelivery_", "\u8ba2\u5355\u53d1\u8d27(APP)"),
        SMSORDERDELIVERY(12, "SMS_OrderDelivery_", "\u8ba2\u5355\u53d1\u8d27\uff08\u77ed\u4fe1\uff09"),
        GFSCORDERDISTRIBUTION(13, "GFSC_OrderDistribution_", "\u8ba2\u5355\u6d3e\u9001\u4e2d(\u5b98\u65b9\u5546\u57ce)"),
        APPORDERDISTRIBUTION(51, "APP_OrderDistribution_", "\u8ba2\u5355\u6d3e\u9001\u4e2d(APP)"),
        SMSORDERDISTRIBUTION(14, "SMS_OrderDistribution_", "\u8ba2\u5355\u6d3e\u9001\u4e2d\uff08\u77ed\u4fe1\uff09"),
        GFSCORDERFULFILLMENT(15, "GFSC_OrderFulfillment_", "\u8ba2\u5355\u5b8c\u6210\uff0c\u63d0\u9192\u8bc4\u4ef7(\u5b98\u65b9\u5546\u57ce)"),
        APPORDERFULFILLMENT(52, "APP_OrderFulfillment_", "\u8ba2\u5355\u5b8c\u6210\uff0c\u63d0\u9192\u8bc4\u4ef7(APP)"),
        GFSCAGREETOREFUND(16, "GFSC_AgreeToRefund_", "\u5356\u5bb6\u540c\u610f\u9000\u6b3e\u7533\u8bf7(\u5546\u6237\u540e\u53f0)"),
        APPAGREETOREFUND(53, "APP_AgreeToRefund_", "\u5356\u5bb6\u540c\u610f\u9000\u6b3e\u7533\u8bf7(app)"),
        APPAGREERETURNGOODS(54, "APP_AgreeReturnGoods_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(app\u4fe1\u606f)"),
        SMSAGREETOREFUND(59, "SMS_AgreeToRefund_", "\u5356\u5bb6\u540c\u610f\u9000\u6b3e\u7533\u8bf7(\u5546\u6237\u540e\u53f0)"),
        GFSCAGREERETURNGOODS(17, "GFSC_AgreeReturnGoods_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(\u5546\u52a1\u540e\u53f0)"),
        SMSAGREERETURNGOODS(18, "SMS_AgreeReturnGoods_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(\u77ed\u4fe1)"),
        GFSCREFUNDED(19, "GFSC_Refunded_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(\u5546\u52a1\u540e\u53f0)"),
        APPREFUNDED(55, "APP_Refunded_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(app\u4fe1\u606f)"),
        SMSREFUNDED(20, "SMS_Refunded_", "\u5356\u5bb6\u540c\u610f\u9000\u8d27\u7533\u8bf7\uff0c\u63d0\u9192\u9000\u8d27(\u77ed\u4fe1)"),
        GFSCNOTIFICATION(22, "GFSC_CouponNotification_", "\u9886\u5238\u901a\u77e5(\u5b98\u65b9\u5546\u57ce)"),
        APPNOTIFICATION(23, "APP_CouponNotification_", "\u9886\u5238\u901a\u77e5(\u5b98\u65b9\u5546\u57ce)"),
        APPCOUPONEXPIRES(58, "APP_CouponExpires_", "\u9886\u5238\u901a\u77e5(APP)"),
        SELLERACCOUNTOPENING(24, "SMS_AccountOpening_", "\u5546\u6237\u8d26\u53f7\u5f00\u901a"),
        SELLERMODACPW(25, "SMS_ModAcPw_", "\u4fee\u6539/\u91cd\u7f6e\u767b\u5f55\u5bc6\u7801"),
        SELLERSMSSTOREAUDITSUC(26, "SMS_StoreAuditSuc_", "\u65b0\u589e\u5e97\u94fa\u5ba1\u6838\u7ed3\u679c\u901a\u77e5(\u6210\u529f \u77ed\u4fe1)"),
        SELLERSHHTSTOREAUDITSUC(27, "SHHT_StoreAuditSuc_", "\u65b0\u589e\u5e97\u94fa\u5ba1\u6838\u7ed3\u679c\u901a\u77e5(\u6210\u529f \u5546\u6237\u540e\u53f0)"),
        SELLERSMSSTOREAUDITFAI(28, "SMS_StoreAuditFai_", "\u65b0\u589e\u5e97\u94fa\u5ba1\u6838\u7ed3\u679c\u901a\u77e5(\u5931\u8d25 \u77ed\u4fe1)"),
        SELLERSHHTSTOREAUDITFAI(29, "SHHT_StoreAuditFai_", "\u65b0\u589e\u5e97\u94fa\u5ba1\u6838\u7ed3\u679c\u901a\u77e5(\u5931\u8d25 \u5546\u6237\u540e\u53f0)"),
        SELLERSHHTNEWORDERNOTI(38, "SHHT_NewOrderNoti_", "\u65b0\u8ba2\u5355\u901a\u77e5"),
        SELLERSHHTREFUNDREVIEW(39, "SHHT_RefundReview_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4\uff0c\u5546\u52a1\u540e\u53f0\uff09"),
        SELLERSMSREFUNDREVIEW(40, "SMS_RefundReview_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u77ed\u4fe1\uff09"),
        SELLERSHHTPAYCONFIRMATION(41, "SHHT_PayConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4\u5546\u52a1\u540e\u53f0\uff09"),
        SELLERSMSPAYCONFIRMATION(42, "SMS_PayConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u77ed\u4fe1\uff09"),
        SELLERSHHTRETURNAUDIT(43, "SHHT_ReturnAudit_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u5546\u52a1\u540e\u53f0"),
        SELLERSMSPRETURNAUDIT(44, "SMS_ReturnAudit_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u77ed\u4fe1\uff09"),
        SELLERSHHTRECECONFIRMATION(45, "SHHT_ReceConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4\u5546\u52a1\u540e\u53f0\uff09"),
        SELLERSMSRECECONFIRMATION(46, "SMS_ReceConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u77ed\u4fe1\uff09"),
        SELLERSHHTINSPECCONFIRMATION(47, "SHHT_InspecConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u5546\u52a1\u540e\u53f0\uff09"),
        SELLERSMSINSPECCONFIRMATION(48, "SMS_InspecConfirmation_", "\u9000\u6b3e\u8ba2\u5355\u901a\u77e5\uff08\u63d0\u9192\u8fdb\u884c\u5ba1\u6838\u786e\u8ba4 \u77ed\u4fe1\uff09");

        private Integer regId;
        private String eventCode;
        private String name;

        private Message(Integer regId, String eventCode, String name) {
            this.regId = regId;
            this.name = name;
            this.eventCode = eventCode;
        }

        public Integer getRegId() {
            return this.regId;
        }

        public void setRegId(Integer regId) {
            this.regId = regId;
        }

        public String getEventCode() {
            return this.eventCode;
        }

        public void setEventCode(String eventCode) {
            this.eventCode = eventCode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum PayType {
        WECHAT_NATIVE("100", "\u5fae\u4fe1\u626b\u7801", "iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAjVBMVEUAAABCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDXXaOApAAAALnRSTlMA5WD88rw6DAjRRjSBLsa1VBrWw6eTjU4UEAP4y66eeWtkXUAl4dyIcyof7VnBpvLmRAAAAv9JREFUaN7t2NmymzAMBuAfwg4JkJ3s+97//R+vbeZMCzUGDD43nXy3mYxGlmLJwcfHx8f/Lrs7yeGX5HjPoN/JucUj31jyy9LwR/HNOUEX17wOKPHjevDQWTqzDVY6x7MUXTibJxt4bkK0NbPZVC8O2oVYUclAPUy4prL1HSoW0ZItLLdoru+zpVUfDb0stma90MiEnUxRz43Z0dqrLfkPdmYvavIYUINRZZSFTS1WGeTW1MI2XUhtqcFy4qCCw+6G0QNVPKN7xQ8LVJuyo3H+Hj6aKBGyk/M0fwenG/IOkd2pZ3du/uC3FslYb9XtmYec5MK3UF8iz0mIvGDAL0Iq/V7blk2Rd9rkBv8JRVe2MUhc5GWRxZwIBe6F6jYBiswzC3yveFoUGMegKrIxOaHoKE6J4jCOKDgA3oQSvpmhqD+maIu8kWSMJgZLrJMFiubXXumqjLwhBdb8/e2x2LLiRrIzJAkXGm8pz3VfaJjLNlXYNa38lZyUltbDW//vSLYPLiAWQy7ff3uWueFL9D5wa3OEYD5lFbM2yNn7+4QY2dMTRDeDjYPsWCpBtdeQNfb1QVao4sSkSpB9Xd1E6aRHtSAmy40g4UVPNmGKLSwKJcXw2cwMf92XLLcuLYZNUf2PcSFrk564DZzGCiMNeQNKTIRiWCpDrdlg7KXI21+oIkJe2OjhdBxRrr5v3DMlnlmhGEoubtMd9VYYS0qujZdUY/4uhkF1YfPlzjg8Xj5bsPGvgNoFEAyo2QAih5o5KLGhVhvNzzn5GiKaUaMZJCJqE0FqTU3WkHN9ajF0USHTEsXPUCkdasgjRY1sxI5Gc9TyxuxkvEATN3ZwQ0NHq3U5HDQW9NjKJIOCC1sYHKHCaxHET6DmoXxcK7PYVPr7y4oD1Oh6UdrbB1pwz/k/mvpm7EsLYZt3tHPkl940xZtjbseGtez9+WBpncdb04Eq8QkZh4X85o8wSMzdznwF4WPuopsVf1vN8I1Si+R5h2/V/12MOb7Z7trHx8fHRzs/Acy0LMsKbCUHAAAAAElFTkSuQmCC"),
        WECHAT_JS("101", "\u5fae\u4fe1\u516c\u4f17\u53f7", "iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAjVBMVEUAAABCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDXXaOApAAAALnRSTlMA5WD88rw6DAjRRjSBLsa1VBrWw6eTjU4UEAP4y66eeWtkXUAl4dyIcyof7VnBpvLmRAAAAv9JREFUaN7t2NmymzAMBuAfwg4JkJ3s+97//R+vbeZMCzUGDD43nXy3mYxGlmLJwcfHx8f/Lrs7yeGX5HjPoN/JucUj31jyy9LwR/HNOUEX17wOKPHjevDQWTqzDVY6x7MUXTibJxt4bkK0NbPZVC8O2oVYUclAPUy4prL1HSoW0ZItLLdoru+zpVUfDb0stma90MiEnUxRz43Z0dqrLfkPdmYvavIYUINRZZSFTS1WGeTW1MI2XUhtqcFy4qCCw+6G0QNVPKN7xQ8LVJuyo3H+Hj6aKBGyk/M0fwenG/IOkd2pZ3du/uC3FslYb9XtmYec5MK3UF8iz0mIvGDAL0Iq/V7blk2Rd9rkBv8JRVe2MUhc5GWRxZwIBe6F6jYBiswzC3yveFoUGMegKrIxOaHoKE6J4jCOKDgA3oQSvpmhqD+maIu8kWSMJgZLrJMFiubXXumqjLwhBdb8/e2x2LLiRrIzJAkXGm8pz3VfaJjLNlXYNa38lZyUltbDW//vSLYPLiAWQy7ff3uWueFL9D5wa3OEYD5lFbM2yNn7+4QY2dMTRDeDjYPsWCpBtdeQNfb1QVao4sSkSpB9Xd1E6aRHtSAmy40g4UVPNmGKLSwKJcXw2cwMf92XLLcuLYZNUf2PcSFrk564DZzGCiMNeQNKTIRiWCpDrdlg7KXI21+oIkJe2OjhdBxRrr5v3DMlnlmhGEoubtMd9VYYS0qujZdUY/4uhkF1YfPlzjg8Xj5bsPGvgNoFEAyo2QAih5o5KLGhVhvNzzn5GiKaUaMZJCJqE0FqTU3WkHN9ajF0USHTEsXPUCkdasgjRY1sxI5Gc9TyxuxkvEATN3ZwQ0NHq3U5HDQW9NjKJIOCC1sYHKHCaxHET6DmoXxcK7PYVPr7y4oD1Oh6UdrbB1pwz/k/mvpm7EsLYZt3tHPkl940xZtjbseGtez9+WBpncdb04Eq8QkZh4X85o8wSMzdznwF4WPuopsVf1vN8I1Si+R5h2/V/12MOb7Z7trHx8fHRzs/Acy0LMsKbCUHAAAAAElFTkSuQmCC"),
        WECHAT_APP("102", "\u5fae\u4fe1APP\u652f\u4ed8", "iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAjVBMVEUAAABCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDVCsDXXaOApAAAALnRSTlMA5WD88rw6DAjRRjSBLsa1VBrWw6eTjU4UEAP4y66eeWtkXUAl4dyIcyof7VnBpvLmRAAAAv9JREFUaN7t2NmymzAMBuAfwg4JkJ3s+97//R+vbeZMCzUGDD43nXy3mYxGlmLJwcfHx8f/Lrs7yeGX5HjPoN/JucUj31jyy9LwR/HNOUEX17wOKPHjevDQWTqzDVY6x7MUXTibJxt4bkK0NbPZVC8O2oVYUclAPUy4prL1HSoW0ZItLLdoru+zpVUfDb0stma90MiEnUxRz43Z0dqrLfkPdmYvavIYUINRZZSFTS1WGeTW1MI2XUhtqcFy4qCCw+6G0QNVPKN7xQ8LVJuyo3H+Hj6aKBGyk/M0fwenG/IOkd2pZ3du/uC3FslYb9XtmYec5MK3UF8iz0mIvGDAL0Iq/V7blk2Rd9rkBv8JRVe2MUhc5GWRxZwIBe6F6jYBiswzC3yveFoUGMegKrIxOaHoKE6J4jCOKDgA3oQSvpmhqD+maIu8kWSMJgZLrJMFiubXXumqjLwhBdb8/e2x2LLiRrIzJAkXGm8pz3VfaJjLNlXYNa38lZyUltbDW//vSLYPLiAWQy7ff3uWueFL9D5wa3OEYD5lFbM2yNn7+4QY2dMTRDeDjYPsWCpBtdeQNfb1QVao4sSkSpB9Xd1E6aRHtSAmy40g4UVPNmGKLSwKJcXw2cwMf92XLLcuLYZNUf2PcSFrk564DZzGCiMNeQNKTIRiWCpDrdlg7KXI21+oIkJe2OjhdBxRrr5v3DMlnlmhGEoubtMd9VYYS0qujZdUY/4uhkF1YfPlzjg8Xj5bsPGvgNoFEAyo2QAih5o5KLGhVhvNzzn5GiKaUaMZJCJqE0FqTU3WkHN9ajF0USHTEsXPUCkdasgjRY1sxI5Gc9TyxuxkvEATN3ZwQ0NHq3U5HDQW9NjKJIOCC1sYHKHCaxHET6DmoXxcK7PYVPr7y4oD1Oh6UdrbB1pwz/k/mvpm7EsLYZt3tHPkl940xZtjbseGtez9+WBpncdb04Eq8QkZh4X85o8wSMzdznwF4WPuopsVf1vN8I1Si+R5h2/V/12MOb7Z7trHx8fHRzs/Acy0LMsKbCUHAAAAAElFTkSuQmCC"),
        ALIPAY_H5("500", "\u652f\u4ed8\u5b9dH5", "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"),
        ALIPAY_SCAN("502", "\u652f\u4ed8\u5b9d\u626b\u7801", "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"),
        BANK("200", "\u5927\u989d\u652f\u4ed8", "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");

        private String code;
        private String desc;
        private String image;

        public static String getDescByCode(String code) {
            if (code != null) {
                for (PayType pay : PayType.values()) {
                    if (!pay.getCode().equals(code)) continue;
                    return pay.getDesc();
                }
            }
            return null;
        }

        public static String getImageByCode(String code) {
            if (code != null) {
                for (PayType pay : PayType.values()) {
                    if (!pay.getCode().equals(code)) continue;
                    return pay.getImage();
                }
            }
            return null;
        }

        private PayType(String code, String desc, String image) {
            this.code = code;
            this.desc = desc;
            this.image = image;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getImage() {
            return this.image;
        }

        public void setImage(String image) {
            this.image = image;
        }
    }

    public static enum Application {
        GLOBAL(1, "global", "\u5168\u5c40\u7ba1\u7406\u5e73\u53f0\u5e94\u7528"),
        B2C_SELLER(2, "seller", "\u5546\u6237\u7ba1\u7406\u5e94\u7528"),
        PLATEFORM(3, "plateform", "\u5e73\u53f0\u540e\u53f0\u7ba1\u7406\u5e94\u7528"),
        INVENTORY(6, "inventory", "\u5e93\u5b58\u7ba1\u7406\u5e94\u7528"),
        LARGECASH(7, "largeCash", "\u5927\u989d\u652f\u4ed8\u7cfb\u7edf");

        private Integer appId;
        private String application;
        private String name;

        private Application(Integer channelId, String application, String name) {
            this.appId = channelId;
            this.application = application;
            this.name = name;
        }

        public Integer getAppId() {
            return this.appId;
        }

        public void setAppId(Integer appId) {
            this.appId = appId;
        }

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum Terminal {
        PC("a1", "1", "PC\u7aef"),
        WAP("b1", "2", "\u624b\u673a\u7aef"),
        H5("c1", "3", "H5");

        private String code;
        private String convertCode;
        private String value;

        public static String getDescByCode(String code) {
            if (code != null) {
                for (Terminal terminal : Terminal.values()) {
                    if (!terminal.getCode().equals(code)) continue;
                    return terminal.getConvertCode();
                }
            }
            return null;
        }

        private Terminal(String code, String convertCode, String value) {
            this.code = code;
            this.convertCode = convertCode;
            this.value = value;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getConvertCode() {
            return this.convertCode;
        }

        public void setConvertCode(String convertCode) {
            this.convertCode = convertCode;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum Channel {
        B2C(1L, "\u5b98\u65b9\u5546\u57ce"),
        O2O(2L, "\u4e91\u5546\u5546\u57ce"),
        TMALL(3L, "\u5929\u732b\u5546\u57ce"),
        JD(4L, "\u4eac\u4e1c\u5546\u57ce");

        private Long channel;
        private String name;

        public static String getDescByCode(Long channel) {
            if (channel != null) {
                for (Channel code : Channel.values()) {
                    if (!code.getChannel().equals(channel)) continue;
                    return code.getName();
                }
            }
            return Channel.B2C.name;
        }

        private Channel(Long channel, String name) {
            this.channel = channel;
            this.name = name;
        }

        public Long getChannel() {
            return this.channel;
        }

        public void setChannel(Long channel) {
            this.channel = channel;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

