/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.controller;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Controller
public abstract class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int SUCCESS_CODE = 0;
    private static final int FAIL_CODE = -1;
    public static final String MSG_SYSTEM_ERROR = "\u7cfb\u7edf\u9519\u8bef";
    public static final String MSG_INVALID_PARAM = "\u65e0\u6548\u7684\u8bf7\u6c42\u53c2\u6570";

    protected RestResponse fail(String msg) {
        return new RestResponse(-1, msg, null);
    }

    protected RestResponse success(String msg) {
        return this.success(msg, null);
    }

    protected RestResponse success(String msg, String data) {
        return new RestResponse(0, msg, (Object)data);
    }

    @ExceptionHandler(value={Exception.class})
    public RestResponse exceptionHandler(Exception ex) {
        String msg = MSG_SYSTEM_ERROR;
        try {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            if (ex instanceof MethodArgumentNotValidException || ex instanceof BindException) {
                BindingResult bindingResult = ex instanceof MethodArgumentNotValidException ? ((MethodArgumentNotValidException)ex).getBindingResult() : ((BindException)ex).getBindingResult();
                msg = this.getBindErrorMsg(bindingResult);
            } else if (ex instanceof BusinessRuntimeException) {
                msg = ex.getMessage();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.fail(msg);
    }

    private String getBindErrorMsg(BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasErrors()) {
            List errorList = bindingResult.getAllErrors();
            ObjectError error = (ObjectError)errorList.get(0);
            return error.getDefaultMessage();
        }
        return MSG_INVALID_PARAM;
    }
}

