/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static <T, R> List<R> copyList(List<T> listT, Class<R> rClass) {
        ArrayList<R> listR = new ArrayList<R>();
        try {
            for (T t : listT) {
                R r = rClass.newInstance();
                BeanUtils.copyProperties(t, r);
                listR.add(r);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return listR;
    }

    public static <T, R> PageInfo<R> copyPage(PageInfo<T> pageT, Class<R> rClass) {
        PageInfo pageR = new PageInfo();
        BeanUtils.copyProperties(pageT, (Object)pageR);
        List<R> listR = BeanUtil.copyList(pageT.getList(), rClass);
        pageR.setList(listR);
        return pageR;
    }
}

